/*
 * Decompiled with CFR 0.152.
 */
package am2.power;

import am2.LogHelper;
import am2.api.power.IPowerNode;
import am2.power.PowerNodeCache;
import am2.power.PowerNodeEntry;
import am2.power.PowerNodePathfinder;
import am2.power.PowerTypes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class PowerNodeRegistry {
    private static final HashMap<Integer, PowerNodeRegistry> serverDimensionPowerManagers = new HashMap();
    private static final HashMap<Integer, PowerNodeRegistry> clientDimensionPowerManagers = new HashMap();
    private static final PowerNodeRegistry dummyRegistry = new PowerNodeRegistry();
    static final int POWER_SEARCH_RADIUS = 10;
    static final int POWER_SEARCH_RADIUS_SQ = 100;
    static final int MAX_POWER_SEARCH_RADIUS = 10000;
    private TreeMap<ChunkPos, HashMap<Vec3d, PowerNodeEntry>> powerNodes;

    public static final PowerNodeRegistry For(World world) {
        HashMap<Integer, PowerNodeRegistry> dimensionPowerManagers;
        if (world == null) {
            return dummyRegistry;
        }
        HashMap<Integer, PowerNodeRegistry> hashMap = dimensionPowerManagers = world.field_72995_K ? clientDimensionPowerManagers : serverDimensionPowerManagers;
        if (dimensionPowerManagers.containsKey(world.field_73011_w.getDimension())) {
            return dimensionPowerManagers.get(world.field_73011_w.getDimension());
        }
        PowerNodeRegistry reg = new PowerNodeRegistry();
        dimensionPowerManagers.put(world.field_73011_w.getDimension(), reg);
        return reg;
    }

    private PowerNodeRegistry() {
        ChunkCoordComparator comparator = new ChunkCoordComparator();
        this.powerNodes = new TreeMap(comparator);
    }

    public void registerPowerNode(IPowerNode<?> node) {
        this.registerPowerNodeInternal(node);
    }

    PowerNodeEntry registerPowerNodeInternal(IPowerNode<?> node) {
        HashMap<Object, PowerNodeEntry> nodeList;
        ChunkPos chunk = this.getChunkFromNode(node);
        TileEntity te = (TileEntity)node;
        World world = te.func_145831_w();
        if (this.powerNodes.containsKey(chunk)) {
            nodeList = this.powerNodes.get(chunk);
            LogHelper.trace(String.format("Located Power Node list for chunk %d, %d", chunk.field_77276_a, chunk.field_77275_b), new Object[0]);
        } else {
            LogHelper.trace("Node list not found.  Checking cache/files for prior data", new Object[0]);
            NBTTagCompound compound = PowerNodeCache.instance.getNBTForChunk(world, chunk);
            nodeList = new HashMap();
            if (compound == null || !compound.func_74764_b("AM2PowerData")) {
                this.powerNodes.put(chunk, nodeList);
                LogHelper.trace("Prior node list not found.  Created Power Node list for chunk %d, %d", chunk.field_77276_a, chunk.field_77275_b);
            } else {
                this.LoadChunkFromNBT(chunk, compound);
                nodeList = this.powerNodes.get(chunk);
                if (nodeList == null) {
                    nodeList = new HashMap();
                    this.powerNodes.put(chunk, nodeList);
                }
                LogHelper.trace(String.format("Loaded power data for chunk %d, %d", chunk.field_77276_a, chunk.field_77275_b), new Object[0]);
            }
        }
        Vec3d nodeLoc = new Vec3d((Vec3i)((TileEntity)node).func_174877_v());
        if (nodeList.containsKey(nodeLoc)) {
            return nodeList.get(nodeLoc);
        }
        PowerNodeEntry pnd = new PowerNodeEntry();
        nodeList.put(nodeLoc, pnd);
        LogHelper.trace("Successfully registered power node at {%d, %d, %d}", ((TileEntity)node).func_174877_v().func_177958_n(), ((TileEntity)node).func_174877_v().func_177956_o(), ((TileEntity)node).func_174877_v().func_177952_p());
        return pnd;
    }

    public void removePowerNode(IPowerNode<?> node) {
        ChunkPos chunk = this.getChunkFromNode(node);
        this.removePowerNode(chunk, new Vec3d((Vec3i)((TileEntity)node).func_174877_v()));
    }

    public String tryPairNodes(IPowerNode<?> powerSource, IPowerNode<?> destination) {
        Vec3d destLocation;
        if (powerSource == destination) {
            return I18n.func_74838_a((String)"am2.tooltip.nodePairToSelf");
        }
        ArrayList<PowerTypes> typesProvided = new ArrayList<PowerTypes>();
        for (PowerTypes type : destination.getValidPowerTypes()) {
            if (!powerSource.canProvidePower(type)) continue;
            typesProvided.add(type);
        }
        if (typesProvided.size() == 0) {
            return I18n.func_74838_a((String)"am2.tooltip.noSupportedPowertypes");
        }
        Vec3d sourceLocation = new Vec3d((Vec3i)((TileEntity)powerSource).func_174877_v());
        double rawDist = sourceLocation.func_72436_e(destLocation = new Vec3d((Vec3i)((TileEntity)destination).func_174877_v()));
        if (rawDist > 10000.0) {
            return I18n.func_74838_a((String)"am2.tooltip.nodesTooFar");
        }
        int successes = 0;
        for (PowerTypes type : typesProvided) {
            LinkedList<Vec3d> powerPath = new LinkedList<Vec3d>();
            PowerNodePathfinder pathfinder = new PowerNodePathfinder(((TileEntity)powerSource).func_145831_w(), sourceLocation, destLocation, type);
            List<Vec3d> path = pathfinder.compute(sourceLocation);
            if (path == null) continue;
            for (Vec3d vec : path) {
                powerPath.addFirst(vec);
            }
            ++successes;
            this.getPowerNodeData(destination).registerNodePath(type, powerPath);
        }
        if (successes == 0) {
            return I18n.func_74838_a((String)"am2.tooltip.noPathFound");
        }
        if (successes == typesProvided.size()) {
            return I18n.func_74838_a((String)"am2.tooltip.success");
        }
        return I18n.func_74838_a((String)"am2.tooltip.partialSuccess");
    }

    public void tryDisconnectAllNodes(IPowerNode<?> node) {
        this.getPowerNodeData(node).clearNodePaths();
    }

    private void removePowerNode(ChunkPos chunk, Vec3d location) {
        if (this.powerNodes.containsKey(chunk)) {
            HashMap<Vec3d, PowerNodeEntry> nodeList = this.powerNodes.get(chunk);
            nodeList.remove(location);
            LogHelper.trace("Successfully removed a node from chunk %d, %d", chunk.field_77276_a, chunk.field_77275_b);
            if (nodeList.size() == 0) {
                this.powerNodes.remove(chunk);
                LogHelper.trace("No more nodes exist in chunk.  Removing tracking data for chunk.", new Object[0]);
            }
        } else {
            LogHelper.error("Power Node removal requested in a non-tracked chunk (%d, %d)!", chunk.field_77276_a, chunk.field_77275_b);
        }
    }

    public float requestPower(IPowerNode<?> destination, PowerTypes type, float amount) {
        PowerNodeEntry data = this.getPowerNodeData(destination);
        if (data == null) {
            return 0.0f;
        }
        float requested = data.requestPower(((TileEntity)destination).func_145831_w(), type, amount, destination.getCapacity());
        return requested;
    }

    public float consumePower(IPowerNode<?> consumer, PowerTypes type, float amount) {
        PowerNodeEntry data = this.getPowerNodeData(consumer);
        if (data == null) {
            return 0.0f;
        }
        float availablePower = data.getPower(type);
        if (availablePower < amount) {
            amount = availablePower;
        }
        data.setPower(type, availablePower - amount);
        return amount;
    }

    public float insertPower(IPowerNode<?> destination, PowerTypes type, float amount) {
        PowerNodeEntry data = this.getPowerNodeData(destination);
        if (data == null) {
            return 0.0f;
        }
        float curPower = data.getPower(type);
        if (curPower + amount > destination.getCapacity()) {
            amount = destination.getCapacity() - curPower;
        }
        data.setPower(type, curPower + amount);
        return amount;
    }

    public void setPower(IPowerNode<?> destination, PowerTypes type, float amount) {
        PowerNodeEntry data = this.getPowerNodeData(destination);
        if (data == null) {
            return;
        }
        if (amount > destination.getCapacity()) {
            amount = destination.getCapacity();
        }
        data.setPower(type, amount);
    }

    public boolean checkPower(IPowerNode<?> node, PowerTypes type, float amount) {
        PowerNodeEntry data = this.getPowerNodeData(node);
        if (data == null) {
            return false;
        }
        return data.getPower(type) >= amount;
    }

    public boolean checkPower(IPowerNode<?> node, float amount) {
        for (PowerTypes type : PowerTypes.all()) {
            if (!this.checkPower(node, type, amount)) continue;
            return true;
        }
        return false;
    }

    public boolean checkPower(IPowerNode<?> node) {
        return this.getHighestPower(node) > 0.0f;
    }

    public float getPower(IPowerNode<?> node, PowerTypes type) {
        PowerNodeEntry data = this.getPowerNodeData(node);
        if (data == null) {
            return 0.0f;
        }
        return data.getPower(type);
    }

    public float getHighestPower(IPowerNode<?> node) {
        PowerNodeEntry data = this.getPowerNodeData(node);
        if (data == null) {
            return 0.0f;
        }
        return data.getHighestPower();
    }

    public PowerTypes getHighestPowerType(IPowerNode<?> node) {
        PowerNodeEntry data = this.getPowerNodeData(node);
        if (data == null) {
            return PowerTypes.NONE;
        }
        return data.getHighestPowerType();
    }

    PowerNodeEntry getPowerNodeData(IPowerNode<?> node) {
        PowerNodeEntry pnd;
        ChunkPos pair = this.getChunkFromNode(node);
        if (pair != null && this.powerNodes.containsKey(pair) && (pnd = this.powerNodes.get(pair).get(new Vec3d((Vec3i)((TileEntity)node).func_174877_v()))) != null) {
            return pnd;
        }
        return this.registerPowerNodeInternal(node);
    }

    public IPowerNode<?>[] getAllNearbyNodes(World world, Vec3d location, PowerTypes power) {
        ChunkPos[] search = this.getSearchChunks(location);
        HashMap<Vec3d, PowerNodeEntry> nodesToSearch = new HashMap<Vec3d, PowerNodeEntry>();
        for (ChunkPos pair : search) {
            HashMap<Vec3d, PowerNodeEntry> nodesInChunk = this.powerNodes.get(pair);
            if (nodesInChunk == null) continue;
            for (Vec3d vector : nodesInChunk.keySet()) {
                if (!(location.func_72436_e(vector) <= 100.0) || vector.equals((Object)location)) continue;
                nodesToSearch.put(vector, nodesInChunk.get(vector));
            }
        }
        ArrayList<IPowerNode> nodes = new ArrayList<IPowerNode>();
        int deadNodesRemoved = 0;
        for (Vec3d vector : nodesToSearch.keySet()) {
            Chunk chunk;
            if (world.func_175726_f(new BlockPos(vector)) == null || !(chunk = world.func_175726_f(new BlockPos(vector))).func_177410_o()) continue;
            TileEntity te = world.func_175625_s(new BlockPos(vector));
            if (te == null || !(te instanceof IPowerNode)) {
                this.removePowerNode(chunk.func_76632_l(), vector);
                ++deadNodesRemoved;
                continue;
            }
            IPowerNode node = (IPowerNode)te;
            nodes.add(node);
        }
        if (deadNodesRemoved > 0) {
            LogHelper.trace("Removed %d dead power nodes", deadNodesRemoved);
        }
        IPowerNode[] nodeArray = nodes.toArray(new IPowerNode[nodes.size()]);
        LogHelper.trace("Located %d nearby power providers", nodeArray.length);
        return nodeArray;
    }

    private ChunkPos[] getSearchChunks(Vec3d location) {
        int chunkX = (int)location.field_72450_a >> 4;
        int chunkZ = (int)location.field_72449_c >> 4;
        ArrayList<ChunkPos> searchChunks = new ArrayList<ChunkPos>();
        searchChunks.add(new ChunkPos(chunkX, chunkZ));
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0) continue;
                ChunkPos newPair = new ChunkPos(chunkX + i, chunkZ + j);
                if ((int)location.field_72450_a + 10 * i >> 4 != newPair.field_77276_a || (int)location.field_72449_c + 10 * j >> 4 != newPair.field_77275_b) continue;
                searchChunks.add(newPair);
            }
        }
        return searchChunks.toArray(new ChunkPos[searchChunks.size()]);
    }

    private ChunkPos getChunkFromNode(IPowerNode<?> node) {
        TileEntity te = (TileEntity)node;
        return new ChunkPos(te.func_174877_v().func_177958_n() >> 4, te.func_174877_v().func_177952_p() >> 4);
    }

    public void SaveChunkToNBT(ChunkPos chunk, NBTTagCompound compound) {
        HashMap<Vec3d, PowerNodeEntry> nodeData = this.powerNodes.get(chunk);
        if (nodeData == null) {
            return;
        }
        NBTTagList powerNodeTagList = new NBTTagList();
        for (Vec3d location : nodeData.keySet()) {
            NBTTagCompound nodeCompound = new NBTTagCompound();
            nodeCompound.func_74768_a("xCoord", (int)location.field_72450_a);
            nodeCompound.func_74768_a("yCoord", (int)location.field_72448_b);
            nodeCompound.func_74768_a("zCoord", (int)location.field_72449_c);
            PowerNodeEntry pnd = nodeData.get(location);
            nodeCompound.func_74782_a("nodeData", (NBTBase)pnd.saveToNBT());
            powerNodeTagList.func_74742_a((NBTBase)nodeCompound);
        }
        LogHelper.trace("Saved %d power node entries", powerNodeTagList.func_74745_c());
        compound.func_74782_a("AM2PowerData", (NBTBase)powerNodeTagList);
    }

    public void LoadChunkFromNBT(ChunkPos chunk, NBTTagCompound compound) {
        if (!compound.func_74764_b("AM2PowerData")) {
            return;
        }
        NBTTagList powerNodeTagList = compound.func_150295_c("AM2PowerData", 10);
        HashMap<Vec3d, PowerNodeEntry> chunkPowerData = new HashMap<Vec3d, PowerNodeEntry>();
        for (int i = 0; i < powerNodeTagList.func_74745_c(); ++i) {
            NBTTagCompound nodeCompound = powerNodeTagList.func_150305_b(i);
            Vec3d nodeLocation = new Vec3d((double)nodeCompound.func_74762_e("xCoord"), (double)nodeCompound.func_74762_e("yCoord"), (double)nodeCompound.func_74762_e("zCoord"));
            PowerNodeEntry pnd = new PowerNodeEntry();
            pnd.readFromNBT(nodeCompound.func_74775_l("nodeData"));
            chunkPowerData.put(nodeLocation, pnd);
        }
        LogHelper.trace("Loaded %d power node entries", chunkPowerData.size());
        this.powerNodes.put(chunk, chunkPowerData);
    }

    public void unloadChunk(Chunk chunk) {
        this.powerNodes.remove(chunk.func_76632_l());
    }

    public boolean hasDataForChunk(Chunk chunk) {
        return this.powerNodes.containsKey(chunk.func_76632_l());
    }

    public NBTTagCompound getDataCompoundForNode(IPowerNode<?> node) {
        PowerNodeEntry pnd = this.getPowerNodeData(node);
        if (pnd == null) {
            return null;
        }
        return pnd.saveToNBT();
    }

    public void setDataCompoundForNode(IPowerNode<?> node, NBTTagCompound compound) {
        PowerNodeEntry pnd = this.getPowerNodeData(node);
        if (pnd == null) {
            return;
        }
        pnd.readFromNBT(compound.func_74737_b());
    }

    public PowerNodeEntry parseFromNBT(NBTTagCompound compound) {
        PowerNodeEntry pnd = new PowerNodeEntry();
        pnd.readFromNBT(compound.func_74737_b());
        return pnd;
    }

    public HashMap<ChunkPos, NBTTagCompound> saveAll() {
        HashMap<ChunkPos, NBTTagCompound> allData = new HashMap<ChunkPos, NBTTagCompound>();
        for (ChunkPos pair : this.powerNodes.keySet()) {
            NBTTagCompound chunkCompound = new NBTTagCompound();
            this.SaveChunkToNBT(pair, chunkCompound);
            allData.put(pair, chunkCompound);
        }
        return allData;
    }

    public void unloadAll() {
        this.powerNodes.clear();
    }

    private class ChunkCoordComparator
    implements Comparator<ChunkPos> {
        private ChunkCoordComparator() {
        }

        @Override
        public int compare(ChunkPos a, ChunkPos b) {
            if (a.field_77276_a == b.field_77276_a && a.field_77275_b == b.field_77275_b) {
                return 0;
            }
            if (a.field_77276_a > b.field_77276_a) {
                return 1;
            }
            if (a.field_77275_b > b.field_77275_b) {
                return 1;
            }
            return -1;
        }
    }
}

