/*
 * Decompiled with CFR 0.152.
 */
package am2.power;

import am2.api.power.IPowerNode;
import am2.power.AStar;
import am2.power.PowerNodeRegistry;
import am2.power.PowerTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class PowerNodePathfinder
extends AStar<Vec3d> {
    private World world;
    private Vec3d end;
    private PowerTypes powerType;

    PowerNodePathfinder(World world, Vec3d start, Vec3d end, PowerTypes type) {
        this.world = world;
        this.end = end;
        this.powerType = type;
    }

    private IPowerNode<?> getPowerNode(World world, Vec3d location) {
        TileEntity te;
        Chunk chunk;
        if (world.func_175726_f(new BlockPos(location)) != null && (chunk = world.func_175726_f(new BlockPos(location))).func_177410_o() && (te = world.func_175625_s(new BlockPos(location))) instanceof IPowerNode) {
            return (IPowerNode)te;
        }
        return null;
    }

    @Override
    protected boolean isGoal(Vec3d node) {
        return node.equals((Object)this.end);
    }

    @Override
    protected Double g(Vec3d from, Vec3d to) {
        return from.func_72436_e(to);
    }

    @Override
    protected Double h(Vec3d from, Vec3d to) {
        return from.func_72436_e(to);
    }

    @Override
    protected List<Vec3d> generateSuccessors(Vec3d node) {
        IPowerNode<?> powerNode = this.getPowerNode(this.world, node);
        if (powerNode == null) {
            return new ArrayList<Vec3d>();
        }
        IPowerNode<?>[] candidates = PowerNodeRegistry.For(this.world).getAllNearbyNodes(this.world, node, this.powerType);
        ArrayList<Vec3d> prunedCandidates = new ArrayList<Vec3d>();
        for (IPowerNode<?> candidate : candidates) {
            if (!this.verifyCandidate(candidate)) continue;
            prunedCandidates.add(new Vec3d((Vec3i)((TileEntity)candidate).func_174877_v()));
        }
        return prunedCandidates;
    }

    private boolean verifyCandidate(IPowerNode<?> powerNode) {
        if (new Vec3d((Vec3i)((TileEntity)powerNode).func_174877_v()).equals((Object)this.end)) {
            for (PowerTypes type : powerNode.getValidPowerTypes()) {
                if (type != this.powerType) continue;
                return true;
            }
        }
        return powerNode.canRelayPower(this.powerType);
    }
}

