/*
 * Decompiled with CFR 0.152.
 */
package am2.power;

import am2.api.power.IPowerNode;
import am2.power.PowerNodeRegistry;
import am2.power.PowerTypes;
import am2.utils.NBTUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class PowerNodeEntry {
    HashMap<PowerTypes, Float> powerAmounts = new HashMap();
    private HashMap<PowerTypes, ArrayList<LinkedList<Vec3d>>> nodePaths = new HashMap();

    public void clearNodePaths() {
        for (PowerTypes type : this.nodePaths.keySet()) {
            this.nodePaths.get(type).clear();
        }
    }

    public void registerNodePath(PowerTypes type, LinkedList<Vec3d> path) {
        ArrayList<LinkedList<Object>> paths = this.nodePaths.get(type);
        if (paths == null) {
            paths = new ArrayList();
            this.nodePaths.put(type, paths);
        }
        Iterator<LinkedList<Vec3d>> it = paths.iterator();
        while (it.hasNext()) {
            if (!it.next().getLast().equals((Object)path.getLast())) continue;
            it.remove();
            break;
        }
        paths.add(path);
    }

    public float requestPower(World world, PowerTypes type, float amount, float capacity) {
        if (this.getPower(type) >= capacity) {
            return 0.0f;
        }
        ArrayList<LinkedList<Vec3d>> paths = this.nodePaths.get(type);
        if (paths == null || paths.size() == 0) {
            return 0.0f;
        }
        if (this.powerAmounts.containsKey(type) && this.powerAmounts.get(type).floatValue() + amount > capacity) {
            amount = capacity - this.powerAmounts.get(type).floatValue();
        }
        float requested = 0.0f;
        for (LinkedList<Vec3d> path : paths) {
            if ((requested += this.requestPowerFrom(world, path, type, amount - requested)) >= amount) break;
        }
        return requested;
    }

    private boolean validatePath(World world, LinkedList<Vec3d> path) {
        for (Vec3d vec : path) {
            Chunk chunk = world.func_175726_f(new BlockPos(vec));
            if (!chunk.func_177410_o()) {
                return false;
            }
            TileEntity te = world.func_175625_s(new BlockPos(vec));
            if (te != null && te instanceof IPowerNode) continue;
            if (world.field_72995_K || world.func_175623_d(new BlockPos(vec))) {
                // empty if block
            }
            return false;
        }
        return true;
    }

    private float requestPowerFrom(World world, LinkedList<Vec3d> path, PowerTypes type, float amount) {
        if (!this.validatePath(world, path)) {
            return 0.0f;
        }
        Vec3d end = path.getLast();
        TileEntity te = world.func_175625_s(new BlockPos(end));
        if (te != null && te instanceof IPowerNode && ((IPowerNode)te).canProvidePower(type)) {
            return PowerNodeRegistry.For(world).consumePower((IPowerNode)te, type, amount);
        }
        return 0.0f;
    }

    public PowerTypes getHighestPowerType() {
        float highest = 0.0f;
        PowerTypes hType = PowerTypes.NONE;
        for (PowerTypes type : this.powerAmounts.keySet()) {
            if (!(this.powerAmounts.get(type).floatValue() > highest)) continue;
            highest = this.powerAmounts.get(type).floatValue();
            hType = type;
        }
        return hType;
    }

    public float getHighestPower() {
        float highest = 0.0f;
        for (PowerTypes type : this.powerAmounts.keySet()) {
            if (!(this.powerAmounts.get(type).floatValue() > highest)) continue;
            highest = this.powerAmounts.get(type).floatValue();
        }
        return highest;
    }

    public float getPower(PowerTypes type) {
        Float f = this.powerAmounts.get(type);
        return f == null ? 0.0f : f.floatValue();
    }

    public void setPower(PowerTypes type, float amt) {
        if (type != null) {
            this.powerAmounts.put(type, Float.valueOf(amt));
        }
    }

    public NBTTagCompound saveToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList powerAmountStore = new NBTTagList();
        for (PowerTypes type : this.powerAmounts.keySet()) {
            if (type == null) continue;
            NBTTagCompound powerType = new NBTTagCompound();
            powerType.func_74768_a("powerType", type.ID());
            powerType.func_74776_a("powerAmount", this.powerAmounts.get(type).floatValue());
            powerAmountStore.func_74742_a((NBTBase)powerType);
        }
        compound.func_74782_a("powerAmounts", (NBTBase)powerAmountStore);
        NBTTagList powerPathList = new NBTTagList();
        for (PowerTypes type : this.nodePaths.keySet()) {
            NBTTagCompound powerPathEntry = new NBTTagCompound();
            ArrayList<LinkedList<Vec3d>> paths = this.nodePaths.get(type);
            NBTTagList pathsForType = new NBTTagList();
            for (LinkedList<Vec3d> path : paths) {
                NBTTagList pathNodes = new NBTTagList();
                for (Vec3d pathNode : path) {
                    NBTTagCompound node = new NBTTagCompound();
                    NBTUtils.writeVecToNBT(pathNode, node);
                    pathNodes.func_74742_a((NBTBase)node);
                }
                pathsForType.func_74742_a((NBTBase)pathNodes);
            }
            powerPathEntry.func_74768_a("powerType", type.ID());
            powerPathEntry.func_74782_a("nodePaths", (NBTBase)pathsForType);
            powerPathList.func_74742_a((NBTBase)powerPathEntry);
        }
        compound.func_74782_a("powerPathList", (NBTBase)powerPathList);
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagList powerPathList;
        NBTTagList powerAmountStore = compound.func_150295_c("powerAmounts", 10);
        if (powerAmountStore != null) {
            for (int i = 0; i < powerAmountStore.func_74745_c(); ++i) {
                NBTTagCompound powerType = powerAmountStore.func_150305_b(i);
                PowerTypes type = PowerTypes.getByID(powerType.func_74762_e("powerType"));
                float powerAmount = powerType.func_74760_g("powerAmount");
                this.powerAmounts.put(type, Float.valueOf(powerAmount));
            }
        }
        if ((powerPathList = compound.func_150295_c("powerPathList", 10)) != null) {
            for (int i = 0; i < powerPathList.func_74745_c(); ++i) {
                NBTTagCompound powerPathEntry = powerPathList.func_150305_b(i);
                PowerTypes type = PowerTypes.getByID(powerPathEntry.func_74762_e("powerType"));
                NBTTagList pathNodes = powerPathEntry.func_150295_c("nodePaths", 9);
                ArrayList pathsList = new ArrayList();
                if (pathNodes == null) continue;
                for (int j = 0; j < pathNodes.func_74745_c(); ++j) {
                    NBTTagList nodeList = (NBTTagList)pathNodes.func_179238_g(j);
                    LinkedList<Vec3d> powerPath = new LinkedList<Vec3d>();
                    if (nodeList == null) continue;
                    for (int b = 0; b < nodeList.func_74745_c(); ++b) {
                        NBTTagCompound node = nodeList.func_150305_b(b);
                        Vec3d nodeLocation = NBTUtils.readVecFromNBT(node);
                        powerPath.add(nodeLocation);
                    }
                    pathsList.add(powerPath);
                }
                this.nodePaths.put(type, pathsList);
            }
        }
    }

    public HashMap<PowerTypes, ArrayList<LinkedList<Vec3d>>> getNodePaths() {
        return (HashMap)this.nodePaths.clone();
    }
}

