/*
 * Decompiled with CFR 0.152.
 */
package am2.particles.ribbon;

import am2.particles.AMParticleIcons;
import am2.particles.ribbon.Quad3D;
import java.util.LinkedList;
import net.minecraft.util.math.Vec3d;

public class RibbonCurve {
    float ribbonWidth;
    float resolution;
    Vec3d startPt;
    Vec3d endPt;
    Vec3d controlPt;
    int stepId;
    float ribbonColor = 0.0f;
    LinkedList<Quad3D> quads;

    RibbonCurve(Vec3d pStartPt, Vec3d pEndPt, Vec3d pControlPt, float pwidth, float presolution, float pcolor) {
        this.startPt = pStartPt;
        this.endPt = pEndPt;
        this.controlPt = pControlPt;
        this.resolution = presolution;
        this.ribbonWidth = pwidth;
        this.stepId = 0;
        this.ribbonColor = pcolor;
        this.quads = new LinkedList();
    }

    void draw() {
        int size = this.quads.size();
        for (int i = 0; i < size; ++i) {
            Quad3D q = this.quads.get(i);
            q.draw();
        }
    }

    void removeSegment() {
        if (this.quads.size() > 1) {
            this.quads.removeFirst();
        }
    }

    void addSegment() {
        float t = (float)this.stepId / this.resolution;
        Vec3d p0 = this.getOffsetPoint(t, 0.0f);
        Vec3d p3 = this.getOffsetPoint(t, this.ribbonWidth);
        ++this.stepId;
        if ((float)this.stepId > this.resolution) {
            return;
        }
        t = (float)this.stepId / this.resolution;
        Vec3d p1 = this.getOffsetPoint(t, 0.0f);
        Vec3d p2 = this.getOffsetPoint(t, this.ribbonWidth);
        Quad3D q = new Quad3D(p0, p1, p2, p3, AMParticleIcons.instance.getIconByName("symbols"));
        this.quads.add(q);
    }

    Vec3d getOffsetPoint(float t, float k) {
        Vec3d p0 = this.startPt;
        Vec3d p1 = this.controlPt;
        Vec3d p2 = this.endPt;
        double xt = (double)((1.0f - t) * (1.0f - t)) * p0.field_72450_a + (double)(2.0f * t * (1.0f - t)) * p1.field_72450_a + (double)(t * t) * p2.field_72450_a;
        double yt = (double)((1.0f - t) * (1.0f - t)) * p0.field_72448_b + (double)(2.0f * t * (1.0f - t)) * p1.field_72448_b + (double)(t * t) * p2.field_72448_b;
        double zt = (double)((1.0f - t) * (1.0f - t)) * p0.field_72449_c + (double)(2.0f * t * (1.0f - t)) * p1.field_72449_c + (double)(t * t) * p2.field_72449_c;
        double xd = (double)t * (p0.field_72450_a - 2.0 * p1.field_72450_a + p2.field_72450_a) - p0.field_72450_a + p1.field_72450_a;
        double yd = (double)t * (p0.field_72448_b - 2.0 * p1.field_72448_b + p2.field_72448_b) - p0.field_72448_b + p1.field_72448_b;
        double zd = (double)t * (p0.field_72449_c - 2.0 * p1.field_72449_c + p2.field_72449_c) - p0.field_72449_c + p1.field_72449_c;
        double dd = (float)Math.pow(xd * xd + yd * yd + zd * zd, 0.0);
        return new Vec3d(xt + (double)k * yd / dd, yt - (double)k * xd / dd, zt - (double)k * xd / dd);
    }
}

