/*
 * Decompiled with CFR 0.152.
 */
package am2.particles.ribbon;

import am2.particles.ribbon.PerlinNoise;
import am2.particles.ribbon.RibbonCurve;
import java.util.LinkedList;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class AMRibbon
extends Particle {
    int NUMCURVES = 5;
    int CURVERESOLUTION = 25;
    float RIBBONWIDTH = 2.25f;
    float NOISESTEP = 0.005f;
    float MAXSEPARATION = 2.0f;
    PerlinNoise noise;
    float ribbonSeparation;
    float noisePosn;
    Vector<Vec3d> pts;
    LinkedList<RibbonCurve> curves;
    float ribbonColor;
    float ribbonWidth;
    RibbonCurve currentCurve;
    int stepId;
    int movement = 2;
    Vec3d ribbonTarget;

    public AMRibbon(World world, float pcolor, float width, double x, double y, double z) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.func_187109_b(x, y, z);
        this.field_187129_i = 0.0;
        this.field_187130_j = 0.0;
        this.field_187131_k = 0.0;
        this.noise = new PerlinNoise();
        this.curves = new LinkedList();
        this.pts = new Vector();
        this.ribbonColor = pcolor;
        this.ribbonWidth = width;
        this.stepId = 0;
        this.ribbonTarget = new Vec3d((double)this.random(-this.movement, this.movement), (double)this.random(-this.movement, this.movement), (double)this.random(-this.movement, this.movement));
        this.ribbonSeparation = this.lerp(-this.MAXSEPARATION, this.MAXSEPARATION, this.noise.noise1(this.noisePosn += this.NOISESTEP));
        this.pts.addElement(this.getRandPt());
        this.pts.addElement(this.getRandPt());
        this.pts.addElement(this.getRandPt());
        this.field_70546_d = 0;
        this.field_70547_e = 200;
        this.addRibbonCurve();
    }

    public void func_180434_a(VertexBuffer par1Tessellator, Entity ent, float partialframe, float cosyaw, float cospitch, float sinyaw, float sinsinpitch, float cossinpitch) {
        GL11.glPushAttrib((int)16640);
        GL11.glDisable((int)2884);
        GL11.glTexEnvf((int)8960, (int)8704, (float)8448.0f);
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        double d = this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialframe - Minecraft.func_71410_x().func_175598_ae().field_78730_l;
        double d1 = this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialframe - Minecraft.func_71410_x().func_175598_ae().field_78731_m;
        double d2 = this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialframe - Minecraft.func_71410_x().func_175598_ae().field_78728_n;
        GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.draw();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    public int func_70537_b() {
        return 2;
    }

    void draw() {
        this.ribbonTarget = new Vec3d((double)this.random(-this.movement, this.movement), (double)this.random(-this.movement, this.movement), (double)this.random(-this.movement, this.movement));
        this.ribbonSeparation = this.lerp(-this.MAXSEPARATION, this.MAXSEPARATION, this.noise.noise1(this.noisePosn += this.NOISESTEP));
        this.currentCurve.addSegment();
        int size = this.curves.size();
        if (size > this.NUMCURVES - 1) {
            RibbonCurve c = this.curves.get(0);
            c.removeSegment();
        }
        ++this.stepId;
        if (this.stepId > this.CURVERESOLUTION) {
            this.addRibbonCurve();
        }
        for (int i = 0; i < size; ++i) {
            RibbonCurve c = this.curves.get(i);
            c.draw();
        }
    }

    private float random(float min, float max) {
        return (float)(Math.random() * (double)max - (double)min);
    }

    private float lerp(float start, float stop, float amount) {
        return start + (stop - start) * amount;
    }

    void addRibbonCurve() {
        this.pts.addElement(this.getRandPt());
        Vec3d nextPt = this.pts.elementAt(this.pts.size() - 1);
        Vec3d curPt = this.pts.elementAt(this.pts.size() - 2);
        Vec3d lastPt = this.pts.elementAt(this.pts.size() - 3);
        Vec3d lastMidPt = new Vec3d((curPt.field_72450_a + lastPt.field_72450_a) / 2.0, (curPt.field_72448_b + lastPt.field_72448_b) / 2.0, (curPt.field_72449_c + lastPt.field_72449_c) / 2.0);
        Vec3d midPt = new Vec3d((curPt.field_72450_a + nextPt.field_72450_a) / 2.0, (curPt.field_72448_b + nextPt.field_72448_b) / 2.0, (curPt.field_72449_c + nextPt.field_72449_c) / 2.0);
        float width = 0.2f;
        this.currentCurve = new RibbonCurve(lastMidPt, midPt, curPt, width, this.CURVERESOLUTION, this.ribbonColor);
        this.curves.add(this.currentCurve);
        if (this.curves.size() > this.NUMCURVES) {
            this.curves.removeFirst();
        }
        this.stepId = 0;
    }

    Vec3d getRandPt() {
        return new Vec3d(this.ribbonTarget.field_72450_a + (double)this.random(-this.ribbonSeparation, this.ribbonSeparation), this.ribbonTarget.field_72448_b + (double)this.random(-this.ribbonSeparation, this.ribbonSeparation), this.ribbonTarget.field_72449_c + (double)this.random(-this.ribbonSeparation, this.ribbonSeparation));
    }

    public void func_189213_a() {
        super.func_189213_a();
    }
}

