/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.particles.AMLineArc;
import am2.particles.AMParticle;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;

public class ParticleRenderer {
    public static String name = "am2-particle";
    private final ArrayList<Particle> particles;
    private final ArrayList<Particle> blocks;
    private final ArrayList<Particle> radiants;
    private final ArrayList<AMLineArc> arcs;
    private final ArrayList<Particle> deferredParticles;
    private final ArrayList<Particle> deferredBlocks;
    private final ArrayList<Particle> deferredRadiants;
    private final ArrayList<AMLineArc> deferredArcs;

    public ParticleRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.particles = new ArrayList();
        this.radiants = new ArrayList();
        this.arcs = new ArrayList();
        this.blocks = new ArrayList();
        this.deferredParticles = new ArrayList();
        this.deferredRadiants = new ArrayList();
        this.deferredArcs = new ArrayList();
        this.deferredBlocks = new ArrayList();
    }

    public void addEffect(Particle effect) {
        if (effect instanceof AMParticle) {
            this.addAMParticle((AMParticle)effect);
        } else if (effect instanceof AMLineArc) {
            this.addArcEffect((AMLineArc)effect);
        } else {
            this.deferredParticles.add(effect);
        }
    }

    public void addAMParticle(AMParticle particle) {
        if (particle.isRadiant()) {
            this.deferredRadiants.add(particle);
        } else if (particle.isBlockTexture()) {
            this.deferredBlocks.add(particle);
        } else {
            this.deferredParticles.add(particle);
        }
    }

    public void addArcEffect(AMLineArc arc) {
        this.deferredArcs.add(arc);
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        this.render(event.getPartialTicks());
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        this.particles.clear();
        this.radiants.clear();
        this.arcs.clear();
        this.blocks.clear();
        this.deferredParticles.clear();
        this.deferredRadiants.clear();
        this.deferredArcs.clear();
        this.deferredBlocks.clear();
    }

    @SubscribeEvent
    public void onTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.updateParticles();
        }
    }

    private void updateParticles() {
        Particle particle;
        Minecraft.func_71410_x().field_71424_I.func_76320_a(name + "-update");
        this.particles.addAll(this.deferredParticles);
        this.deferredParticles.clear();
        this.radiants.addAll(this.deferredRadiants);
        this.deferredRadiants.clear();
        this.arcs.addAll(this.deferredArcs);
        this.deferredArcs.clear();
        this.blocks.addAll(this.deferredBlocks);
        this.deferredBlocks.clear();
        Iterator<Particle> it = this.particles.iterator();
        while (it.hasNext()) {
            particle = it.next();
            particle.func_189213_a();
            if (particle.func_187113_k()) continue;
            it.remove();
        }
        it = this.radiants.iterator();
        while (it.hasNext()) {
            particle = it.next();
            particle.func_189213_a();
            if (particle.func_187113_k()) continue;
            it.remove();
        }
        it = this.arcs.iterator();
        while (it.hasNext()) {
            particle = (AMLineArc)it.next();
            particle.func_189213_a();
            if (particle.func_187113_k()) continue;
            it.remove();
        }
        it = this.blocks.iterator();
        while (it.hasNext()) {
            particle = it.next();
            particle.func_189213_a();
            if (particle.func_187113_k()) continue;
            it.remove();
        }
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    private void render(float partialTicks) {
        GL11.glPushAttrib((int)16640);
        Minecraft.func_71410_x().field_71424_I.func_76320_a(name + "-render");
        EntityLivingBase player = (EntityLivingBase)Minecraft.func_71410_x().func_175606_aa();
        Particle.field_70556_an = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        Particle.field_70554_ao = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        Particle.field_70555_ap = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.renderBlockParticles(partialTicks);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.renderStandardParticles(partialTicks);
        this.renderRadiants(partialTicks);
        this.renderArcs(partialTicks);
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
        GL11.glPopAttrib();
    }

    private void renderStandardParticles(float partialTicks) {
        float rotationX = ActiveRenderInfo.func_178808_b();
        float rotationZ = ActiveRenderInfo.func_178803_d();
        float rotationYZ = ActiveRenderInfo.func_178805_e();
        float rotationXY = ActiveRenderInfo.func_178807_f();
        float rotationXZ = ActiveRenderInfo.func_178809_c();
        GL11.glPushAttrib((int)16640);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        GL11.glDisable((int)32826);
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (Particle particle : this.particles) {
            particle.func_180434_a(tessellator.func_178180_c(), Minecraft.func_71410_x().func_175606_aa(), partialTicks, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
        }
        tessellator.func_78381_a();
        GL11.glPopAttrib();
    }

    private void renderBlockParticles(float partialTicks) {
        float rotationX = ActiveRenderInfo.func_178808_b();
        float rotationZ = ActiveRenderInfo.func_178803_d();
        float rotationYZ = ActiveRenderInfo.func_178805_e();
        float rotationXY = ActiveRenderInfo.func_178807_f();
        float rotationXZ = ActiveRenderInfo.func_178809_c();
        GL11.glPushAttrib((int)16640);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        GL11.glDisable((int)32826);
        Tessellator tessellator = Tessellator.func_178181_a();
        for (Particle particle : this.blocks) {
            particle.func_180434_a(tessellator.func_178180_c(), Minecraft.func_71410_x().func_175606_aa(), partialTicks, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
        }
        GL11.glPopAttrib();
    }

    private void renderRadiants(float partialTicks) {
        float rotationX = ActiveRenderInfo.func_178808_b();
        float rotationZ = ActiveRenderInfo.func_178803_d();
        float rotationYZ = ActiveRenderInfo.func_178805_e();
        float rotationXY = ActiveRenderInfo.func_178807_f();
        float rotationXZ = ActiveRenderInfo.func_178809_c();
        GL11.glPushAttrib((int)16640);
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)2884);
        GL11.glDepthMask((boolean)false);
        Tessellator tessellator = Tessellator.func_178181_a();
        for (Particle particle : this.radiants) {
            particle.func_180434_a(tessellator.func_178180_c(), Minecraft.func_71410_x().func_175606_aa(), partialTicks, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
        }
        GL11.glPopAttrib();
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glShadeModel((int)7424);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
    }

    private void renderArcs(float partialTicks) {
        float rotationX = ActiveRenderInfo.func_178808_b();
        float rotationZ = ActiveRenderInfo.func_178803_d();
        float rotationYZ = ActiveRenderInfo.func_178805_e();
        float rotationXY = ActiveRenderInfo.func_178807_f();
        float rotationXZ = ActiveRenderInfo.func_178809_c();
        Tessellator tessellator = Tessellator.func_178181_a();
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)2884);
        for (AMLineArc particle : this.arcs) {
            particle.func_180434_a(tessellator.func_178180_c(), Minecraft.func_71410_x().func_175606_aa(), partialTicks, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
        }
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }
}

