/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.particles.AMParticle;
import am2.particles.ParticleController;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class ParticleFleePoint
extends ParticleController {
    private Vec3d target;
    private double fleeSpeed;
    private double targetDistance;

    public ParticleFleePoint(AMParticle particleEffect, Vec3d fleePoint, double fleeSpeed, double targetDistance, int priority, boolean exclusive) {
        super(particleEffect, priority, exclusive);
        this.target = fleePoint;
        this.fleeSpeed = fleeSpeed;
        this.targetDistance = targetDistance;
    }

    @Override
    public void doUpdate() {
        double angle;
        double posY = this.particle.getPosY();
        double distanceToTarget = new Vec3d(this.particle.getPosX(), this.particle.getPosY(), this.particle.getPosZ()).func_72438_d(this.target);
        double deltaZ = this.particle.getPosZ() - this.target.field_72449_c;
        double deltaX = this.particle.getPosX() - this.target.field_72450_a;
        double radians = angle = Math.atan2(deltaZ, deltaX);
        double posX = this.particle.getPosX() + this.fleeSpeed * Math.cos(radians);
        double posZ = this.particle.getPosZ() + this.fleeSpeed * Math.sin(radians);
        double deltaY = this.target.field_72448_b - posY;
        double horizontalDistance = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
        float pitchRotation = (float)(-Math.atan2(deltaY, horizontalDistance));
        double pitchRadians = pitchRotation;
        posY = this.particle.getPosY() + this.fleeSpeed * Math.sin(pitchRadians);
        if (distanceToTarget > this.targetDistance) {
            this.finish();
        } else {
            this.particle.func_187109_b(posX, posY, posZ);
        }
    }

    @Override
    public ParticleController clone() {
        return new ParticleFleePoint(this.particle, this.target, this.fleeSpeed, this.targetDistance, this.priority, this.exclusive);
    }
}

