/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.particles.AMParticle;
import net.minecraft.world.World;

public abstract class ParticleController {
    protected AMParticle particle;
    protected int priority;
    protected boolean exclusive;
    private boolean finished;
    private boolean killParticleOnFinish;
    protected boolean firstTick = true;
    public static String[] AuraControllerOptions = new String[]{"fade", "float", "sink", "orbit", "arc", "flee", "forward", "pendulum", "grow"};

    public ParticleController(AMParticle particleEffect, int priority, boolean exclusive) {
        this.particle = particleEffect;
        this.priority = priority;
        this.exclusive = exclusive;
        this.killParticleOnFinish = false;
    }

    protected ParticleController targetNewParticle(AMParticle particle) {
        if (this.particle != null) {
            this.particle.RemoveParticleController(this);
        }
        particle.AddParticleController(this);
        this.particle = particle;
        return this;
    }

    public ParticleController setKillParticleOnFinish(boolean kill) {
        this.killParticleOnFinish = kill;
        return this;
    }

    public boolean getKillParticleOnFinish() {
        return this.killParticleOnFinish;
    }

    public abstract void doUpdate();

    public abstract ParticleController clone();

    public void onUpdate(World world) {
        if (!world.field_72995_K) {
            if (this.particle != null) {
                this.particle.func_187112_i();
            }
            return;
        }
        if (this.particle != null) {
            this.doUpdate();
        }
        if (this.firstTick) {
            this.firstTick = false;
        }
    }

    public int getPriority() {
        return this.priority;
    }

    protected void finish() {
        this.finished = true;
        if (this.killParticleOnFinish && this.particle != null) {
            this.particle.func_187112_i();
        }
    }

    public boolean getExclusive() {
        return this.exclusive;
    }

    public boolean getFinished() {
        return this.finished;
    }
}

