/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.particles.AMParticle;
import am2.particles.ParticleController;
import am2.utils.MathUtilities;
import net.minecraft.util.math.Vec3d;

public class ParticleArcToPoint
extends ParticleController {
    private final Vec3d start;
    private final Vec3d target;
    private Vec3d firstControl;
    private Vec3d secondControl;
    private float percent;
    private float speed;
    private final float offsetFactor;
    private final float halfOffsetFactor;

    public ParticleArcToPoint(AMParticle particleEffect, int priority, double startX, double startY, double startZ, double endX, double endY, double endZ, boolean exclusive) {
        super(particleEffect, priority, exclusive);
        this.start = new Vec3d(startX, startY, startZ);
        this.target = new Vec3d(endX, endY, endZ);
        this.percent = 0.0f;
        this.speed = 0.03f;
        this.offsetFactor = 10.0f;
        this.halfOffsetFactor = this.offsetFactor / 2.0f;
        this.generateControlPoints();
    }

    public ParticleArcToPoint(AMParticle particleEffect, int priority, double endX, double endY, double endZ, boolean exclusive) {
        this(particleEffect, priority, particleEffect.getPosX(), particleEffect.getPosY(), particleEffect.getPosZ(), endX, endY, endZ, exclusive);
    }

    public ParticleArcToPoint generateControlPoints() {
        this.firstControl = new Vec3d(this.start.field_72450_a + (this.target.field_72450_a - this.start.field_72450_a) / 3.0, this.start.field_72448_b + (this.target.field_72448_b - this.start.field_72448_b) / 3.0, this.start.field_72449_c + (this.target.field_72449_c - this.start.field_72449_c) / 3.0);
        this.secondControl = new Vec3d(this.start.field_72450_a + (this.target.field_72450_a - this.start.field_72450_a) / 3.0 * 2.0, this.start.field_72448_b + (this.target.field_72448_b - this.start.field_72448_b) / 3.0 * 2.0, this.start.field_72449_c + (this.target.field_72449_c - this.start.field_72449_c) / 3.0 * 2.0);
        double offsetX = this.particle.getWorldObj().field_73012_v.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        double offsetZ = this.particle.getWorldObj().field_73012_v.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        double offsetY = this.particle.getWorldObj().field_73012_v.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        Vec3d offset = new Vec3d(offsetX, offsetY, offsetZ);
        this.firstControl = this.firstControl.func_178787_e(offset);
        this.secondControl = this.secondControl.func_178787_e(offset);
        return this;
    }

    public ParticleArcToPoint specifyControlPoints(Vec3d first, Vec3d second) {
        this.firstControl = first;
        this.secondControl = second;
        return this;
    }

    public ParticleArcToPoint SetSpeed(float speed) {
        this.speed = speed;
        return this;
    }

    @Override
    public void doUpdate() {
        this.percent += this.speed;
        if (this.percent >= 1.0f) {
            this.finish();
            return;
        }
        Vec3d bez = MathUtilities.bezier(this.start, this.firstControl, this.secondControl, this.target, this.percent);
        this.particle.func_187109_b(bez.field_72450_a, bez.field_72448_b, bez.field_72449_c);
    }

    @Override
    public ParticleController clone() {
        return new ParticleArcToPoint(this.particle, this.priority, this.target.field_72450_a, this.target.field_72448_b, this.target.field_72449_c, this.exclusive).SetSpeed(this.speed).specifyControlPoints(this.firstControl, this.secondControl);
    }
}

