/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.ArsMagica2;
import am2.particles.AMParticle;
import am2.particles.ParticleColorShift;
import am2.particles.ParticleController;
import am2.utils.MathUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;

public class ParticleArcToEntity
extends ParticleController {
    private Vec3d start;
    private Entity target;
    private Vec3d firstControl;
    private Vec3d secondControl;
    private float percent;
    private float speed;
    private float offsetFactor;
    private float halfOffsetFactor;

    public ParticleArcToEntity(AMParticle particleEffect, int priority, double startX, double startY, double startZ, Entity target, boolean exclusive) {
        super(particleEffect, priority, exclusive);
        this.start = new Vec3d(startX, startY, startZ);
        this.percent = 0.0f;
        this.speed = 0.03f;
        this.offsetFactor = 10.0f;
        this.halfOffsetFactor = this.offsetFactor / 2.0f;
        this.target = target;
        this.generateControlPoints();
    }

    public ParticleArcToEntity(AMParticle particleEffect, int priority, Entity target, boolean exclusive) {
        this(particleEffect, priority, particleEffect.getPosX(), particleEffect.getPosY(), particleEffect.getPosZ(), target, exclusive);
    }

    public ParticleArcToEntity generateControlPoints() {
        this.firstControl = new Vec3d(this.start.field_72450_a + (this.target.field_70165_t - this.start.field_72450_a) / 3.0, this.start.field_72448_b + (this.target.field_70163_u - this.start.field_72448_b) / 3.0, this.start.field_72449_c + (this.target.field_70161_v - this.start.field_72449_c) / 3.0);
        this.secondControl = new Vec3d(this.start.field_72450_a + (this.target.field_70165_t - this.start.field_72450_a) / 3.0 * 2.0, this.start.field_72448_b + (this.target.field_70163_u - this.start.field_72448_b) / 3.0 * 2.0, this.start.field_72449_c + (this.target.field_70161_v - this.start.field_72449_c) / 3.0 * 2.0);
        double offsetX = this.particle.getWorldObj().field_73012_v.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        double offsetZ = this.particle.getWorldObj().field_73012_v.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        Vec3d offset = new Vec3d(offsetX, 0.0, offsetZ);
        this.firstControl = this.firstControl.func_178787_e(offset);
        this.secondControl = this.secondControl.func_178787_e(offset);
        this.addParticleAtPoint(this.start);
        this.addParticleAtPoint(this.firstControl);
        this.addParticleAtPoint(this.secondControl);
        this.addParticleAtPoint(new Vec3d(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v));
        return this;
    }

    private void addParticleAtPoint(Vec3d point) {
        AMParticle p = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.particle.getWorldObj(), "smoke", point.field_72450_a, point.field_72448_b, point.field_72449_c));
        if (p != null) {
            p.setIgnoreMaxAge(false);
            p.func_187114_a(200);
            p.setParticleScale(1.5f);
            p.AddParticleController(new ParticleColorShift(p, 1, false));
        }
    }

    public ParticleArcToEntity specifyControlPoints(Vec3d first, Vec3d second) {
        this.firstControl = first;
        this.secondControl = second;
        return this;
    }

    public ParticleArcToEntity SetSpeed(float speed) {
        this.speed = speed;
        return this;
    }

    @Override
    public void doUpdate() {
        this.percent += this.speed;
        if (this.percent >= 1.0f) {
            this.finish();
            return;
        }
        Vec3d bez = MathUtilities.bezier(this.start, this.firstControl, this.secondControl, new Vec3d(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v).func_178787_e(new Vec3d(0.0, (double)this.target.func_70047_e(), 0.0)), this.percent);
        this.particle.func_187109_b(bez.field_72450_a, bez.field_72448_b, bez.field_72449_c);
    }

    @Override
    public ParticleController clone() {
        return new ParticleArcToEntity(this.particle, this.priority, this.target, this.exclusive).SetSpeed(this.speed).specifyControlPoints(this.firstControl, this.secondControl);
    }
}

