/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.particles.AMParticle;
import am2.particles.ParticleController;
import net.minecraft.util.math.MathHelper;

public class ParticleApproachPoint
extends ParticleController {
    private final double targetX;
    private final double targetY;
    private final double targetZ;
    private final double approachSpeed;
    private final double targetDistance;
    private boolean ignoreYCoord;

    public ParticleApproachPoint(AMParticle particleEffect, double targetX, double targetY, double targetZ, double approachSpeed, double targetDistance, int priority, boolean exclusive) {
        super(particleEffect, priority, exclusive);
        this.targetX = targetX;
        this.targetY = targetY;
        this.targetZ = targetZ;
        this.approachSpeed = approachSpeed;
        this.targetDistance = targetDistance;
    }

    private double getDistanceSqToPoint(double x, double y, double z) {
        double var2 = this.particle.getPosX() - x;
        double var4 = this.particle.getPosY() - y;
        double var6 = this.particle.getPosZ() - z;
        return var2 * var2 + var4 * var4 + var6 * var6;
    }

    public ParticleApproachPoint setIgnoreYCoordinate(boolean ignore) {
        this.ignoreYCoord = ignore;
        return this;
    }

    @Override
    public void doUpdate() {
        double posX = this.particle.getPosX();
        double posZ = this.particle.getPosZ();
        double posY = this.particle.getPosY();
        double distanceToTarget = this.getDistanceSqToPoint(this.targetX, this.targetY, this.targetZ);
        double deltaZ = this.targetZ - this.particle.getPosZ();
        double deltaX = this.targetX - this.particle.getPosX();
        if (Math.abs(deltaX) > this.targetDistance || Math.abs(deltaZ) > this.targetDistance) {
            double angle;
            double radians = angle = Math.atan2(deltaZ, deltaX);
            posX = this.particle.getPosX() + this.approachSpeed * Math.cos(radians);
            posZ = this.particle.getPosZ() + this.approachSpeed * Math.sin(radians);
        }
        if (!this.ignoreYCoord) {
            double deltaY = posY - this.targetY;
            double horizontalDistance = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
            float pitchRotation = (float)(-Math.atan2(deltaY, horizontalDistance));
            double pitchRadians = pitchRotation;
            posY = this.particle.getPosY() + this.approachSpeed * Math.sin(pitchRadians);
        }
        if (distanceToTarget <= this.targetDistance * this.targetDistance) {
            this.finish();
        } else {
            this.particle.func_187109_b(posX, posY, posZ);
        }
    }

    @Override
    public ParticleController clone() {
        return new ParticleApproachPoint(this.particle, this.targetX, this.targetY, this.targetZ, this.approachSpeed, this.targetDistance, this.priority, this.exclusive).setIgnoreYCoordinate(this.ignoreYCoord);
    }
}

