/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.particles.AMParticleIcons;
import am2.particles.ParticleController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AMParticle
extends Particle {
    private boolean ignoreMaxAge;
    private final List<ParticleController> controllers;
    private final ControllerComparator comparer;
    private float particleRed;
    private float particleGreen;
    private float particleBlue;
    private float particleAlpha;
    private float particleScaleX = 0.2f;
    private float particleScaleY = 0.2f;
    private float particleScaleZ = 0.2f;
    private boolean isRadiant = false;
    private boolean isBreak = false;
    private boolean isAffectedByGravity = false;
    private boolean ignoreNoControllers = false;
    private boolean doVelocityUpdates = true;
    public static String[] particleTypes;

    public void setParticleAge(int age) {
        this.field_70546_d = age;
    }

    public AMParticle(World par1World, double par2, double par4, double par6) {
        super(par1World, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.field_187129_i = 0.0;
        this.field_187130_j = 0.0;
        this.field_187131_k = 0.0;
        this.func_187109_b(par2, par4, par6);
        par2 += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
        par4 += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
        par6 += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
        this.particleAlpha = 1.0f;
        this.particleBlue = 1.0f;
        this.particleGreen = 1.0f;
        this.particleRed = 1.0f;
        this.ignoreMaxAge = false;
        this.field_70547_e = 20 + this.field_187136_p.nextInt(20);
        this.controllers = new ArrayList<ParticleController>();
        this.comparer = new ControllerComparator();
        this.field_70545_g = 1.0f;
        this.setRandomScale(0.1f, 0.3f);
    }

    public AMParticle setAffectedByGravity() {
        this.isAffectedByGravity = true;
        return this;
    }

    public AMParticle setDontRequireControllers() {
        this.ignoreNoControllers = true;
        return this;
    }

    public void setNoVelocityUpdates() {
        this.doVelocityUpdates = false;
    }

    public boolean isRadiant() {
        return this.isRadiant;
    }

    public boolean isBlockTexture() {
        return this.isBreak;
    }

    public void addRandomOffset(double maxX, double maxY, double maxZ) {
        double newX = this.field_187126_f + this.field_187136_p.nextDouble() * maxX - maxX / 2.0;
        double newY = this.field_187127_g + this.field_187136_p.nextDouble() * maxY - maxY / 2.0;
        double newZ = this.field_187128_h + this.field_187136_p.nextDouble() * maxZ - maxZ / 2.0;
        this.func_187109_b(newX, newY, newZ);
    }

    public float getParticleScaleX() {
        return this.particleScaleX;
    }

    public float getParticleScaleY() {
        return this.particleScaleY;
    }

    public float getParticleScaleZ() {
        return this.particleScaleZ;
    }

    public AMParticle setRandomScale(float min, float max) {
        this.setParticleScale(this.field_187136_p.nextFloat() * (max - min) + min);
        return this;
    }

    public void setParticleScale(float scale) {
        this.particleScaleX = scale;
        this.particleScaleY = scale;
        this.particleScaleZ = scale;
    }

    public void setParticleScale(float scaleX, float scaleY, float scaleZ) {
        this.particleScaleX = scaleX;
        this.particleScaleY = scaleY;
        this.particleScaleZ = scaleZ;
    }

    public int GetParticleAge() {
        return this.field_70546_d;
    }

    public int GetParticleMaxAge() {
        return this.field_70547_e;
    }

    public void func_187114_a(int age) {
        this.field_70547_e = age;
    }

    public void setIgnoreMaxAge(boolean ignore) {
        this.ignoreMaxAge = ignore;
        this.field_70546_d = 0;
    }

    public void setRGBColorF(float r, float g, float b) {
        this.particleRed = r;
        this.particleGreen = g;
        this.particleBlue = b;
    }

    public void setRGBColorI(int color) {
        this.particleRed = (float)(color >> 16 & 0xFF) / 255.0f;
        this.particleGreen = (float)(color >> 8 & 0xFF) / 255.0f;
        this.particleBlue = (float)(color & 0xFF) / 255.0f;
    }

    public void SetParticleAlpha(float alpha) {
        this.particleAlpha = alpha;
    }

    public float GetParticleRed() {
        return this.particleRed;
    }

    public float GetParticleGreen() {
        return this.particleGreen;
    }

    public float GetParticleBlue() {
        return this.particleBlue;
    }

    public float GetParticleAlpha() {
        return this.particleAlpha;
    }

    public void AddParticleController(ParticleController controller) {
        this.controllers.add(controller);
        Collections.sort(this.controllers, this.comparer);
    }

    public void RemoveParticleController(ParticleController controller) {
        this.controllers.remove(controller);
    }

    public void ClearParticleControllers() {
        this.controllers.clear();
    }

    public int func_189214_a(float par1) {
        float f = ((float)this.field_70546_d + par1) / (float)this.field_70547_e;
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        int i = super.func_189214_a(par1);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.isAffectedByGravity) {
            this.field_187130_j -= 0.04 * (double)this.field_70545_g;
        }
        if (this.doVelocityUpdates) {
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        }
        ArrayList<ParticleController> remove = new ArrayList<ParticleController>();
        for (ParticleController pmc : this.controllers) {
            if (pmc.getFinished()) {
                remove.add(pmc);
                continue;
            }
            pmc.onUpdate(this.field_187122_b);
            if (!pmc.getExclusive()) continue;
            break;
        }
        for (ParticleController pmc : remove) {
            this.controllers.remove(pmc);
        }
        if (this.field_70546_d++ > this.field_70547_e && !this.ignoreMaxAge || !this.ignoreNoControllers && this.controllers.size() == 0) {
            this.func_187112_i();
        }
    }

    public int func_70537_b() {
        return 2;
    }

    public void func_180434_a(VertexBuffer tessellator, Entity ent, float partialframe, float cosyaw, float cospitch, float sinyaw, float sinsinpitch, float cossinpitch) {
        if (!this.field_187122_b.field_72995_K) {
            return;
        }
        float f11 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialframe - field_70556_an);
        float f12 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialframe - field_70554_ao);
        float f13 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialframe - field_70555_ap);
        if (this.isRadiant) {
            this.renderRadiant(Tessellator.func_178181_a(), partialframe);
        } else {
            if (this.field_187119_C == null) {
                return;
            }
            float scaleFactorX = this.getParticleScaleX();
            float scaleFactorY = this.getParticleScaleY();
            float scaleFactorZ = this.getParticleScaleZ();
            float min_u = this.field_187119_C.func_94209_e();
            float min_v = this.field_187119_C.func_94206_g();
            float max_u = this.field_187119_C.func_94212_f();
            float max_v = this.field_187119_C.func_94210_h();
            tessellator.func_181662_b((double)(f11 - cosyaw * scaleFactorX - sinsinpitch * scaleFactorX), (double)(f12 - cospitch * scaleFactorY), (double)(f13 - sinyaw * scaleFactorZ - cossinpitch * scaleFactorZ)).func_187315_a((double)max_u, (double)max_v).func_181666_a(this.GetParticleRed(), this.GetParticleGreen(), this.GetParticleBlue(), this.GetParticleAlpha()).func_181675_d();
            tessellator.func_181662_b((double)(f11 - cosyaw * scaleFactorX + sinsinpitch * scaleFactorX), (double)(f12 + cospitch * scaleFactorY), (double)(f13 - sinyaw * scaleFactorZ + cossinpitch * scaleFactorZ)).func_187315_a((double)max_u, (double)min_v).func_181666_a(this.GetParticleRed(), this.GetParticleGreen(), this.GetParticleBlue(), this.GetParticleAlpha()).func_181675_d();
            tessellator.func_181662_b((double)(f11 + cosyaw * scaleFactorX + sinsinpitch * scaleFactorX), (double)(f12 + cospitch * scaleFactorY), (double)(f13 + sinyaw * scaleFactorZ + cossinpitch * scaleFactorZ)).func_187315_a((double)min_u, (double)min_v).func_181666_a(this.GetParticleRed(), this.GetParticleGreen(), this.GetParticleBlue(), this.GetParticleAlpha()).func_181675_d();
            tessellator.func_181662_b((double)(f11 + cosyaw * scaleFactorX - sinsinpitch * scaleFactorX), (double)(f12 - cospitch * scaleFactorY), (double)(f13 + sinyaw * scaleFactorZ - cossinpitch * scaleFactorZ)).func_187315_a((double)min_u, (double)max_v).func_181666_a(this.GetParticleRed(), this.GetParticleGreen(), this.GetParticleBlue(), this.GetParticleAlpha()).func_181675_d();
        }
    }

    private void renderRadiant(Tessellator tessellator, float partialFrame) {
        RenderHelper.func_74518_a();
        float var4 = ((float)this.GetParticleAge() + partialFrame) / (float)this.GetParticleMaxAge();
        float var5 = 0.0f;
        if (var4 > 0.8f) {
            var5 = (var4 - 0.8f) / 0.2f;
        }
        Random var6 = new Random(432L);
        float f11 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialFrame - Minecraft.func_71410_x().func_175598_ae().field_78730_l);
        float f12 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialFrame - Minecraft.func_71410_x().func_175598_ae().field_78731_m);
        float f13 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialFrame - Minecraft.func_71410_x().func_175598_ae().field_78728_n);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)f11, (float)f12, (float)f13);
        GlStateManager.func_179152_a((float)this.getParticleScaleX(), (float)this.getParticleScaleY(), (float)this.getParticleScaleZ());
        int var7 = 0;
        while ((float)var7 < 50.0f) {
            GlStateManager.func_179114_b((float)(var6.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(var6.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(var6.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(var6.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(var6.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(var6.nextFloat() * 360.0f + var4 * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            tessellator.func_178180_c().func_181668_a(6, DefaultVertexFormats.field_181706_f);
            float var8 = var6.nextFloat() * 2.0f + 2.0f + var5 * 0.5f;
            float var9 = var6.nextFloat() * 2.0f + 1.0f + var5 * 2.0f;
            tessellator.func_178180_c().func_181662_b(0.0, 0.0, 0.0).func_181666_a(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha).func_181675_d();
            tessellator.func_178180_c().func_181662_b(-0.866 * (double)var9, (double)var8, (double)(-0.5f * var9)).func_181666_a(this.particleRed, this.particleGreen, this.particleBlue, 0.0f).func_181675_d();
            tessellator.func_178180_c().func_181662_b(0.866 * (double)var9, (double)var8, (double)(-0.5f * var9)).func_181666_a(this.particleRed, this.particleGreen, this.particleBlue, 0.0f).func_181675_d();
            tessellator.func_178180_c().func_181662_b(0.0, (double)var8, (double)(1.0f * var9)).func_181666_a(this.particleRed, this.particleGreen, this.particleBlue, 0.0f).func_181675_d();
            tessellator.func_178180_c().func_181662_b(-0.866 * (double)var9, (double)var8, (double)(-0.5f * var9)).func_181666_a(this.particleRed, this.particleGreen, this.particleBlue, 0.0f).func_181675_d();
            tessellator.func_78381_a();
            ++var7;
        }
        GlStateManager.func_179121_F();
    }

    public double getPosX() {
        return this.field_187126_f;
    }

    public double getPosY() {
        return this.field_187127_g;
    }

    public double getPosZ() {
        return this.field_187128_h;
    }

    public double getPrevPosX() {
        return this.field_187123_c;
    }

    public double getPrevPosY() {
        return this.field_187124_d;
    }

    public double getPrevPosZ() {
        return this.field_187125_e;
    }

    public void setPrevPos(double prevPosX, double prevPosY, double prevPosZ) {
        this.field_187123_c = prevPosX;
        this.field_187124_d = prevPosY;
        this.field_187125_e = prevPosZ;
    }

    public void pushPos() {
        this.setPrevPos(this.field_187126_f, this.field_187127_g, this.field_187128_h);
    }

    public World getWorldObj() {
        return this.field_187122_b;
    }

    public void SetParticleTextureByName(String name) {
        if (name.equalsIgnoreCase("radiant")) {
            this.isRadiant = true;
        }
        this.field_187119_C = AMParticleIcons.instance.getIconByName(name);
    }

    public void setPosition(Entity entity) {
        this.func_187109_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public boolean isCollided() {
        return this.field_187132_l;
    }

    public void addVelocity(double d, double e, double f) {
        this.field_187129_i = d;
        this.field_187130_j = e;
        this.field_187131_k = f;
    }

    public class ControllerComparator
    implements Comparator<ParticleController> {
        @Override
        public int compare(ParticleController o1, ParticleController o2) {
            return o1.getPriority() > o2.getPriority() ? 1 : (o1 == o2 ? 0 : -1);
        }
    }
}

