/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class AMLineArc
extends Particle {
    Vec3d targetPoint;
    Vec3d currentTargetPoint;
    Vec3d sourcePoint;
    Entity targetEntity;
    Entity sourceEntity;
    boolean hadSource = false;
    boolean hadTarget = false;
    boolean ignoreAge = true;
    double deviation;
    float speed;
    float field_187134_n;
    boolean extendToTarget;
    float extensionProgress;
    ResourceLocation rl;
    float forwardFactor;

    public AMLineArc(World world, double x, double y, double z, double targetX, double targetY, double targetZ, String IIconName) {
        super(world, x, y, z);
        this.targetPoint = new Vec3d(targetX, targetY, targetZ);
        this.currentTargetPoint = new Vec3d(this.targetPoint.field_72450_a, this.targetPoint.field_72448_b, this.targetPoint.field_72449_c);
        this.sourcePoint = new Vec3d(x, y, z);
        this.deviation = 1.0;
        this.speed = 0.01f;
        this.field_187134_n = 0.05f;
        this.rl = new ResourceLocation("arsmagica2", IIconName);
        this.field_70547_e = 100;
        this.forwardFactor = 0.0f;
    }

    public AMLineArc(World world, double x, double y, double z, Entity targetEntity, String IIconName) {
        this(world, x, y, z, targetEntity.field_70165_t, targetEntity.field_70163_u + (double)targetEntity.func_70047_e() - (double)(targetEntity.field_70131_O * 0.2f), targetEntity.field_70161_v, IIconName);
        this.targetEntity = targetEntity;
        this.hadTarget = true;
    }

    public AMLineArc(World world, Entity sourceEntity, Entity targetEntity, String IIconName) {
        this(world, sourceEntity.field_70165_t, sourceEntity.field_70163_u + (double)sourceEntity.func_70047_e() - (double)(sourceEntity.field_70131_O * 0.2f), sourceEntity.field_70161_v, targetEntity.field_70165_t, targetEntity.field_70163_u + (double)targetEntity.func_70047_e() - (double)(targetEntity.field_70131_O * 0.2f), targetEntity.field_70161_v, IIconName);
        this.targetEntity = targetEntity;
        this.sourceEntity = sourceEntity;
        this.hadSource = true;
        this.hadTarget = true;
    }

    public AMLineArc setExtendToTarget() {
        this.extendToTarget = true;
        return this;
    }

    public AMLineArc setIgnoreAge(boolean ignore) {
        this.ignoreAge = ignore;
        return this;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d >= this.field_70547_e) {
            this.func_187112_i();
            return;
        }
        if (this.targetEntity != null) {
            if (this.ignoreAge) {
                this.field_70546_d = 0;
            }
            if (this.targetEntity.field_70128_L) {
                this.func_187112_i();
                return;
            }
            this.targetPoint = new Vec3d(this.targetEntity.field_70165_t, this.targetEntity.field_70163_u + (double)this.targetEntity.func_70047_e() - (double)(this.targetEntity.field_70131_O * 0.2f), this.targetEntity.field_70161_v);
            this.currentTargetPoint = this.targetPoint.func_178787_e(Vec3d.field_186680_a);
        } else if (this.hadTarget) {
            this.func_187112_i();
            return;
        }
        if (this.sourceEntity != null) {
            if (this.ignoreAge) {
                this.field_70546_d = 0;
            }
            if (this.sourceEntity.field_70128_L) {
                this.func_187112_i();
                return;
            }
            this.sourcePoint = new Vec3d(this.sourceEntity.field_70165_t, this.sourceEntity.field_70163_u + (double)this.sourceEntity.func_70047_e() - (double)(this.sourceEntity.field_70131_O * 0.2f), this.sourceEntity.field_70161_v);
        } else if (this.hadSource) {
            this.func_187112_i();
            return;
        }
        if (this.extendToTarget && this.extensionProgress < 1.0f) {
            this.extensionProgress = (float)((double)this.extensionProgress + 0.08);
            Vec3d delta = this.targetPoint.func_178788_d(this.sourcePoint);
            delta.func_186678_a((double)this.extensionProgress);
            this.currentTargetPoint = delta.func_178787_e(this.sourcePoint);
        }
        ++this.field_70546_d;
    }

    public void func_180434_a(VertexBuffer par1Tessellator, Entity ent, float partialTicks, float rotationX, float rotationXZ, float rotationZ, float rotationYZ, float rotationXY) {
        if (this.targetEntity != null && this.sourceEntity != null) {
            this.drawArcingLine(this.sourceEntity.field_70169_q + (this.sourceEntity.field_70165_t - this.sourceEntity.field_70169_q) * (double)partialTicks, this.sourceEntity.field_70167_r + (this.sourceEntity.field_70163_u - this.sourceEntity.field_70167_r) * (double)partialTicks + (double)(this.sourceEntity.func_70047_e() - this.sourceEntity.field_70131_O * 0.2f), this.sourceEntity.field_70166_s + (this.sourceEntity.field_70161_v - this.sourceEntity.field_70166_s) * (double)partialTicks, this.targetEntity.field_70169_q + (this.targetEntity.field_70165_t - this.targetEntity.field_70169_q) * (double)partialTicks, this.targetEntity.field_70167_r + (this.targetEntity.field_70163_u - this.targetEntity.field_70167_r) * (double)partialTicks + (double)(this.targetEntity.func_70047_e() - this.targetEntity.field_70131_O * 0.2f), this.targetEntity.field_70166_s + (this.targetEntity.field_70161_v - this.targetEntity.field_70166_s) * (double)partialTicks, partialTicks, this.speed, this.deviation);
        } else if (this.targetEntity != null) {
            this.drawArcingLine(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks, this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks, this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks, this.targetEntity.field_70169_q + (this.targetEntity.field_70165_t - this.targetEntity.field_70169_q) * (double)partialTicks, this.targetEntity.field_70167_r + (this.targetEntity.field_70163_u - this.targetEntity.field_70167_r) * (double)partialTicks + (double)(this.targetEntity.func_70047_e() - this.targetEntity.field_70131_O * 0.2f), this.targetEntity.field_70166_s + (this.targetEntity.field_70161_v - this.targetEntity.field_70166_s) * (double)partialTicks, partialTicks, this.speed, this.deviation);
        } else {
            this.drawArcingLine(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks, this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks, this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks, this.currentTargetPoint.field_72450_a, this.currentTargetPoint.field_72448_b, this.currentTargetPoint.field_72449_c, partialTicks, this.speed, this.deviation);
        }
    }

    public void drawArcingLine(double srcX, double srcY, double srcZ, double dstX, double dstY, double dstZ, float partialTicks, float speed, double distance) {
        GL11.glPushMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.rl);
        int fxQuality = 8;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double interpolatedX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
        double interpolatedY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
        double interpolatedZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
        Tessellator tessellator = Tessellator.func_178181_a();
        double deltaX = srcX - dstX;
        double deltaY = srcY - dstY;
        double deltaZ = srcZ - dstZ;
        float time = System.nanoTime() / 10000000L;
        float dist = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
        float blocks = Math.round(dist);
        float length = blocks * ((float)fxQuality / 2.0f);
        GL11.glTranslated((double)(-interpolatedX + dstX), (double)(-interpolatedY + dstY), (double)(-interpolatedZ + dstZ));
        double wGain = (double)(this.field_187134_n * 3.0f) / ((double)length * distance);
        float curWidth = this.field_187134_n * 3.0f;
        tessellator.func_178180_c().func_181668_a(5, DefaultVertexFormats.field_181707_g);
        int i = 0;
        while ((double)i <= (double)length * distance) {
            float lengthFactor = (float)i / length;
            float f3 = 1.0f - Math.abs((float)i - length / 2.0f) / (length / 2.0f);
            double dx = deltaX + (double)(MathHelper.func_76126_a((float)((float)((srcX % 16.0 + (double)(dist * (1.0f - lengthFactor) * (float)fxQuality / 2.0f) - (double)(time % 32767.0f / 5.0f)) / 4.0))) * 0.5f * f3);
            double dy = deltaY + (double)(MathHelper.func_76126_a((float)((float)((srcY % 16.0 + (double)(dist * (1.0f - lengthFactor) * (float)fxQuality / 2.0f) - (double)(time % 32767.0f / 5.0f)) / 3.0))) * 0.5f * f3);
            double dz = deltaZ + (double)(MathHelper.func_76126_a((float)((float)((srcZ % 16.0 + (double)(dist * (1.0f - lengthFactor) * (float)fxQuality / 2.0f) - (double)(time % 32767.0f / 5.0f)) / 2.0))) * 0.5f * f3);
            GL11.glColor4f((float)this.field_70552_h, (float)this.field_70553_i, (float)this.field_70551_j, (float)this.field_82339_as);
            float u = (1.0f - lengthFactor) * dist - time * speed;
            tessellator.func_178180_c().func_181662_b(dx * (double)lengthFactor - (double)curWidth, dy * (double)lengthFactor, dz * (double)lengthFactor).func_187315_a((double)u, 1.0).func_181675_d();
            tessellator.func_178180_c().func_181662_b(dx * (double)lengthFactor + (double)curWidth, dy * (double)lengthFactor, dz * (double)lengthFactor).func_187315_a((double)u, 0.0).func_181675_d();
            curWidth = (float)((double)curWidth - wGain);
            ++i;
        }
        tessellator.func_78381_a();
        this.forwardFactor = (this.forwardFactor + 0.01f) % 1.0f;
        GL11.glPopMatrix();
    }
}

