/*
 * Decompiled with CFR 0.152.
 */
package am2.packet;

import am2.ArsMagica2;
import am2.LogHelper;
import am2.api.power.IPowerNode;
import am2.api.spell.SpellModifier;
import am2.api.spell.SpellModifiers;
import am2.blocks.tileentity.TileEntityCraftingAltar;
import am2.blocks.tileentity.TileEntityLectern;
import am2.blocks.tileentity.TileEntityObelisk;
import am2.bosses.BossActions;
import am2.bosses.IArsMagicaBoss;
import am2.extensions.EntityExtension;
import am2.extensions.datamanager.DataSyncExtension;
import am2.gui.AMGuiHelper;
import am2.packet.AMDataReader;
import am2.packet.AMPacketProcessorServer;
import am2.particles.AMParticle;
import am2.particles.ParticleChangeSize;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleLeaveParticleTrail;
import am2.particles.ParticleMoveOnHeading;
import am2.power.PowerNodeEntry;
import am2.power.PowerNodeRegistry;
import am2.proxy.tick.ClientTickHandler;
import am2.spell.modifier.Colour;
import am2.utils.MathUtilities;
import am2.utils.SpellUtils;
import io.netty.buffer.ByteBufInputStream;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;

public class AMPacketProcessorClient
extends AMPacketProcessorServer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SubscribeEvent
    public void onPacketData(FMLNetworkEvent.ClientCustomPacketEvent event) {
        ByteBufInputStream bbis = new ByteBufInputStream(event.getPacket().payload());
        int packetID = -1;
        try {
            if (event.getPacket().getTarget() != Side.CLIENT) {
                return;
            }
            packetID = bbis.readByte();
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            byte[] remaining = new byte[bbis.available()];
            bbis.readFully(remaining);
            switch (packetID) {
                case 5: {
                    ArsMagica2.proxy.particleManager.handleClientPacketData((World)Minecraft.func_71410_x().field_71441_e, remaining);
                    return;
                }
                case 9: {
                    this.handleFlashArmor(remaining);
                    return;
                }
                case 38: {
                    this.handleEntityActionUpdate(remaining, (EntityPlayer)player);
                    return;
                }
                case 42: {
                    this.handlePlayerLoginData(remaining, (EntityPlayer)player);
                    return;
                }
                case 47: {
                    this.handleSyncWorldName(remaining);
                    return;
                }
                case 48: {
                    this.handleStarFall(remaining);
                    return;
                }
                case 50: {
                    this.handleHecateDeath(remaining);
                    return;
                }
                case 53: {
                    this.handleRcvPowerPaths(remaining);
                    return;
                }
                case 4: {
                    this.handleCraftingAltarData(remaining);
                    return;
                }
                case 56: {
                    this.handleLecternData(remaining);
                    return;
                }
                case 58: {
                    this.handleObeliskData(remaining);
                    return;
                }
                case 60: {
                    this.handleManaLinkUpdate(remaining);
                    return;
                }
                case 62: {
                    this.handleClientUpdate(remaining);
                    return;
                }
            }
            return;
        }
        catch (Throwable t) {
            LogHelper.error("Client Packet Failed to Handle!", new Object[0]);
            LogHelper.error("Packet Type: " + packetID, new Object[0]);
            t.printStackTrace();
            return;
        }
        finally {
            try {
                if (bbis != null) {
                    bbis.close();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void handleClientUpdate(byte[] remaining) {
        EntityLivingBase ent;
        AMDataReader reader = new AMDataReader(remaining, false);
        if (Minecraft.func_71410_x().field_71441_e != null && (ent = (EntityLivingBase)Minecraft.func_71410_x().field_71441_e.func_73045_a(reader.getInt())) != null) {
            DataSyncExtension.For(ent).handleUpdatePacket(reader);
        }
    }

    private void handleManaLinkUpdate(byte[] remaining) {
        AMDataReader reader = new AMDataReader(remaining, false);
        EntityExtension.For((EntityLivingBase)Minecraft.func_71410_x().field_71441_e.func_73045_a(reader.getInt())).handleManaLinkUpdate(reader);
    }

    private void handleObeliskData(byte[] remaining) {
        AMDataReader rdr = new AMDataReader(remaining, false);
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(new BlockPos(rdr.getInt(), rdr.getInt(), rdr.getInt()));
        if (te == null || !(te instanceof TileEntityObelisk)) {
            return;
        }
        ((TileEntityObelisk)te).handlePacket(rdr.getRemainingBytes());
    }

    private void handleLecternData(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(new BlockPos(rdr.getInt(), rdr.getInt(), rdr.getInt()));
        if (te == null || !(te instanceof TileEntityLectern)) {
            return;
        }
        if (rdr.getBoolean()) {
            ((TileEntityLectern)te).setStack(rdr.getItemStack());
        } else {
            ((TileEntityLectern)te).setStack(null);
        }
    }

    private void handleCraftingAltarData(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(new BlockPos(rdr.getInt(), rdr.getInt(), rdr.getInt()));
        if (te == null || !(te instanceof TileEntityCraftingAltar)) {
            return;
        }
        ((TileEntityCraftingAltar)te).HandleUpdatePacket(rdr.getRemainingBytes());
    }

    private void handleRcvPowerPaths(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        byte bite = rdr.getByte();
        NBTTagCompound compound = rdr.getNBTTagCompound();
        if (bite == 0) {
            PowerNodeEntry pnd = PowerNodeRegistry.For((World)Minecraft.func_71410_x().field_71441_e).parseFromNBT(compound);
            ArsMagica2.proxy.receivePowerPathVisuals(pnd.getNodePaths());
        } else if (bite == 1) {
            int x = rdr.getInt();
            int y = rdr.getInt();
            int z = rdr.getInt();
            ArsMagica2.proxy.setTrackedPowerCompound(compound.func_74737_b());
            TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(new BlockPos(x, y, z));
            if (te != null && te instanceof IPowerNode) {
                PowerNodeRegistry.For((World)Minecraft.func_71410_x().field_71441_e).setDataCompoundForNode((IPowerNode)te, compound);
            }
        }
    }

    private void handleHecateDeath(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        double x = rdr.getDouble();
        double y = rdr.getDouble();
        double z = rdr.getDouble();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        for (int i = 0; i < 10 * ArsMagica2.config.getGFXLevel(); ++i) {
            world.func_175688_a(EnumParticleTypes.FLAME, x, y + 1.0, z, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5, new int[0]);
        }
    }

    private void handleStarFall(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        double x = rdr.getDouble();
        double y = rdr.getDouble();
        double z = rdr.getDouble();
        ItemStack spellStack = null;
        if (rdr.getBoolean()) {
            spellStack = rdr.getItemStack();
        }
        int color = -1;
        if (spellStack != null && SpellUtils.modifierIsPresent(SpellModifiers.COLOR, spellStack)) {
            ArrayList<SpellModifier> mods = SpellUtils.getModifiersForStage(spellStack, -1);
            for (SpellModifier mod : mods) {
                if (!(mod instanceof Colour)) continue;
                color = (int)mod.getModifier(SpellModifiers.COLOR, null, null, null, spellStack.func_77978_p());
            }
        }
        for (int i = 0; i < 360; i += ArsMagica2.config.FullGFX() ? 5 : (ArsMagica2.config.LowGFX() ? 10 : 20)) {
            AMParticle effect = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn((World)Minecraft.func_71410_x().field_71441_e, "sparkle2", x, y + 1.5, z));
            if (effect == null) continue;
            effect.setIgnoreMaxAge(true);
            effect.AddParticleController(new ParticleMoveOnHeading(effect, i, 0.0, 0.7f, 1, false));
            float clrMod = Minecraft.func_71410_x().field_71441_e.field_73012_v.nextFloat();
            int finalColor = -1;
            if (color == -1) {
                finalColor = MathUtilities.colorFloatsToInt(0.24f * clrMod, 0.58f * clrMod, 0.71f * clrMod);
            } else {
                float[] colors = MathUtilities.colorIntToFloats(color);
                for (int c = 0; c < colors.length; ++c) {
                    colors[c] = colors[c] * clrMod;
                }
                finalColor = MathUtilities.colorFloatsToInt(colors[0], colors[1], colors[2]);
            }
            effect.setParticleScale(1.2f);
            effect.setRGBColorI(finalColor);
            effect.AddParticleController(new ParticleFadeOut(effect, 1, false).setFadeSpeed(0.05f).setKillParticleOnFinish(true));
            effect.AddParticleController(new ParticleLeaveParticleTrail(effect, "sparkle2", false, 15, 1, false).addControllerToParticleList(new ParticleChangeSize(effect, 1.2f, 0.01f, 15, 1, false)).setParticleRGB_I(finalColor).setChildAffectedByGravity().addRandomOffset(0.2f, 0.2f, 0.2f));
        }
    }

    private void handleSyncWorldName(byte[] data) {
        String worldName;
        AMDataReader rdr = new AMDataReader(data, false);
        ClientTickHandler.worldName = worldName = rdr.getString();
    }

    private void handlePlayerLoginData(byte[] data, EntityPlayer player) {
        AMDataReader rdr = new AMDataReader(data, false);
        int skillTreeLock = rdr.getInt();
        ArsMagica2.config.setSkillTreeSecondaryTierCap(skillTreeLock);
        int[] disabledSkills = rdr.getIntArray();
        double manaCap = rdr.getDouble();
        ArsMagica2.config.setManaCap(manaCap);
        LogHelper.info("Received player login packet.", new Object[0]);
        LogHelper.debug("Secondary tree cap: %d", skillTreeLock);
        LogHelper.debug("Disabled skills: %d", disabledSkills.length);
        LogHelper.debug("Mana cap: %.2f", manaCap);
        ArsMagica2.disabledSkills.disableAllSkillsIn(disabledSkills);
    }

    private void handleEntityActionUpdate(byte[] data, EntityPlayer player) {
        AMDataReader rdr = new AMDataReader(data, false);
        int entityID = rdr.getInt();
        int actionOrdinal = rdr.getInt();
        Entity ent = player.field_70170_p.func_73045_a(entityID);
        if (ent == null || ent.field_70128_L || !(ent instanceof IArsMagicaBoss)) {
            return;
        }
        ((IArsMagicaBoss)ent).setCurrentAction(BossActions.values()[actionOrdinal]);
    }

    private void handleFlashArmor(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        AMGuiHelper.instance.blackoutArmorPiece(rdr.getInt(), rdr.getInt());
    }
}

