/*
 * Decompiled with CFR 0.152.
 */
package am2.packet;

import am2.LogHelper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class AMDataWriter {
    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
    DataOutputStream data = new DataOutputStream(this.bytes);

    public AMDataWriter add(int value) {
        try {
            this.data.writeInt(value);
        }
        catch (IOException e) {
            LogHelper.error("AMDataWriter: " + e.getMessage(), new Object[0]);
        }
        return this;
    }

    public AMDataWriter add(boolean value) {
        try {
            this.data.writeBoolean(value);
        }
        catch (IOException e) {
            LogHelper.error(e.getMessage(), new Object[0]);
        }
        return this;
    }

    public AMDataWriter add(byte value) {
        try {
            this.data.writeByte(value);
        }
        catch (IOException e) {
            LogHelper.error("AMDataWriter: " + e.getMessage(), new Object[0]);
        }
        return this;
    }

    public AMDataWriter add(String value) {
        try {
            this.data.writeUTF(value);
        }
        catch (IOException e) {
            LogHelper.error("AMDataWriter: " + e.getMessage(), new Object[0]);
        }
        return this;
    }

    public AMDataWriter add(short value) {
        try {
            this.data.writeShort(value);
        }
        catch (IOException e) {
            LogHelper.error("AMDataWriter: " + e.getMessage(), new Object[0]);
        }
        return this;
    }

    public AMDataWriter add(double value) {
        try {
            this.data.writeDouble(value);
        }
        catch (IOException e) {
            LogHelper.error("AMDataWriter: " + e.getMessage(), new Object[0]);
        }
        return this;
    }

    public AMDataWriter add(float value) {
        try {
            this.data.writeFloat(value);
        }
        catch (IOException e) {
            LogHelper.error("AMDataWriter: " + e.getMessage(), new Object[0]);
        }
        return this;
    }

    public AMDataWriter add(long value) {
        try {
            this.data.writeLong(value);
        }
        catch (IOException e) {
            LogHelper.error("AMDataWriter: " + e.getMessage(), new Object[0]);
        }
        return this;
    }

    public AMDataWriter add(byte[] value) {
        try {
            this.data.write(value);
        }
        catch (IOException e) {
            LogHelper.error("AMDataWriter: " + e.getMessage(), new Object[0]);
        }
        return this;
    }

    public AMDataWriter add(int[] value) {
        try {
            this.data.writeInt(value.length);
            for (int i = 0; i < value.length; ++i) {
                this.data.writeInt(value[i]);
            }
        }
        catch (IOException e) {
            LogHelper.error("AMDataWriter: " + e.getMessage(), new Object[0]);
        }
        return this;
    }

    public AMDataWriter add(NBTTagCompound compound) {
        try {
            ByteBuf buf = Unpooled.buffer();
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)compound);
            byte[] arr = buf.array();
            this.data.writeInt(arr.length);
            this.data.write(arr);
        }
        catch (IOException ex) {
            LogHelper.error("AMDataWriter: " + ex.getMessage(), new Object[0]);
        }
        return this;
    }

    public AMDataWriter add(ItemStack stack) {
        NBTTagCompound compound = new NBTTagCompound();
        if (stack == null) {
            return this.add((NBTTagCompound)null);
        }
        stack.func_77955_b(compound);
        return this.add(compound);
    }

    public byte[] generate() {
        return this.bytes.toByteArray();
    }
}

