/*
 * Decompiled with CFR 0.152.
 */
package am2.navigation;

import am2.api.math.AMVector3;
import am2.navigation.BreadCrumb;
import am2.navigation.PathFinder;
import am2.navigation.Point3D;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class PathNavigator {
    private BreadCrumb pathData;
    private Point3D currentWaypoint;
    private final EntityLivingBase pathEntity;
    private int PathUpdateTicks;
    private Point3D currentLocation;
    private Point3D lastLocation;
    private int ticksStuck;
    private Point3D longRangeWaypoint;
    private boolean pathIsLongRange;
    private static final int MaxPathDistance = 19;

    public PathNavigator(EntityLivingBase entity) {
        this.pathEntity = entity;
        this.PathUpdateTicks = 0;
        this.currentWaypoint = null;
        this.pathData = null;
        this.pathIsLongRange = false;
    }

    public boolean HasWaypoint() {
        return this.currentWaypoint != null;
    }

    public boolean HasPath() {
        return this.pathData != null;
    }

    public void tryMoveFlying(World world, Entity entity) {
        if (this.pathEntity.field_70128_L) {
            return;
        }
        this.getEntityLocation(world);
        if (!this.HasWaypoint() || !this.HasPath()) {
            return;
        }
        if (this.PathUpdateTicks++ >= 20) {
            this.PathUpdateTicks = 0;
            this.GetPathToWaypoint(world, entity);
        }
        if (!this.HasPath()) {
            return;
        }
        this.FaceEntityToBreadCrumb();
        this.MoveEntityTowardBreadCrumbFlying();
        this.checkDistance(world, entity);
        this.checkStuck();
    }

    public void GenerateNewRandomWaypoint(World world, Entity entity) {
        for (int i = 0; i < 5; ++i) {
            int newZ;
            int newY;
            int newX = (int)Math.round(this.pathEntity.field_70165_t + (world.field_73012_v.nextDouble() * 19.0 - 9.0));
            BlockPos pos = new BlockPos(newX, newY = (int)Math.round(this.pathEntity.field_70163_u + (world.field_73012_v.nextDouble() * 8.0 - 4.0)), newZ = (int)Math.round(this.pathEntity.field_70161_v + (world.field_73012_v.nextDouble() * 19.0 - 9.0)));
            if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a || newY <= 5) continue;
            this.getEntityLocation(world);
            this.SetWaypoint(world, pos, entity);
            this.GetPathToWaypoint(world, entity);
            break;
        }
    }

    public void GenerateNewRandomWaypoint(World world, Entity entity, int minY, int maxY) {
        for (int i = 0; i < 5; ++i) {
            int newZ;
            int newY;
            int newX = (int)Math.round(this.pathEntity.field_70165_t + (world.field_73012_v.nextDouble() * 19.0 - 9.0));
            BlockPos pos = new BlockPos(newX, newY = (int)Math.round((double)minY + world.field_73012_v.nextDouble() * (double)(maxY - minY)), newZ = (int)Math.round(this.pathEntity.field_70161_v + (world.field_73012_v.nextDouble() * 19.0 - 9.0)));
            if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a || newY <= 5) continue;
            this.getEntityLocation(world);
            this.SetWaypoint(world, pos, entity);
            this.GetPathToWaypoint(world, entity);
            break;
        }
    }

    public void GenerateNewRandomWaypoint(World world) {
        this.GenerateNewRandomWaypoint(world, null);
    }

    public void GenerateNewRandomWaypoint(World world, int minY, int maxY) {
        this.GenerateNewRandomWaypoint(world, null, minY, maxY);
    }

    public boolean GenerateWaypointToEntity(Entity entityTarget, World world, Entity entity) {
        if (this.pathEntity.func_70068_e(entityTarget) > 225.0) {
            return false;
        }
        this.getEntityLocation(world);
        this.SetWaypoint(world, entityTarget.func_180425_c(), entity);
        return true;
    }

    public boolean GenerateWaypointToEntity(Entity entityTarget, World world) {
        return this.GenerateWaypointToEntity(entityTarget, world, null);
    }

    public void SetWaypoint(World world, BlockPos pos, Entity entity) {
        this.getEntityLocation(world);
        this.currentWaypoint = new Point3D(pos);
        this.longRangeWaypoint = new Point3D(pos);
        Point3D estimatedLocation = Point3D.fromDoubleCoordinates(this.pathEntity.field_70165_t, this.pathEntity.field_70163_u, this.pathEntity.field_70161_v);
        if (estimatedLocation.GetDistanceSq(this.longRangeWaypoint) > 400.0) {
            this.pathIsLongRange = true;
            double posY = this.pathEntity.field_70163_u;
            float moveSpeed = 15.0f;
            double deltaZ = (double)((float)this.longRangeWaypoint.z + 0.5f) - this.pathEntity.field_70161_v;
            double deltaX = (double)((float)this.longRangeWaypoint.x + 0.5f) - this.pathEntity.field_70165_t;
            double deltaY = posY - (double)((float)this.longRangeWaypoint.y + 0.5f);
            double horizontalDistance = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
            float radiansYaw = (float)Math.atan2(deltaZ, deltaX);
            float radiansPitch = (float)(-Math.atan2(deltaY, horizontalDistance));
            double posX = this.pathEntity.field_70165_t + (double)(MathHelper.func_76134_b((float)radiansYaw) * moveSpeed);
            double posZ = this.pathEntity.field_70161_v + (double)(MathHelper.func_76126_a((float)radiansYaw) * moveSpeed);
            posY = this.pathEntity.field_70163_u + (double)(MathHelper.func_76126_a((float)radiansPitch) * moveSpeed);
            while (!this.BlockIsAir(world, Point3D.fromDoubleCoordinates(posX, posY, posZ))) {
                posY += 1.0;
            }
            this.currentWaypoint = Point3D.fromDoubleCoordinates(posX, posY, posZ);
        }
        this.GetPathToWaypoint(world, entity);
    }

    private void MoveEntityTowardBreadCrumbFlying() {
        float moveSpeed = this.pathEntity.func_70689_ay() * 2.0f;
        AMVector3 current = new AMVector3(this.pathEntity.field_70165_t, this.pathEntity.field_70163_u, this.pathEntity.field_70161_v);
        AMVector3 target = new AMVector3((float)this.pathData.position.x + 0.5f, (float)this.pathData.position.y + 0.5f, (float)this.pathData.position.z + 0.5f);
        AMVector3 movement = target.sub(current).normalize();
        this.pathEntity.func_70091_d((double)(movement.x * moveSpeed), (double)(movement.y * moveSpeed), (double)(movement.z * moveSpeed));
    }

    private void checkDistance(World world, Entity entity) {
        double distance = this.currentLocation.GetDistanceSq(this.pathData.position);
        if (distance < (double)0.8f) {
            this.pathData = this.pathData.next;
            if (this.pathData != null) {
                this.pathData.unshift();
            } else if (this.pathIsLongRange) {
                this.SetWaypoint(world, this.longRangeWaypoint.toBlockPos(), entity);
                this.GetPathToWaypoint(world, entity);
            }
        }
    }

    private void FaceEntityToBreadCrumb() {
        if (!this.HasPath() || !this.HasWaypoint()) {
            return;
        }
        double deltaZ = this.currentWaypoint.z - this.currentLocation.z;
        double deltaX = this.currentWaypoint.x - this.currentLocation.x;
        double angle = Math.atan2(deltaZ, deltaX) * 180.0 / Math.PI;
        this.pathEntity.field_70177_z = (float)angle;
    }

    private void getEntityLocation(World world) {
        this.currentLocation = new Point3D((int)Math.floor(this.pathEntity.field_70165_t), (int)Math.floor(this.pathEntity.field_70163_u), (int)Math.floor(this.pathEntity.field_70161_v));
        if (!this.BlockIsAir(world, this.currentLocation)) {
            this.currentLocation = new Point3D((int)Math.ceil(this.pathEntity.field_70165_t), (int)Math.floor(this.pathEntity.field_70163_u), (int)Math.floor(this.pathEntity.field_70161_v));
            if (!this.BlockIsAir(world, this.currentLocation)) {
                this.currentLocation = new Point3D((int)Math.floor(this.pathEntity.field_70165_t), (int)Math.ceil(this.pathEntity.field_70163_u), (int)Math.floor(this.pathEntity.field_70161_v));
                if (!this.BlockIsAir(world, this.currentLocation)) {
                    this.currentLocation = new Point3D((int)Math.floor(this.pathEntity.field_70165_t), (int)Math.floor(this.pathEntity.field_70163_u), (int)Math.ceil(this.pathEntity.field_70161_v));
                    if (!this.BlockIsAir(world, this.currentLocation)) {
                        this.currentLocation = new Point3D((int)Math.ceil(this.pathEntity.field_70165_t), (int)Math.ceil(this.pathEntity.field_70163_u), (int)Math.floor(this.pathEntity.field_70161_v));
                        if (!this.BlockIsAir(world, this.currentLocation)) {
                            this.currentLocation = new Point3D((int)Math.ceil(this.pathEntity.field_70165_t), (int)Math.floor(this.pathEntity.field_70163_u), (int)Math.ceil(this.pathEntity.field_70161_v));
                            if (!this.BlockIsAir(world, this.currentLocation)) {
                                this.currentLocation = new Point3D((int)Math.floor(this.pathEntity.field_70165_t), (int)Math.ceil(this.pathEntity.field_70163_u), (int)Math.ceil(this.pathEntity.field_70161_v));
                                if (!this.BlockIsAir(world, this.currentLocation)) {
                                    this.currentLocation = new Point3D((int)Math.ceil(this.pathEntity.field_70165_t), (int)Math.ceil(this.pathEntity.field_70163_u), (int)Math.ceil(this.pathEntity.field_70161_v));
                                    if (!this.BlockIsAir(world, this.currentLocation)) {
                                        this.pathEntity.func_70107_b(this.pathEntity.field_70165_t, this.pathEntity.field_70163_u + 1.0, this.pathEntity.field_70161_v);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (this.lastLocation != null && this.currentLocation.GetDistanceSq(this.lastLocation) < 1.0 && this.HasPath() && this.HasWaypoint()) {
            ++this.ticksStuck;
        } else {
            this.lastLocation = this.currentLocation;
            this.ticksStuck = 0;
        }
    }

    private boolean BlockIsAir(World world, Point3D point) {
        return world.func_175623_d(point.toBlockPos());
    }

    private void checkStuck() {
        if (this.ticksStuck > 40) {
            this.currentWaypoint = null;
            this.longRangeWaypoint = null;
            this.pathData = null;
            this.ticksStuck = 0;
        }
    }

    private void GetPathToWaypoint(World world, Entity entity) {
        try {
            if (this.currentLocation == null) {
                return;
            }
            this.pathData = PathFinder.FindPath(world, this.currentLocation.Unshift(), this.currentWaypoint.Unshift(), entity);
            if (this.pathData != null) {
                this.pathData.unshift();
            }
            if (this.currentWaypoint != null) {
                this.currentWaypoint.Unshift();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.currentWaypoint = null;
        }
    }
}

