/*
 * Decompiled with CFR 0.152.
 */
package am2.models;

import am2.api.event.RenderingItemEvent;
import am2.utils.ModelUtils;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.tuple.Pair;

public class SpecialRenderModelLoader
implements ICustomModelLoader {
    static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms = IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)ModelUtils.DEFAULT_ITEM_STATE);

    public void func_110549_a(IResourceManager resourceManager) {
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return (modelLocation.toString().contains("nature_scythe") || modelLocation.toString().contains("winter_arm") || modelLocation.toString().contains("air_sled") || modelLocation.toString().contains("fire_ears") || modelLocation.toString().contains("water_orbs") || modelLocation.toString().contains("earth_armor") || modelLocation.toString().contains("arcane_spellbook") || modelLocation.toString().contains("keystone_recepticle") || modelLocation.toString().contains("flicker_habitat") || modelLocation.toString().contains("crystal_marker") || modelLocation.toString().contains("keystone_chest") || modelLocation.toString().contains("magic_broom") || modelLocation.toString().contains("essence_conduit") || modelLocation.toString().contains("arcane_reconstructor") || modelLocation.toString().contains("seer_stone") || modelLocation.toString().contains("warding_candle") || modelLocation.toString().contains("bound_shield") || modelLocation.toString().contains("calefactor") || modelLocation.toString().contains("magicians_workbench") || modelLocation.toString().contains("summoner") || modelLocation.toString().contains("astral_barrier") || modelLocation.toString().contains("otherworld_aura")) && modelLocation.func_110624_b().equals("arsmagica2") && !modelLocation.toString().contains(".obj");
    }

    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        return new Model();
    }

    class Model
    implements IModel {
        Model() {
        }

        public Collection<ResourceLocation> getDependencies() {
            return Lists.newArrayList();
        }

        public Collection<ResourceLocation> getTextures() {
            return Lists.newArrayList();
        }

        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            return new Baked();
        }

        public IModelState getDefaultState() {
            return ModelUtils.DEFAULT_ITEM_STATE;
        }
    }

    class Overrides
    extends ItemOverrideList {
        Baked baked;

        public Overrides(Baked baked) {
            super(new ArrayList());
            this.baked = baked;
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            this.baked.stack = stack;
            this.baked.entity = entity;
            return super.handleItemState(originalModel, stack, world, entity);
        }
    }

    public class Baked
    implements IPerspectiveAwareModel {
        private ItemStack stack = null;
        private EntityLivingBase entity = null;

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            return new ArrayList<BakedQuad>();
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return true;
        }

        public TextureAtlasSprite func_177554_e() {
            return Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return new Overrides(this);
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            MinecraftForge.EVENT_BUS.post((Event)new RenderingItemEvent(this.stack, cameraTransformType, this.entity));
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
        }
    }
}

