/*
 * Decompiled with CFR 0.152.
 */
package am2.models;

import am2.ArsMagica2;
import am2.api.ArsMagicaAPI;
import am2.api.affinity.Affinity;
import am2.items.rendering.SpellModel;
import am2.utils.ModelUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ArsMagicaModelLoader
implements ICustomModelLoader {
    public static final HashMap<Affinity, TextureAtlasSprite> sprites = new HashMap();
    public static final HashMap<String, TextureAtlasSprite> particles = new HashMap();
    public static final List<ResourceLocation> spellIcons = ArsMagicaModelLoader.getResourceListing();
    private static final String iconsPath = "/assets/arsmagica2/textures/items/spells/icons/";
    private static final String iconsPrefix = "items/spells/icons/";

    public void func_110549_a(IResourceManager resourceManager) {
        sprites.clear();
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return modelLocation.toString().contains("spells/icons");
    }

    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        if (!Loader.instance().hasReachedState(LoaderState.POSTINITIALIZATION)) {
            return ModelLoaderRegistry.getMissingModel();
        }
        try {
            ImmutableList.Builder builder = ImmutableList.builder();
            IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a() + ".json"));
            InputStreamReader reader = new InputStreamReader(iresource.func_110527_b(), Charsets.UTF_8);
            for (String s : ((Map)ModelUtils.GSON.fromJson((Reader)reader, ModelUtils.mapType)).values()) {
                builder.add((Object)new ResourceLocation(s));
            }
            SpellModel model = new SpellModel((ImmutableList<ResourceLocation>)builder.build());
            return model;
        }
        catch (IOException e) {
            e.printStackTrace();
            return ModelLoaderRegistry.getMissingModel();
        }
    }

    @SubscribeEvent
    public void preStitch(TextureStitchEvent.Pre e) {
        for (Affinity aff : ArsMagicaAPI.getAffinityRegistry().getValues()) {
            e.getMap().func_174942_a(new ResourceLocation("arsmagica2", "items/particles/" + aff.getName().toLowerCase() + "_hand"));
            sprites.put(aff, e.getMap().getTextureExtry(new ResourceLocation("arsmagica2", "items/particles/" + aff.getName().toLowerCase() + "_hand").toString()));
        }
        this.registerParticle(e.getMap(), "arcane");
        this.registerParticle(e.getMap(), "beam");
        this.registerParticle(e.getMap(), "beam1");
        this.registerParticle(e.getMap(), "beam2");
        this.registerParticle(e.getMap(), "clock");
        this.registerParticle(e.getMap(), "ember");
        this.registerParticle(e.getMap(), "explosion_2");
        this.registerParticle(e.getMap(), "ghost");
        this.registerParticle(e.getMap(), "heart");
        this.registerParticle(e.getMap(), "leaf");
        this.registerParticle(e.getMap(), "lens_flare");
        this.registerParticle(e.getMap(), "lights");
        this.registerParticle(e.getMap(), "plant");
        this.registerParticle(e.getMap(), "pulse");
        this.registerParticle(e.getMap(), "rock");
        this.registerParticle(e.getMap(), "rotating_rings");
        this.registerParticle(e.getMap(), "smoke");
        this.registerParticle(e.getMap(), "sparkle");
        this.registerParticle(e.getMap(), "sparkle2");
        this.registerParticle(e.getMap(), "water_ball");
        this.registerParticle(e.getMap(), "wind");
        this.registerParticle(e.getMap(), "witchwood_leaf");
        e.getMap().func_174942_a(new ResourceLocation("arsmagica2:blocks/custom/obelisk"));
        e.getMap().func_174942_a(new ResourceLocation("arsmagica2:blocks/custom/obelisk_active"));
        e.getMap().func_174942_a(new ResourceLocation("arsmagica2:blocks/custom/obelisk_active_highpower"));
        e.getMap().func_174942_a(new ResourceLocation("arsmagica2:blocks/custom/obelisk_runes"));
        e.getMap().func_174942_a(new ResourceLocation("arsmagica2:blocks/custom/celestial_prism"));
        e.getMap().func_174942_a(new ResourceLocation("arsmagica2:blocks/custom/crystalmarker"));
        e.getMap().func_174942_a(new ResourceLocation("arsmagica2:blocks/custom/habitat"));
        e.getMap().func_174942_a(new ResourceLocation("arsmagica2:blocks/custom/essenceCrystal"));
        e.getMap().func_174942_a(new ResourceLocation("arsmagica2:blocks/custom/Arcane_Reconstructor"));
        e.getMap().func_174942_a(new ResourceLocation("arsmagica2:blocks/everstone"));
        for (Affinity aff : ArsMagicaAPI.getAffinityRegistry().getValues()) {
            e.getMap().func_174942_a(new ResourceLocation(aff.getRegistryName().func_110624_b(), "blocks/runes/rune_" + aff.getRegistryName().func_110623_a()));
        }
    }

    private void registerParticle(TextureMap map, String name) {
        map.func_174942_a(new ResourceLocation("arsmagica2", "items/particles/" + name));
        particles.put(name, map.getTextureExtry(new ResourceLocation("arsmagica2", "items/particles/" + name).toString()));
    }

    public static List<ResourceLocation> getResourceListing() {
        ArrayList<ResourceLocation> toReturn = new ArrayList();
        try {
            URI uri = ArsMagica2.class.getResource(iconsPath).toURI();
            if (uri.getScheme().equals("jar")) {
                FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
                Path myPath = fs.getPath(iconsPath, new String[0]);
                toReturn = ArsMagicaModelLoader.processDirectory(myPath, fs);
                fs.close();
                return toReturn;
            }
            Path myPath = Paths.get(uri);
            toReturn = ArsMagicaModelLoader.processDirectory(myPath, FileSystems.getDefault());
            return toReturn;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Lists.newArrayList();
    }

    private static ArrayList<ResourceLocation> processDirectory(Path dir, FileSystem fs) {
        ArrayList<ResourceLocation> toReturn = new ArrayList<ResourceLocation>();
        try {
            Stream<Path> walk = Files.walk(dir, 1, new FileVisitOption[0]);
            Iterator file = walk.iterator();
            while (file.hasNext()) {
                String name = ((Path)file.next()).toString();
                if (name.lastIndexOf(fs.getSeparator()) + 1 > name.length() || (name = name.substring(name.lastIndexOf(fs.getSeparator()) + 1)).equals("")) continue;
                toReturn.add(new ResourceLocation("arsmagica2:items/spells/icons/" + name.replace(".png", "")));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Collections.sort(toReturn, (o1, o2) -> o1.toString().compareTo(o2.toString()));
        return toReturn;
    }
}

