/*
 * Decompiled with CFR 0.152.
 */
package am2.lore;

import am2.ArsMagica2;
import am2.api.SkillRegistry;
import am2.api.event.PlayerMagicLevelChangeEvent;
import am2.api.event.SkillLearnedEvent;
import am2.api.event.SpellCastEvent;
import am2.api.extensions.IArcaneCompendium;
import am2.api.skill.SkillPoint;
import am2.extensions.EntityExtension;
import am2.lore.ArcaneCompendium;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class CompendiumUnlockHandler {
    @SubscribeEvent
    public void onPlayerPickupItem(EntityItemPickupEvent event) {
        IArcaneCompendium instance = ArcaneCompendium.For(event.getEntityPlayer());
        instance.unlockRelatedItems(event.getItem().func_92059_d());
    }

    @SubscribeEvent
    public void onPlayerMagicLevelChange(PlayerMagicLevelChangeEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayer) {
            IArcaneCompendium instance = ArcaneCompendium.For(event.getEntityPlayer());
            if (event.getLevel() >= 5) {
                instance.unlockEntry("enchantments");
            }
            if (event.getLevel() >= 10) {
                instance.unlockEntry("armorMage");
                instance.unlockEntry("playerjournal");
            }
            if (event.getLevel() >= 15) {
                instance.unlockEntry("BossWaterGuardian");
                instance.unlockEntry("BossEarthGuardian");
                instance.unlockEntry("rituals");
                instance.unlockEntry("inlays");
                instance.unlockEntry("inlays_structure");
            }
            if (event.getLevel() >= 20) {
                instance.unlockEntry("armorBattlemage");
            }
            if (event.getLevel() >= 25) {
                instance.unlockEntry("BossAirGuardian");
                instance.unlockEntry("BossArcaneGuardian");
                instance.unlockEntry("BossLifeGuardian");
            }
            if (event.getLevel() >= 35) {
                instance.unlockEntry("BossNatureGuardian");
                instance.unlockEntry("BossWinterGuardian");
                instance.unlockEntry("BossFireGuardian");
                instance.unlockEntry("BossLightningGuardian");
                instance.unlockEntry("BossEnderGuardian");
            }
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K && event.getSource().func_76346_g() instanceof EntityPlayer) {
            if (event.getEntity() instanceof EntityEnderman) {
                ArcaneCompendium.For((EntityPlayer)event.getSource().func_76346_g()).unlockEntry("blockastralbarrier");
            } else {
                EntityRegistry.EntityRegistration reg = EntityRegistry.instance().lookupModSpawn(event.getEntityLiving().getClass(), true);
                if (reg != null && reg.getContainer().matches((Object)ArsMagica2.instance)) {
                    String id = reg.getEntityName();
                    ArcaneCompendium.For((EntityPlayer)event.getSource().func_76346_g()).unlockEntry(id);
                }
            }
        }
    }

    @SubscribeEvent
    public void onSkillLearned(SkillLearnedEvent event) {
        IArcaneCompendium instance = ArcaneCompendium.For(event.getEntityPlayer());
        if (((Object)((Object)event.getSkill())).equals((Object)SkillRegistry.getSkillFromName("summon"))) {
            instance.unlockEntry("crystal_phylactery");
            instance.unlockEntry("summoner");
        } else if (((Object)((Object)event.getSkill())).equals((Object)SkillRegistry.getSkillFromName("true_sight"))) {
            instance.unlockEntry("illusionBlocks");
        } else if (event.getSkill().getPoint().equals(SkillPoint.SILVER_POINT)) {
            instance.unlockEntry("silver_skills");
        }
    }

    @SubscribeEvent
    public void onSpellCast(SpellCastEvent.Pre event) {
        if (event.entityLiving instanceof EntityPlayer) {
            IArcaneCompendium instance = ArcaneCompendium.For((EntityPlayer)event.entityLiving);
            instance.unlockEntry("unlockingPowers");
            instance.unlockEntry("affinity");
            if (EntityExtension.For(event.entityLiving).getCurrentMana() < EntityExtension.For(event.entityLiving).getMaxMana() / 2.0f) {
                instance.unlockEntry("mana_potion");
            }
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            IArcaneCompendium instance = ArcaneCompendium.For(event.player);
            instance.unlockRelatedItems(event.crafting);
        }
    }
}

