/*
 * Decompiled with CFR 0.152.
 */
package am2.lore;

import am2.api.compendium.CompendiumCategory;
import am2.api.compendium.CompendiumEntry;
import am2.api.extensions.IArcaneCompendium;
import am2.api.extensions.IDataSyncExtension;
import am2.defs.ItemDefs;
import am2.extensions.DataDefinitions;
import am2.extensions.datamanager.DataSyncExtension;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.stats.Achievement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class ArcaneCompendium
implements IArcaneCompendium,
ICapabilityProvider,
ICapabilitySerializable<NBTBase> {
    @CapabilityInject(value=IArcaneCompendium.class)
    public static Capability<IArcaneCompendium> INSTANCE = null;
    public static Achievement compendiumData = new Achievement("am2_ach_data", "compendiumData", 0, 0, ItemDefs.arcaneCompendium, null);
    public static Achievement componentUnlock = new Achievement("am2_ach_unlock", "componentUnlock", 0, 0, (Item)ItemDefs.spellParchment, null);
    private EntityPlayer player;
    private String path = "";

    @Override
    public void unlockEntry(String name) {
        ArrayList<String> compendium = DataSyncExtension.For((EntityLivingBase)this.player).get(DataDefinitions.COMPENDIUM);
        compendium.add(name);
        DataSyncExtension.For((EntityLivingBase)this.player).setWithSync(DataDefinitions.COMPENDIUM, compendium);
    }

    @Override
    public boolean isUnlocked(String name) {
        for (String str : DataSyncExtension.For((EntityLivingBase)this.player).get(DataDefinitions.COMPENDIUM)) {
            if (!str.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public void init(EntityPlayer player, IDataSyncExtension ext) {
        this.player = player;
        ext.setWithSync(DataDefinitions.COMPENDIUM, new ArrayList());
    }

    public static IArcaneCompendium For(EntityPlayer entityPlayer) {
        return (IArcaneCompendium)entityPlayer.getCapability(INSTANCE, null);
    }

    @Override
    public boolean isNew(String id) {
        return false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == INSTANCE;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == INSTANCE) {
            return (T)this;
        }
        return null;
    }

    public NBTBase serializeNBT() {
        return new IArcaneCompendium.Storage().writeNBT(INSTANCE, this, null);
    }

    public void deserializeNBT(NBTBase nbt) {
        new IArcaneCompendium.Storage().readNBT(INSTANCE, this, null, nbt);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String str) {
        this.path = str;
    }

    @Override
    public void unlockRelatedItems(ItemStack crafting) {
        for (CompendiumEntry entry : CompendiumCategory.getAllEntries()) {
            Object obj = entry.getRenderObject();
            if (obj == null) continue;
            if (obj instanceof ItemStack && ((ItemStack)obj).func_77969_a(crafting)) {
                this.unlockEntry(entry.getID());
                continue;
            }
            if (obj instanceof Item && crafting.func_77973_b() == obj) {
                this.unlockEntry(entry.getID());
                continue;
            }
            if (!(obj instanceof Block) || !(crafting.func_77973_b() instanceof ItemBlock) || ((ItemBlock)crafting.func_77973_b()).field_150939_a != obj) continue;
            this.unlockEntry(entry.getID());
        }
    }

    @Override
    public ArrayList<CompendiumEntry> getEntriesForCategory(String categoryName) {
        return null;
    }
}

