/*
 * Decompiled with CFR 0.152.
 */
package am2.items;

import am2.ArsMagica2;
import am2.container.InventorySpellBook;
import am2.defs.ItemDefs;
import am2.enchantments.AMEnchantmentHelper;
import am2.enchantments.AMEnchantments;
import am2.extensions.SkillData;
import am2.items.ItemArsMagica;
import am2.items.ItemSpellBase;
import java.util.List;
import java.util.Map;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSpellBook
extends ItemArsMagica {
    public static final byte ID_NEXT_SPELL = 0;
    public static final byte ID_PREV_SPELL = 1;

    public ItemSpellBook() {
        this.func_77656_e(0);
        this.func_77625_d(1);
    }

    public String func_77653_i(ItemStack par1ItemStack) {
        ItemStack activeSpell = this.GetActiveItemStack(par1ItemStack);
        if (activeSpell != null) {
            return String.format("\u00a77%s (" + activeSpell.func_82833_r() + "\u00a77)", I18n.func_74838_a((String)"item.arsmagica2:spellbook.name"));
        }
        return I18n.func_74838_a((String)"item.arsmagica2:spellbook.name");
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        if (this.func_77626_a(itemstack) == 0) {
            return EnumAction.NONE;
        }
        return EnumAction.BLOCK;
    }

    public final int func_77626_a(ItemStack itemstack) {
        ItemSpellBase scroll = this.GetActiveScroll(itemstack);
        if (scroll != null) {
            return scroll.func_77626_a(itemstack);
        }
        return 0;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (playerIn.func_70093_af()) {
            FMLNetworkHandler.openGui((EntityPlayer)playerIn, (Object)ArsMagica2.instance, (int)3, (World)worldIn, (int)((int)playerIn.field_70165_t), (int)((int)playerIn.field_70163_u), (int)((int)playerIn.field_70161_v));
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        playerIn.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    private ItemStack[] getMyInventory(ItemStack itemStack) {
        return this.ReadFromStackTagCompound(itemStack);
    }

    public ItemStack[] getActiveScrollInventory(ItemStack bookStack) {
        ItemStack[] inventoryItems = this.getMyInventory(bookStack);
        ItemStack[] returnArray = new ItemStack[8];
        for (int i = 0; i < 8; ++i) {
            returnArray[i] = inventoryItems[i];
        }
        return returnArray;
    }

    public ItemSpellBase GetActiveScroll(ItemStack bookStack) {
        ItemStack[] inventoryItems = this.getMyInventory(bookStack);
        if (inventoryItems[this.GetActiveSlot(bookStack)] == null) {
            return null;
        }
        return (ItemSpellBase)inventoryItems[this.GetActiveSlot(bookStack)].func_77973_b();
    }

    public ItemStack GetActiveItemStack(ItemStack bookStack) {
        ItemStack[] inventoryItems = this.getMyInventory(bookStack);
        if (inventoryItems[this.GetActiveSlot(bookStack)] == null) {
            return null;
        }
        return inventoryItems[this.GetActiveSlot(bookStack)].func_77946_l();
    }

    public void replaceAciveItemStack(ItemStack bookStack, ItemStack newstack) {
        ItemStack[] inventoryItems = this.getMyInventory(bookStack);
        int index = this.GetActiveSlot(bookStack);
        inventoryItems[index] = newstack;
        this.UpdateStackTagCompound(bookStack, inventoryItems);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving.func_70093_af()) {
            FMLNetworkHandler.openGui((EntityPlayer)((EntityPlayer)entityLiving), (Object)ArsMagica2.instance, (int)3, (World)worldIn, (int)((int)entityLiving.field_70165_t), (int)((int)entityLiving.field_70163_u), (int)((int)entityLiving.field_70161_v));
        } else {
            ItemStack currentSpellStack = this.GetActiveItemStack(stack);
            if (currentSpellStack != null) {
                ItemDefs.spell.func_77615_a(currentSpellStack, worldIn, entityLiving, timeLeft);
            }
        }
    }

    public void UpdateStackTagCompound(ItemStack itemStack, ItemStack[] values) {
        boolean Soulbound;
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < values.length; ++i) {
            ItemStack stack = values[i];
            NBTTagCompound spell = new NBTTagCompound();
            if (stack == null) continue;
            spell.func_74768_a("meta", stack.func_77952_i());
            spell.func_74768_a("index", i);
            if (stack.func_77978_p() != null) {
                spell.func_74782_a("data", (NBTBase)stack.func_77978_p());
            }
            list.func_74742_a((NBTBase)spell);
        }
        itemStack.func_77978_p().func_74782_a("spell_book_inventory", (NBTBase)list);
        ItemStack active = this.GetActiveItemStack(itemStack);
        boolean bl = Soulbound = EnchantmentHelper.func_77506_a((Enchantment)AMEnchantments.soulbound, (ItemStack)itemStack) > 0;
        if (active != null) {
            AMEnchantmentHelper.copyEnchantments(active, itemStack);
        }
        if (Soulbound) {
            AMEnchantmentHelper.soulbindStack(itemStack);
        }
    }

    public void SetActiveSlot(ItemStack itemStack, int slot) {
        boolean Soulbound;
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (slot < 0) {
            slot = 0;
        }
        if (slot > 7) {
            slot = 7;
        }
        itemStack.func_77978_p().func_74768_a("spellbookactiveslot", slot);
        ItemStack active = this.GetActiveItemStack(itemStack);
        boolean bl = Soulbound = EnchantmentHelper.func_77506_a((Enchantment)AMEnchantments.soulbound, (ItemStack)itemStack) > 0;
        if (active != null) {
            AMEnchantmentHelper.copyEnchantments(active, itemStack);
        }
        if (Soulbound) {
            AMEnchantmentHelper.soulbindStack(itemStack);
        }
    }

    public int SetNextSlot(ItemStack itemStack) {
        int slot;
        int newSlot = slot = this.GetActiveSlot(itemStack);
        do {
            if (++newSlot > 7) {
                newSlot = 0;
            }
            this.SetActiveSlot(itemStack, newSlot);
        } while (this.GetActiveScroll(itemStack) == null && newSlot != slot);
        return slot;
    }

    public int SetPrevSlot(ItemStack itemStack) {
        int slot;
        int newSlot = slot = this.GetActiveSlot(itemStack);
        do {
            if (--newSlot < 0) {
                newSlot = 7;
            }
            this.SetActiveSlot(itemStack, newSlot);
        } while (this.GetActiveScroll(itemStack) == null && newSlot != slot);
        return slot;
    }

    public int GetActiveSlot(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            this.SetActiveSlot(itemStack, 0);
            return 0;
        }
        return itemStack.func_77978_p().func_74762_e("spellbookactiveslot");
    }

    public ItemStack[] ReadFromStackTagCompound(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            return new ItemStack[InventorySpellBook.inventorySize];
        }
        ItemStack[] items = new ItemStack[InventorySpellBook.inventorySize];
        NBTTagList list = itemStack.func_77978_p().func_150295_c("spell_book_inventory", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound spell = list.func_150305_b(i);
            int meta = spell.func_74762_e("meta");
            NBTTagCompound tag = spell.func_74775_l("data");
            int index = spell.func_74762_e("index");
            items[index] = new ItemStack((Item)ItemDefs.spell, 1, meta);
            items[index].func_77982_d(tag);
        }
        return items;
    }

    public InventorySpellBook ConvertToInventory(ItemStack bookStack) {
        InventorySpellBook isb = new InventorySpellBook();
        isb.SetInventoryContents(this.getMyInventory(bookStack));
        return isb;
    }

    public boolean func_77651_p() {
        return true;
    }

    public String GetActiveSpellName(ItemStack bookStack) {
        ItemStack stack = this.GetActiveItemStack(bookStack);
        if (stack == null) {
            return I18n.func_74838_a((String)"am2.tooltip.none");
        }
        return stack.func_82833_r();
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List<String> par3List, boolean par4) {
        ItemSpellBase activeScroll = this.GetActiveScroll(par1ItemStack);
        ItemStack stack = this.GetActiveItemStack(par1ItemStack);
        String s = I18n.func_74838_a((String)"am2.tooltip.open");
        String s2 = I18n.func_74838_a((String)"am2.tooltip.scroll");
        par3List.add("\u00a77" + s);
        par3List.add("\u00a77" + s2);
        if (activeScroll != null) {
            activeScroll.func_77624_a(stack, par2EntityPlayer, par3List, par4);
        }
        par3List.add("\u00a7c" + I18n.func_74838_a((String)"am2.tooltip.spellbookWarning1") + "\u00a7f");
        par3List.add("\u00a7c" + I18n.func_74838_a((String)"am2.tooltip.spellbookWarning2") + "\u00a7f");
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        ItemStack scrollStack = this.GetActiveItemStack(stack);
        if (scrollStack != null) {
            ItemDefs.spell.onUsingTick(scrollStack, player, count);
        }
    }

    public boolean isBookEnchantable(ItemStack bookStack, ItemStack enchantBook) {
        Map enchantMap = EnchantmentHelper.func_82781_a((ItemStack)enchantBook);
        for (Enchantment o : enchantMap.keySet()) {
            if (o != AMEnchantments.soulbound) continue;
            return true;
        }
        return false;
    }

    public int func_77619_b() {
        return 1;
    }

    public boolean func_77616_k(ItemStack par1ItemStack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        EntityPlayerSP player;
        ItemStack usingItem;
        super.func_77663_a(stack, world, entity, par4, par5);
        if (entity instanceof EntityPlayerSP && (usingItem = (player = (EntityPlayerSP)entity).func_184607_cu()) != null && usingItem.func_77973_b() == this && SkillData.For((EntityLivingBase)player).hasSkill("spell_motion")) {
            player.field_71158_b.field_78900_b *= 2.5f;
            player.field_71158_b.field_78902_a *= 2.5f;
        }
    }
}

