/*
 * Decompiled with CFR 0.152.
 */
package am2.items;

import am2.api.math.AMVector3;
import am2.items.ItemArsMagica;
import am2.utils.MathUtilities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class ItemLightningCharm
extends ItemArsMagica {
    private static final String KEY_ACTIVE = "IsActive";

    private boolean isActive(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        return stack.func_77978_p().func_74771_c(KEY_ACTIVE) == 1;
    }

    private void toggleActive(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (this.isActive(stack)) {
            stack.func_77978_p().func_74774_a(KEY_ACTIVE, (byte)0);
        } else {
            stack.func_77978_p().func_74774_a(KEY_ACTIVE, (byte)1);
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer, EnumHand hand) {
        if (par3EntityPlayer.func_70093_af()) {
            this.toggleActive(par1ItemStack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)par1ItemStack);
    }

    private void attractItems(World world, Entity ent) {
        double distance = 16.0;
        int hDist = 5;
        List entities = world.func_72872_a(EntityItem.class, new AxisAlignedBB(ent.field_70165_t - distance, ent.field_70163_u - (double)hDist, ent.field_70161_v - distance, ent.field_70165_t + distance, ent.field_70163_u + (double)hDist, ent.field_70161_v + distance));
        for (Entity e : entities) {
            EntityItem item = (EntityItem)e;
            if (item.func_174872_o() < 10) continue;
            AMVector3 movement = MathUtilities.GetMovementVectorBetweenPoints(new AMVector3(e), new AMVector3(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v));
            if (world.field_72995_K) continue;
            float factor = 0.35f;
            if (movement.y > 0.0f) {
                movement.y = 0.0f;
            }
            double x = -(movement.x * factor);
            double y = -(movement.y * factor);
            double z = -(movement.z * factor);
            e.func_70024_g(x, y, z);
            item.func_174867_a(0);
            if (Math.abs(e.field_70159_w) > Math.abs(x * 2.0)) {
                e.field_70159_w = x * (e.field_70159_w / e.field_70159_w);
            }
            if (Math.abs(e.field_70181_x) > Math.abs(y * 2.0)) {
                e.field_70181_x = y * (e.field_70181_x / e.field_70181_x);
            }
            if (!(Math.abs(e.field_70179_y) > Math.abs(z * 2.0))) continue;
            e.field_70179_y = z * (e.field_70179_y / e.field_70179_y);
        }
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (this.isActive(par1ItemStack)) {
            this.attractItems(par2World, par3Entity);
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.isActive(stack);
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List<String> par3List, boolean par4) {
        par3List.add(I18n.func_74838_a((String)"am2.tooltip.lightning_charm"));
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
    }
}

