/*
 * Decompiled with CFR 0.152.
 */
package am2.items;

import am2.ArsMagica2;
import am2.blocks.BlockInvisibleUtility;
import am2.defs.BlockDefs;
import am2.items.ItemArsMagica;
import am2.particles.AMParticle;
import am2.particles.ParticleHoldPosition;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemCandle
extends ItemArsMagica {
    private static final int radius = 10;
    private static final int short_radius = 5;
    private static final float immediate_radius = 2.5f;

    public ItemCandle() {
        this.func_77625_d(1);
        this.func_77656_e(18000);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState block;
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("search_block")) {
            block = worldIn.func_180495_p(pos);
            if (playerIn.func_70093_af() && block != null && block.func_185887_b(worldIn, pos) > 0.0f && worldIn.func_175625_s(pos) == null) {
                if (!worldIn.field_72995_K) {
                    this.setSearchBlock(block, stack);
                    worldIn.func_175698_g(pos);
                } else {
                    AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(worldIn, "radiant", (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5));
                    if (particle != null) {
                        particle.AddParticleController(new ParticleHoldPosition(particle, 20, 1, false));
                        particle.setRGBColorF(0.0f, 0.5f, 1.0f);
                    }
                }
                return EnumActionResult.SUCCESS;
            }
        }
        if (!worldIn.field_72995_K) {
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("search_block")) {
                playerIn.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"am2.tooltip.candlecantplace")));
                return EnumActionResult.PASS;
            }
            block = worldIn.func_180495_p(pos = pos.func_177972_a(facing));
            if (block == null || block.func_177230_c().func_176200_f((IBlockAccess)worldIn, pos)) {
                worldIn.func_180501_a(pos, BlockDefs.wardingCandle.func_176223_P(), 3);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    playerIn.field_71071_by.func_70299_a(playerIn.field_71071_by.field_70461_c, null);
                }
            }
            return EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    public void setSearchBlock(IBlockState state, ItemStack item) {
        if (!item.func_77942_o()) {
            item.func_77982_d(new NBTTagCompound());
        }
        this.setFlameColor(item, 0.0f, 1.0f, 0.0f);
        item.func_77978_p().func_74768_a("search_block", Block.func_176210_f((IBlockState)state));
    }

    private void setFlameColor(ItemStack stack, float r, float g, float b) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74776_a("flame_red", r);
        stack.func_77978_p().func_74776_a("flame_green", g);
        stack.func_77978_p().func_74776_a("flame_blue", b);
    }

    public void search(EntityPlayer player, ItemStack stack, World world, BlockPos pos, IBlockState state) {
        boolean found = false;
        boolean foundLarge = false;
        boolean foundSmall = false;
        for (int i = -10; i <= 10; ++i) {
            for (int j = -10; j <= 10; ++j) {
                for (int k = -10; k <= 10; ++k) {
                    IBlockState f_block = world.func_180495_p(pos.func_177982_a(i, j, k));
                    int dist = Math.abs(i) + Math.abs(j) + Math.abs(k);
                    if (dist > 10 || state != f_block) continue;
                    if ((float)dist <= 2.5f) {
                        this.setFlameColor(stack, 0.0f, 0.0f, 0.0f);
                        return;
                    }
                    if (dist <= 5 && !foundSmall) {
                        this.setFlameColor(stack, 1.0f, 0.0f, 0.0f);
                        found = true;
                        foundSmall = true;
                        continue;
                    }
                    if (found || foundSmall || foundLarge) continue;
                    this.setFlameColor(stack, 0.0f, 0.5f, 1.0f);
                    found = true;
                    foundLarge = true;
                }
            }
        }
        if (!found) {
            this.setFlameColor(stack, 0.0f, 1.0f, 0.0f);
        }
    }

    public boolean func_77651_p() {
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int indexInInventory, boolean isCurrentlyHeld) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            isCurrentlyHeld = player.func_184614_ca() == stack;
            if ((isCurrentlyHeld |= player.func_184592_cb() == stack) && !world.field_72995_K && ArsMagica2.config.candlesAreRovingLights() && world.func_175623_d(player.func_180425_c()) && world.func_175642_b(EnumSkyBlock.BLOCK, player.func_180425_c()) < 14) {
                world.func_180501_a(player.func_180425_c(), BlockDefs.invisibleUtility.func_176223_P().func_177226_a(BlockInvisibleUtility.TYPE, (Comparable)((Object)BlockInvisibleUtility.EnumInvisibleType.HIGH_ILLUMINATED)), 2);
            }
            if (isCurrentlyHeld) {
                if (!world.field_72995_K && stack.func_77942_o() && stack.func_77952_i() % 40 == 0) {
                    this.search(player, stack, world, player.func_180425_c(), Block.func_176220_d((int)stack.func_77978_p().func_74762_e("search_block")));
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_77972_a(1, (EntityLivingBase)player);
                }
                if (!world.field_72995_K && stack.func_77952_i() >= this.func_77612_l()) {
                    player.func_184201_a(player.func_184592_cb() == stack ? EntityEquipmentSlot.OFFHAND : EntityEquipmentSlot.MAINHAND, null);
                }
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        IBlockState state;
        ItemStack blockStack;
        Item tempItem;
        String name = I18n.func_74838_a((String)"item.arsmagica2:warding_candle.name");
        name = stack.func_77942_o() && stack.func_77978_p().func_74764_b("search_block") ? ((tempItem = (blockStack = new ItemStack((state = Block.func_176220_d((int)stack.func_77978_p().func_74762_e("search_block"))).func_177230_c(), 0, state.func_177230_c().func_176201_c(state))).func_77973_b()) == null ? name + " (" + stack.func_77978_p().func_74762_e("search_block") + ":" + stack.func_77978_p().func_74762_e("search_meta") + ")" : name + " (" + blockStack.func_82833_r() + ")") : name + " (" + I18n.func_74838_a((String)"am2.tooltip.unattuned") + ")";
        return name;
    }

    public boolean func_77614_k() {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack == null) {
            return slotChanged;
        }
        if (newStack == null) {
            return slotChanged;
        }
        if (oldStack.func_77978_p() == null) {
            return slotChanged;
        }
        if (newStack.func_77978_p() == null) {
            return slotChanged;
        }
        if (oldStack.func_77978_p().equals((Object)newStack.func_77978_p())) {
            return false;
        }
        return slotChanged;
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        ItemStack unattuned = new ItemStack((Item)this, 1, 0);
        par3List.add(unattuned);
    }
}

