/*
 * Decompiled with CFR 0.152.
 */
package am2.handler;

import am2.ArsMagica2;
import am2.api.math.AMVector2;
import am2.defs.PotionEffectsDefs;
import am2.extensions.EntityExtension;
import am2.utils.EntityUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ShrinkHandler {
    @SubscribeEvent
    public void onEntityLiving(LivingEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (ArsMagica2.disabledSkills.isSkillDisabled("shrink")) {
            return;
        }
        EntityExtension exProps = null;
        try {
            exProps = EntityExtension.For((EntityLivingBase)player);
        }
        catch (Throwable t) {
            return;
        }
        if (exProps.originalSize == null) {
            exProps.originalSize = new AMVector2(player.field_70130_N, player.field_70131_O);
        }
        boolean shrunk = exProps.isShrunk();
        if (!player.field_70170_p.field_72995_K && shrunk && !player.func_70644_a(PotionEffectsDefs.shrink)) {
            exProps.setShrunk(false);
            shrunk = false;
        } else if (!player.field_70170_p.field_72995_K && !shrunk && player.func_70644_a(PotionEffectsDefs.shrink)) {
            exProps.setShrunk(true);
            shrunk = true;
        }
        float shrinkPct = exProps.getShrinkPct();
        if (shrunk && shrinkPct < 1.0f) {
            shrinkPct = Math.min(1.0f, shrinkPct + 0.005f);
        } else if (!shrunk && shrinkPct > 0.0f) {
            shrinkPct = Math.max(0.0f, shrinkPct - 0.005f);
        }
        exProps.setShrinkPct(shrinkPct);
        if (exProps.getShrinkPct() > 0.0f) {
            if (exProps.shrinkAmount == 0.0f || exProps.getOriginalSize().x * 0.5 != (double)player.field_70130_N || exProps.getOriginalSize().y * 0.5 != (double)player.field_70131_O) {
                exProps.setOriginalSize(new AMVector2(player.field_70130_N, player.field_70131_O));
                exProps.shrinkAmount = 0.5f;
                EntityUtils.setSize((EntityLivingBase)player, player.field_70130_N * exProps.shrinkAmount, player.field_70131_O * exProps.shrinkAmount);
            }
        } else if (exProps.shrinkAmount != 0.0f) {
            AMVector2 size = EntityExtension.For((EntityLivingBase)player).getOriginalSize();
            EntityUtils.setSize((EntityLivingBase)player, (float)size.x, (float)size.y);
            exProps.shrinkAmount = 0.0f;
            if (exProps.getIsFlipped()) {
                event.getEntityLiving().func_70091_d(0.0, -1.0, 0.0);
            }
        }
        if (!player.field_70170_p.field_72995_K || exProps.getPrevShrinkPct() != exProps.getShrinkPct()) {
            // empty if block
        }
    }
}

