/*
 * Decompiled with CFR 0.152.
 */
package am2.gui;

import am2.blocks.tileentity.TileEntityParticleEmitter;
import am2.gui.controls.GuiButtonVariableDims;
import am2.gui.controls.GuiSlideControl;
import am2.particles.AMParticle;
import am2.particles.ParticleController;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiParticleEmitter
extends GuiScreen {
    protected String screenTitle = I18n.func_74838_a((String)"am2.gui.particleEmitter");
    private GuiButtonVariableDims btnParticleType;
    private GuiButtonVariableDims btnParticleBehaviour;
    private GuiButtonVariableDims btnParticleColorMode;
    private GuiSlideControl sliParticleRed;
    private GuiSlideControl sliParticleGreen;
    private GuiSlideControl sliParticleBlue;
    private GuiSlideControl sliParticleAlpha;
    private GuiSlideControl sliParticleScale;
    private GuiSlideControl sliParticleQuantity;
    private GuiSlideControl sliParticleDelay;
    private GuiSlideControl sliParticleSpeed;
    private GuiButton activeButton;
    private GuiButtonVariableDims hideBlock;
    private final TileEntityParticleEmitter tile;
    private final GuiScreen parent;

    public GuiParticleEmitter(TileEntityParticleEmitter target) {
        this.field_146297_k = Minecraft.func_71410_x();
        this.parent = this.field_146297_k.field_71462_r;
        this.field_146289_q = Minecraft.func_71410_x().field_71466_p;
        ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k);
        this.field_146294_l = scaledresolution.func_78326_a();
        this.field_146295_m = scaledresolution.func_78328_b();
        this.tile = target;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        this.btnParticleType = new GuiButtonVariableDims(10, 50, 40, AMParticle.particleTypes[this.tile.getParticleType()]);
        this.btnParticleBehaviour = new GuiButtonVariableDims(11, 50, 60, ParticleController.AuraControllerOptions[this.tile.getParticleBehaviour()]);
        this.btnParticleColorMode = new GuiButtonVariableDims(12, 50, 80, this.tile.getColorDefault() ? I18n.func_74838_a((String)"am2.gui.default") : (this.tile.getColorRandom() ? I18n.func_74838_a((String)"am2.gui.random") : I18n.func_74838_a((String)"am2.gui.custom")));
        this.hideBlock = new GuiButtonVariableDims(19, 50, 100, this.tile.getShow() ? I18n.func_74838_a((String)"am2.gui.visible") : I18n.func_74838_a((String)"am2.gui.hidden"));
        this.btnParticleType.setDimensions(80, 20);
        this.btnParticleBehaviour.setDimensions(80, 20);
        this.btnParticleColorMode.setDimensions(80, 20);
        this.hideBlock.setDimensions(80, 20);
        this.sliParticleScale = new GuiSlideControl(14, this.field_146294_l - 110, 40, 100, I18n.func_74838_a((String)"am2.gui.scale"), this.tile.getScale() * 100.0f, 1.0f, 200.0f);
        this.sliParticleAlpha = new GuiSlideControl(15, this.field_146294_l - 110, 60, 100, I18n.func_74838_a((String)"am2.gui.alpha"), this.tile.getAlpha() * 100.0f, 1.0f, 100.0f);
        this.sliParticleRed = new GuiSlideControl(16, this.field_146294_l - 110, 80, 100, I18n.func_74838_a((String)"am2.gui.red"), this.tile.getColor() >> 16 & 0xFF, 0.0f, 255.0f);
        this.sliParticleRed.setInteger(true);
        this.sliParticleGreen = new GuiSlideControl(17, this.field_146294_l - 110, 100, 100, I18n.func_74838_a((String)"am2.gui.green"), this.tile.getColor() >> 8 & 0xFF, 0.0f, 255.0f);
        this.sliParticleGreen.setInteger(true);
        this.sliParticleBlue = new GuiSlideControl(18, this.field_146294_l - 110, 120, 100, I18n.func_74838_a((String)"am2.gui.blue"), this.tile.getColor() & 0xFF, 0.0f, 255.0f);
        this.sliParticleBlue.setInteger(true);
        this.sliParticleQuantity = new GuiSlideControl(20, this.field_146294_l - 110, 140, 100, I18n.func_74838_a((String)"am2.gui.qty"), this.tile.getQuantity(), 1.0f, 5.0f);
        this.sliParticleQuantity.setInteger(true);
        this.sliParticleDelay = new GuiSlideControl(21, this.field_146294_l - 110, 160, 100, I18n.func_74838_a((String)"am2.gui.delay"), this.tile.getDelay(), 1.0f, 100.0f);
        this.sliParticleDelay.setInteger(true);
        this.sliParticleSpeed = new GuiSlideControl(22, this.field_146294_l - 110, 180, 100, I18n.func_74838_a((String)"am2.gui.speed"), 1.0f, 0.25f, 10.0f);
        if (this.tile.getColorDefault() || this.tile.getColorRandom()) {
            this.sliParticleRed.field_146124_l = false;
            this.sliParticleBlue.field_146124_l = false;
            this.sliParticleGreen.field_146124_l = false;
        } else {
            this.sliParticleRed.field_146124_l = true;
            this.sliParticleBlue.field_146124_l = true;
            this.sliParticleGreen.field_146124_l = true;
        }
        this.field_146292_n.add(new GuiButton(200, this.field_146294_l / 2 - 100, this.field_146295_m - 28, I18n.func_74838_a((String)"am2.gui.done")));
        this.field_146292_n.add(this.btnParticleType);
        this.field_146292_n.add(this.btnParticleBehaviour);
        this.field_146292_n.add(this.btnParticleColorMode);
        this.field_146292_n.add(this.sliParticleScale);
        this.field_146292_n.add(this.sliParticleAlpha);
        this.field_146292_n.add(this.sliParticleRed);
        this.field_146292_n.add(this.sliParticleGreen);
        this.field_146292_n.add(this.sliParticleBlue);
        this.field_146292_n.add(this.hideBlock);
        this.field_146292_n.add(this.sliParticleDelay);
        this.field_146292_n.add(this.sliParticleQuantity);
        this.field_146292_n.add(this.sliParticleSpeed);
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.screenTitle, this.field_146294_l / 2, 4, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, I18n.func_74838_a((String)"am2.gui.type"), 10, 45, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, I18n.func_74838_a((String)"am2.gui.action"), 10, 65, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, I18n.func_74838_a((String)"am2.gui.color"), 10, 85, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, I18n.func_74838_a((String)"am2.gui.border"), 10, 105, 0xFFFFFF);
        if (!this.tile.getShow()) {
            this.field_146289_q.func_78279_b(I18n.func_74838_a((String)"am2.gui.wrenchWarning"), 10, 125, 100, 0xFF0000);
        }
        if (this.activeButton != null && this.activeButton instanceof GuiSlideControl) {
            this.func_146284_a(this.activeButton);
        }
        super.func_73863_a(par1, par2, par3);
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        int index = 0;
        boolean flag = false;
        this.activeButton = par1GuiButton;
        switch (par1GuiButton.field_146127_k) {
            case 10: {
                index = this.tile.getParticleType();
                if (++index >= AMParticle.particleTypes.length) {
                    index = 0;
                }
                this.tile.setParticleType(index);
                this.btnParticleType.field_146126_j = AMParticle.particleTypes[index];
                break;
            }
            case 11: {
                index = this.tile.getParticleBehaviour();
                if (++index >= ParticleController.AuraControllerOptions.length) {
                    index = 0;
                }
                this.tile.setParticleBehaviour(index);
                this.btnParticleBehaviour.field_146126_j = ParticleController.AuraControllerOptions[index];
                break;
            }
            case 12: 
            case 13: {
                if (this.tile.getColorDefault()) {
                    this.tile.setColorDefault(false);
                    this.tile.setColorRandom(true);
                    this.sliParticleRed.field_146124_l = false;
                    this.sliParticleBlue.field_146124_l = false;
                    this.sliParticleGreen.field_146124_l = false;
                } else if (this.tile.getColorRandom()) {
                    this.tile.setColorDefault(false);
                    this.tile.setColorRandom(false);
                    this.sliParticleRed.field_146124_l = true;
                    this.sliParticleBlue.field_146124_l = true;
                    this.sliParticleGreen.field_146124_l = true;
                } else {
                    this.tile.setColorDefault(true);
                    this.tile.setColorRandom(false);
                    this.sliParticleRed.field_146124_l = false;
                    this.sliParticleBlue.field_146124_l = false;
                    this.sliParticleGreen.field_146124_l = false;
                }
                this.btnParticleColorMode.field_146126_j = this.tile.getColorDefault() ? "Default" : (this.tile.getColorRandom() ? I18n.func_74838_a((String)"am2.gui.random") : I18n.func_74838_a((String)"am2.gui.custom"));
                break;
            }
            case 14: {
                this.tile.setScale(((GuiSlideControl)par1GuiButton).getShiftedValue() / 100.0f);
                break;
            }
            case 15: {
                this.tile.setAlpha(((GuiSlideControl)par1GuiButton).getShiftedValue() / 100.0f);
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                int color = ((int)this.sliParticleRed.getShiftedValue() & 0xFF) << 16 | ((int)this.sliParticleGreen.getShiftedValue() & 0xFF) << 8 | (int)this.sliParticleBlue.getShiftedValue() & 0xFF;
                this.tile.setColor(color);
                break;
            }
            case 19: {
                flag = this.tile.getShow();
                this.tile.setShow(!flag);
                this.hideBlock.field_146126_j = !flag ? I18n.func_74838_a((String)"am2.gui.visible") : I18n.func_74838_a((String)"am2.gui.hidden");
                break;
            }
            case 20: {
                this.tile.setQuantity((int)this.sliParticleQuantity.getShiftedValue());
                break;
            }
            case 21: {
                this.tile.setDelay((int)this.sliParticleDelay.getShiftedValue());
                break;
            }
            case 22: {
                this.tile.setSpeed(this.sliParticleSpeed.getShiftedValue());
                break;
            }
            case 200: {
                this.tile.syncWithServer();
                this.field_146297_k.func_147108_a(this.parent);
            }
        }
        this.tile.syncWithServer();
    }

    public void func_146281_b() {
        this.tile.syncWithServer();
        super.func_146281_b();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.activeButton != null && this.activeButton instanceof GuiSlideControl && mouseButton != 0) {
            this.func_146284_a(this.activeButton);
        } else {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }
}

