/*
 * Decompiled with CFR 0.152.
 */
package am2.gui;

import am2.ArsMagica2;
import am2.api.ArsMagicaAPI;
import am2.api.SkillPointRegistry;
import am2.api.SkillRegistry;
import am2.api.SkillTreeRegistry;
import am2.api.affinity.AbstractAffinityAbility;
import am2.api.affinity.Affinity;
import am2.api.extensions.ISkillData;
import am2.api.skill.Skill;
import am2.api.skill.SkillPoint;
import am2.api.skill.SkillTree;
import am2.defs.ItemDefs;
import am2.defs.SkillDefs;
import am2.extensions.AffinityData;
import am2.extensions.SkillData;
import am2.gui.AMGuiIcons;
import am2.gui.controls.GuiButtonSkillTree;
import am2.packet.AMDataWriter;
import am2.packet.AMNetHandler;
import am2.texture.SpellIconManager;
import am2.utils.RenderUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.lwjgl.input.Keyboard;

public class GuiOcculus
extends GuiScreen {
    int xSize = 210;
    int ySize = 210;
    SkillTree currentTree = SkillDefs.TREE_OFFENSE;
    EntityPlayer player;
    int currentTabId = 0;
    private boolean isDragging = false;
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private int page = 0;
    private int maxPage = 0;
    private int offsetX = 210;
    private int offsetY = 0;
    private Skill hoverItem = null;
    private GuiButton nextPage;
    private GuiButton prevPage;

    public GuiOcculus(EntityPlayer player) {
        this.player = player;
    }

    public void func_73866_w_() {
        int tabId = 0;
        int posX = this.field_146294_l / 2 - this.xSize / 2;
        int posY = this.field_146295_m / 2 - this.ySize / 2;
        ImmutableList<SkillTree> testTab = SkillTreeRegistry.getSkillTreeMap();
        for (SkillTree entry : testTab) {
            if (tabId % 16 < 8) {
                this.field_146292_n.add(new GuiButtonSkillTree(tabId, posX + 7 + tabId % 16 * 24, posY - 22, entry, (int)Math.floor((float)tabId / 16.0f), false));
            } else {
                this.field_146292_n.add(new GuiButtonSkillTree(tabId, posX + 7 + (tabId % 16 - 8) * 24, posY + 210, entry, (int)Math.floor((float)tabId / 16.0f), true));
            }
            ++tabId;
        }
        this.maxPage = (int)Math.floor((float)(tabId - 1) / 16.0f);
        this.nextPage = new GuiButton(1000, posX + 212, posY - 21, 20, 20, ">");
        this.prevPage = new GuiButton(1001, posX - 15, posY - 21, 20, 20, "<");
        this.nextPage.field_146124_l = this.page < this.maxPage;
        this.prevPage.field_146124_l = this.page > 0;
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof GuiButtonSkillTree)) continue;
            button.field_146125_m = (int)Math.floor((float)button.field_146127_k / 16.0f) == this.page;
        }
        this.field_146292_n.add(this.nextPage);
        this.field_146292_n.add(this.prevPage);
        super.func_73866_w_();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            if (this.hoverItem != null && !SkillData.For((EntityLivingBase)this.player).hasSkill(this.hoverItem.getID())) {
                ISkillData data = SkillData.For((EntityLivingBase)this.player);
                if (data.canLearn(this.hoverItem.getID())) {
                    AMNetHandler.INSTANCE.sendPacketToServer((byte)63, new AMDataWriter().add(this.hoverItem.getID()).generate());
                }
            } else if (this.currentTree != SkillDefs.TREE_AFFINITY) {
                this.isDragging = true;
            }
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.isDragging = false;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        block5: {
            block6: {
                block4: {
                    super.func_146284_a(button);
                    if (!(button instanceof GuiButtonSkillTree)) break block4;
                    this.currentTree = ((GuiButtonSkillTree)button).getTree();
                    this.currentTabId = button.field_146127_k;
                    this.offsetX = 210;
                    this.offsetY = 0;
                    break block5;
                }
                if (button != this.nextPage) break block6;
                ++this.page;
                if (this.page > this.maxPage) {
                    this.page = this.maxPage;
                }
                this.nextPage.field_146124_l = this.page < this.maxPage;
                this.prevPage.field_146124_l = this.page > 0;
                for (GuiButton button_ : this.field_146292_n) {
                    if (!(button_ instanceof GuiButtonSkillTree)) continue;
                    button_.field_146125_m = (int)Math.floor((float)button_.field_146127_k / 16.0f) == this.page;
                }
                break block5;
            }
            if (button != this.prevPage) break block5;
            --this.page;
            if (this.page < 0) {
                this.page = 0;
            }
            this.nextPage.field_146124_l = this.page < this.maxPage;
            this.prevPage.field_146124_l = this.page > 0;
            for (GuiButton button_ : this.field_146292_n) {
                if (!(button_ instanceof GuiButtonSkillTree)) continue;
                button_.field_146125_m = (int)Math.floor((float)button_.field_146127_k / 16.0f) == this.page;
            }
        }
    }

    private int calcXOffset(int posX, Skill s) {
        return posX - this.offsetX + s.getPosX();
    }

    private int calcYOffset(int posY, Skill s) {
        return posY - this.offsetY + s.getPosY();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int posX = this.field_146294_l / 2 - this.xSize / 2;
        int posY = this.field_146295_m / 2 - this.ySize / 2;
        float renderSize = 32.0f;
        float renderRatio = 0.29f;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("arsmagica2", "textures/occulus/overlay.png"));
        this.func_73729_b(posX, posY, 0, 0, 210, 210);
        if ((int)Math.floor((float)this.currentTabId / 16.0f) == this.page) {
            if (this.currentTabId % 16 < 8) {
                this.func_73729_b(posX + 7 + this.currentTabId % 16 * 24, posY, 22, 210, 22, 7);
            } else {
                this.func_73729_b(posX + 7 + (this.currentTabId % 16 - 8) * 24, posY + 203, 22, 210, 22, 7);
            }
        }
        this.field_73735_i = -18.0f;
        if (this.isDragging) {
            int dx = this.lastMouseX - mouseX;
            int dy = this.lastMouseY - mouseY;
            this.offsetX += dx;
            this.offsetY += dy;
            if (this.offsetX < 0) {
                this.offsetX = 0;
            }
            if (this.offsetX > 568) {
                this.offsetX = 568;
            }
            if (this.offsetY < 0) {
                this.offsetY = 0;
            }
            if (this.offsetY > 568) {
                this.offsetY = 568;
            }
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        float calcYOffest = (float)this.offsetY / 568.0f * (1.0f - renderRatio);
        float calcXOffest = (float)this.offsetX / 568.0f * (1.0f - renderRatio);
        int maxSize = 0;
        for (SkillPoint skillPoint : SkillPointRegistry.getSkillPointMap().values()) {
            if (!skillPoint.canRender()) continue;
            maxSize = Math.max(maxSize, this.field_146289_q.func_78256_a(skillPoint.getName() + " : " + SkillData.For((EntityLivingBase)this.player).getSkillPoint(skillPoint)));
        }
        this.field_73735_i = 0.0f;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("arsmagica2", "textures/occulus/skill_points.png"));
        this.drawSkillPointBackground(posX, posY, maxSize + 10, 210);
        int pointOffsetX = 5;
        for (SkillPoint point : SkillPointRegistry.getSkillPointMap().values()) {
            if (!point.canRender()) continue;
            this.field_146289_q.func_78276_b(point.getName() + " : " + SkillData.For((EntityLivingBase)this.player).getSkillPoint(point), posX + 215, posY + pointOffsetX, point.getColor());
            pointOffsetX += 10;
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.currentTree.getBackground());
        if (this.currentTree != SkillDefs.TREE_AFFINITY) {
            RenderUtils.drawBox(posX + 7, posY + 7, 196.0f, 196.0f, this.field_73735_i, calcXOffest, calcYOffest, renderRatio + calcXOffest, renderRatio + calcYOffest);
            ArrayList<Skill> skills = SkillRegistry.getSkillsForTree(this.currentTree);
            this.field_73735_i = 1.0f;
            ISkillData data = SkillData.For((EntityLivingBase)this.player);
            for (Object s : skills) {
                if (!s.getPoint().canRender() && !data.hasSkill(s.getID())) continue;
                for (String p : s.getParents()) {
                    int color;
                    Skill parent;
                    if (p == null || (parent = SkillRegistry.getSkillFromName(p)) == null || !skills.contains((Object)parent) || !parent.getPoint().canRender() && !data.hasSkill(parent.getID())) continue;
                    int offsetX = this.calcXOffset(posX, (Skill)((Object)s)) + 16;
                    int offsetY = this.calcYOffset(posY, (Skill)((Object)s)) + 16;
                    int offsetX2 = this.calcXOffset(posX, parent) + 16;
                    int offsetY2 = this.calcYOffset(posY, parent) + 16;
                    offsetX = MathHelper.func_76125_a((int)offsetX, (int)(posX + 7), (int)(posX + 203));
                    offsetY = MathHelper.func_76125_a((int)offsetY, (int)(posY + 7), (int)(posY + 203));
                    offsetX2 = MathHelper.func_76125_a((int)offsetX2, (int)(posX + 7), (int)(posX + 203));
                    offsetY2 = MathHelper.func_76125_a((int)offsetY2, (int)(posY + 7), (int)(posY + 203));
                    boolean hasPrereq = data.canLearn(s.getID()) || data.hasSkill(s.getID());
                    int n = color = !SkillData.For((EntityLivingBase)this.player).hasSkill(s.getID()) ? s.getPoint().getColor() & 0x999999 : 65280;
                    if (!hasPrereq) {
                        color = 0;
                    }
                    if (offsetX != posX + 7 && offsetX != posX + 203) {
                        RenderUtils.lineThick2d(offsetX, offsetY, offsetX, offsetY2, hasPrereq ? 0.0f : -1.0f, color);
                    }
                    if (offsetY2 == posY + 7 || offsetY2 == posY + 203) continue;
                    RenderUtils.lineThick2d(offsetX, offsetY2, offsetX2, offsetY2, hasPrereq ? 0.0f : -1.0f, color);
                }
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            for (Object s : skills) {
                float mod;
                if (!s.getPoint().canRender() && !data.hasSkill(s.getID())) continue;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ISkillData skillData = SkillData.For((EntityLivingBase)this.player);
                boolean hasPrereq = skillData.canLearn(s.getID()) || data.hasSkill(s.getID());
                int offsetX = this.calcXOffset(posX, (Skill)((Object)s));
                int offsetY = this.calcYOffset(posY, (Skill)((Object)s));
                int tick = this.player.field_70173_aa % 80 >= 40 ? this.player.field_70173_aa % 40 - 20 : -(this.player.field_70173_aa % 40) + 20;
                float multiplier = 0.75f + (float)tick / 80.0f;
                TextureAtlasSprite sprite = SpellIconManager.INSTANCE.getSprite(s.getID());
                if ((float)offsetX + renderSize < (float)(posX + 7) || offsetX > posX + 203 || (float)offsetY + renderSize < (float)(posY + 7) || offsetY > posY + 203 || sprite == null) continue;
                float spriteXSize = sprite.func_94212_f() - sprite.func_94209_e();
                float spriteYSize = sprite.func_94210_h() - sprite.func_94206_g();
                float xStartMod = 0.0f;
                float yStartMod = 0.0f;
                float xEndMod = 0.0f;
                float yEndMod = 0.0f;
                if (offsetX < posX + 7) {
                    xStartMod = mod = (float)(posX + 7 - offsetX);
                } else if ((float)offsetX + renderSize > (float)(posX + 203)) {
                    xEndMod = mod = renderSize - (float)(posX + 203 - offsetX);
                }
                if (offsetY < posY + 7) {
                    yStartMod = mod = (float)(posY + 7 - offsetY);
                } else if ((float)offsetY + renderSize > (float)(posY + 203)) {
                    yEndMod = mod = renderSize - (float)(posY + 203 - offsetY);
                }
                if (!hasPrereq) {
                    GlStateManager.func_179124_c((float)0.1f, (float)0.1f, (float)0.1f);
                } else if (!skillData.hasSkill(s.getID())) {
                    GlStateManager.func_179124_c((float)(Math.max(RenderUtils.getRed(s.getPoint().getColor()), 0.6f) * multiplier), (float)(Math.max(RenderUtils.getGreen(s.getPoint().getColor()), 0.6f) * multiplier), (float)(Math.max(RenderUtils.getBlue(s.getPoint().getColor()), 0.6f) * multiplier));
                }
                if (ArsMagica2.disabledSkills.isSkillDisabled(s.getID())) {
                    GlStateManager.func_179124_c((float)0.3f, (float)0.3f, (float)0.3f);
                }
                RenderUtils.drawBox((float)offsetX + xStartMod, (float)offsetY + yStartMod, renderSize - xStartMod - xEndMod, renderSize - yStartMod - yEndMod, 0.0f, sprite.func_94209_e() + xStartMod / renderSize * spriteXSize, sprite.func_94206_g() + yStartMod / renderSize * spriteYSize, sprite.func_94212_f() - xEndMod / renderSize * spriteXSize, sprite.func_94210_h() - yEndMod / renderSize * spriteYSize);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (!ArsMagica2.disabledSkills.isSkillDisabled(s.getID())) continue;
                sprite = AMGuiIcons.padlock;
                spriteXSize = sprite.func_94212_f() - sprite.func_94209_e();
                spriteYSize = sprite.func_94210_h() - sprite.func_94206_g();
                xStartMod = 0.0f;
                yStartMod = 0.0f;
                xEndMod = 0.0f;
                yEndMod = 0.0f;
                if (offsetX + 8 < posX + 7) {
                    xStartMod = mod = (float)(posX + 7 - offsetX - 8);
                } else if (offsetX + 24 > posX + 203) {
                    xEndMod = mod = (float)(16 - (posX + 203 - offsetX - 8));
                }
                if (offsetY + 8 < posY + 7) {
                    yStartMod = mod = (float)(posY + 7 - offsetY - 8);
                } else if (offsetY + 24 > posY + 203) {
                    yEndMod = mod = (float)(16 - (posY + 203 - offsetY - 8));
                }
                RenderUtils.drawBox((float)offsetX + xStartMod + 8.0f, (float)offsetY + yStartMod + 8.0f, 16.0f - xStartMod - xEndMod, 16.0f - yStartMod - yEndMod, 0.0f, sprite.func_94209_e() + xStartMod / 16.0f * spriteXSize, sprite.func_94206_g() + yStartMod / 16.0f * spriteYSize, sprite.func_94212_f() - xEndMod / 16.0f * spriteXSize, sprite.func_94210_h() - yEndMod / 16.0f * spriteYSize);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (mouseX > posX && mouseX < posX + 210 && mouseY > posY && mouseY < posY + 210) {
                boolean bl;
                boolean bl2 = false;
                this.field_73735_i = 0.0f;
                for (Skill s : skills) {
                    if (!s.getPoint().canRender() && !data.hasSkill(s.getID())) continue;
                    int offsetX = this.calcXOffset(posX, s);
                    int offsetY = this.calcYOffset(posY, s);
                    if (offsetX > mouseX || (float)offsetX < (float)mouseX - renderSize || offsetY > mouseY || (float)offsetY < (float)mouseY - renderSize) continue;
                    boolean hasPrereq = true;
                    for (String subParent : s.getParents()) {
                        hasPrereq &= data.hasSkill(subParent);
                    }
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(s.getPoint().getChatColor().toString() + s.getName());
                    if (ArsMagica2.disabledSkills.isSkillDisabled(s.getID())) {
                        list.add(TextFormatting.DARK_RED.toString() + I18n.func_74838_a((String)"am2.gui.occulus.disabled"));
                    } else if (hasPrereq) {
                        list.add(TextFormatting.DARK_GRAY.toString() + s.getOcculusDesc());
                    } else {
                        list.add(TextFormatting.DARK_RED.toString() + I18n.func_74838_a((String)"am2.gui.occulus.missingrequirements"));
                    }
                    this.drawHoveringText(list, mouseX, mouseY, Minecraft.func_71410_x().field_71466_p);
                    bl = true;
                    this.hoverItem = s;
                    RenderHelper.func_74518_a();
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                }
                if (!bl) {
                    this.hoverItem = null;
                }
            }
        } else {
            boolean isShiftDown = Keyboard.isKeyDown((int)42);
            RenderUtils.drawBox(posX + 7, posY + 7, 196.0f, 196.0f, this.field_73735_i, 0.0f, 0.0f, 1.0f, 1.0f);
            int affNum = ArsMagicaAPI.getAffinityRegistry().getValues().size() - 1;
            int n = 360 / affNum;
            int currentID = 0;
            int cX = posX + this.xSize / 2;
            int cY = posY + this.ySize / 2;
            ArrayList<String> drawString = new ArrayList<String>();
            for (Affinity aff : ArsMagicaAPI.getAffinityRegistry().getValues()) {
                if (aff == Affinity.NONE) continue;
                double depth = AffinityData.For((EntityLivingBase)this.player).getAffinityDepth(aff);
                double affEndX = Math.cos(Math.toRadians(n * currentID)) * 10.0 + Math.cos(Math.toRadians(n * currentID)) * depth * 60.0;
                double affEndY = Math.sin(Math.toRadians(n * currentID)) * 10.0 + Math.sin(Math.toRadians(n * currentID)) * depth * 60.0;
                double affStartX1 = Math.cos(Math.toRadians(n * currentID - n / 2)) * 10.0;
                double affStartY1 = Math.sin(Math.toRadians(n * currentID - n / 2)) * 10.0;
                double affStartX2 = Math.cos(Math.toRadians(n * currentID + n / 2)) * 10.0;
                double affStartY2 = Math.sin(Math.toRadians(n * currentID + n / 2)) * 10.0;
                double affDrawTextX = Math.cos(Math.toRadians(n * currentID)) * 80.0 - 7.0;
                double affDrawTextY = Math.sin(Math.toRadians(n * currentID)) * 80.0 - 7.0;
                ++currentID;
                int displace = (int)((Math.max(affStartX1, affStartX2) - Math.min(affStartX1, affStartX2) + Math.max(affStartY1, affStartY2) - Math.min(affStartY1, affStartY2)) / 2.0);
                if (depth > (double)0.01f) {
                    RenderUtils.fractalLine2dd(affStartX1 + (double)cX, affStartY1 + (double)cY, affEndX + (double)cX, affEndY + (double)cY, this.field_73735_i, aff.getColor(), displace, 0.8f);
                    RenderUtils.fractalLine2dd(affStartX2 + (double)cX, affStartY2 + (double)cY, affEndX + (double)cX, affEndY + (double)cY, this.field_73735_i, aff.getColor(), displace, 0.8f);
                    RenderUtils.fractalLine2dd(affStartX1 + (double)cX, affStartY1 + (double)cY, affEndX + (double)cX, affEndY + (double)cY, this.field_73735_i, aff.getColor(), displace, 1.1f);
                    RenderUtils.fractalLine2dd(affStartX2 + (double)cX, affStartY2 + (double)cY, affEndX + (double)cX, affEndY + (double)cY, this.field_73735_i, aff.getColor(), displace, 1.1f);
                } else {
                    RenderUtils.line2d((float)affStartX1 + (float)cX, (float)affStartY1 + (float)cY, (float)affEndX + (float)cX, (float)affEndY + (float)cY, this.field_73735_i, aff.getColor());
                    RenderUtils.line2d((float)affStartX2 + (float)cX, (float)affStartY2 + (float)cY, (float)affEndX + (float)cX, (float)affEndY + (float)cY, this.field_73735_i, aff.getColor());
                }
                Minecraft.func_71410_x().field_71466_p.func_78276_b("" + (float)Math.round(depth * 10000.0) / 100.0f, (int)(affDrawTextX * 0.9 + (double)cX), (int)(affDrawTextY * 0.9 + (double)cY), aff.getColor());
                int xMovement = affDrawTextX > 0.0 ? 5 : -5;
                xMovement = affDrawTextX == 0.0 ? 0 : xMovement;
                int yMovement = affDrawTextY > 0.0 ? 5 : -5;
                yMovement = affDrawTextY == 0.0 ? 0 : yMovement;
                int drawX = (int)(affDrawTextX * 1.1 + (double)cX + (double)xMovement);
                int drawY = (int)(affDrawTextY * 1.1 + (double)cY + (double)yMovement);
                this.field_146296_j.func_180450_b(new ItemStack((Item)ItemDefs.essence, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)aff)), drawX, drawY);
                if (mouseX <= drawX || mouseX >= drawX + 16 || mouseY <= drawY || mouseY >= drawY + 16) continue;
                drawString.add(TextFormatting.RESET.toString() + aff.getLocalizedName());
                ArrayList abilites = Lists.newArrayList((Iterable)ArsMagicaAPI.getAffinityAbilityRegistry().getValues());
                abilites.sort(new Comparator<AbstractAffinityAbility>(){

                    @Override
                    public int compare(AbstractAffinityAbility o1, AbstractAffinityAbility o2) {
                        return (int)(o1.getMinimumDepth() * 100.0f - o2.getMinimumDepth() * 100.0f);
                    }
                });
                for (AbstractAffinityAbility ability : abilites) {
                    if (ability.getAffinity() != aff) continue;
                    String advancedTooltip = "";
                    if (isShiftDown) {
                        advancedTooltip = " (Min. : " + Math.round(ability.getMinimumDepth() * 100.0f) + "%" + (ability.hasMax() ? ", Max. : " + Math.round(ability.getMaximumDepth() * 100.0f) + "%" : "") + ")";
                    }
                    drawString.add(TextFormatting.RESET.toString() + (ability.isEligible(this.player) ? TextFormatting.GREEN.toString() : TextFormatting.DARK_RED.toString()) + I18n.func_74838_a((String)("affinityability." + ability.getRegistryName().toString().replaceAll("arsmagica2:", "") + ".name")) + advancedTooltip);
                }
            }
            if (!drawString.isEmpty()) {
                if (!isShiftDown) {
                    drawString.add(TextFormatting.GRAY.toString() + I18n.func_74838_a((String)"am2.tooltip.shiftForDetails"));
                }
                this.func_146283_a(drawString, mouseX, mouseY);
            }
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.func_74518_a();
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void drawSkillPointBackground(int startX, int startY, int width, int height) {
        int w;
        int x;
        int posX = 210;
        int posY = 0;
        this.func_73729_b(startX + posX + width - 4, startY + posY, 252, 0, 4, 4);
        this.func_73729_b(startX + posX + width - 4, startY + posY + height - 4, 252, 252, 4, 4);
        int h = height - 8;
        for (w = width - 4; w > 0; w -= x) {
            x = 0;
            x = w > 252 ? 252 : w;
            while (h > 0) {
                int y = 0;
                y = h > 248 ? 248 : h;
                this.func_73729_b(startX + posX + w - x, startY + posY + 4 + h - y, 4, 4, x, y);
                h -= y;
            }
        }
        h = height - 8;
        for (w = width - 4; w > 0; w -= x) {
            x = 0;
            x = w > 252 ? 252 : w;
            this.func_73729_b(startX + posX + w - x, startY + posY, 4, 0, x, 4);
            this.func_73729_b(startX + posX + w - x, startY + posY + height - 4, 4, 252, x, 4);
        }
        while (h > 0) {
            int y = 0;
            y = h > 248 ? 248 : h;
            this.func_73729_b(startX + posX + width - 4, startY + posY + 4 + h - y, 252, 4, 4, y);
            h -= y;
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

