/*
 * Decompiled with CFR 0.152.
 */
package am2.gui;

import am2.api.ArsMagicaAPI;
import am2.api.SkillRegistry;
import am2.api.SpellRegistry;
import am2.api.math.AMVector2;
import am2.api.skill.Skill;
import am2.api.spell.AbstractSpellPart;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifier;
import am2.api.spell.SpellShape;
import am2.blocks.tileentity.TileEntityInscriptionTable;
import am2.container.ContainerInscriptionTable;
import am2.extensions.SkillData;
import am2.gui.AMGuiHelper;
import am2.gui.controls.GuiButtonVariableDims;
import am2.spell.SpellValidator;
import am2.spell.shape.MissingShape;
import am2.texture.SpellIconManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import org.lwjgl.opengl.GL11;

public class GuiInscriptionTable
extends GuiContainer {
    private static final ResourceLocation background = new ResourceLocation("arsmagica2", "textures/gui/inscriptionTableGui.png");
    private final EntityPlayer usingPlayer;
    private final ArrayList<String> knownShapes;
    private final ArrayList<String> knownComponents;
    private final ArrayList<String> knownModifiers;
    private AbstractSpellPart hoveredItem;
    private TextureAtlasSprite hoveredIcon;
    private boolean dragging;
    private boolean lowerHover;
    private int lowerHoverIndex;
    private int lowerHoverShapeGroup = -1;
    private int lastMouseX;
    private int lastMouseY;
    private int iconX;
    private int iconY;
    int IIconXStart_upper = 41;
    int IIconYStart_upper = 5;
    int IIconXStart_lower = 41;
    int IIconYStart_lower = 146;
    int shapeGroupWidth = 37;
    int shapeGroupPadding = 3;
    int shapeGroupY = 108;
    int shapeGroupX = 13;
    AMVector2 searchFieldPosition;
    AMVector2 nameFieldPosition;
    AMVector2 searchFieldDimensions;
    AMVector2 nameFieldDimensions;
    int IIconStep = 17;
    private SpellValidator.ValidationResult result;
    private GuiTextField searchBar;
    private GuiTextField nameBar;
    private GuiButtonVariableDims createSpellButton;
    private GuiButtonVariableDims resetSpellButton;
    private String defaultSearchLabel = "\u00a77\u00a7o" + I18n.func_74838_a((String)"am2.gui.search");
    private String defaultNameLabel = "\u00a77\u00a7o" + I18n.func_74838_a((String)"am2.gui.name");

    public GuiInscriptionTable(InventoryPlayer playerInventory, TileEntityInscriptionTable table) {
        super((Container)new ContainerInscriptionTable(table, playerInventory));
        this.usingPlayer = playerInventory.field_70458_d;
        this.field_146999_f = 220;
        this.field_147000_g = 252;
        this.dragging = false;
        this.knownShapes = SkillData.For((EntityLivingBase)this.usingPlayer).getKnownShapes();
        this.knownComponents = SkillData.For((EntityLivingBase)this.usingPlayer).getKnownComponents();
        this.knownModifiers = SkillData.For((EntityLivingBase)this.usingPlayer).getKnownModifiers();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.searchFieldPosition = new AMVector2(39.0, 59.0);
        this.searchFieldDimensions = new AMVector2(141.0, 12.0);
        this.searchBar = new GuiTextField(0, Minecraft.func_71410_x().field_71466_p, this.searchFieldPosition.iX, this.searchFieldPosition.iY, this.searchFieldDimensions.iX, this.searchFieldDimensions.iY);
        this.nameFieldPosition = new AMVector2(39.0, 93.0);
        this.nameFieldDimensions = new AMVector2(141.0, 12.0);
        this.nameBar = new GuiTextField(1, Minecraft.func_71410_x().field_71466_p, this.nameFieldPosition.iX, this.nameFieldPosition.iY, this.nameFieldDimensions.iX, this.nameFieldDimensions.iY);
        int l = (this.field_146294_l - this.field_146999_f) / 2;
        int i1 = (this.field_146295_m - this.field_147000_g) / 2;
        this.createSpellButton = new GuiButtonVariableDims(0, l - 65, i1, I18n.func_74838_a((String)"am2.gui.makeSpell"));
        this.createSpellButton.setDimensions(60, 20);
        this.resetSpellButton = new GuiButtonVariableDims(1, l + 120, i1 + 72, I18n.func_74838_a((String)"am2.gui.resetSpell"));
        this.resetSpellButton.setDimensions(60, 20);
        this.resetSpellButton.field_146125_m = false;
        if (this.usingPlayer.field_71075_bZ.field_75098_d) {
            this.field_146292_n.add(this.createSpellButton);
        }
        this.field_146292_n.add(this.resetSpellButton);
        this.nameBar.func_146180_a(((ContainerInscriptionTable)this.field_147002_h).getSpellName());
        if (this.nameBar.func_146179_b().equals("")) {
            this.nameBar.func_146180_a(this.defaultNameLabel);
        }
        this.searchBar.func_146180_a(this.defaultSearchLabel);
        this.result = ((ContainerInscriptionTable)this.field_147002_h).validateCurrentDefinition();
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton == this.createSpellButton && this.usingPlayer.field_71075_bZ.field_75098_d) {
            ((ContainerInscriptionTable)this.field_147002_h).giveSpellToPlayer(this.usingPlayer);
        } else if (par1GuiButton == this.resetSpellButton) {
            ((ContainerInscriptionTable)this.field_147002_h).resetSpellNameAndIcon();
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) throws IOException {
        super.func_73864_a(par1, par2, par3);
        int l = (this.field_146294_l - this.field_146999_f) / 2;
        int i1 = (this.field_146295_m - this.field_147000_g) / 2;
        par1 -= l;
        par2 -= i1;
        if (this.hoveredItem != null && this.hoveredIcon != null) {
            if (this.spellPartIsValidAddition(this.hoveredItem) && !this.lowerHover) {
                this.dragging = true;
            } else if (this.lowerHover) {
                if (this.lowerHoverShapeGroup == -1 && ((ContainerInscriptionTable)this.field_147002_h).currentRecipeContains(this.hoveredItem)) {
                    if (this.hoveredItem instanceof SpellShape) {
                        int index = this.lowerHoverIndex;
                        int startIndex = index++;
                        int count = 0;
                        while (index < ((ContainerInscriptionTable)this.field_147002_h).getCurrentRecipeSize() && !(((ContainerInscriptionTable)this.field_147002_h).getRecipeItemAt(index) instanceof SpellShape)) {
                            ++count;
                            ++index;
                        }
                        ((ContainerInscriptionTable)this.field_147002_h).removeMultipleRecipeParts(startIndex, count);
                    } else {
                        ((ContainerInscriptionTable)this.field_147002_h).removeSingleRecipePart(this.lowerHoverIndex);
                    }
                    this.result = ((ContainerInscriptionTable)this.field_147002_h).validateCurrentDefinition();
                } else if (this.lowerHoverShapeGroup >= 0) {
                    if (this.hoveredItem instanceof SpellShape) {
                        int index = this.lowerHoverIndex;
                        int startIndex = index++;
                        int count = 0;
                        while (index < ((ContainerInscriptionTable)this.field_147002_h).getShapeGroupSize(this.lowerHoverShapeGroup) && !(((ContainerInscriptionTable)this.field_147002_h).getShapeGroupPartAt(this.lowerHoverShapeGroup, index) instanceof SpellShape)) {
                            ++count;
                            ++index;
                        }
                        ((ContainerInscriptionTable)this.field_147002_h).removeMultipleRecipePartsFromGroup(this.lowerHoverShapeGroup, startIndex, count);
                    } else {
                        ((ContainerInscriptionTable)this.field_147002_h).removeSingleRecipePartFromGroup(this.lowerHoverShapeGroup, this.lowerHoverIndex);
                    }
                    this.result = ((ContainerInscriptionTable)this.field_147002_h).validateCurrentDefinition();
                }
            }
        } else {
            boolean boxClick = false;
            if (par1 >= this.searchFieldPosition.iX && par1 <= this.searchFieldPosition.iX + this.searchFieldDimensions.iX && par2 >= this.searchFieldPosition.iY && par2 <= this.searchFieldPosition.iY + this.searchFieldDimensions.iY) {
                if (par3 == 1 || this.searchBar.func_146179_b().equals(this.defaultSearchLabel)) {
                    this.searchBar.func_146180_a("");
                }
                if (this.nameBar.func_146179_b().equals("")) {
                    this.nameBar.func_146180_a(this.defaultNameLabel);
                }
                boxClick = true;
            }
            if (par1 >= this.nameFieldPosition.iX && par1 <= this.nameFieldPosition.iX + this.nameFieldDimensions.iX && par2 >= this.nameFieldPosition.iY && par2 <= this.nameFieldPosition.iY + this.nameFieldDimensions.iY) {
                if (par3 == 1 || this.nameBar.func_146179_b().equals(this.defaultNameLabel)) {
                    this.nameBar.func_146180_a("");
                    ((ContainerInscriptionTable)this.field_147002_h).setSpellName(this.nameBar.func_146179_b());
                }
                if (this.searchBar.func_146179_b().equals("")) {
                    this.searchBar.func_146180_a(this.defaultSearchLabel);
                }
                boxClick = true;
            }
            if (!boxClick) {
                if (this.nameBar.func_146179_b().equals("")) {
                    this.nameBar.func_146180_a(this.defaultNameLabel);
                }
                if (this.searchBar.func_146179_b().equals("")) {
                    this.searchBar.func_146180_a(this.defaultSearchLabel);
                }
            }
            this.searchBar.func_146192_a(par1, par2, par3);
            this.nameBar.func_146192_a(par1, par2, par3);
        }
    }

    protected void func_146286_b(int x, int y, int action) {
        super.func_146286_b(x, y, action);
        int l = (this.field_146294_l - this.field_146999_f) / 2;
        int i1 = (this.field_146295_m - this.field_147000_g) / 2;
        x -= l;
        y -= i1;
        if ((action == 0 || action == 1) && this.dragging) {
            this.dragging = false;
            if (x >= this.IIconXStart_lower && x <= this.IIconXStart_lower + 150 && y >= this.IIconYStart_lower && y <= this.IIconYStart_lower + 18) {
                ((ContainerInscriptionTable)this.field_147002_h).addRecipePart(this.hoveredItem);
                this.result = ((ContainerInscriptionTable)this.field_147002_h).validateCurrentDefinition();
            }
            int sg = ((ContainerInscriptionTable)this.field_147002_h).getNumStageGroups();
            for (int i = 0; i < sg; ++i) {
                int SGX = this.shapeGroupX + (this.shapeGroupWidth + this.shapeGroupPadding) * i;
                int SGY = this.shapeGroupY;
                if (x < SGX || x > SGX + this.shapeGroupWidth || y < SGY || y > SGY + this.shapeGroupWidth) continue;
                ((ContainerInscriptionTable)this.field_147002_h).addRecipePartToGroup(i, this.hoveredItem);
                this.result = ((ContainerInscriptionTable)this.field_147002_h).validateCurrentDefinition();
            }
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        if (!this.searchBar.func_146201_a(par1, par2)) {
            if (this.nameBar.func_146201_a(par1, par2)) {
                ((ContainerInscriptionTable)this.field_147002_h).setSpellName(this.nameBar.func_146179_b());
            } else {
                super.func_73869_a(par1, par2);
            }
        }
    }

    protected void func_146976_a(float f, int i, int j) {
        this.field_146297_k.field_71446_o.func_110577_a(background);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int l = (this.field_146294_l - this.field_146999_f) / 2;
        int i1 = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(l, i1, 0, 0, this.field_146999_f, 165);
        this.func_73729_b(l + 22, i1 + 165, 0, 165, 176, 87);
        int offsetX = l + this.shapeGroupX;
        for (int sg = 0; sg < 5; ++sg) {
            if (sg >= ((ContainerInscriptionTable)this.field_147002_h).getNumStageGroups()) {
                GL11.glColor3f((float)0.5f, (float)0.5f, (float)0.5f);
            }
            this.func_73729_b(offsetX + sg * (this.shapeGroupWidth + this.shapeGroupPadding), i1 + this.shapeGroupY, 176, 165, 37, 37);
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(l + 101, i1 + 73, 220, 0, 18, 18);
        this.lastMouseX = i - l;
        this.lastMouseY = j - i1;
    }

    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        ArrayList<String> label = new ArrayList<String>();
        int l = (this.field_146294_l - this.field_146999_f) / 2;
        int i1 = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_73735_i = 0.0f;
        GL11.glEnable((int)3008);
        this.drawBookIcon();
        boolean hovering = false;
        if (this.drawAvailableParts(label)) {
            hovering = true;
            this.lowerHover = false;
        }
        if (this.drawCurrentRecipe(label, l, i1)) {
            hovering = true;
            this.lowerHover = true;
        }
        this.searchBar.func_146194_f();
        this.nameBar.func_146194_f();
        if (this.result.valid) {
            if (((ContainerInscriptionTable)this.field_147002_h).slotHasStack(0)) {
                if (((ContainerInscriptionTable)this.field_147002_h).slotIsBook(0)) {
                    Minecraft.func_71410_x().field_71466_p.func_78279_b(I18n.func_74838_a((String)"am2.gui.bookOut"), 225, 5, 100, 0xFF7700);
                } else {
                    this.resetSpellButton.field_146125_m = true;
                }
            } else {
                this.resetSpellButton.field_146125_m = false;
            }
            this.createSpellButton.field_146124_l = true;
        } else {
            this.resetSpellButton.field_146125_m = ((ContainerInscriptionTable)this.field_147002_h).slotHasStack(0) && !((ContainerInscriptionTable)this.field_147002_h).slotIsBook(0);
            Minecraft.func_71410_x().field_71466_p.func_78279_b(this.result.message, 225, 5, 100, 0xFF7700);
            this.createSpellButton.field_146124_l = false;
        }
        if (!this.dragging) {
            if (hovering) {
                this.drawHoveringText(label, this.lastMouseX, this.lastMouseY, Minecraft.func_71410_x().field_71466_p);
            } else {
                this.hoveredItem = null;
                this.hoveredIcon = null;
            }
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawDraggedItem();
        }
    }

    private void drawBookIcon() {
        int bookX = this.field_147002_h.func_75139_a((int)0).field_75223_e;
        int bookY = this.field_147002_h.func_75139_a((int)0).field_75221_f;
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178082_a(Items.field_151099_bA);
        if (AMGuiHelper.instance.getFastTicker() < 20) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
        }
        AMGuiHelper.DrawIconAtXY(icon, (float)bookX, (float)bookY, this.field_73735_i, 16, 16, true);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private boolean drawCurrentRecipe(ArrayList<String> labelText, int l, int i1) {
        int i;
        this.iconX = this.IIconXStart_lower;
        this.iconY = this.IIconYStart_lower;
        boolean hovering = false;
        int index = 0;
        for (i = 0; i < ((ContainerInscriptionTable)this.field_147002_h).getCurrentRecipeSize(); ++i) {
            AbstractSpellPart part = ((ContainerInscriptionTable)this.field_147002_h).getRecipeItemAt(i);
            if (part == new MissingShape()) continue;
            String name = SpellRegistry.getSkillFromPart(part).getName();
            if (this.drawIcon(part, false)) {
                labelText.add(name);
                hovering = true;
                this.lowerHoverIndex = index;
                this.lowerHoverShapeGroup = -1;
            }
            ++index;
        }
        for (i = 0; i < ((ContainerInscriptionTable)this.field_147002_h).getNumStageGroups(); ++i) {
            for (int n = 0; n < ((ContainerInscriptionTable)this.field_147002_h).getShapeGroupSize(i); ++n) {
                AbstractSpellPart part = ((ContainerInscriptionTable)this.field_147002_h).getShapeGroupPartAt(i, n);
                String name = SpellRegistry.getSkillFromPart(part).getName();
                int SGX = this.shapeGroupX + (this.shapeGroupWidth + this.shapeGroupPadding) * i + 1;
                int SGY = this.shapeGroupY;
                this.iconX = SGX + n % 2 * this.IIconStep;
                this.iconY = SGY + (int)Math.floor(n / 2) * this.IIconStep;
                if (!this.drawIcon(part, false)) continue;
                labelText.add(name);
                hovering = true;
                this.lowerHoverIndex = n;
                this.lowerHoverShapeGroup = i;
            }
        }
        return hovering;
    }

    private boolean drawAvailableParts(ArrayList<String> labelText) {
        this.iconX = this.IIconXStart_upper;
        this.iconY = this.IIconYStart_upper;
        boolean b = this.drawPartIcons(labelText);
        return b;
    }

    private boolean drawPartIcons(ArrayList<String> labelText) {
        boolean hovering = false;
        hovering |= this.drawIconSet(this.knownShapes, labelText);
        hovering |= this.drawIconSet(this.knownComponents, labelText);
        return hovering |= this.drawIconSet(this.knownModifiers, labelText);
    }

    private boolean drawIconSet(ArrayList<String> ids, ArrayList<String> labelText) {
        boolean hovering = false;
        for (String i : ids) {
            Skill part = SkillRegistry.getSkillFromName(i);
            if (part == null || ArsMagicaAPI.getSpellRegistry().getValue(part.getRegistryName()) == null) continue;
            String name = part.getName();
            String filterText = this.searchBar.func_146179_b().toLowerCase();
            if (filterText != "" && !filterText.equals(this.defaultSearchLabel.toLowerCase()) && !name.toLowerCase().contains(filterText)) continue;
            if (this.iconY < 0 || this.iconY > 42) {
                return hovering;
            }
            if (!this.drawIcon((AbstractSpellPart)ArsMagicaAPI.getSpellRegistry().getValue(part.getRegistryName()))) continue;
            hovering = true;
            labelText.add(name);
        }
        return hovering;
    }

    private boolean spellPartIsValidAddition(AbstractSpellPart part) {
        boolean hasShape = false;
        block0: for (int i = 0; i < ((ContainerInscriptionTable)this.field_147002_h).getNumStageGroups(); ++i) {
            for (int n = 0; n < ((ContainerInscriptionTable)this.field_147002_h).getShapeGroupSize(i); ++n) {
                AbstractSpellPart groupPart = ((ContainerInscriptionTable)this.field_147002_h).getShapeGroupPartAt(i, n);
                if (!(groupPart instanceof SpellShape)) continue;
                hasShape = true;
                continue block0;
            }
        }
        if (!hasShape && !(part instanceof SpellShape)) {
            return false;
        }
        if (part instanceof SpellShape && ((ContainerInscriptionTable)this.field_147002_h).currentRecipeContains(part)) {
            return false;
        }
        if (part instanceof SpellComponent) {
            int index = ((ContainerInscriptionTable)this.field_147002_h).getCurrentRecipeSize() - 1;
            while (index >= 0 && !(((ContainerInscriptionTable)this.field_147002_h).getRecipeItemAt(index) instanceof SpellShape)) {
                AbstractSpellPart curPart;
                if (!((curPart = ((ContainerInscriptionTable)this.field_147002_h).getRecipeItemAt(index--)) instanceof SpellComponent) || SpellRegistry.getSkillFromPart(curPart).getID() != SpellRegistry.getSkillFromPart(part).getID()) continue;
                return false;
            }
        }
        if (part instanceof SpellModifier) {
            return ((ContainerInscriptionTable)this.field_147002_h).modifierCanBeAdded((SpellModifier)part);
        }
        return true;
    }

    private boolean drawIcon(AbstractSpellPart part) {
        return this.drawIcon(part, true);
    }

    private boolean drawIcon(AbstractSpellPart part, boolean allowDarken) {
        boolean hovering = false;
        TextureAtlasSprite shapeIcon = SpellIconManager.INSTANCE.getSprite(SpellRegistry.getSkillFromPart(part).getID());
        if (shapeIcon == null) {
            return false;
        }
        if (!this.currentSpellDefIsReadOnly()) {
            if (!this.spellPartIsValidAddition(part) && allowDarken) {
                GL11.glColor3f((float)0.3f, (float)0.3f, (float)0.3f);
            } else {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
        } else {
            GL11.glColor3f((float)1.0f, (float)0.7f, (float)0.7f);
        }
        AMGuiHelper.DrawIconAtXY(shapeIcon, (float)this.iconX, (float)this.iconY, this.field_73735_i, 16, 16, false);
        if (!this.dragging && this.lastMouseX > this.iconX && this.lastMouseX < this.iconX + 16 && this.lastMouseY > this.iconY && this.lastMouseY < this.iconY + 16) {
            this.hoveredItem = part;
            this.hoveredIcon = shapeIcon;
            hovering = true;
        }
        this.iconX += this.IIconStep;
        if (this.iconX >= 175) {
            this.iconX = this.IIconXStart_upper;
            this.iconY += 17;
        }
        return hovering;
    }

    private void drawDraggedItem() {
        AMGuiHelper.DrawIconAtXY(this.hoveredIcon, (float)(this.lastMouseX - 8), (float)(this.lastMouseY - 8), this.field_73735_i, 16, 16, false);
    }

    protected void drawHoveringText(List<String> par1List, int par2, int par3, FontRenderer font) {
        if (!par1List.isEmpty()) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String s : par1List) {
                int l = font.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int i1 = par2 + 12;
            int j1 = par3 - 12;
            int k1 = 8;
            if (par1List.size() > 1) {
                k1 += 2 + (par1List.size() - 1) * 10;
            }
            if (i1 + k > this.field_146294_l) {
                i1 -= 28 + k;
            }
            if (j1 + k1 + 6 > this.field_146295_m) {
                j1 = this.field_146295_m - k1 - 6;
            }
            this.field_73735_i = 300.0f;
            int l1 = -267386864;
            this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < par1List.size(); ++k2) {
                String s1 = par1List.get(k2);
                font.func_175063_a(s1, (float)i1, (float)j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            this.field_73735_i = 0.0f;
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74519_b();
            GL11.glEnable((int)32826);
        }
    }

    private boolean currentSpellDefIsReadOnly() {
        return ((ContainerInscriptionTable)this.field_147002_h).currentSpellDefIsReadOnly();
    }
}

