/*
 * Decompiled with CFR 0.152.
 */
package am2.gui;

import am2.ArsMagica2;
import am2.api.IBoundItem;
import am2.api.SpellRegistry;
import am2.api.affinity.Affinity;
import am2.api.math.AMVector2;
import am2.api.spell.AbstractSpellPart;
import am2.armor.ArmorHelper;
import am2.blocks.BlockManaBattery;
import am2.commands.ConfigureAMUICommand;
import am2.defs.ItemDefs;
import am2.extensions.AffinityData;
import am2.extensions.EntityExtension;
import am2.gui.AMGuiHelper;
import am2.gui.AMGuiIcons;
import am2.gui.GuiHudCustomization;
import am2.items.ItemSpellBook;
import am2.power.PowerTypes;
import am2.spell.ContingencyType;
import am2.texture.SpellIconManager;
import am2.utils.AffinityShiftUtils;
import am2.utils.SpellUtils;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AMIngameGUI
extends Gui {
    private final Minecraft mc = Minecraft.func_71410_x();
    private float zLevel;
    private static final short MANA_BAR_FLASH_SLOT = 4;
    private static final ResourceLocation mc_gui = new ResourceLocation("textures/gui/icons.png");
    private static final ResourceLocation spellbook_ui = new ResourceLocation("arsmagica2", "textures/gui/spellbook_ui.png");

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderGameOverlay(RenderGameOverlayEvent.Post e) {
        if (e.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        if (this.mc.field_71462_r instanceof GuiHudCustomization || this.mc.field_71415_G) {
            ItemStack item;
            ItemStack ci = Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
            boolean drawAMHud = !ArsMagica2.config.showHudMinimally() || ci != null && (ci.func_77973_b() == ItemDefs.spellBook || ci.func_77973_b() == ItemDefs.spell || ci.func_77973_b() == ItemDefs.arcaneSpellbook || ci.func_77973_b() instanceof IBoundItem);
            ScaledResolution scaledresolution = new ScaledResolution(this.mc);
            int i = scaledresolution.func_78326_a();
            int j = scaledresolution.func_78328_b();
            GlStateManager.func_179123_a();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            if (drawAMHud) {
                this.RenderContingency(i, j);
            }
            if (drawAMHud) {
                this.RenderArsMagicaGUIItems(i, j, this.mc.field_71466_p);
            }
            if (drawAMHud) {
                this.RenderAffinity(i, j);
            }
            this.RenderArmorStatus(i, j, this.mc, this.mc.field_71466_p);
            if (drawAMHud) {
                this.RenderMagicXP(i, j);
            }
            if ((item = this.mc.field_71439_g.func_184586_b(EnumHand.MAIN_HAND)) != null && item.func_77973_b() instanceof ItemSpellBook) {
                this.RenderSpellBookUI(i, j, this.mc.field_71466_p, this.mc.field_71439_g.func_184586_b(EnumHand.MAIN_HAND));
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179099_b();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_DST_ALPHA);
            GlStateManager.func_179126_j();
            GlStateManager.func_179118_c();
            GlStateManager.func_179117_G();
            ConfigureAMUICommand.showIfQueued();
        }
    }

    private void RenderArsMagicaGUIItems(int i, int j, FontRenderer fontRenderer) {
        if (EntityExtension.For((EntityLivingBase)this.mc.field_71439_g).getCurrentLevel() > 0 || this.mc.field_71439_g.field_71075_bZ.field_75098_d) {
            this.RenderManaBar(i, j, fontRenderer);
        }
    }

    private void RenderSpellBookUI(int i, int j, FontRenderer fontrenderer, ItemStack bookStack) {
        this.mc.field_71446_o.func_110577_a(spellbook_ui);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AMVector2 spellbookVec = this.getShiftedVector(ArsMagica2.config.getSpellBookPosition(), i, j);
        int spellUI_x = spellbookVec.iX;
        int spellUI_y = spellbookVec.iY;
        int spellUI_width = 148;
        int spellUI_height = 22;
        float activeSpellSize = 15.0f;
        int bookActiveSlot = ((ItemSpellBook)bookStack.func_77973_b()).GetActiveSlot(bookStack);
        float x = (float)spellUI_x + (float)bookActiveSlot * 12.9f;
        float y = spellUI_y;
        this.zLevel = -5.0f;
        this.drawTexturedModalRect_Classic(spellUI_x, spellUI_y, 0.0f, 0.0f, 106.0f, 15.0f, spellUI_width, spellUI_height);
        ItemStack[] activeScrolls = ((ItemSpellBook)bookStack.func_77973_b()).getActiveScrollInventory(bookStack);
        Minecraft.func_71410_x().func_147117_R();
        this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.zLevel = 0.0f;
        for (int n = 0; n < 8; ++n) {
            float IIconX = (float)spellUI_x + 1.5f + (float)n * 12.9f;
            ItemStack stackItem = activeScrolls[n];
            if (stackItem == null) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)IIconX, (double)((double)spellUI_y + 1.5), (double)this.zLevel);
            GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
            Minecraft.func_71410_x().func_175599_af().func_175042_a(stackItem, 0, 0);
            GlStateManager.func_179121_F();
        }
        this.mc.field_71446_o.func_110577_a(spellbook_ui);
        this.zLevel = 1000.0f;
        this.drawTexturedModalRect_Classic(x, y, 148.0f, 0.0f, activeSpellSize, activeSpellSize, 20.0f, 20.0f);
        this.zLevel = 0.0f;
        this.mc.field_71446_o.func_110577_a(mc_gui);
    }

    private void RenderManaBar(int i, int j, FontRenderer fontRendererObj) {
        ItemStack curItem;
        boolean hasOverloadMana;
        int barWidth = i / 8;
        AMVector2 Burnout_hud = this.getShiftedVector(ArsMagica2.config.getBurnoutHudPosition(), i, j);
        AMVector2 mana_hud = this.getShiftedVector(ArsMagica2.config.getManaHudPosition(), i, j);
        float green = 0.5f;
        float blue = 1.0f;
        float red = 0.126f;
        EntityExtension props = EntityExtension.For((EntityLivingBase)this.mc.field_71439_g);
        float mana = props.getCurrentMana();
        float bonusMana = props.getBonusCurrentMana();
        float maxMana = props.getMaxMana();
        float BurnoutBarWidth = barWidth;
        float Burnout = props.getCurrentBurnout();
        float maxBurnout = props.getMaxBurnout();
        float renderMana = mana + bonusMana;
        if (renderMana > maxMana) {
            renderMana = maxMana;
        }
        float progressScaled = renderMana / (maxMana + 0.01f);
        boolean hasBonusMana = bonusMana > 0.0f;
        boolean bl = hasOverloadMana = mana > maxMana + 1.0f;
        if (ArsMagica2.config.showHudBars()) {
            float flashTimer = AMGuiHelper.instance.getFlashTimer(4);
            if (flashTimer > 0.0f) {
                float pct;
                green = 0.0f;
                float redShift = 1.0f - red;
                float halfFlash = AMGuiHelper.instance.flashDuration / 2;
                if (flashTimer > halfFlash) {
                    pct = (flashTimer - halfFlash) / halfFlash;
                    red += redShift - redShift * pct;
                } else {
                    pct = flashTimer / halfFlash;
                    red += redShift * pct;
                }
                GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
            } else if (hasBonusMana) {
                GlStateManager.func_179124_c((float)0.2f, (float)0.9f, (float)0.6f);
            } else if (hasOverloadMana) {
                GlStateManager.func_179124_c((float)1.0f, (float)0.0f, (float)0.0f);
            }
            curItem = Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
            if (curItem != null && (curItem.func_77973_b() == ItemDefs.spell || curItem.func_77973_b() == ItemDefs.spellBook || curItem.func_77973_b() == ItemDefs.arcaneSpellbook)) {
                ItemStack spellStack;
                ItemStack itemStack = spellStack = curItem.func_77973_b() == ItemDefs.spell ? curItem : ((ItemSpellBook)curItem.func_77973_b()).GetActiveItemStack(curItem);
                if (spellStack != null) {
                    ArrayList<AbstractSpellPart> parts = SpellUtils.getPartsForGroup(spellStack, 0);
                    int sx = mana_hud.iX - 2 * parts.size() / 2;
                    int sy = mana_hud.iY - 2 * parts.size() / 2;
                    for (AbstractSpellPart p : parts) {
                        TextureAtlasSprite icon = SpellIconManager.INSTANCE.getSprite(SpellRegistry.getSkillFromPart(p).getID());
                        if (icon == null) continue;
                        this.DrawIconAtXY(icon, "items", sx, sy, false);
                        sx += 3;
                        sy += 3;
                    }
                }
            }
            this.DrawPartialIconAtXY(AMGuiIcons.manaLevel, progressScaled, 1.0f, mana_hud.iX + 16, (float)mana_hud.iY + 1.0f, (int)((float)barWidth * 0.99f), 40.0f, false);
            this.DrawIconAtXY(AMGuiIcons.manaBar, "items", mana_hud.iX + 15, mana_hud.iY + 3, barWidth, 50, false);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            progressScaled = Burnout / (maxBurnout + 0.01f);
            this.DrawIconAtXY(AMGuiIcons.fatigueIcon, "items", Burnout_hud.iX + barWidth, Burnout_hud.iY, false);
            this.DrawPartialIconAtXY(AMGuiIcons.fatigueLevel, progressScaled, 1.0f, Burnout_hud.iX, (float)Burnout_hud.iY + 3.0f, BurnoutBarWidth, 40.0f, false);
            this.DrawIconAtXY(AMGuiIcons.fatigueBar, "items", Burnout_hud.iX, Burnout_hud.iY + 4, barWidth, 48, false);
            green = 0.5f;
            blue = 1.0f;
            red = 0.126f;
            int manaBarColor = Math.round(red * 255.0f);
            manaBarColor = (manaBarColor << 8) + Math.round(green * 255.0f);
            manaBarColor = (manaBarColor << 8) + Math.round(blue * 255.0f);
            String magicLevel = "" + EntityExtension.For((EntityLivingBase)this.mc.field_71439_g).getCurrentLevel();
            AMVector2 magicLevelPos = this.getShiftedVector(ArsMagica2.config.getLevelPosition(), i, j);
            magicLevelPos.iX -= Minecraft.func_71410_x().field_71466_p.func_78256_a(magicLevel) / 2;
            fontRendererObj.func_175063_a(magicLevel, (float)magicLevelPos.iX, (float)magicLevelPos.iY, manaBarColor);
            if (flashTimer > 0.0f) {
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        if (ArsMagica2.config.getShowNumerics()) {
            GlStateManager.func_179147_l();
            String spellcost = "";
            curItem = Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
            if (curItem != null && (curItem.func_77973_b() == ItemDefs.spell || curItem.func_77973_b() == ItemDefs.spellBook || curItem.func_77973_b() == ItemDefs.arcaneSpellbook)) {
                ItemStack spellStack;
                ItemStack itemStack = spellStack = curItem.func_77973_b() == ItemDefs.spell ? curItem : ((ItemSpellBook)curItem.func_77973_b()).GetActiveItemStack(curItem);
                if (spellStack != null) {
                    float manaCost = SpellUtils.getManaCost(spellStack, (Entity)Minecraft.func_71410_x().field_71439_g) * (1.0f + EntityExtension.For((EntityLivingBase)Minecraft.func_71410_x().field_71439_g).getCurrentBurnout() / EntityExtension.For((EntityLivingBase)Minecraft.func_71410_x().field_71439_g).getMaxBurnout());
                    spellcost = (EntityExtension.For((EntityLivingBase)Minecraft.func_71410_x().field_71439_g).hasEnoughtMana(manaCost) ? ChatFormatting.AQUA.toString() : ChatFormatting.DARK_RED.toString()) + " (" + (int)manaCost + ")";
                    spellcost = spellcost + ChatFormatting.RESET.toString();
                }
            }
            String manaStr = I18n.func_74838_a((String)"am2.gui.mana") + ": " + (int)(mana + bonusMana) + "/" + (int)maxMana + spellcost;
            String burnoutStr = I18n.func_74838_a((String)"am2.gui.burnout") + ": " + (int)props.getCurrentBurnout() + "/" + (int)props.getMaxBurnout();
            AMVector2 manaNumericPos = this.getShiftedVector(ArsMagica2.config.getManaNumericPosition(), i, j);
            AMVector2 burnoutNumericPos = this.getShiftedVector(ArsMagica2.config.getBurnoutNumericPosition(), i, j);
            fontRendererObj.func_78276_b(manaStr, manaNumericPos.iX, manaNumericPos.iY, hasBonusMana ? 15393564 : (hasOverloadMana ? 0xFF2020 : 2130175));
            fontRendererObj.func_78276_b(burnoutStr, burnoutNumericPos.iX + 25 - fontRendererObj.func_78256_a(burnoutStr), burnoutNumericPos.iY, 0xFF2020);
        }
    }

    private void RenderArmorStatus(int i, int j, Minecraft mc, FontRenderer fontRenderer) {
        if (!ArsMagica2.config.showArmorUI()) {
            return;
        }
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        for (int slot = 0; slot < 4; ++slot) {
            float pct;
            if (!ArmorHelper.PlayerHasArmorInSlot((EntityPlayer)mc.field_71439_g, EntityEquipmentSlot.values()[5 - slot])) continue;
            AMVector2 position = this.getArmorSlotPosition(slot, scaledResolution.func_78326_a(), scaledResolution.func_78328_b());
            int blackoutTimer = AMGuiHelper.instance.getBlackoutTimer(3 - slot);
            int blackoutMaxTimer = AMGuiHelper.instance.getBlackoutTimerMax(3 - slot);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            ItemStack armor = mc.field_71439_g.field_71071_by.field_70460_b[3 - slot];
            float lineweight = 4.0f;
            if (armor.func_77951_h() && armor.func_77958_k() > 0) {
                pct = 1.0f - (float)armor.func_77952_i() / (float)armor.func_77958_k();
                AMGuiHelper.line2d(position.iX, position.iY + 10, position.iX + 10, position.iY + 10, this.zLevel + 100.0f, lineweight, 0);
                int color = (int)(255.0f * (1.0f - pct)) << 16 | (int)(255.0f * pct) << 8;
                AMGuiHelper.line2d(position.iX, position.iY + 10, (float)position.iX + 10.0f * pct, position.iY + 10, this.zLevel + 101.0f, lineweight, color);
            }
            if (blackoutMaxTimer > 0) {
                pct = (float)(blackoutMaxTimer - blackoutTimer) / (float)blackoutMaxTimer;
                AMGuiHelper.line2d(position.iX, position.iY + 11, position.iX + 10, position.iY + 11, this.zLevel + 100.0f, lineweight, 0);
                AMGuiHelper.line2d(position.iX, position.iY + 11, (float)position.iX + 10.0f * pct, position.iY + 11, this.zLevel + 101.0f, lineweight, 0xFF0000);
            } else {
                AMGuiHelper.line2d(position.iX, position.iY + 11, position.iX + 10, position.iY + 11, this.zLevel + 101.0f, lineweight, 255);
            }
            float green = 0.5f;
            float blue = 1.0f;
            float red = 0.126f;
            float flashTimer = AMGuiHelper.instance.getFlashTimer(3 - slot);
            if (flashTimer > 0.0f) {
                float pct2;
                green = 0.0f;
                float redShift = 1.0f - red;
                float halfFlash = AMGuiHelper.instance.flashDuration / 2;
                if (flashTimer > halfFlash) {
                    pct2 = (flashTimer - halfFlash) / halfFlash;
                    red += redShift - redShift * pct2;
                } else {
                    pct2 = flashTimer / halfFlash;
                    red += redShift * pct2;
                }
                GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
            }
            GlStateManager.func_179094_E();
            AMGuiHelper.DrawItemAtXY(mc.field_71439_g.field_71071_by.field_70460_b[3 - slot], position.iX, position.iY, this.zLevel, 0.63f);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(new ResourceLocation("arsmagica2", "textures/gui/overlay.png"));
        AMVector2 shieldPos = this.getShiftedVector(ArsMagica2.config.getManaShieldingPosition(), scaledResolution.func_78326_a(), scaledResolution.func_78328_b());
        int shielding = (int)EntityExtension.For((EntityLivingBase)mc.field_71439_g).getManaShielding();
        if (shielding <= 20) {
            int iter;
            for (iter = 0; iter < shielding; iter += 2) {
                this.func_73729_b(shieldPos.iX + iter * 8 / 2, shieldPos.iY, 0, 0, 9, 9);
            }
            for (iter = 0; iter < shielding; iter += 2) {
                boolean half = iter + 2 > shielding && (shielding & 1) == 1;
                this.func_73729_b(shieldPos.iX + iter * 8 / 2, shieldPos.iY, half ? 18 : 9, 0, 9, 9);
            }
        } else {
            this.func_73729_b(shieldPos.iX, shieldPos.iY, 0, 0, 9, 9);
            this.func_73729_b(shieldPos.iX, shieldPos.iY, 18, 0, 9, 9);
            mc.field_71466_p.func_78276_b("x" + shielding, shieldPos.iX + 10, shieldPos.iY, 31487);
        }
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
    }

    private AMVector2 getArmorSlotPosition(int slot, int screenWidth, int screenHeight) {
        switch (slot) {
            case 0: {
                return this.getShiftedVector(ArsMagica2.config.getArmorPositionHead(), screenWidth, screenHeight);
            }
            case 1: {
                return this.getShiftedVector(ArsMagica2.config.getArmorPositionChest(), screenWidth, screenHeight);
            }
            case 2: {
                return this.getShiftedVector(ArsMagica2.config.getArmorPositionLegs(), screenWidth, screenHeight);
            }
            case 3: {
                return this.getShiftedVector(ArsMagica2.config.getArmorPositionBoots(), screenWidth, screenHeight);
            }
        }
        return new AMVector2(0.0, 0.0);
    }

    public void RenderAffinity(int i, int j) {
        AMVector2 affinityPos = this.getShiftedVector(ArsMagica2.config.getAffinityPosition(), i, j);
        int x = affinityPos.iX;
        int y = affinityPos.iY;
        AffinityData ad = AffinityData.For((EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
        for (Affinity affinity : ad.getHighestAffinities()) {
            if (affinity == null || affinity == Affinity.NONE) continue;
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            AMGuiHelper.DrawIconAtXY(this.mc.func_175599_af().func_175037_a().func_178087_a((Item)ItemDefs.essence, AffinityShiftUtils.getEssenceForAffinity(affinity).func_77952_i()), (float)x, (float)y, (float)j, 12, 12, true);
            if (ArsMagica2.config.getShowNumerics()) {
                GlStateManager.func_179147_l();
                String display = String.format("%.2f%%", AffinityData.For((EntityLivingBase)this.mc.field_71439_g).getAffinityDepth(affinity) * 100.0);
                if (x < i / 2) {
                    Minecraft.func_71410_x().field_71466_p.func_78276_b(display, x + 14, y + 2, affinity.getColor());
                } else {
                    Minecraft.func_71410_x().field_71466_p.func_78276_b(display, x - 2 - Minecraft.func_71410_x().field_71466_p.func_78256_a(display), y + 2, affinity.getColor());
                }
            }
            y += 15;
        }
    }

    public void RenderContingency(int i, int j) {
        AMVector2 contingencyPos = this.getShiftedVector(ArsMagica2.config.getContingencyPosition(), i, j);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        TextureAtlasSprite icon = null;
        ContingencyType type = EntityExtension.For((EntityLivingBase)Minecraft.func_71410_x().field_71439_g).getContingencyType();
        switch (type) {
            case DAMAGE: {
                icon = SpellIconManager.INSTANCE.getSprite("arsmagica2:contingency_damage");
                break;
            }
            case FALL: {
                icon = SpellIconManager.INSTANCE.getSprite("arsmagica2:contingency_fall");
                break;
            }
            case HEALTH: {
                icon = SpellIconManager.INSTANCE.getSprite("arsmagica2:contingency_health");
                break;
            }
            case FIRE: {
                icon = SpellIconManager.INSTANCE.getSprite("arsmagica2:contingency_fire");
                break;
            }
            case DEATH: {
                icon = SpellIconManager.INSTANCE.getSprite("arsmagica2:contingency_death");
                break;
            }
            default: {
                return;
            }
        }
        this.DrawIconAtXY(icon, "items", contingencyPos.iX, contingencyPos.iY, 16, 16, true);
    }

    public void RenderMagicXP(int i, int j) {
        EntityExtension props = EntityExtension.For((EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
        if (props.getCurrentLevel() > 0) {
            GlStateManager.func_179147_l();
            AMVector2 position = this.getShiftedVector(ArsMagica2.config.getXPBarPosition(), i, j);
            AMVector2 dimensions = new AMVector2(182.0, 5.0);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(mc_gui);
            GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)1.0f, (float)(ArsMagica2.config.showXPAlways() ? 1.0f : AMGuiHelper.instance.getMagicXPBarAlpha()));
            this.drawTexturedModalRect_Classic(position.iX, position.iY, 0.0f, 64.0f, dimensions.iX, dimensions.iY, dimensions.iX, dimensions.iY);
            if (props.getCurrentXP() > 0.0f) {
                float pctXP = props.getCurrentXP() / props.getMaxXP();
                if (pctXP > 1.0f) {
                    pctXP = 1.0f;
                }
                int width = (int)((float)(dimensions.iX + 1) * pctXP);
                this.drawTexturedModalRect_Classic(position.iX, position.iY, 0.0f, 69.0f, width, dimensions.iY, width, dimensions.iY);
            }
            if (ArsMagica2.config.getShowNumerics() && (ArsMagica2.config.showXPAlways() || AMGuiHelper.instance.getMagicXPBarAlpha() > 0.0f)) {
                String xpStr = I18n.func_74838_a((String)"am2.gui.xp") + ": " + (int)(props.getCurrentXP() * 100.0f) + "/" + (int)(props.getMaxXP() * 100.0f);
                AMVector2 numericPos = this.getShiftedVector(ArsMagica2.config.getXPNumericPosition(), i, j);
                Minecraft.func_71410_x().field_71466_p.func_78276_b(xpStr, numericPos.iX, numericPos.iY, 0x999999);
            }
        }
    }

    public void drawTexturedModalRect_Classic(int par1, int par2, int par3, int par4, int par5, int par6) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator var9 = Tessellator.func_178181_a();
        var9.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        var9.func_178180_c().func_181662_b((double)(par1 + 0), (double)(par2 + par6), (double)this.zLevel).func_187315_a((double)((float)(par3 + 0) * var7), (double)((float)(par4 + par6) * var8)).func_181675_d();
        var9.func_178180_c().func_181662_b((double)(par1 + par5), (double)(par2 + par6), (double)this.zLevel).func_187315_a((double)((float)(par3 + par5) * var7), (double)((float)(par4 + par6) * var8)).func_181675_d();
        var9.func_178180_c().func_181662_b((double)(par1 + par5), (double)(par2 + 0), (double)this.zLevel).func_187315_a((double)((float)(par3 + par5) * var7), (double)((float)(par4 + 0) * var8)).func_181675_d();
        var9.func_178180_c().func_181662_b((double)(par1 + 0), (double)(par2 + 0), (double)this.zLevel).func_187315_a((double)((float)(par3 + 0) * var7), (double)((float)(par4 + 0) * var8)).func_181675_d();
        var9.func_78381_a();
    }

    public void drawTexturedModalRect_Classic(float dst_x, float dst_y, float src_x, float src_y, float dst_width, float dst_height, float src_width, float src_height) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator var9 = Tessellator.func_178181_a();
        var9.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        var9.func_178180_c().func_181662_b((double)(dst_x + 0.0f), (double)(dst_y + dst_height), (double)this.zLevel).func_187315_a((double)((src_x + 0.0f) * var7), (double)((src_y + src_height) * var8)).func_181675_d();
        var9.func_178180_c().func_181662_b((double)(dst_x + dst_width), (double)(dst_y + dst_height), (double)this.zLevel).func_187315_a((double)((src_x + src_width) * var7), (double)((src_y + src_height) * var8)).func_181675_d();
        var9.func_178180_c().func_181662_b((double)(dst_x + dst_width), (double)(dst_y + 0.0f), (double)this.zLevel).func_187315_a((double)((src_x + src_width) * var7), (double)((src_y + 0.0f) * var8)).func_181675_d();
        var9.func_178180_c().func_181662_b((double)(dst_x + 0.0f), (double)(dst_y + 0.0f), (double)this.zLevel).func_187315_a((double)((src_x + 0.0f) * var7), (double)((src_y + 0.0f) * var8)).func_181675_d();
        var9.func_78381_a();
    }

    public void func_73729_b(int par1, int par2, int par3, int par4, int par5, int par6) {
        float f = 0.00390625f;
        float var9 = (float)par3 * f;
        float var10 = (float)(par3 + par5) * f;
        float var11 = (float)par4 * f;
        float var12 = (float)(par4 + par5) * f;
        Tessellator var8 = Tessellator.func_178181_a();
        var8.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181710_j);
        var8.func_178180_c().func_181662_b((double)(par1 + 0), (double)(par2 + par6), (double)this.zLevel).func_187315_a((double)var9, (double)var12).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        var8.func_178180_c().func_181662_b((double)(par1 + par5), (double)(par2 + par6), (double)this.zLevel).func_187315_a((double)var10, (double)var12).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        var8.func_178180_c().func_181662_b((double)(par1 + par5), (double)(par2 + 0), (double)this.zLevel).func_187315_a((double)var10, (double)var11).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        var8.func_178180_c().func_181662_b((double)(par1 + 0), (double)(par2 + 0), (double)this.zLevel).func_187315_a((double)var9, (double)var11).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        var8.func_78381_a();
    }

    private void DrawIconAtXY(TextureAtlasSprite icon, String base, float x, float y, boolean semitransparent) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.DrawIconAtXY(icon, base, x, y, 16, 16, semitransparent);
    }

    private void DrawIconAtXY(TextureAtlasSprite IIcon, String base, float x, float y, int w, int h, boolean semitransparent) {
        if (IIcon == null) {
            return;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        tessellator.func_178180_c().func_181662_b((double)x, (double)(y + (float)h), (double)this.zLevel).func_187315_a((double)IIcon.func_94209_e(), (double)IIcon.func_94210_h()).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(x + (float)w), (double)(y + (float)h), (double)this.zLevel).func_187315_a((double)IIcon.func_94212_f(), (double)IIcon.func_94210_h()).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(x + (float)w), (double)y, (double)this.zLevel).func_187315_a((double)IIcon.func_94212_f(), (double)IIcon.func_94206_g()).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)x, (double)y, (double)this.zLevel).func_187315_a((double)IIcon.func_94209_e(), (double)IIcon.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    private void DrawPartialIconAtXY(TextureAtlasSprite IIcon, float pct_x, float pct_y, float x, float y, float w, float h, boolean semitransparent) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        if (IIcon == null) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        tessellator.func_178180_c().func_181662_b((double)x, (double)(y + h * pct_y), (double)this.zLevel).func_187315_a((double)IIcon.func_94209_e(), (double)IIcon.func_94210_h()).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(x + w * pct_x), (double)(y + h * pct_y), (double)this.zLevel).func_187315_a((double)IIcon.func_94212_f(), (double)IIcon.func_94210_h()).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(x + w * pct_x), (double)y, (double)this.zLevel).func_187315_a((double)IIcon.func_94212_f(), (double)IIcon.func_94206_g()).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)x, (double)y, (double)this.zLevel).func_187315_a((double)IIcon.func_94209_e(), (double)IIcon.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    private AMVector2 getShiftedVector(AMVector2 configVec, int screenWidth, int screenHeight) {
        int x = (int)Math.round(configVec.x * (double)screenWidth);
        int y = (int)Math.round(configVec.y * (double)screenHeight);
        return new AMVector2(x, y);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent e) {
        if (e.getItemStack().func_77973_b() instanceof ItemBlock && ((ItemBlock)e.getItemStack().func_77973_b()).func_179223_d() instanceof BlockManaBattery && e.getItemStack().func_77978_p() != null) {
            float charge = e.getItemStack().func_77978_p().func_74760_g("mana_battery_charge");
            PowerTypes powerType = PowerTypes.getByID(e.getItemStack().func_77978_p().func_74762_e("mana_battery_powertype"));
            e.getToolTip().add(String.format("\u00a7r\u00a79Contains \u00a75%.2f %s%s \u00a79etherium", Float.valueOf(charge), powerType.getChatColor(), powerType.name()));
        }
    }

    class PotionEffectDurationComparator
    implements Comparator<PotionEffect> {
        @Override
        public int compare(PotionEffect o1, PotionEffect o2) {
            if (o1.func_76459_b() < o2.func_76459_b()) {
                return -1;
            }
            if (o1.func_76459_b() > o2.func_76459_b()) {
                return 1;
            }
            return 0;
        }
    }
}

