/*
 * Decompiled with CFR 0.152.
 */
package am2.extensions;

import am2.ArsMagica2;
import am2.api.ArsMagicaAPI;
import am2.api.SkillPointRegistry;
import am2.api.SkillRegistry;
import am2.api.compendium.CompendiumCategory;
import am2.api.compendium.CompendiumEntry;
import am2.api.extensions.IDataSyncExtension;
import am2.api.extensions.ISkillData;
import am2.api.skill.Skill;
import am2.api.skill.SkillPoint;
import am2.api.spell.AbstractSpellPart;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifier;
import am2.api.spell.SpellShape;
import am2.extensions.DataDefinitions;
import am2.extensions.datamanager.DataSyncExtension;
import am2.lore.ArcaneCompendium;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class SkillData
implements ISkillData,
ICapabilityProvider,
ICapabilitySerializable<NBTBase> {
    private EntityPlayer player;
    public static final ResourceLocation ID = new ResourceLocation("arsmagica2:SkillData");
    @CapabilityInject(value=ISkillData.class)
    public static Capability<ISkillData> INSTANCE = null;

    public static ISkillData For(EntityLivingBase living) {
        return (ISkillData)living.getCapability(INSTANCE, null);
    }

    @Override
    public HashMap<Skill, Boolean> getSkills() {
        return DataSyncExtension.For((EntityLivingBase)this.player).get(DataDefinitions.SKILL);
    }

    @Override
    public boolean hasSkill(String name) {
        if (this.player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (ArsMagica2.disabledSkills.isSkillDisabled(name)) {
            return true;
        }
        Boolean bool = DataSyncExtension.For((EntityLivingBase)this.player).get(DataDefinitions.SKILL).get((Object)SkillRegistry.getSkillFromName(name));
        return bool == null ? false : bool;
    }

    @Override
    public void unlockSkill(String name) {
        if (SkillRegistry.getSkillFromName(name) == null) {
            return;
        }
        Skill skill = SkillRegistry.getSkillFromName(name);
        for (CompendiumEntry entry : CompendiumCategory.getAllEntries()) {
            if (ArsMagicaAPI.getSpellRegistry().getObject(skill.getRegistryName()) != null) {
                AbstractSpellPart part = (AbstractSpellPart)ArsMagicaAPI.getSpellRegistry().getObject(skill.getRegistryName());
                for (Object obj : entry.getObjects()) {
                    if (obj != part) continue;
                    ArcaneCompendium.For(this.player).unlockEntry(entry.getID());
                }
                continue;
            }
            for (Object obj : entry.getObjects()) {
                if (obj != skill) continue;
                ArcaneCompendium.For(this.player).unlockEntry(entry.getID());
            }
        }
        this.setSkillPoint(skill.getPoint(), this.getSkillPoint(skill.getPoint()) - 1);
        HashMap<Skill, Boolean> map = DataSyncExtension.For((EntityLivingBase)this.player).get(DataDefinitions.SKILL);
        map.put(skill, true);
        DataSyncExtension.For((EntityLivingBase)this.player).setWithSync(DataDefinitions.SKILL, map);
    }

    @Override
    public HashMap<SkillPoint, Integer> getSkillPoints() {
        return DataSyncExtension.For((EntityLivingBase)this.player).get(DataDefinitions.POINT_TIER);
    }

    @Override
    public int getSkillPoint(SkillPoint skill) {
        if (skill == null) {
            return 0;
        }
        Integer integer = DataSyncExtension.For((EntityLivingBase)this.player).get(DataDefinitions.POINT_TIER).get(skill);
        return integer == null ? 0 : integer;
    }

    @Override
    public void setSkillPoint(SkillPoint point, int num) {
        HashMap<SkillPoint, Integer> map = DataSyncExtension.For((EntityLivingBase)this.player).get(DataDefinitions.POINT_TIER);
        map.put(point, num);
        DataSyncExtension.For((EntityLivingBase)this.player).setWithSync(DataDefinitions.POINT_TIER, map);
    }

    public void init(EntityPlayer entity, IDataSyncExtension ext) {
        this.player = entity;
        HashMap<Skill, Boolean> skillMap = new HashMap<Skill, Boolean>();
        HashMap<SkillPoint, Integer> pointMap = new HashMap<SkillPoint, Integer>();
        for (Skill skill : ArsMagicaAPI.getSkillRegistry().getValues()) {
            skillMap.put(skill, false);
        }
        for (SkillPoint skillPoint : SkillPointRegistry.getSkillPointMap().values()) {
            pointMap.put(skillPoint, 0);
        }
        pointMap.put(SkillPoint.SKILL_POINT_1, 3);
        ext.setWithSync(DataDefinitions.SKILL, skillMap);
        ext.setWithSync(DataDefinitions.POINT_TIER, pointMap);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == INSTANCE;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == INSTANCE) {
            return (T)this;
        }
        return null;
    }

    public NBTBase serializeNBT() {
        return new ISkillData.Storage().writeNBT(INSTANCE, this, null);
    }

    public void deserializeNBT(NBTBase nbt) {
        new ISkillData.Storage().readNBT(INSTANCE, this, null, nbt);
    }

    @Override
    public boolean canLearn(String name) {
        if (SkillRegistry.getSkillFromName(name) == null) {
            return false;
        }
        if (ArsMagica2.disabledSkills.isSkillDisabled(name)) {
            return false;
        }
        for (String skill : SkillRegistry.getSkillFromName(name).getParents()) {
            Skill s = SkillRegistry.getSkillFromName(skill);
            if (s == null || this.hasSkill(skill)) continue;
            return false;
        }
        return this.getSkillPoint(SkillRegistry.getSkillFromName(name).getPoint()) > 0;
    }

    @Override
    public ArrayList<String> getKnownShapes() {
        ArrayList<String> out = new ArrayList<String>();
        for (Map.Entry<Skill, Boolean> entry : this.getSkills().entrySet()) {
            AbstractSpellPart part = (AbstractSpellPart)ArsMagicaAPI.getSpellRegistry().getValue(entry.getKey().getRegistryName());
            if (!entry.getValue().booleanValue() && !this.player.field_71075_bZ.field_75098_d || part == null || !(part instanceof SpellShape) || ArsMagica2.disabledSkills.isSkillDisabled(part.getRegistryName().toString())) continue;
            out.add(entry.getKey().getID());
        }
        out.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        return out;
    }

    @Override
    public ArrayList<String> getKnownComponents() {
        ArrayList<String> out = new ArrayList<String>();
        for (Map.Entry<Skill, Boolean> entry : this.getSkills().entrySet()) {
            AbstractSpellPart part = (AbstractSpellPart)ArsMagicaAPI.getSpellRegistry().getValue(entry.getKey().getRegistryName());
            if (!entry.getValue().booleanValue() && !this.player.field_71075_bZ.field_75098_d || part == null || !(part instanceof SpellComponent) || ArsMagica2.disabledSkills.isSkillDisabled(part.getRegistryName().toString())) continue;
            out.add(entry.getKey().getID());
        }
        out.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        return out;
    }

    @Override
    public ArrayList<String> getKnownModifiers() {
        ArrayList<String> out = new ArrayList<String>();
        for (Map.Entry<Skill, Boolean> entry : this.getSkills().entrySet()) {
            AbstractSpellPart part = (AbstractSpellPart)ArsMagicaAPI.getSpellRegistry().getValue(entry.getKey().getRegistryName());
            if (!entry.getValue().booleanValue() && !this.player.field_71075_bZ.field_75098_d || part == null || !(part instanceof SpellModifier) || ArsMagica2.disabledSkills.isSkillDisabled(part.getRegistryName().toString())) continue;
            out.add(entry.getKey().getID());
        }
        out.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        return out;
    }
}

