/*
 * Decompiled with CFR 0.152.
 */
package am2.extensions;

import am2.ArsMagica2;
import am2.api.ArsMagicaAPI;
import am2.api.event.PlayerMagicLevelChangeEvent;
import am2.api.extensions.IDataSyncExtension;
import am2.api.extensions.IEntityExtension;
import am2.api.math.AMVector2;
import am2.armor.ArmorHelper;
import am2.armor.ArsMagicaArmorMaterial;
import am2.armor.infusions.ImbuementRegistry;
import am2.bosses.EntityLifeGuardian;
import am2.defs.ItemDefs;
import am2.defs.PotionEffectsDefs;
import am2.defs.SkillDefs;
import am2.extensions.DataDefinitions;
import am2.extensions.SkillData;
import am2.extensions.datamanager.DataSyncExtension;
import am2.packet.AMDataReader;
import am2.packet.AMDataWriter;
import am2.packet.AMNetHandler;
import am2.particles.AMLineArc;
import am2.spell.ContingencyType;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityExtension
implements IEntityExtension,
ICapabilityProvider,
ICapabilitySerializable<NBTBase> {
    public static final ResourceLocation ID = new ResourceLocation("arsmagica2:ExtendedProp");
    private static int baseTicksForFullRegen = 2400;
    private int ticksForFullRegen = baseTicksForFullRegen;
    public boolean isRecoveringKeystone;
    private Entity ent;
    @CapabilityInject(value=IEntityExtension.class)
    public static Capability<IEntityExtension> INSTANCE = null;
    private ArrayList<Integer> summon_ent_ids = new ArrayList();
    private EntityLivingBase entity;
    private ArrayList<ManaLinkEntry> manaLinks = new ArrayList();
    public AMVector2 originalSize;
    public float shrinkAmount;
    public boolean astralBarrierBlocked = false;
    public float bankedInfusionHelm = 0.0f;
    public float bankedInfusionChest = 0.0f;
    public float bankedInfusionLegs = 0.0f;
    public float bankedInfusionBoots = 0.0f;
    public ArrayList<ItemStack> runningStacks = new ArrayList();

    @Override
    public boolean hasEnoughtMana(float cost) {
        return !(this.getCurrentMana() + this.getBonusCurrentMana() < cost);
    }

    @Override
    public void setContingency(ContingencyType type, ItemStack stack) {
        DataSyncExtension.For(this.entity).set(DataDefinitions.CONTENGENCY_TYPE, type.name().toLowerCase());
        DataSyncExtension.For(this.entity).set(DataDefinitions.CONTENGENCY_STACK, Optional.fromNullable((Object)stack));
    }

    @Override
    public ContingencyType getContingencyType() {
        return ContingencyType.fromName(DataSyncExtension.For(this.entity).get(DataDefinitions.CONTENGENCY_TYPE));
    }

    @Override
    public ItemStack getContingencyStack() {
        return (ItemStack)DataSyncExtension.For(this.entity).get(DataDefinitions.CONTENGENCY_STACK).orNull();
    }

    @Override
    public double getMarkX() {
        return DataSyncExtension.For(this.entity).get(DataDefinitions.MARK_X);
    }

    @Override
    public double getMarkY() {
        return DataSyncExtension.For(this.entity).get(DataDefinitions.MARK_Y);
    }

    @Override
    public double getMarkZ() {
        return DataSyncExtension.For(this.entity).get(DataDefinitions.MARK_Z);
    }

    @Override
    public int getMarkDimensionID() {
        return DataSyncExtension.For(this.entity).get(DataDefinitions.MARK_DIMENSION);
    }

    @Override
    public float getCurrentMana() {
        return DataSyncExtension.For(this.entity).get(DataDefinitions.CURRENT_MANA).floatValue();
    }

    @Override
    public int getCurrentLevel() {
        return DataSyncExtension.For(this.entity).get(DataDefinitions.CURRENT_LEVEL);
    }

    @Override
    public float getCurrentBurnout() {
        return DataSyncExtension.For(this.entity).get(DataDefinitions.CURRENT_MANA_FATIGUE).floatValue();
    }

    @Override
    public int getCurrentSummons() {
        return DataSyncExtension.For(this.entity).get(DataDefinitions.CURRENT_SUMMONS);
    }

    @Override
    public float getCurrentXP() {
        return DataSyncExtension.For(this.entity).get(DataDefinitions.CURRENT_XP).floatValue();
    }

    @Override
    public int getHealCooldown() {
        return DataSyncExtension.For(this.entity).get(DataDefinitions.HEAL_COOLDOWN);
    }

    @Override
    public void lowerHealCooldown(int amount) {
        this.setHealCooldown(Math.max(0, this.getHealCooldown() - amount));
    }

    @Override
    public void placeHealOnCooldown() {
        DataSyncExtension.For(this.entity).set(DataDefinitions.HEAL_COOLDOWN, 40);
    }

    @Override
    public void lowerAffinityHealCooldown(int amount) {
        this.setAffinityHealCooldown(Math.max(0, this.getAffinityHealCooldown() - amount));
    }

    @Override
    public int getAffinityHealCooldown() {
        return DataSyncExtension.For(this.entity).get(DataDefinitions.AFFINITY_HEAL_COOLDOWN);
    }

    @Override
    public void placeAffinityHealOnCooldown(boolean full) {
        DataSyncExtension.For(this.entity).set(DataDefinitions.AFFINITY_HEAL_COOLDOWN, 40);
    }

    @Override
    public float getMaxMana() {
        float mana = (float)(Math.pow(this.getCurrentLevel(), 1.5) * (double)(85.0f * ((float)this.getCurrentLevel() / 100.0f)) + 500.0);
        if (this.entity.func_70644_a(PotionEffectsDefs.manaBoost)) {
            mana = (float)((double)mana * (1.0 + 0.25 * (double)(this.entity.func_70660_b(PotionEffectsDefs.manaBoost).func_76458_c() + 1)));
        }
        return (float)((double)mana + this.entity.func_110140_aT().func_111151_a(ArsMagicaAPI.maxManaBonus).func_111126_e());
    }

    @Override
    public float getMaxXP() {
        return (float)Math.pow((float)this.getCurrentLevel() * 0.25f, 1.5);
    }

    @Override
    public float getMaxBurnout() {
        return this.getCurrentLevel() * 10 + 1;
    }

    @Override
    public void setAffinityHealCooldown(int affinityHealCooldown) {
        DataSyncExtension.For(this.entity).set(DataDefinitions.AFFINITY_HEAL_COOLDOWN, affinityHealCooldown);
    }

    @Override
    public void setCurrentBurnout(float currentBurnout) {
        DataSyncExtension.For(this.entity).set(DataDefinitions.CURRENT_MANA_FATIGUE, Float.valueOf(currentBurnout));
    }

    @Override
    public void setCurrentLevel(int currentLevel) {
        this.ticksForFullRegen = (int)Math.round((double)baseTicksForFullRegen * (0.75 - 0.25 * (double)((float)this.getCurrentLevel() / 99.0f)));
        if (this.entity instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new PlayerMagicLevelChangeEvent((EntityPlayer)this.entity, currentLevel));
        }
        DataSyncExtension.For(this.entity).set(DataDefinitions.CURRENT_LEVEL, currentLevel);
    }

    @Override
    public void setCurrentMana(float currentMana) {
        DataSyncExtension.For(this.entity).set(DataDefinitions.CURRENT_MANA, Float.valueOf(currentMana));
    }

    @Override
    public void setCurrentSummons(int currentSummons) {
        DataSyncExtension.For(this.entity).set(DataDefinitions.CURRENT_SUMMONS, currentSummons);
    }

    @Override
    public void setCurrentXP(float currentXP) {
        while (currentXP >= this.getMaxXP()) {
            currentXP -= this.getMaxXP();
            this.setMagicLevelWithMana(this.getCurrentLevel() + 1);
        }
        DataSyncExtension.For(this.entity).set(DataDefinitions.CURRENT_XP, Float.valueOf(currentXP));
    }

    @Override
    public void setHealCooldown(int healCooldown) {
        DataSyncExtension.For(this.entity).set(DataDefinitions.HEAL_COOLDOWN, healCooldown);
    }

    @Override
    public void setMarkX(double markX) {
        DataSyncExtension.For(this.entity).set(DataDefinitions.MARK_X, markX);
    }

    @Override
    public void setMarkY(double markY) {
        DataSyncExtension.For(this.entity).set(DataDefinitions.MARK_Y, markY);
    }

    @Override
    public void setMarkZ(double markZ) {
        DataSyncExtension.For(this.entity).set(DataDefinitions.MARK_Z, markZ);
    }

    @Override
    public void setMarkDimensionID(int markDimensionID) {
        DataSyncExtension.For(this.entity).set(DataDefinitions.MARK_DIMENSION, markDimensionID);
    }

    @Override
    public void setMark(double x, double y, double z, int dim) {
        this.setMarkX(x);
        this.setMarkY(y);
        this.setMarkZ(z);
        this.setMarkDimensionID(dim);
    }

    @Override
    public boolean isShrunk() {
        return DataSyncExtension.For(this.entity).get(DataDefinitions.IS_SHRUNK);
    }

    @Override
    public void setShrunk(boolean shrunk) {
        DataSyncExtension.For(this.entity).set(DataDefinitions.IS_SHRUNK, shrunk);
    }

    @Override
    public void setInverted(boolean isInverted) {
        DataSyncExtension.For(this.entity).set(DataDefinitions.IS_INVERTED, isInverted);
    }

    @Override
    public void setFallProtection(float hasFallProtection) {
        DataSyncExtension.For(this.entity).set(DataDefinitions.FALL_PROTECTION, Float.valueOf(hasFallProtection));
    }

    @Override
    public boolean isInverted() {
        return DataSyncExtension.For(this.entity).get(DataDefinitions.IS_INVERTED) == null ? false : DataSyncExtension.For(this.entity).get(DataDefinitions.IS_INVERTED);
    }

    @Override
    public float getFallProtection() {
        return DataSyncExtension.For(this.entity).get(DataDefinitions.FALL_PROTECTION) == null ? 0.0f : DataSyncExtension.For(this.entity).get(DataDefinitions.FALL_PROTECTION).floatValue();
    }

    @Override
    public void addEntityReference(EntityLivingBase entity) {
        this.entity = entity;
        this.setOriginalSize(new AMVector2(entity.field_70130_N, entity.field_70131_O));
    }

    public void setOriginalSize(AMVector2 amVector2) {
        this.originalSize = amVector2;
    }

    public AMVector2 getOriginalSize() {
        return this.originalSize;
    }

    @Override
    public void init(EntityLivingBase entity, IDataSyncExtension ext) {
        this.addEntityReference(entity);
        if (this.entity instanceof EntityPlayer) {
            ext.setWithSync(DataDefinitions.CURRENT_LEVEL, 0);
            ext.setWithSync(DataDefinitions.CURRENT_MANA, Float.valueOf(0.0f));
            ext.setWithSync(DataDefinitions.CURRENT_MANA_FATIGUE, Float.valueOf(0.0f));
            ext.setWithSync(DataDefinitions.CURRENT_XP, Float.valueOf(0.0f));
            ext.setWithSync(DataDefinitions.CURRENT_SUMMONS, 0);
        } else {
            ext.setWithSync(DataDefinitions.CURRENT_LEVEL, 0);
            ext.setWithSync(DataDefinitions.CURRENT_MANA, Float.valueOf(500.0f));
            ext.setWithSync(DataDefinitions.CURRENT_MANA_FATIGUE, Float.valueOf(0.0f));
            ext.setWithSync(DataDefinitions.CURRENT_XP, Float.valueOf(0.0f));
            ext.setWithSync(DataDefinitions.CURRENT_SUMMONS, 0);
        }
        ext.setWithSync(DataDefinitions.HEAL_COOLDOWN, 0);
        ext.setWithSync(DataDefinitions.AFFINITY_HEAL_COOLDOWN, 0);
        ext.setWithSync(DataDefinitions.MARK_X, 0.0);
        ext.setWithSync(DataDefinitions.MARK_Y, 0.0);
        ext.setWithSync(DataDefinitions.MARK_Z, 0.0);
        ext.setWithSync(DataDefinitions.MARK_DIMENSION, -512);
        ext.setWithSync(DataDefinitions.CONTENGENCY_STACK, Optional.absent());
        ext.setWithSync(DataDefinitions.CONTENGENCY_TYPE, "NULL");
        ext.setWithSync(DataDefinitions.FALL_PROTECTION, Float.valueOf(0.0f));
        ext.setWithSync(DataDefinitions.IS_INVERTED, false);
        ext.setWithSync(DataDefinitions.IS_SHRUNK, false);
        ext.setWithSync(DataDefinitions.FLIP_ROTATION, Float.valueOf(0.0f));
        ext.setWithSync(DataDefinitions.PREV_FLIP_ROTATION, Float.valueOf(0.0f));
        ext.setWithSync(DataDefinitions.SHRINK_PCT, Float.valueOf(0.0f));
        ext.setWithSync(DataDefinitions.PREV_SHRINK_PCT, Float.valueOf(0.0f));
        ext.setWithSync(DataDefinitions.TK_DISTANCE, Float.valueOf(8.0f));
        ext.setWithSync(DataDefinitions.DISABLE_GRAVITY, false);
        ext.setWithSync(DataDefinitions.MANA_SHIELD, Float.valueOf(0.0f));
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == INSTANCE;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == INSTANCE) {
            return (T)this;
        }
        return null;
    }

    public static EntityExtension For(EntityLivingBase thePlayer) {
        return (EntityExtension)thePlayer.getCapability(INSTANCE, null);
    }

    public NBTBase serializeNBT() {
        return new IEntityExtension.Storage().writeNBT(INSTANCE, this, null);
    }

    public void deserializeNBT(NBTBase nbt) {
        new IEntityExtension.Storage().readNBT(INSTANCE, this, null, nbt);
    }

    @Override
    public boolean canHeal() {
        return this.getHealCooldown() <= 0;
    }

    @Override
    public int getMaxSummons() {
        int maxSummons = 1;
        if (!(this.entity instanceof EntityPlayer) || SkillData.For((EntityLivingBase)((EntityPlayer)this.entity)).hasSkill(SkillDefs.EXTRA_SUMMONS.getID())) {
            // empty if block
        }
        return ++maxSummons;
    }

    @Override
    public boolean addSummon(EntityCreature entityliving) {
        if (!this.entity.field_70170_p.field_72995_K) {
            this.summon_ent_ids.add(entityliving.func_145782_y());
            this.setCurrentSummons(this.getCurrentSummons() + 1);
        }
        return true;
    }

    @Override
    public boolean getCanHaveMoreSummons() {
        if (this.entity instanceof EntityLifeGuardian) {
            return true;
        }
        this.verifySummons();
        return this.getCurrentSummons() < this.getMaxSummons();
    }

    private void verifySummons() {
        for (int i = 0; i < this.summon_ent_ids.size(); ++i) {
            int id = this.summon_ent_ids.get(i);
            Entity e = this.entity.field_70170_p.func_73045_a(id);
            if (e != null && e instanceof EntityLivingBase) continue;
            this.summon_ent_ids.remove(i);
            --i;
            this.removeSummon();
        }
    }

    @Override
    public boolean removeSummon() {
        if (this.getCurrentSummons() == 0) {
            return false;
        }
        if (!this.entity.field_70170_p.field_72995_K) {
            this.setCurrentSummons(this.getCurrentSummons() - 1);
        }
        return true;
    }

    @Override
    public void updateManaLink(EntityLivingBase entity) {
        ManaLinkEntry mle = new ManaLinkEntry(entity.func_145782_y(), 20);
        if (!this.manaLinks.contains(mle)) {
            this.manaLinks.add(mle);
        } else {
            this.manaLinks.remove(mle);
        }
        if (!this.entity.field_70170_p.field_72995_K) {
            AMNetHandler.INSTANCE.sendPacketToAllClientsNear(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 32.0, (byte)60, this.getManaLinkUpdate());
        }
    }

    @Override
    public void deductMana(float manaCost) {
        block1: {
            float leftOver = manaCost - this.getCurrentMana();
            this.setCurrentMana(this.getCurrentMana() - manaCost);
            if (!(leftOver > 0.0f)) break block1;
            for (ManaLinkEntry entry : this.manaLinks) {
                if ((leftOver -= entry.deductMana(this.entity.field_70170_p, (Entity)this.entity, leftOver)) <= 0.0f) break;
            }
        }
    }

    @Override
    public void cleanupManaLinks() {
        Iterator<ManaLinkEntry> it = this.manaLinks.iterator();
        while (it.hasNext()) {
            ManaLinkEntry entry = it.next();
            Entity e = this.entity.field_70170_p.func_73045_a(entry.entityID);
            if (e != null) continue;
            it.remove();
        }
    }

    @Override
    public float getBonusCurrentMana() {
        float bonus = 0.0f;
        for (ManaLinkEntry entry : this.manaLinks) {
            bonus += entry.getAdditionalCurrentMana(this.entity.field_70170_p, (Entity)this.entity);
        }
        return bonus;
    }

    @Override
    public float getBonusMaxMana() {
        float bonus = 0.0f;
        for (ManaLinkEntry entry : this.manaLinks) {
            bonus += entry.getAdditionalMaxMana(this.entity.field_70170_p, (Entity)this.entity);
        }
        return bonus;
    }

    @Override
    public boolean isManaLinkedTo(EntityLivingBase entity) {
        for (ManaLinkEntry entry : this.manaLinks) {
            if (entry.entityID != entity.func_145782_y()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void spawnManaLinkParticles() {
        if (this.entity.field_70170_p != null && this.entity.field_70170_p.field_72995_K) {
            for (ManaLinkEntry entry : this.manaLinks) {
                AMLineArc arc;
                Entity e = this.entity.field_70170_p.func_73045_a(entry.entityID);
                if (e == null || !(e.func_70068_e((Entity)this.entity) < (double)entry.range) || e.field_70173_aa % 90 != 0 || (arc = (AMLineArc)((Object)ArsMagica2.proxy.particleManager.spawn(this.entity.field_70170_p, "textures/blocks/oreblockbluetopaz.png", e, (Entity)this.entity))) == null) continue;
                arc.setIgnoreAge(false);
                arc.func_70538_b(0.17f, 0.88f, 0.88f);
            }
        }
    }

    @Override
    public boolean shouldReverseInput() {
        return this.getFlipRotation() > 0.0f || this.entity.func_70644_a(PotionEffectsDefs.scrambleSynapses);
    }

    @Override
    public boolean getIsFlipped() {
        return DataSyncExtension.For(this.entity).get(DataDefinitions.IS_INVERTED) == null ? false : DataSyncExtension.For(this.entity).get(DataDefinitions.IS_INVERTED);
    }

    @Override
    public float getFlipRotation() {
        return DataSyncExtension.For(this.entity).get(DataDefinitions.FLIP_ROTATION) == null ? 0.0f : DataSyncExtension.For(this.entity).get(DataDefinitions.FLIP_ROTATION).floatValue();
    }

    @Override
    public float getPrevFlipRotation() {
        return DataSyncExtension.For(this.entity).get(DataDefinitions.PREV_FLIP_ROTATION) == null ? 0.0f : DataSyncExtension.For(this.entity).get(DataDefinitions.PREV_FLIP_ROTATION).floatValue();
    }

    @Override
    public void setFlipRotation(float rot) {
        DataSyncExtension.For(this.entity).set(DataDefinitions.FLIP_ROTATION, Float.valueOf(rot));
    }

    @Override
    public void setPrevFlipRotation(float rot) {
        DataSyncExtension.For(this.entity).set(DataDefinitions.PREV_FLIP_ROTATION, Float.valueOf(rot));
    }

    @Override
    public float getShrinkPct() {
        return DataSyncExtension.For(this.entity).get(DataDefinitions.SHRINK_PCT) == null ? 0.0f : DataSyncExtension.For(this.entity).get(DataDefinitions.SHRINK_PCT).floatValue();
    }

    @Override
    public float getPrevShrinkPct() {
        return DataSyncExtension.For(this.entity).get(DataDefinitions.PREV_SHRINK_PCT) == null ? 0.0f : DataSyncExtension.For(this.entity).get(DataDefinitions.PREV_SHRINK_PCT).floatValue();
    }

    @Override
    public void setTKDistance(float TK_Distance) {
        DataSyncExtension.For(this.entity).set(DataDefinitions.TK_DISTANCE, Float.valueOf(TK_Distance));
    }

    @Override
    public void addToTKDistance(float toAdd) {
        this.setTKDistance(this.getTKDistance() + toAdd);
    }

    @Override
    public float getTKDistance() {
        return DataSyncExtension.For(this.entity).get(DataDefinitions.TK_DISTANCE) == null ? 0.0f : DataSyncExtension.For(this.entity).get(DataDefinitions.TK_DISTANCE).floatValue();
    }

    @Override
    public void syncTKDistance() {
        AMDataWriter writer = new AMDataWriter();
        writer.add(this.getTKDistance());
        AMNetHandler.INSTANCE.sendPacketToServer((byte)39, writer.generate());
    }

    @Override
    public void manaBurnoutTick() {
        float toRemove;
        if (this.isGravityDisabled()) {
            this.entity.field_70181_x = 0.0;
        }
        float actualMaxMana = this.getMaxMana();
        if (this.getCurrentMana() < actualMaxMana) {
            if (this.entity instanceof EntityPlayer && ((EntityPlayer)this.entity).field_71075_bZ.field_75098_d) {
                this.setCurrentMana(actualMaxMana);
            } else {
                if (this.getCurrentMana() < 0.0f) {
                    this.setCurrentMana(0.0f);
                }
                int regenTicks = (int)Math.ceil((double)this.ticksForFullRegen * this.entity.func_110140_aT().func_111151_a(ArsMagicaAPI.manaRegenTimeModifier).func_111126_e());
                if (this.entity.func_70644_a(PotionEffectsDefs.manaRegen)) {
                    PotionEffect pe = this.entity.func_70660_b(PotionEffectsDefs.manaRegen);
                    regenTicks = (int)((double)regenTicks * Math.max(0.01, (double)(1.0f - (float)(pe.func_76458_c() + 1) * 0.25f)));
                }
                if (this.entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)this.entity;
                    int armorSet = ArmorHelper.getFullArsMagicaArmorSet(player);
                    if (armorSet == ArsMagicaArmorMaterial.MAGE.getMaterialID()) {
                        regenTicks = (int)((double)regenTicks * 0.8);
                    } else if (armorSet == ArsMagicaArmorMaterial.BATTLEMAGE.getMaterialID()) {
                        regenTicks = (int)((double)regenTicks * 0.95);
                    } else if (armorSet == ArsMagicaArmorMaterial.ARCHMAGE.getMaterialID()) {
                        regenTicks = (int)((double)regenTicks * 0.5);
                    }
                    if (SkillData.For((EntityLivingBase)player).hasSkill(SkillDefs.MANA_REGEN_3.getID())) {
                        regenTicks = (int)((float)regenTicks * 0.7f);
                    } else if (SkillData.For((EntityLivingBase)player).hasSkill(SkillDefs.MANA_REGEN_2.getID())) {
                        regenTicks = (int)((float)regenTicks * 0.85f);
                    } else if (SkillData.For((EntityLivingBase)player).hasSkill(SkillDefs.MANA_REGEN_1.getID())) {
                        regenTicks = (int)((float)regenTicks * 0.95f);
                    }
                    int numArmorPieces = 0;
                    for (int i = 0; i < 4; ++i) {
                        ItemStack stack = player.field_71071_by.field_70460_b[i];
                        if (!ImbuementRegistry.instance.isImbuementPresent(stack, "mn_reg")) continue;
                        ++numArmorPieces;
                    }
                    regenTicks = (int)((float)regenTicks * (1.0f - 0.15f * (float)numArmorPieces));
                }
                float manaToAdd = actualMaxMana / (float)regenTicks;
                this.setCurrentMana(this.getCurrentMana() + manaToAdd);
                if (this.getCurrentMana() > this.getMaxMana()) {
                    this.setCurrentMana(this.getMaxMana());
                }
            }
        } else if (this.getCurrentMana() > this.getMaxMana()) {
            float overloadMana = this.getCurrentMana() - this.getMaxMana();
            overloadMana = this.getCurrentMana() - this.getMaxMana();
            toRemove = Math.max(overloadMana * 0.002f, 1.0f);
            this.deductMana(toRemove);
            if (this.entity instanceof EntityPlayer && SkillData.For(this.entity).hasSkill(SkillDefs.SHIELD_OVERLOAD.getID())) {
                this.addMagicShieldingCapped(toRemove / 500.0f);
            }
        }
        if (this.getManaShielding() > this.getMaxMagicShielding()) {
            float overload = this.getManaShielding() - this.getMaxMagicShielding();
            toRemove = Math.max(overload * 0.002f, 1.0f);
            if (this.getManaShielding() - toRemove < this.getMaxMagicShielding()) {
                toRemove = overload;
            }
            this.setManaShielding(this.getManaShielding() - toRemove);
        }
        if (this.getCurrentBurnout() > 0.0f) {
            int numArmorPieces = 0;
            if (this.entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)this.entity;
                for (int i = 0; i < 4; ++i) {
                    ItemStack stack = player.field_71071_by.field_70460_b[i];
                    if (stack == null || !ImbuementRegistry.instance.isImbuementPresent(stack, "bn_red")) continue;
                    ++numArmorPieces;
                }
            }
            float factor = (float)((double)(0.01f + 0.015f * (float)numArmorPieces) * this.entity.func_110140_aT().func_111151_a(ArsMagicaAPI.burnoutReductionRate).func_111126_e());
            float decreaseamt = factor * (float)this.getCurrentLevel();
            this.setCurrentBurnout(this.getCurrentBurnout() - decreaseamt);
            if (this.getCurrentBurnout() < 0.0f) {
                this.setCurrentBurnout(0.0f);
            }
        }
    }

    public byte[] getManaLinkUpdate() {
        AMDataWriter writer = new AMDataWriter();
        writer.add(this.entity.func_145782_y());
        writer.add(this.manaLinks.size());
        for (ManaLinkEntry entry : this.manaLinks) {
            writer.add(entry.entityID);
        }
        return writer.generate();
    }

    public void handleManaLinkUpdate(AMDataReader rdr) {
        this.manaLinks.clear();
        int numLinks = rdr.getInt();
        for (int i = 0; i < numLinks; ++i) {
            Entity e = this.entity.field_70170_p.func_73045_a(rdr.getInt());
            if (e == null || !(e instanceof EntityLivingBase)) continue;
            this.updateManaLink((EntityLivingBase)e);
        }
    }

    @Override
    public boolean setMagicLevelWithMana(int level) {
        if (level < 0) {
            level = 0;
        }
        this.setCurrentLevel(level);
        this.setCurrentMana(this.getMaxMana());
        this.setCurrentBurnout(0.0f);
        return true;
    }

    @Override
    public void addMagicXP(float xp) {
        this.setCurrentXP(this.getCurrentXP() + xp);
    }

    @Override
    public void setDisableGravity(boolean b) {
        DataSyncExtension.For(this.entity).set(DataDefinitions.DISABLE_GRAVITY, b);
    }

    @Override
    public boolean isGravityDisabled() {
        return DataSyncExtension.For(this.entity).get(DataDefinitions.DISABLE_GRAVITY);
    }

    @Override
    public Entity getInanimateTarget() {
        return this.ent;
    }

    @Override
    public void setInanimateTarget(Entity ent) {
        this.ent = ent;
    }

    public void flipTick() {
        boolean flipped = this.getIsFlipped();
        ItemStack boots = ((EntityPlayer)this.entity).field_71071_by.field_70460_b[0];
        if (boots == null || boots.func_77973_b() != ItemDefs.enderBoots) {
            this.setInverted(false);
        }
        this.setPrevFlipRotation(this.getFlipRotation());
        if (flipped && this.getFlipRotation() < 180.0f) {
            this.setFlipRotation(this.getFlipRotation() + 15.0f);
        } else if (!flipped && this.getFlipRotation() > 0.0f) {
            this.setFlipRotation(this.getFlipRotation() - 15.0f);
        }
    }

    public void setShrinkPct(float shrinkPct) {
        DataSyncExtension.For(this.entity).set(DataDefinitions.PREV_SHRINK_PCT, Float.valueOf(this.getShrinkPct()));
        DataSyncExtension.For(this.entity).set(DataDefinitions.SHRINK_PCT, Float.valueOf(shrinkPct));
    }

    @Override
    public float getManaShielding() {
        return DataSyncExtension.For(this.entity).get(DataDefinitions.MANA_SHIELD).floatValue();
    }

    @Override
    public void setManaShielding(float manaShield) {
        manaShield = Math.max(0.0f, manaShield);
        DataSyncExtension.For(this.entity).set(DataDefinitions.MANA_SHIELD, Float.valueOf(manaShield));
    }

    public float getMaxMagicShielding() {
        return this.getCurrentLevel() * 2;
    }

    public float protect(float damage) {
        float left = this.getManaShielding() - damage;
        this.setManaShielding(Math.max(0.0f, left));
        if (left < 0.0f) {
            return -left;
        }
        return 0.0f;
    }

    public void addMagicShielding(float manaShield) {
        this.setManaShielding(this.getManaShielding() + manaShield);
    }

    public void addMagicShieldingCapped(float manaShield) {
        this.setManaShielding(Math.min(this.getManaShielding() + manaShield, this.getMaxMagicShielding()));
    }

    private class ManaLinkEntry {
        private final int entityID;
        private final int range;

        public ManaLinkEntry(int entityID, int range) {
            this.entityID = entityID;
            this.range = range * range;
        }

        private EntityLivingBase getEntity(World world) {
            Entity e = world.func_73045_a(this.entityID);
            if (e == null || !(e instanceof EntityLivingBase)) {
                return null;
            }
            return (EntityLivingBase)e;
        }

        public float getAdditionalCurrentMana(World world, Entity host) {
            EntityLivingBase e = this.getEntity(world);
            if (e == null || e.func_70068_e(host) > (double)this.range) {
                return 0.0f;
            }
            return EntityExtension.For(e).getCurrentMana();
        }

        public float getAdditionalMaxMana(World world, Entity host) {
            EntityLivingBase e = this.getEntity(world);
            if (e == null || e.func_70068_e(host) > (double)this.range) {
                return 0.0f;
            }
            return EntityExtension.For(e).getMaxMana();
        }

        public float deductMana(World world, Entity host, float amt) {
            EntityLivingBase e = this.getEntity(world);
            if (e == null || e.func_70068_e(host) > (double)this.range) {
                return 0.0f;
            }
            amt = Math.min(EntityExtension.For(e).getCurrentMana(), amt);
            EntityExtension.For(e).deductMana(amt);
            return amt;
        }

        public int hashCode() {
            return this.entityID;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ManaLinkEntry) {
                return ((ManaLinkEntry)obj).entityID == this.entityID;
            }
            return false;
        }
    }
}

