/*
 * Decompiled with CFR 0.152.
 */
package am2.extensions;

import am2.api.ArsMagicaAPI;
import am2.api.affinity.Affinity;
import am2.api.extensions.IAffinityData;
import am2.api.extensions.IDataSyncExtension;
import am2.extensions.DataDefinitions;
import am2.extensions.datamanager.DataSyncExtension;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class AffinityData
implements IAffinityData,
ICapabilityProvider,
ICapabilitySerializable<NBTBase> {
    public static final ResourceLocation ID = new ResourceLocation("arsmagica2:AffinityData");
    public static final String NIGHT_VISION = "night_vision";
    public static final String ICE_BRIDGE_STATE = "ice_bridge";
    public static final float MAX_DEPTH = 100.0f;
    private static final float ADJACENT_FACTOR = 0.25f;
    private static final float MINOR_OPPOSING_FACTOR = 0.5f;
    private static final float MAJOR_OPPOSING_FACTOR = 0.75f;
    private EntityPlayer player;
    public float accumulatedLifeRegen = 0.0f;
    public float accumulatedHungerRegen = 0.0f;
    @CapabilityInject(value=IAffinityData.class)
    public static Capability<IAffinityData> INSTANCE = null;

    public static AffinityData For(EntityLivingBase living) {
        return (AffinityData)living.getCapability(INSTANCE, null);
    }

    @Override
    public double getAffinityDepth(Affinity aff) {
        return DataSyncExtension.For((EntityLivingBase)this.player).get(DataDefinitions.AFFINITY_DATA).get(aff) / 100.0;
    }

    @Override
    public void setAffinityDepth(Affinity name, double value) {
        value = MathHelper.func_151237_a((double)value, (double)0.0, (double)100.0);
        HashMap<Affinity, Double> map = DataSyncExtension.For((EntityLivingBase)this.player).get(DataDefinitions.AFFINITY_DATA);
        map.put(name, value);
        DataSyncExtension.For((EntityLivingBase)this.player).setWithSync(DataDefinitions.AFFINITY_DATA, map);
    }

    @Override
    public HashMap<Affinity, Double> getAffinities() {
        return DataSyncExtension.For((EntityLivingBase)this.player).get(DataDefinitions.AFFINITY_DATA);
    }

    @Override
    public void init(EntityPlayer entity, IDataSyncExtension ext) {
        this.player = entity;
        HashMap<Affinity, Double> map = new HashMap<Affinity, Double>();
        for (Affinity DEPTH : ArsMagicaAPI.getAffinityRegistry().getValues()) {
            map.put(DEPTH, 0.0);
        }
        map.put(Affinity.NONE, 0.0);
        ext.setWithSync(DataDefinitions.AFFINITY_DATA, map);
        ext.setWithSync(DataDefinitions.ABILITY_BOOLEAN, new HashMap());
        ext.setWithSync(DataDefinitions.ABILITY_FLOAT, new HashMap());
        ext.setWithSync(DataDefinitions.DIMINISHING_RETURNS, Float.valueOf(1.0f));
        ext.setWithSync(DataDefinitions.COOLDOWNS, new HashMap());
    }

    @Override
    public boolean getAbilityBoolean(String name) {
        Boolean bool = this.getAbilityBooleanMap().get(name);
        return bool == null ? false : bool;
    }

    @Override
    public void addAbilityBoolean(String name, boolean bool) {
        HashMap<String, Boolean> map = DataSyncExtension.For((EntityLivingBase)this.player).get(DataDefinitions.ABILITY_BOOLEAN);
        map.put(name, bool);
        DataSyncExtension.For((EntityLivingBase)this.player).setWithSync(DataDefinitions.ABILITY_BOOLEAN, map);
    }

    @Override
    public float getAbilityFloat(String name) {
        Float bool = this.getAbilityFloatMap().get(name);
        return bool == null ? 0.0f : bool.floatValue();
    }

    @Override
    public void addAbilityFloat(String name, float f) {
        HashMap<String, Float> map = DataSyncExtension.For((EntityLivingBase)this.player).get(DataDefinitions.ABILITY_FLOAT);
        map.put(name, Float.valueOf(f));
        DataSyncExtension.For((EntityLivingBase)this.player).setWithSync(DataDefinitions.ABILITY_FLOAT, map);
    }

    @Override
    public Map<String, Boolean> getAbilityBooleanMap() {
        return DataSyncExtension.For((EntityLivingBase)this.player).get(DataDefinitions.ABILITY_BOOLEAN);
    }

    @Override
    public Map<String, Float> getAbilityFloatMap() {
        return DataSyncExtension.For((EntityLivingBase)this.player).get(DataDefinitions.ABILITY_FLOAT);
    }

    @Override
    public void addCooldown(String name, int cooldown) {
        HashMap<String, Integer> map = DataSyncExtension.For((EntityLivingBase)this.player).get(DataDefinitions.COOLDOWNS);
        map.put(name, cooldown);
        DataSyncExtension.For((EntityLivingBase)this.player).setWithSync(DataDefinitions.COOLDOWNS, map);
    }

    @Override
    public int getCooldown(String name) {
        return this.getCooldowns().get(name) == null ? 0 : this.getCooldowns().get(name);
    }

    @Override
    public Map<String, Integer> getCooldowns() {
        return DataSyncExtension.For((EntityLivingBase)this.player).get(DataDefinitions.COOLDOWNS);
    }

    @Override
    public float getDiminishingReturnsFactor() {
        return DataSyncExtension.For((EntityLivingBase)this.player).get(DataDefinitions.DIMINISHING_RETURNS).floatValue();
    }

    @Override
    public void tickDiminishingReturns() {
        if (this.getDiminishingReturnsFactor() < 1.3f) {
            DataSyncExtension.For((EntityLivingBase)this.player).set(DataDefinitions.DIMINISHING_RETURNS, Float.valueOf(DataSyncExtension.For((EntityLivingBase)this.player).get(DataDefinitions.DIMINISHING_RETURNS).floatValue() + 0.005f));
        }
    }

    @Override
    public void addDiminishingReturns(boolean isChanneled) {
        DataSyncExtension.For((EntityLivingBase)this.player).set(DataDefinitions.DIMINISHING_RETURNS, Float.valueOf(this.getDiminishingReturnsFactor() - (isChanneled ? 0.1f : 0.3f)));
        if (this.getDiminishingReturnsFactor() < 0.0f) {
            DataSyncExtension.For((EntityLivingBase)this.player).set(DataDefinitions.DIMINISHING_RETURNS, Float.valueOf(0.0f));
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == INSTANCE;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == INSTANCE) {
            return (T)this;
        }
        return null;
    }

    public NBTBase serializeNBT() {
        return new IAffinityData.Storage().writeNBT(INSTANCE, this, null);
    }

    public void deserializeNBT(NBTBase nbt) {
        new IAffinityData.Storage().readNBT(INSTANCE, this, null, nbt);
    }

    @Override
    public Affinity[] getHighestAffinities() {
        double max1 = 0.0;
        double max2 = 0.0;
        Affinity maxAff1 = Affinity.NONE;
        Affinity maxAff2 = Affinity.NONE;
        for (Map.Entry<Affinity, Double> entry : this.getAffinities().entrySet()) {
            if (entry.getValue() > max1) {
                max2 = max1;
                maxAff2 = maxAff1;
                max1 = entry.getValue();
                maxAff1 = entry.getKey();
                continue;
            }
            if (!(entry.getValue() > max2)) continue;
            max2 = entry.getValue();
            maxAff2 = entry.getKey();
        }
        return new Affinity[]{maxAff1, maxAff2};
    }

    @Override
    public void incrementAffinity(Affinity affinity, float amt) {
        if (affinity == Affinity.NONE || this.isLocked()) {
            return;
        }
        float adjacentDecrement = amt * 0.25f;
        float minorOppositeDecrement = amt * 0.5f;
        float majorOppositeDecrement = amt * 0.75f;
        this.addToAffinity(affinity, amt);
        if (this.getAffinityDepth(affinity) * 100.0 == 100.0) {
            this.setLocked(true);
        }
        for (Affinity adjacent : affinity.getAdjacentAffinities()) {
            this.subtractFromAffinity(adjacent, adjacentDecrement);
        }
        for (Affinity minorOpposite : affinity.getMinorOpposingAffinities()) {
            this.subtractFromAffinity(minorOpposite, minorOppositeDecrement);
        }
        for (Affinity majorOpposite : affinity.getMajorOpposingAffinities()) {
            this.subtractFromAffinity(majorOpposite, majorOppositeDecrement);
        }
        Affinity directOpposite = affinity.getOpposingAffinity();
        if (directOpposite != null) {
            this.subtractFromAffinity(directOpposite, amt);
        }
    }

    private void addToAffinity(Affinity affinity, float amt) {
        if (affinity == Affinity.NONE) {
            return;
        }
        double existingAmt = this.getAffinityDepth(affinity) * 100.0;
        if ((existingAmt += (double)amt) > 100.0) {
            existingAmt = 100.0;
        } else if (existingAmt < 0.0) {
            existingAmt = 0.0;
        }
        this.setAffinityDepth(affinity, existingAmt);
    }

    private void subtractFromAffinity(Affinity affinity, float amt) {
        if (affinity == Affinity.NONE) {
            return;
        }
        double existingAmt = this.getAffinityDepth(affinity) * 100.0;
        if ((existingAmt -= (double)amt) > 100.0) {
            existingAmt = 100.0;
        } else if (existingAmt < 0.0) {
            existingAmt = 0.0;
        }
        this.setAffinityDepth(affinity, existingAmt);
    }

    @Override
    public void setLocked(boolean b) {
        this.addAbilityBoolean("affinity_data_locked", b);
    }

    @Override
    public boolean isLocked() {
        return this.getAbilityBoolean("affinity_data_locked");
    }
}

