/*
 * Decompiled with CFR 0.152.
 */
package am2.entity;

import am2.ArsMagica2;
import am2.api.DamageSources;
import am2.api.spell.SpellModifier;
import am2.api.spell.SpellModifiers;
import am2.blocks.BlockArsMagicaOre;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.packet.AMNetHandler;
import am2.particles.AMParticle;
import am2.particles.ParticleChangeSize;
import am2.particles.ParticleColorShift;
import am2.particles.ParticleHoldPosition;
import am2.spell.modifier.Colour;
import am2.utils.MathUtilities;
import am2.utils.SpellUtils;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityThrownRock
extends EntityLiving {
    private EntityLivingBase throwingEntity;
    private int maxTicksToExist;
    private Vec3d target = null;
    private float damage;
    private static final DataParameter<Boolean> IS_MOONSTONE_METEOR = EntityDataManager.func_187226_a(EntityThrownRock.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_SHOOTING_STAR = EntityDataManager.func_187226_a(EntityThrownRock.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Optional<ItemStack>> SPELL_STACK = EntityDataManager.func_187226_a(EntityThrownRock.class, (DataSerializer)DataSerializers.field_187196_f);

    public EntityThrownRock(World par1World) {
        super(par1World);
        this.field_70173_aa = 0;
        this.maxTicksToExist = 120;
        this.field_70145_X = true;
    }

    public void setMoonstoneMeteor() {
        this.field_70180_af.func_187227_b(IS_MOONSTONE_METEOR, (Object)true);
    }

    public void setShootingStar(float damage) {
        this.field_70180_af.func_187227_b(IS_SHOOTING_STAR, (Object)true);
        this.damage = damage;
    }

    public void setMoonstoneMeteorTarget(Vec3d target) {
        this.target = target;
    }

    public boolean getIsMoonstoneMeteor() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_MOONSTONE_METEOR);
    }

    public boolean getIsShootingStar() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SHOOTING_STAR);
    }

    public EntityThrownRock(World world, EntityLivingBase entityLiving, double projectileSpeed) {
        super(world);
        this.field_70145_X = true;
        this.throwingEntity = entityLiving;
        this.func_70105_a(0.25f, 0.25f);
        this.func_70012_b(entityLiving.field_70165_t, entityLiving.field_70163_u + (double)entityLiving.func_70047_e(), entityLiving.field_70161_v, entityLiving.field_70177_z, entityLiving.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        float f = 0.05f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f)) * f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f)) * f;
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * 3.141593f)) * f;
        this.maxTicksToExist = 100;
        this.setHeading(this.field_70159_w, this.field_70181_x, this.field_70179_y, projectileSpeed, projectileSpeed);
    }

    public void setHeading(double movementX, double movementY, double movementZ, double projectileSpeed, double projectileSpeed2) {
        float f = MathHelper.func_76133_a((double)(movementX * movementX + movementY * movementY + movementZ * movementZ));
        movementX /= (double)f;
        movementY /= (double)f;
        movementZ /= (double)f;
        movementX += this.field_70146_Z.nextGaussian() * (double)0.0075f * projectileSpeed2;
        movementY += this.field_70146_Z.nextGaussian() * (double)0.0075f * projectileSpeed2;
        movementZ += this.field_70146_Z.nextGaussian() * (double)0.0075f * projectileSpeed2;
        this.field_70159_w = movementX *= projectileSpeed;
        this.field_70181_x = movementY *= projectileSpeed;
        this.field_70179_y = movementZ *= projectileSpeed;
        float f1 = MathHelper.func_76133_a((double)(movementX * movementX + movementZ * movementZ));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(movementX, movementZ) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(movementY, f1) * 180.0 / Math.PI);
    }

    public void setThrowingEntity(EntityLivingBase thrower) {
        this.throwingEntity = thrower;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_MOONSTONE_METEOR, (Object)false);
        this.field_70180_af.func_187214_a(IS_SHOOTING_STAR, (Object)false);
        this.field_70180_af.func_187214_a(SPELL_STACK, (Object)Optional.fromNullable((Object)new ItemStack((Item)ItemDefs.spell)));
    }

    private ItemStack getSpellStack() {
        return (ItemStack)((Optional)this.field_70180_af.func_187225_a(SPELL_STACK)).get();
    }

    public void setSpellStack(ItemStack spellStack) {
        this.field_70180_af.func_187227_b(SPELL_STACK, (Object)Optional.fromNullable((Object)spellStack));
    }

    protected boolean func_70692_ba() {
        return !this.getIsMoonstoneMeteor() && !this.getIsShootingStar();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.target != null && this.field_70163_u > this.target.field_72448_b) {
            double deltaX = this.field_70165_t - this.target.field_72450_a;
            double deltaY = this.field_70163_u - this.target.field_72448_b;
            double deltaZ = this.field_70161_v - this.target.field_72449_c;
            double angle = Math.atan2(deltaZ, deltaX);
            double hDist = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            double vAngle = Math.atan2(deltaY, hDist);
            this.field_70159_w = -Math.cos(angle) * 0.2;
            this.field_70179_y = -Math.sin(angle) * 0.2;
            this.field_70181_x = -Math.sin(vAngle) * 2.5;
        }
        if (!this.getIsMoonstoneMeteor() && !this.getIsShootingStar()) {
            if (!this.field_70170_p.field_72995_K && (this.throwingEntity == null || this.throwingEntity.field_70128_L)) {
                this.func_70106_y();
            } else {
                int maxTicksToLive;
                ++this.field_70173_aa;
                int n = maxTicksToLive = this.maxTicksToExist > -1 ? this.maxTicksToExist : 100;
                if (this.field_70173_aa >= maxTicksToLive && !this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                    return;
                }
            }
        }
        if (this.getIsShootingStar()) {
            this.field_70181_x -= (double)0.1f;
            if (this.field_70181_x < -2.0) {
                this.field_70181_x = -2.0;
            }
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.getIsMoonstoneMeteor()) {
                AMParticle fire = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_70170_p, "explosion_2", this.field_70165_t, this.field_70163_u, this.field_70161_v));
                if (fire != null) {
                    fire.func_187114_a(20);
                    fire.setRGBColorF(1.0f, 1.0f, 1.0f);
                    fire.setParticleScale(2.0f);
                    fire.AddParticleController(new ParticleHoldPosition(fire, 20, 1, false));
                    fire.AddParticleController(new ParticleColorShift(fire, 1, false).SetShiftSpeed(0.1f).SetColorTarget(0.01f, 0.01f, 0.01f).SetEndOnReachingTargetColor().setKillParticleOnFinish(false));
                }
            } else if (this.getIsShootingStar()) {
                int color = -1;
                if (this.getSpellStack() != null && SpellUtils.modifierIsPresent(SpellModifiers.COLOR, this.getSpellStack())) {
                    ArrayList<SpellModifier> mods = SpellUtils.getModifiersForStage(this.getSpellStack(), -1);
                    for (SpellModifier mod : mods) {
                        if (!(mod instanceof Colour)) continue;
                        color = (int)mod.getModifier(SpellModifiers.COLOR, null, null, null, this.getSpellStack().func_77978_p());
                    }
                }
                float i = 0.0f;
                while ((double)i < Math.abs(this.field_70181_x)) {
                    AMParticle star = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_70170_p, "ember", this.field_70165_t + this.field_70159_w * (double)i, this.field_70163_u + this.field_70181_x * (double)i, this.field_70161_v + this.field_70179_y * (double)i));
                    if (star != null) {
                        star.func_187114_a(22);
                        float clrMod = Minecraft.func_71410_x().field_71441_e.field_73012_v.nextFloat();
                        int finalColor = -1;
                        if (color == -1) {
                            finalColor = MathUtilities.colorFloatsToInt(0.24f * clrMod, 0.58f * clrMod, 0.71f * clrMod);
                        } else {
                            float[] colors = MathUtilities.colorIntToFloats(color);
                            for (int c = 0; c < colors.length; ++c) {
                                colors[c] = colors[c] * clrMod;
                            }
                            finalColor = MathUtilities.colorFloatsToInt(colors[0], colors[1], colors[2]);
                        }
                        star.setRGBColorI(finalColor);
                        star.AddParticleController(new ParticleHoldPosition(star, 20, 1, false));
                        star.AddParticleController(new ParticleChangeSize(star, 0.5f, 0.05f, 20, 1, false));
                    }
                    i += 0.1f;
                }
            }
        }
        Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult movingobjectposition = this.field_70170_p.func_72933_a(vec3d, vec3d1);
        vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (movingobjectposition != null) {
            vec3d1 = new Vec3d(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        double d = 0.0;
        for (int j = 0; j < list.size(); ++j) {
            double d1;
            Entity entity1 = (Entity)list.get(j);
            if (!entity1.func_70067_L() || entity1.func_70028_i((Entity)this.throwingEntity) && this.field_70173_aa < 25) continue;
            float f2 = 0.3f;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72314_b((double)f2, (double)f2, (double)f2);
            RayTraceResult movingobjectposition1 = axisalignedbb.func_72327_a(vec3d, vec3d1);
            if (movingobjectposition1 == null || !((d1 = vec3d.func_72438_d(movingobjectposition1.field_72307_f)) < d) && d != 0.0) continue;
            entity = entity1;
            d = d1;
        }
        if (entity != null) {
            movingobjectposition = new RayTraceResult(entity);
        }
        if (movingobjectposition != null) {
            this.HitObject(movingobjectposition);
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / 3.1415927410125732);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / 3.1415927410125732);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected void HitObject(RayTraceResult movingobjectposition) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.getIsShootingStar()) {
            AMNetHandler.INSTANCE.sendStarImpactToClients(this.field_70165_t, this.field_70163_u + (double)(movingobjectposition.field_72313_a == RayTraceResult.Type.ENTITY ? -movingobjectposition.field_72308_g.func_70047_e() : 1.5f), this.field_70161_v, this.field_70170_p, this.getSpellStack());
            List ents = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(12.0, 5.0, 12.0));
            this.field_70163_u += 1.0;
            for (EntityLivingBase e : ents) {
                if (e == this.throwingEntity || !(this.func_70032_d((Entity)e) < 12.0f) || !this.func_70685_l((Entity)e)) continue;
                SpellUtils.attackTargetSpecial(null, (Entity)e, DamageSources.causeMagicDamage(this.throwingEntity), this.damage);
            }
        } else if (movingobjectposition.field_72308_g != null && movingobjectposition.field_72308_g instanceof EntityLivingBase) {
            if (movingobjectposition.field_72308_g == this.throwingEntity || this.throwingEntity == null) {
                return;
            }
            if (this.throwingEntity != null) {
                movingobjectposition.field_72308_g.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.throwingEntity), 10.0f);
            }
        } else if (movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK && this.getIsMoonstoneMeteor()) {
            if (this.target == null) {
                this.target = movingobjectposition.field_72307_f;
            }
            this.field_70170_p.func_72885_a((Entity)this, this.target.field_72450_a, this.target.field_72448_b, this.target.field_72449_c, 0.8f, false, ArsMagica2.config.moonstoneMeteorsDestroyTerrain());
            int numOres = this.field_70146_Z.nextInt(4) + 1;
            for (int i = 0; i < numOres; ++i) {
                this.generateSurfaceOreAtOffset(this.field_70170_p, new BlockPos(this.target), i == 0);
            }
        }
        this.func_70106_y();
    }

    private void generateSurfaceOreAtOffset(World world, BlockPos pos, boolean force) {
        pos = pos.func_177965_g(this.field_70146_Z.nextInt(4) - 2);
        pos = pos.func_177970_e(this.field_70146_Z.nextInt(4) - 2);
        while (!world.func_175623_d(pos) && pos.func_177956_o() < world.func_72940_L()) {
            pos = pos.func_177984_a();
        }
        if (this.field_70146_Z.nextInt(4) < 2 || force) {
            world.func_175656_a(pos, BlockDefs.ores.func_176223_P().func_177226_a(BlockArsMagicaOre.ORE_TYPE, (Comparable)((Object)BlockArsMagicaOre.EnumOreType.MOONSTONE)));
        } else {
            world.func_175656_a(pos, Blocks.field_150348_b.func_176223_P());
        }
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        return false;
    }

    public void func_70037_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70037_a(par1nbtTagCompound);
        this.damage = par1nbtTagCompound.func_74760_g("star_damage");
        if (par1nbtTagCompound.func_74767_n("MoonstoneMeteor")) {
            this.setMoonstoneMeteor();
        }
    }

    public void func_70014_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70014_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74776_a("star_damage", this.damage);
        par1nbtTagCompound.func_74757_a("MoonstoneMeteor", this.getIsMoonstoneMeteor());
    }
}

