/*
 * Decompiled with CFR 0.152.
 */
package am2.entity;

import am2.ArsMagica2;
import am2.api.math.AMVector3;
import am2.blocks.tileentity.TileEntityCraftingAltar;
import am2.defs.AMSounds;
import am2.entity.ai.EntityAISpellmaking;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import am2.proxy.ShadowSkinHelper;
import com.google.common.base.Optional;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityShadowHelper
extends EntityLiving {
    private static final DataParameter<String> DW_MIMIC_USER = EntityDataManager.func_187226_a(EntityShadowHelper.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Optional<ItemStack>> DW_SEARCH_ITEM = EntityDataManager.func_187226_a(EntityShadowHelper.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Integer> DW_TRANS_LOC_X = EntityDataManager.func_187226_a(EntityShadowHelper.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DW_TRANS_LOC_Y = EntityDataManager.func_187226_a(EntityShadowHelper.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DW_TRANS_LOC_Z = EntityDataManager.func_187226_a(EntityShadowHelper.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<ItemStack>> DW_HELD_ITEM = EntityDataManager.func_187226_a(EntityShadowHelper.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Integer> DW_DROP_LOC_X = EntityDataManager.func_187226_a(EntityShadowHelper.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DW_DROP_LOC_Y = EntityDataManager.func_187226_a(EntityShadowHelper.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DW_DROP_LOC_Z = EntityDataManager.func_187226_a(EntityShadowHelper.class, (DataSerializer)DataSerializers.field_187192_b);
    private TileEntityCraftingAltar altarTarget = null;
    private String lastDWString = "";
    @SideOnly(value=Side.CLIENT)
    private ShadowSkinHelper skinHelper;

    public EntityShadowHelper(World world) {
        super(world);
        this.initAI();
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (this.field_70170_p.field_72995_K) {
            this.spawnParticles();
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, AMSounds.CRAFTING_ALTAR_CREATE_SPELL, SoundCategory.NEUTRAL, 1.0f, 1.0f, true);
        }
    }

    private void spawnParticles() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 25 * ArsMagica2.config.getGFXLevel() + 1; ++i) {
                AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_70170_p, "arcane", this.field_70165_t, this.field_70163_u, this.field_70161_v));
                if (particle == null) continue;
                particle.addRandomOffset(1.0, 1.0, 1.0);
                particle.AddParticleController(new ParticleFloatUpward(particle, 0.0f, 0.02f + this.func_70681_au().nextFloat() * 0.2f, 1, false));
                particle.setIgnoreMaxAge(false);
                particle.func_187114_a(20 + this.func_70681_au().nextInt(20));
            }
        }
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_70609_aI() {
        this.func_70106_y();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DW_MIMIC_USER, (Object)"");
        this.field_70180_af.func_187214_a(DW_SEARCH_ITEM, (Object)Optional.of((Object)new ItemStack(Items.field_151034_e)));
        this.field_70180_af.func_187214_a(DW_TRANS_LOC_X, (Object)0);
        this.field_70180_af.func_187214_a(DW_TRANS_LOC_Y, (Object)0);
        this.field_70180_af.func_187214_a(DW_TRANS_LOC_Z, (Object)0);
        this.field_70180_af.func_187214_a(DW_HELD_ITEM, (Object)Optional.of((Object)new ItemStack(Items.field_151121_aF)));
        this.field_70180_af.func_187214_a(DW_DROP_LOC_X, (Object)0);
        this.field_70180_af.func_187214_a(DW_DROP_LOC_Y, (Object)0);
        this.field_70180_af.func_187214_a(DW_DROP_LOC_Z, (Object)0);
    }

    public void setSearchLocationAndItem(AMVector3 location, ItemStack item) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.field_70180_af.func_187227_b(DW_SEARCH_ITEM, (Object)Optional.of((Object)item));
        this.field_70180_af.func_187227_b(DW_TRANS_LOC_X, (Object)((int)location.x));
        this.field_70180_af.func_187227_b(DW_TRANS_LOC_Y, (Object)((int)location.y));
        this.field_70180_af.func_187227_b(DW_TRANS_LOC_Z, (Object)((int)location.z));
    }

    public void setDropoffLocation(AMVector3 location) {
        this.field_70180_af.func_187227_b(DW_DROP_LOC_X, (Object)((int)location.x));
        this.field_70180_af.func_187227_b(DW_DROP_LOC_Y, (Object)((int)location.y));
        this.field_70180_af.func_187227_b(DW_DROP_LOC_Z, (Object)((int)location.z));
    }

    public AMVector3 getSearchLocation() {
        return new AMVector3(((Integer)this.field_70180_af.func_187225_a(DW_TRANS_LOC_X)).intValue(), ((Integer)this.field_70180_af.func_187225_a(DW_TRANS_LOC_Y)).intValue(), ((Integer)this.field_70180_af.func_187225_a(DW_TRANS_LOC_Z)).intValue());
    }

    public AMVector3 getDropLocation() {
        return new AMVector3(((Integer)this.field_70180_af.func_187225_a(DW_DROP_LOC_X)).intValue(), ((Integer)this.field_70180_af.func_187225_a(DW_DROP_LOC_Y)).intValue(), ((Integer)this.field_70180_af.func_187225_a(DW_DROP_LOC_Z)).intValue());
    }

    public ItemStack getSearchItem() {
        return (ItemStack)((Optional)this.field_70180_af.func_187225_a(DW_SEARCH_ITEM)).orNull();
    }

    public void setHeldItem(ItemStack item) {
        this.field_70180_af.func_187227_b(DW_HELD_ITEM, (Object)Optional.of((Object)item));
    }

    public void setMimicUser(String userName) {
        this.field_70180_af.func_187227_b(DW_MIMIC_USER, (Object)userName);
    }

    public String getMimicUser() {
        return (String)this.field_70180_af.func_187225_a(DW_MIMIC_USER);
    }

    public boolean hasSearchLocation() {
        return !this.getSearchLocation().equals(AMVector3.zero());
    }

    public TileEntityCraftingAltar getAltarTarget() {
        return this.altarTarget;
    }

    public void setAltarTarget(TileEntityCraftingAltar target) {
        this.altarTarget = target;
    }

    private void initAI() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISpellmaking(this));
    }

    public ItemStack func_184614_ca() {
        return (ItemStack)((Optional)this.field_70180_af.func_187225_a(DW_HELD_ITEM)).orNull();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p != null && this.field_70170_p.field_72995_K && this.skinHelper == null) {
            this.skinHelper = new ShadowSkinHelper();
            this.spawnParticles();
        }
        if (this.field_70170_p.field_72995_K && this.getMimicUser() != this.lastDWString) {
            this.lastDWString = this.getMimicUser();
            this.skinHelper.setupCustomSkin(this.lastDWString);
        }
        if (!(this.field_70170_p.field_72995_K || this.altarTarget != null && this.altarTarget.isCrafting())) {
            this.unSummon();
        }
    }

    protected SoundEvent func_184601_bQ() {
        return null;
    }

    public void unSummon() {
        this.func_70097_a(DamageSource.field_76377_j, 5000.0f);
    }

    public ResourceLocation getLocationSkin() {
        return this.skinHelper.getLocationSkin();
    }

    public ThreadDownloadImageData getTextureSkin() {
        return this.skinHelper.getTextureSkin();
    }
}

