/*
 * Decompiled with CFR 0.152.
 */
package am2.entity;

import am2.ArsMagica2;
import am2.api.ArsMagicaAPI;
import am2.api.affinity.Affinity;
import am2.defs.AMSounds;
import am2.defs.ItemDefs;
import am2.entity.SpawnBlacklists;
import am2.extensions.EntityExtension;
import am2.packet.AMNetHandler;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleFloatUpward;
import am2.particles.ParticleMoveOnHeading;
import java.util.List;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class EntityHecate
extends EntityZombie {
    private double leftArmAnimTicks = 0.0;
    private double rightArmAnimTicks = 12.0;
    private double leftArmRotationOffset = 0.0;
    private double rightArmRotationOffset = 0.0;
    private final float hostileSpeed;
    private static final float forwardThreshold = 1.22f;
    private float currentForwardRotation = 0.0f;
    private int invisibilityCooldown = 0;
    private int invisibilityCounter = 0;
    private boolean hasSpawnedInvisParticles = false;

    public EntityHecate(World par1World) {
        super(par1World);
        this.hostileSpeed = 1.7f;
        this.func_70105_a(0.6f, 1.5f);
        EntityExtension.For((EntityLivingBase)this).setCurrentLevel(7);
        EntityExtension.For((EntityLivingBase)this).setCurrentMana(600.0f);
        this.field_70714_bg.field_75782_a.clear();
        this.field_70715_bh.field_75782_a.clear();
        this.initAI();
        this.field_70138_W = 1.02f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    private void initAI() {
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, (double)this.hostileSpeed, false));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, (double)this.hostileSpeed));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityGolem.class, 0, false, false, null));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, 0, false, false, null));
    }

    public int func_70658_aO() {
        return 5;
    }

    public float getHorizontalAverageVelocity() {
        return (float)((this.field_70159_w + this.field_70179_y) / 2.0);
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
    }

    private boolean isMoving() {
        return this.field_70169_q != this.field_70165_t || this.field_70166_s != this.field_70161_v;
    }

    private void updateForwardRotation() {
        if (this.isMoving() && this.currentForwardRotation < 1.22f) {
            this.currentForwardRotation += 0.12f;
        } else if (!this.isMoving() && this.currentForwardRotation > 0.0f) {
            this.currentForwardRotation -= 0.12f;
        }
    }

    public float getForwardRotation() {
        return this.currentForwardRotation;
    }

    public void func_70071_h_() {
        if (this.invisibilityCooldown > 0) {
            --this.invisibilityCooldown;
        }
        if (this.invisibilityCooldown == 0) {
            this.hasSpawnedInvisParticles = false;
        }
        if (this.field_70181_x < 0.0) {
            this.field_70181_x *= (double)0.79999f;
        }
        if (this.field_70170_p != null) {
            if (this.field_70170_p.field_72995_K) {
                if (!this.func_70083_f(5) && this.field_70173_aa % 3 == 0) {
                    this.spawnLivingParticles();
                } else if (!this.hasSpawnedInvisParticles) {
                    this.spawnInvisibilityParticles();
                }
                if (this.invisibilityCounter > 0) {
                    --this.invisibilityCounter;
                }
                this.updateArmRotations();
                this.updateForwardRotation();
            }
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && this.func_70638_az() != null && this.invisibilityCooldown == 0) {
                this.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"invisibility"), 60, 2));
                this.invisibilityCooldown = 600;
            }
        }
        super.func_70071_h_();
    }

    public void func_70636_d() {
        float f;
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && !this.field_70128_L && (f = this.func_70013_c(1.0f)) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175710_j(this.func_180425_c())) {
            AMNetHandler.INSTANCE.sendHecateDeathToAllAround(this);
            this.func_70097_a(DamageSource.field_76370_b, 5000.0f);
        }
        super.func_70636_d();
    }

    private void spawnInvisibilityParticles() {
        this.hasSpawnedInvisParticles = true;
        this.invisibilityCooldown = 600;
    }

    public double getLeftArmOffset() {
        return this.leftArmRotationOffset;
    }

    public double getRightArmOffset() {
        return this.rightArmRotationOffset;
    }

    private void spawnLivingParticles() {
        if (this.field_70146_Z.nextInt(3) == 0) {
            AMParticle effect;
            double yPos = this.field_70163_u + 1.1;
            if ((double)this.currentForwardRotation >= 0.24) {
                yPos += 0.3;
            }
            if ((effect = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_70170_p, "smoke", this.field_70165_t + ((double)this.field_70146_Z.nextFloat() * 0.2 - (double)0.1f), yPos, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() * 0.4 - (double)0.2f)))) != null) {
                if ((double)this.currentForwardRotation < 0.24) {
                    effect.AddParticleController(new ParticleFloatUpward(effect, 0.1f, -0.06f, 1, false));
                } else {
                    effect.AddParticleController(new ParticleMoveOnHeading(effect, this.field_70177_z - 90.0f, this.field_70125_A, 0.01f, 1, false));
                }
                effect.AddParticleController(new ParticleFadeOut(effect, 2, false).setFadeSpeed(0.04f));
                effect.func_187114_a(25);
                effect.setIgnoreMaxAge(false);
                effect.setRGBColorF(0.3f, 0.3f, 0.3f);
            }
        }
    }

    private void updateArmRotations() {
        this.leftArmAnimTicks += 0.05;
        this.leftArmAnimTicks %= 90.0;
        this.rightArmAnimTicks += 0.05;
        this.rightArmAnimTicks %= 90.0;
        this.leftArmRotationOffset = Math.sin(this.leftArmAnimTicks) * 0.3;
        this.rightArmRotationOffset = Math.cos(this.rightArmAnimTicks) * 0.3;
    }

    protected void func_70628_a(boolean bool, int looting) {
        if (this.func_70681_au().nextInt(10) == 5) {
            this.func_70099_a(new ItemStack((Item)ItemDefs.essence, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.ENDER)), 0.0f);
        }
    }

    protected Item func_146068_u() {
        return null;
    }

    protected SoundEvent func_184601_bQ() {
        return AMSounds.HECATE_HIT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSounds.HECATE_DEATH;
    }

    protected SoundEvent func_184639_G() {
        return AMSounds.HECATE_IDLE;
    }

    private int getAverageNearbyPlayerMagicLevel() {
        if (this.field_70170_p == null) {
            return 0;
        }
        List players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(250.0, 250.0, 250.0));
        if (players.size() == 0) {
            return 0;
        }
        int avgLvl = 0;
        for (EntityPlayer player : players) {
            avgLvl += EntityExtension.For((EntityLivingBase)player).getCurrentLevel();
        }
        return (int)Math.ceil(avgLvl / players.size());
    }

    public boolean func_70601_bi() {
        if (!SpawnBlacklists.entityCanSpawnHere(this.func_180425_c(), this.field_70170_p, (EntityLivingBase)this)) {
            return false;
        }
        if (this.getAverageNearbyPlayerMagicLevel() < 20) {
            return false;
        }
        return super.func_70601_bi();
    }
}

