/*
 * Decompiled with CFR 0.152.
 */
package am2.entity;

import am2.ArsMagica2;
import am2.api.ArsMagicaAPI;
import am2.api.affinity.Affinity;
import am2.api.event.FlickerAffinityEvent;
import am2.api.math.AMVector3;
import am2.armor.ArmorHelper;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.particles.AMParticle;
import am2.particles.AMParticleDefs;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleMoveOnHeading;
import am2.utils.InventoryUtilities;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class EntityFlicker
extends EntityAmbientCreature {
    private static final DataParameter<Integer> WATCHER_FLICKERTYPE = EntityDataManager.func_187226_a(EntityFlicker.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> WATCHER_AMBIENTFLICK = EntityDataManager.func_187226_a(EntityFlicker.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final int DIRECTION_CHANGE_TIME = 200;
    private AMVector3 targetPosition = null;
    private AMVector3 normalizedMovementVector = AMVector3.zero();
    private int flickCount = 0;

    public EntityFlicker(World par1World) {
        super(par1World);
        this.func_70105_a(0.5f, 0.5f);
        this.setFlickerType((Affinity)ArsMagicaAPI.getAffinityRegistry().func_186801_a(this.func_70681_au()));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(WATCHER_FLICKERTYPE, (Object)0);
        this.field_70180_af.func_187214_a(WATCHER_AMBIENTFLICK, (Object)false);
    }

    public void func_70106_y() {
        ArsMagica2.proxy.decrementFlickerCount();
        super.func_70106_y();
    }

    public void setFlickerType(Affinity affinity) {
        this.field_70180_af.func_187227_b(WATCHER_FLICKERTYPE, (Object)ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)affinity));
    }

    public Affinity getFlickerAffinity() {
        return (Affinity)ArsMagicaAPI.getAffinityRegistry().getObjectById(((Integer)this.field_70180_af.func_187225_a(WATCHER_FLICKERTYPE)).intValue());
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        this.flick();
        return !par1DamageSource.func_76363_c();
    }

    public boolean func_145773_az() {
        return true;
    }

    public void func_180430_e(float par1, float par2) {
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70041_e_() {
        return false;
    }

    public void func_70020_e(NBTTagCompound par1nbtTagCompound) {
        ArsMagica2.proxy.incrementFlickerCount();
        super.func_70020_e(par1nbtTagCompound);
    }

    public void func_70071_h_() {
        AMParticle effect;
        super.func_70071_h_();
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        long time = this.field_70170_p.func_72820_D() % 24000L;
        if (!this.field_70170_p.field_72995_K && time >= 18500L && time <= 18600L) {
            this.func_70106_y();
            return;
        }
        boolean playerClose = false;
        AMVector3 me = new AMVector3((Entity)this);
        if (!this.field_70170_p.field_72995_K) {
            for (Object o : this.field_70170_p.field_73010_i) {
                AMVector3 aMVector3 = new AMVector3((Entity)((EntityPlayer)o));
                if (!(me.distanceSqTo(aMVector3) < 25.0)) continue;
                ItemStack chestArmor = ((EntityPlayer)o).func_184582_a(EntityEquipmentSlot.CHEST);
                if (chestArmor != null && ArmorHelper.isInfusionPreset(chestArmor, "fl_lure")) break;
                playerClose = true;
                break;
            }
        }
        if (this.field_70173_aa > 100 && playerClose && !((Boolean)this.field_70180_af.func_187225_a(WATCHER_AMBIENTFLICK)).booleanValue()) {
            if (this.func_70651_bq().size() == 0 || this.func_70651_bq().size() == 1 && this.field_70170_p.field_73012_v.nextDouble() < (double)0.1f) {
                this.field_70180_af.func_187227_b(WATCHER_AMBIENTFLICK, (Object)true);
            }
        } else if (((Boolean)this.field_70180_af.func_187225_a(WATCHER_AMBIENTFLICK)).booleanValue()) {
            ++this.flickCount;
            if (this.field_70170_p.field_72995_K && this.flickCount > 7) {
                this.flick();
            } else if (!this.field_70170_p.field_72995_K && this.flickCount > 10) {
                this.flick();
            }
        }
        if (this.field_70170_p.field_72995_K && this.func_70681_au().nextInt(10) < ArsMagica2.config.getGFXLevel() && (effect = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_70170_p, AMParticleDefs.getParticleForAffinity(this.getFlickerAffinity()), this.field_70165_t, this.field_70163_u, this.field_70161_v))) != null) {
            effect.addRandomOffset(this.field_70130_N, this.field_70131_O, this.field_70130_N);
            effect.setDontRequireControllers();
            effect.func_187114_a(10);
            if (this.getFlickerAffinity() == Affinity.EARTH) {
                effect.setParticleScale(0.01f + this.field_70146_Z.nextFloat() * 0.05f);
            } else {
                effect.setParticleScale(0.05f + this.field_70146_Z.nextFloat() * 0.05f);
            }
        }
    }

    protected void func_70619_bc() {
        boolean needsNewPath;
        super.func_70619_bc();
        AMVector3 me = new AMVector3((Entity)this);
        boolean bl = needsNewPath = this.targetPosition == null || this.field_70173_aa % 200 == 0;
        if (needsNewPath && this.field_70170_p.field_73012_v.nextDouble() < (double)0.1f) {
            this.pickNewTargetPosition();
        }
        if (this.targetPosition == null) {
            return;
        }
        if (me.distanceSqTo(this.targetPosition) > 400.0) {
            this.targetPosition = null;
            return;
        }
        if (me.distanceSqTo(this.targetPosition) < 1.0) {
            this.targetPosition = null;
            return;
        }
        this.field_70177_z = AMVector3.anglePreNorm(me, this.targetPosition);
        this.normalizedMovementVector = me.copy().sub(this.targetPosition).normalize();
        if (this.normalizedMovementVector.y > 0.0f) {
            this.rotatePitchTowards(-70.0f * this.normalizedMovementVector.y, 30.0f);
        } else {
            this.rotatePitchTowards(0.0f, 30.0f);
        }
        float speed = 0.2f;
        this.func_70024_g(-this.normalizedMovementVector.x * speed, -this.normalizedMovementVector.y * speed, -this.normalizedMovementVector.z * speed);
    }

    public AMVector3 getNormalizedMovement() {
        return this.normalizedMovementVector;
    }

    private void rotatePitchTowards(float p, float step) {
        if (this.field_70125_A != p) {
            if (step > 0.0f && this.field_70125_A + step > p) {
                step = p - this.field_70125_A;
            } else if (step < 0.0f && this.field_70125_A + step < p) {
                step = p - this.field_70125_A;
            }
            this.field_70125_A += step;
        }
    }

    private void flick() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 10 * ArsMagica2.config.getGFXLevel(); ++i) {
                AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_70170_p, "radiant", this.field_70165_t, this.field_70163_u, this.field_70161_v));
                if (particle == null) continue;
                particle.AddParticleController(new ParticleMoveOnHeading(particle, this.field_70170_p.field_73012_v.nextDouble() * 360.0, this.field_70170_p.field_73012_v.nextDouble() * 360.0, this.field_70170_p.field_73012_v.nextDouble() * (double)0.3f + (double)0.01f, 1, false));
                particle.setRGBColorI(this.getFlickerAffinity().getColor());
                particle.AddParticleController(new ParticleFadeOut(particle, 1, false).setFadeSpeed((float)(this.field_70170_p.field_73012_v.nextDouble() * 0.1 + 0.05)).setKillParticleOnFinish(true));
                particle.setIgnoreMaxAge(true);
                particle.setParticleScale(0.1f);
            }
        } else {
            this.func_70106_y();
        }
    }

    private void pickNewTargetPosition() {
        int groundLevel = 0;
        Affinity aff = this.getFlickerAffinity();
        for (int x = -5; x <= 5; ++x) {
            for (int y = 0; y <= 5; ++y) {
                for (int z = 0; z <= 5; ++z) {
                    if (this.field_70170_p.func_180495_p(this.func_180425_c().func_177982_a(x, y, z)).func_177230_c() != BlockDefs.flickerLure) continue;
                    BlockPos pos = this.func_180425_c().func_177982_a(x, y, z);
                    groundLevel = this.getTopBlockNearMe();
                    this.targetPosition = new AMVector3(pos.func_177958_n() + this.field_70170_p.field_73012_v.nextInt(5) - 2, groundLevel + this.field_70170_p.field_73012_v.nextInt(3), pos.func_177956_o() + this.field_70170_p.field_73012_v.nextInt(5) - 2);
                    return;
                }
            }
        }
        if (aff == Affinity.WATER) {
            for (int i = 0; i < 5; ++i) {
                this.targetPosition = new AMVector3(this.field_70165_t - 5.0 + (double)this.field_70170_p.field_73012_v.nextInt(10), this.field_70163_u - 5.0 + (double)this.field_70170_p.field_73012_v.nextInt(10), this.field_70161_v - 5.0 + (double)this.field_70170_p.field_73012_v.nextInt(10));
                Block block = this.field_70170_p.func_180495_p(this.targetPosition.toBlockPos()).func_177230_c();
                if (block != Blocks.field_150355_j && block != Blocks.field_150358_i) {
                    continue;
                }
                break;
            }
        } else if (aff == Affinity.AIR) {
            groundLevel = this.getTopBlockNearMe();
            this.targetPosition = new AMVector3(this.field_70165_t - 5.0 + (double)this.field_70170_p.field_73012_v.nextInt(10), groundLevel + 10 + this.field_70170_p.field_73012_v.nextInt(15), this.field_70161_v - 5.0 + (double)this.field_70170_p.field_73012_v.nextInt(10));
        } else if (aff == Affinity.EARTH) {
            groundLevel = this.getTopBlockNearMe();
            this.targetPosition = new AMVector3(this.field_70165_t - 5.0 + (double)this.field_70170_p.field_73012_v.nextInt(10), groundLevel + this.field_70170_p.field_73012_v.nextInt(1) + 1, this.field_70161_v - 5.0 + (double)this.field_70170_p.field_73012_v.nextInt(10));
        } else {
            groundLevel = this.getTopBlockNearMe();
            this.targetPosition = new AMVector3(this.field_70165_t - 5.0 + (double)this.field_70170_p.field_73012_v.nextInt(10), groundLevel + 3 + this.field_70170_p.field_73012_v.nextInt(5), this.field_70161_v - 5.0 + (double)this.field_70170_p.field_73012_v.nextInt(10));
        }
    }

    private int getTopBlockNearMe() {
        BlockPos checkPos = this.func_180425_c();
        while (checkPos.func_177956_o() > 0 && this.field_70170_p.func_175623_d(checkPos)) {
            checkPos = checkPos.func_177977_b();
        }
        while (checkPos.func_177956_o() < this.field_70170_p.func_72940_L() && !this.field_70170_p.func_175623_d(checkPos)) {
            checkPos = checkPos.func_177984_a();
        }
        return checkPos.func_177956_o();
    }

    public void func_70014_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70014_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a("flickerType", ((Integer)this.field_70180_af.func_187225_a(WATCHER_FLICKERTYPE)).intValue());
    }

    public void func_70037_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70037_a(par1nbtTagCompound);
        this.field_70180_af.func_187227_b(WATCHER_FLICKERTYPE, (Object)par1nbtTagCompound.func_74762_e("flickerType"));
        ArsMagica2.proxy.incrementFlickerCount();
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, ItemStack stack, EnumHand hand) {
        if (stack != null && stack.func_77973_b() == ItemDefs.flickerJar && !this.field_70128_L) {
            if (stack.func_77952_i() == 0) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                    InventoryUtilities.decrementStackQuantity((IInventory)player.field_71071_by, player.field_71071_by.field_70461_c, 1);
                    ItemStack newStack = new ItemStack((Item)ItemDefs.flickerJar);
                    ItemDefs.flickerJar.setFlickerJarTypeFromFlicker(newStack, this);
                    if (!InventoryUtilities.mergeIntoInventory((IInventory)player.field_71071_by, newStack) && !this.field_70170_p.field_72995_K) {
                        player.func_145779_a(newStack.func_77973_b(), newStack.func_77952_i());
                    }
                }
                return EnumActionResult.SUCCESS;
            }
            this.flick();
        }
        return EnumActionResult.PASS;
    }

    public boolean func_70601_bi() {
        if (ArsMagica2.proxy.getTotalFlickerCount() > 12 * this.field_70170_p.field_73010_i.size() || this.field_70170_p.field_73012_v.nextDouble() > (double)0.2f) {
            return false;
        }
        Biome biome = this.func_130014_f_().func_180494_b(this.func_180425_c());
        if (biome != null) {
            BiomeDictionary.Type[] biomeTags = BiomeDictionary.getTypesForBiome((Biome)biome);
            BiomeDictionary.Type tagType = biomeTags[this.field_70170_p.field_73012_v.nextInt(biomeTags.length)];
            ArrayList<Affinity> validAffinities = new ArrayList<Affinity>();
            switch (tagType) {
                case DEAD: 
                case END: {
                    validAffinities.add(Affinity.ENDER);
                    break;
                }
                case PLAINS: 
                case FOREST: 
                case CONIFEROUS: 
                case JUNGLE: {
                    validAffinities.add(Affinity.NATURE);
                    break;
                }
                case COLD: 
                case SNOWY: {
                    validAffinities.add(Affinity.ICE);
                    break;
                }
                case MAGICAL: {
                    validAffinities.add(Affinity.ARCANE);
                    break;
                }
                case DRY: 
                case HOT: 
                case SAVANNA: 
                case NETHER: {
                    validAffinities.add(Affinity.FIRE);
                    break;
                }
                case OCEAN: {
                    validAffinities.add(Affinity.LIGHTNING);
                }
                case SWAMP: 
                case WATER: 
                case RIVER: 
                case WET: 
                case BEACH: {
                    validAffinities.add(Affinity.WATER);
                    break;
                }
            }
            if (this.field_70163_u < 55.0) {
                validAffinities.add(Affinity.EARTH);
            }
            if (this.field_70170_p.func_175710_j(this.func_180425_c())) {
                validAffinities.add(Affinity.AIR);
            }
            if (this.field_70170_p.func_72896_J() && this.field_70170_p.field_73012_v.nextBoolean()) {
                validAffinities.clear();
                validAffinities.add(Affinity.LIGHTNING);
            }
            if (validAffinities.size() <= 0) {
                return false;
            }
            if (this.field_70170_p.field_73011_w.getDimension() == 1) {
                validAffinities.clear();
                validAffinities.add(Affinity.ENDER);
            }
            MinecraftForge.EVENT_BUS.post((Event)new FlickerAffinityEvent(validAffinities, this, biome));
            if (this.field_70170_p.field_73012_v.nextDouble() < (double)0.1f) {
                this.setFlickerType(Affinity.LIFE);
            } else {
                this.setFlickerType(validAffinities.get(this.field_70170_p.field_73012_v.nextInt(validAffinities.size())));
            }
            if (this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this)) {
                ArsMagica2.proxy.incrementFlickerCount();
                return true;
            }
        }
        return false;
    }
}

