/*
 * Decompiled with CFR 0.152.
 */
package am2.defs;

import am2.LogHelper;
import am2.buffs.BuffEffect;
import am2.buffs.BuffEffectAgility;
import am2.buffs.BuffEffectAstralDistortion;
import am2.buffs.BuffEffectBurnoutReduction;
import am2.buffs.BuffEffectCharmed;
import am2.buffs.BuffEffectClarity;
import am2.buffs.BuffEffectEntangled;
import am2.buffs.BuffEffectFlight;
import am2.buffs.BuffEffectFrostSlowed;
import am2.buffs.BuffEffectFury;
import am2.buffs.BuffEffectGravityWell;
import am2.buffs.BuffEffectHaste;
import am2.buffs.BuffEffectIllumination;
import am2.buffs.BuffEffectInstantMana;
import am2.buffs.BuffEffectLeap;
import am2.buffs.BuffEffectLevitation;
import am2.buffs.BuffEffectMagicShield;
import am2.buffs.BuffEffectManaRegen;
import am2.buffs.BuffEffectRegeneration;
import am2.buffs.BuffEffectScrambleSynapses;
import am2.buffs.BuffEffectShield;
import am2.buffs.BuffEffectShrink;
import am2.buffs.BuffEffectSilence;
import am2.buffs.BuffEffectSlowfall;
import am2.buffs.BuffEffectSpellReflect;
import am2.buffs.BuffEffectSwiftSwim;
import am2.buffs.BuffEffectTemporalAnchor;
import am2.buffs.BuffEffectTrueSight;
import am2.buffs.BuffEffectWaterBreathing;
import am2.buffs.BuffEffectWateryGrave;
import am2.buffs.BuffMaxManaIncrease;
import am2.defs.AMPotion;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class PotionEffectsDefs {
    public static final HashMap<Potion, Class<? extends BuffEffect>> classForId = new HashMap();
    public static Potion agility;
    public static Potion astralDistortion;
    public static Potion burnoutReduction;
    public static Potion charme;
    public static Potion clarity;
    public static Potion entangle;
    public static Potion flight;
    public static Potion frostSlow;
    public static Potion fury;
    public static Potion gravityWell;
    public static Potion haste;
    public static Potion illumination;
    public static Potion instantMana;
    public static Potion leap;
    public static Potion levitation;
    public static Potion magicShield;
    public static Potion manaRegen;
    public static Potion regeneration;
    public static Potion scrambleSynapses;
    public static Potion shield;
    public static Potion shrink;
    public static Potion silence;
    public static Potion slowfall;
    public static Potion spellReflect;
    public static Potion swiftSwim;
    public static Potion temporalAnchor;
    public static Potion trueSight;
    public static Potion waterBreathing;
    public static Potion wateryGrave;
    public static Potion manaBoost;
    public static final int default_buff_duration = 600;

    public static void init() {
        agility = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:agility"), false, 11395072, 0, 0, BuffEffectAgility.class);
        astralDistortion = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:astral_distortion"), true, 0x6C0000, 0, 4, BuffEffectAstralDistortion.class);
        burnoutReduction = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:burnout_reduction"), false, 0xCC0000, 1, 1, BuffEffectBurnoutReduction.class);
        charme = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:charme"), true, 16727202, 3, 2, BuffEffectCharmed.class);
        clarity = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:clarity"), false, 0xBBFFFF, 0, 5, BuffEffectClarity.class);
        entangle = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:entangle"), false, 37632, 3, 7, BuffEffectEntangled.class);
        flight = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:flight"), false, 13032154, 2, 1, BuffEffectFlight.class);
        frostSlow = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:frost_slow"), true, 0x1FFFDD, 3, 3, BuffEffectFrostSlowed.class);
        fury = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:fury"), true, 16744499, 3, 6, BuffEffectFury.class);
        gravityWell = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:gravity_well"), true, 10748159, 0, 6, BuffEffectGravityWell.class);
        haste = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:haste"), false, 0xF1F1F1, 2, 3, BuffEffectHaste.class);
        illumination = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:illumination"), false, 0xFFFFBE, 1, 0, BuffEffectIllumination.class);
        instantMana = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:instant_mana"), false, 65535, 0, 0, BuffEffectInstantMana.class);
        leap = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:leap"), false, 65280, 0, 2, BuffEffectLeap.class);
        levitation = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:levitation"), false, 14123263, 0, 7, BuffEffectLevitation.class);
        magicShield = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:magic_shield"), false, 14123263, 3, 1, BuffEffectMagicShield.class);
        manaRegen = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:mana_regen"), false, 0x8BFFFF, 3, 5, BuffEffectManaRegen.class);
        regeneration = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:regeneration"), false, 0xFF00FF, 2, 6, BuffEffectRegeneration.class);
        scrambleSynapses = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:scramble_synapses"), true, 0x306600, 3, 7, BuffEffectScrambleSynapses.class);
        shield = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:shield"), false, 0xC4C4C4, 0, 0, BuffEffectShield.class);
        shrink = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:shrink"), false, 221, 0, 5, BuffEffectShrink.class);
        silence = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:silence"), true, 0xC1C1FF, 4, 6, BuffEffectSilence.class);
        slowfall = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:slowfall"), false, 0xE3FFE3, 2, 2, BuffEffectSlowfall.class);
        spellReflect = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:spell_reflect"), false, 0xADFFFF, 4, 3, BuffEffectSpellReflect.class);
        swiftSwim = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:swift_swim"), false, 0x3B3BFF, 4, 7, BuffEffectSwiftSwim.class);
        temporalAnchor = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:temporal_anchor"), false, 0xA2A2A2, 3, 4, BuffEffectTemporalAnchor.class);
        trueSight = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:true_sight"), false, 12845311, 2, 4, BuffEffectTrueSight.class);
        waterBreathing = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:water_breathing"), false, 255, 2, 0, BuffEffectWaterBreathing.class);
        wateryGrave = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:watery_grave"), true, 162, 4, 0, BuffEffectWateryGrave.class);
        manaBoost = PotionEffectsDefs.createPotion(new ResourceLocation("arsmagica2:mana_boost"), false, 37887, 3, 0, BuffMaxManaIncrease.class);
    }

    public static Potion createPotion(ResourceLocation loc, boolean isBad, int color, int posX, int posY, Class<? extends BuffEffect> clazz) {
        Potion potion = new AMPotion(isBad, color).func_76399_b(posX, posY).func_76390_b(loc.toString());
        GameRegistry.register((IForgeRegistryEntry)potion, (ResourceLocation)loc);
        classForId.put(potion, clazz);
        return potion;
    }

    public static PotionEffect getEffect(PotionEffect effect) {
        Class<? extends BuffEffect> clazz = classForId.get(effect.func_188419_a());
        if (clazz == null) {
            return null;
        }
        if (effect instanceof BuffEffect) {
            return null;
        }
        try {
            Constructor<? extends BuffEffect> constr;
            try {
                constr = clazz.getDeclaredConstructor(Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                Constructor<? extends BuffEffect> constr2 = clazz.getDeclaredConstructor(Potion.class, Integer.TYPE, Integer.TYPE);
                return constr2.newInstance(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c());
            }
            return constr.newInstance(effect.func_76459_b(), effect.func_76458_c());
        }
        catch (NoSuchMethodException e) {
            LogHelper.warn("Wrong definition for : " + clazz.getName(), new Object[0]);
        }
        catch (SecurityException e) {
            LogHelper.warn("Is this even a thing ? (SecurityException:" + clazz.getName() + ")", new Object[0]);
        }
        catch (InstantiationException e) {
            LogHelper.warn("Could not create : " + clazz.getName(), new Object[0]);
        }
        catch (IllegalAccessException e) {
            LogHelper.warn("Could not access : " + clazz.getName(), new Object[0]);
        }
        catch (IllegalArgumentException e) {
            LogHelper.warn("Could not create : " + clazz.getName(), new Object[0]);
        }
        catch (InvocationTargetException e) {
            LogHelper.warn("InvocationTargetException" + clazz.getName(), new Object[0]);
        }
        catch (NullPointerException e) {
            LogHelper.warn("This should never be a thing : NullPointerExecption at " + clazz.getName(), new Object[0]);
        }
        return null;
    }
}

