/*
 * Decompiled with CFR 0.152.
 */
package am2.buffs;

import am2.api.extensions.IEntityExtension;
import am2.buffs.BuffEffect;
import am2.defs.PotionEffectsDefs;
import am2.extensions.EntityExtension;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;

public class BuffEffectTemporalAnchor
extends BuffEffect {
    private double x;
    private double y;
    private double z;
    private float rotationPitch;
    private float rotationYaw;
    private float rotationYawHead;
    private float mana;
    private float health;

    public BuffEffectTemporalAnchor(int duration, int amplifier) {
        super(PotionEffectsDefs.temporalAnchor, duration, amplifier);
    }

    @Override
    public void applyEffect(EntityLivingBase entityliving) {
        this.x = entityliving.field_70165_t;
        this.y = entityliving.field_70163_u;
        this.z = entityliving.field_70161_v;
        this.rotationPitch = entityliving.field_70125_A;
        this.rotationYaw = entityliving.field_70177_z;
        this.rotationYawHead = entityliving.field_70759_as;
        this.health = entityliving.func_110143_aJ();
        this.mana = ((IEntityExtension)entityliving.getCapability(EntityExtension.INSTANCE, null)).getCurrentMana();
    }

    @Override
    public void stopEffect(EntityLivingBase entityliving) {
        entityliving.func_70634_a(this.x, this.y, this.z);
        entityliving.func_70082_c(this.rotationYaw, this.rotationPitch);
        entityliving.field_70759_as = this.rotationYawHead;
        ((IEntityExtension)entityliving.getCapability(EntityExtension.INSTANCE, null)).setCurrentMana(this.mana);
        entityliving.func_70606_j(this.health);
        entityliving.field_70143_R = 0.0f;
    }

    @Override
    protected String spellBuffName() {
        return "Temporal Anchor";
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        nbt.func_74780_a("X", this.x);
        nbt.func_74780_a("Y", this.y);
        nbt.func_74780_a("Z", this.z);
        nbt.func_74776_a("RotationPitch", this.rotationPitch);
        nbt.func_74776_a("RotationYaw", this.rotationYaw);
        nbt.func_74776_a("RotationYawHead", this.rotationYawHead);
        nbt.func_74776_a("Mana", this.mana);
        nbt.func_74776_a("Health", this.health);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        this.x = nbt.func_74769_h("X");
        this.y = nbt.func_74769_h("Y");
        this.z = nbt.func_74769_h("Z");
        this.rotationPitch = nbt.func_74760_g("RotationPitch");
        this.rotationYaw = nbt.func_74760_g("RotationYaw");
        this.rotationYawHead = nbt.func_74760_g("RotationYawHead");
        this.health = nbt.func_74760_g("Health");
        this.mana = nbt.func_74762_e("Mana");
    }
}

