/*
 * Decompiled with CFR 0.152.
 */
package am2.buffs;

import am2.buffs.BuffEffect;
import am2.defs.PotionEffectsDefs;
import am2.utils.EntityUtils;
import java.util.UUID;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class BuffEffectCharmed
extends BuffEffect {
    public static final int CHARM_TO_PLAYER = 1;
    public static final int CHARM_TO_MONSTER = 2;
    private EntityLivingBase charmer;

    public BuffEffectCharmed(int duration, int amplifier) {
        super(PotionEffectsDefs.charme, duration, amplifier);
    }

    public void setCharmer(EntityLivingBase entity) {
        this.charmer = entity;
    }

    @Override
    public void applyEffect(EntityLivingBase entityliving) {
        if (this.func_76458_c() == 1 && entityliving instanceof EntityCreature && this.charmer instanceof EntityPlayer) {
            EntityUtils.makeSummon_PlayerFaction((EntityCreature)entityliving, (EntityPlayer)this.charmer, true);
        } else if (this.func_76458_c() == 2 && entityliving instanceof EntityCreature) {
            EntityUtils.makeSummon_MonsterFaction((EntityCreature)entityliving, true);
        }
        EntityUtils.setOwner(entityliving, this.charmer);
        EntityUtils.setSummonDuration(entityliving, -1);
    }

    @Override
    public void stopEffect(EntityLivingBase entityliving) {
        if (entityliving instanceof EntityCreature) {
            EntityUtils.revertAI((EntityCreature)entityliving);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("Charmer", this.charmer.func_110124_au().toString());
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        try {
            this.charmer = (EntityLivingBase)FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[0].func_175733_a(UUID.fromString(nbt.func_74779_i("Charmer")));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected String spellBuffName() {
        return "Charmed";
    }
}

