/*
 * Decompiled with CFR 0.152.
 */
package am2.buffs;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.translation.I18n;

public abstract class BuffEffect
extends PotionEffect {
    protected boolean InitialApplication = true;
    protected boolean HasNotified;

    public BuffEffect(Potion buffID, int duration, int amplifier) {
        super(buffID, duration, amplifier);
        this.HasNotified = duration / 20 <= 5;
    }

    public boolean shouldNotify() {
        return true;
    }

    public abstract void applyEffect(EntityLivingBase var1);

    public abstract void stopEffect(EntityLivingBase var1);

    private void effectEnding(EntityLivingBase entityliving) {
        this.stopEffect(entityliving);
    }

    public void func_76457_b(EntityLivingBase entityliving) {
    }

    public void func_76452_a(PotionEffect potioneffect) {
        if (!(potioneffect instanceof BuffEffect)) {
            return;
        }
        int thisAmplifier = this.func_76458_c();
        if (thisAmplifier >= potioneffect.func_76458_c()) {
            super.func_76452_a(potioneffect);
            this.HasNotified = false;
        }
    }

    public boolean func_76455_a(EntityLivingBase entityliving) {
        boolean bool = super.func_76455_a(entityliving);
        if (this.InitialApplication) {
            this.InitialApplication = false;
            this.applyEffect(entityliving);
        } else if (this.func_76459_b() == 1) {
            this.effectEnding(entityliving);
        } else if (this.func_76459_b() / 20 < 5 && !this.HasNotified && this.shouldNotify() && !entityliving.field_70170_p.field_72995_K) {
            this.HasNotified = true;
        }
        this.func_76457_b(entityliving);
        return bool;
    }

    public boolean isReady(int i, int j) {
        int k = 25 >> j;
        if (k > 0) {
            return i % k == 0;
        }
        return true;
    }

    protected abstract String spellBuffName();

    public String func_76453_d() {
        return I18n.func_74838_a((String)this.func_188419_a().getRegistryName().toString());
    }

    public final NBTTagCompound func_82719_a(NBTTagCompound nbt) {
        nbt.func_74757_a("InitialApplication", this.InitialApplication);
        nbt.func_74757_a("HasNotified", this.HasNotified);
        this.writeCustomNBT(nbt);
        return super.func_82719_a(nbt);
    }

    public void writeCustomNBT(NBTTagCompound nbt) {
    }

    public final void readFromNBT(NBTTagCompound nbt) {
        this.InitialApplication = nbt.func_74767_n("InitialApplication");
        this.HasNotified = nbt.func_74767_n("HasNotified");
        this.readCustomNBT(nbt);
    }

    public void readCustomNBT(NBTTagCompound nbt) {
    }
}

