/*
 * Decompiled with CFR 0.152.
 */
package am2.bosses;

import am2.ArsMagica2;
import am2.api.ArsMagicaAPI;
import am2.api.DamageSources;
import am2.api.affinity.Affinity;
import am2.api.sources.DamageSourceFire;
import am2.api.sources.DamageSourceFrost;
import am2.bosses.AM2Boss;
import am2.bosses.BossActions;
import am2.bosses.ai.EntityAICastSpell;
import am2.bosses.ai.EntityAIPlantGuardianThrowSickle;
import am2.bosses.ai.EntityAIShieldBash;
import am2.bosses.ai.EntityAISpinAttack;
import am2.bosses.ai.EntityAIStrikeAttack;
import am2.bosses.ai.ISpellCastCallback;
import am2.defs.AMSounds;
import am2.defs.ItemDefs;
import am2.packet.AMNetHandler;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import am2.particles.ParticleOrbitEntity;
import am2.utils.NPCSpells;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class EntityNatureGuardian
extends AM2Boss {
    public float tendrilRotation;
    public boolean hasSickle;
    public float last_rotation_z_main = 0.0f;
    public float last_rotation_z_shield = 0.0f;
    public float last_rotation_x_main = 0.0f;
    public float last_rotation_x_shield = 0.0f;
    public float last_rotation_y_main = 0.0f;
    public float last_rotation_y_shield = 0.0f;
    public float spinRotation = 0.0f;

    public EntityNatureGuardian(World par1World) {
        super(par1World);
        this.func_70105_a(1.65f, 4.75f);
        this.hasSickle = true;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(500.0);
    }

    @Override
    protected void initSpecificAI() {
        this.field_70714_bg.func_75776_a(1, new EntityAICastSpell<EntityNatureGuardian>(this, NPCSpells.instance.dispel, 16, 23, 50, BossActions.CASTING, new ISpellCastCallback<EntityNatureGuardian>(){

            @Override
            public boolean shouldCast(EntityNatureGuardian host, ItemStack spell) {
                return host.func_70651_bq().size() > 0;
            }
        }));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIPlantGuardianThrowSickle(this, 0.75f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAISpinAttack(this, 0.5f, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIStrikeAttack(this, 0.75f, 12.0f, DamageSources.DamageSourceTypes.CACTUS));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIShieldBash(this, 0.75f));
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            this.updateMovementAngles();
            this.spawnParticles();
        }
        super.func_70071_h_();
    }

    public int func_70658_aO() {
        return 20;
    }

    private void spawnParticles() {
        AMParticle leaf = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_70170_p, "leaf", this.field_70165_t + this.field_70146_Z.nextDouble() * 3.0 - 1.5, this.field_70163_u + this.field_70146_Z.nextDouble() * 5.0, this.field_70161_v + this.field_70146_Z.nextDouble() * 3.0 - 1.5));
        if (leaf != null) {
            leaf.func_187114_a(20);
            leaf.setIgnoreMaxAge(false);
            leaf.AddParticleController(new ParticleFloatUpward(leaf, 0.05f, -0.02f, 1, false));
            if (this.getCurrentAction() == BossActions.SPINNING) {
                leaf.AddParticleController(new ParticleOrbitEntity(leaf, (Entity)this, 0.6f, 1, false));
            }
        }
    }

    @Override
    public void setCurrentAction(BossActions action) {
        super.setCurrentAction(action);
        this.spinRotation = 0.0f;
        if (!this.field_70170_p.field_72995_K) {
            AMNetHandler.INSTANCE.sendActionUpdateToAllAround(this);
        }
    }

    private void updateMovementAngles() {
        this.tendrilRotation += 0.2f;
        this.tendrilRotation %= 360.0f;
        switch (this.currentAction) {
            case IDLE: {
                break;
            }
            case SPINNING: {
                this.spinRotation = (this.spinRotation - 40.0f) % 360.0f;
                break;
            }
            case STRIKE: {
                break;
            }
            case THROWING_SICKLE: {
                break;
            }
        }
    }

    public ItemStack func_184586_b(EnumHand hand) {
        return null;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
    }

    @Override
    public boolean isActionValid(BossActions action) {
        if (action == BossActions.STRIKE || action == BossActions.SPINNING || action == BossActions.THROWING_SICKLE) {
            return this.hasSickle;
        }
        return true;
    }

    protected void func_70628_a(boolean par1, int par2) {
        if (par1) {
            this.func_70099_a(new ItemStack((Item)ItemDefs.infinityOrb, 1, 2), 0.0f);
        }
        int i = this.field_70146_Z.nextInt(4);
        for (int j = 0; j < i; ++j) {
            this.func_70099_a(new ItemStack((Item)ItemDefs.essence, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.NATURE)), 0.0f);
        }
        i = this.field_70146_Z.nextInt(10);
        if (i < 3 && par1) {
            this.func_70099_a(ItemDefs.natureScytheEnchanted.func_77946_l(), 0.0f);
        }
    }

    @Override
    protected float modifyDamageAmount(DamageSource source, float damageAmt) {
        if (source instanceof DamageSourceFire || source.func_76347_k()) {
            damageAmt *= 2.0f;
        } else if (source instanceof DamageSourceFrost) {
            damageAmt *= 1.5f;
        }
        return damageAmt;
    }

    protected SoundEvent func_184601_bQ() {
        return AMSounds.NATURE_GUARDIAN_HIT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSounds.NATURE_GUARDIAN_DEATH;
    }

    protected SoundEvent func_184639_G() {
        return AMSounds.NATURE_GUARDIAN_IDLE;
    }

    @Override
    public SoundEvent getAttackSound() {
        return AMSounds.NATURE_GUARDIAN_ATTACK;
    }

    @Override
    protected BossInfo.Color getBarColor() {
        return BossInfo.Color.RED;
    }
}

