/*
 * Decompiled with CFR 0.152.
 */
package am2.bosses;

import am2.ArsMagica2;
import am2.api.ArsMagicaAPI;
import am2.api.DamageSources;
import am2.api.affinity.Affinity;
import am2.api.sources.DamageSourceFrost;
import am2.bosses.AM2Boss;
import am2.bosses.BossActions;
import am2.bosses.ai.EntityAICastSpell;
import am2.bosses.ai.EntityAIDispel;
import am2.bosses.ai.EntityAIDive;
import am2.bosses.ai.EntityAIFireRain;
import am2.bosses.ai.EntityAIFlamethrower;
import am2.defs.AMSounds;
import am2.defs.ItemDefs;
import am2.packet.AMNetHandler;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import am2.particles.ParticleHoldPosition;
import am2.particles.ParticleLeaveParticleTrail;
import am2.particles.ParticleMoveOnHeading;
import am2.particles.ParticleOrbitEntity;
import am2.utils.NPCSpells;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class EntityFireGuardian
extends AM2Boss {
    private boolean isUnderground = false;
    private int hitCount = 0;

    public EntityFireGuardian(World par1World) {
        super(par1World);
        this.func_70105_a(1.0f, 4.0f);
        this.field_70178_ae = true;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(250.0);
    }

    public int func_70658_aO() {
        return 17;
    }

    @Override
    protected void initSpecificAI() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFireRain(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIDispel(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIDive(this));
        this.field_70714_bg.func_75776_a(2, new EntityAICastSpell<EntityFireGuardian>(this, NPCSpells.instance.meltArmor, 12, 23, 40, BossActions.CASTING));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFlamethrower(this));
        this.field_70714_bg.func_75776_a(4, new EntityAICastSpell<EntityFireGuardian>(this, NPCSpells.instance.fireBolt, 12, 23, 5, BossActions.CASTING));
    }

    public boolean getIsUnderground() {
        return this.isUnderground;
    }

    @Override
    public void setCurrentAction(BossActions action) {
        super.setCurrentAction(action);
        if (action == BossActions.SPINNING) {
            this.func_70024_g(0.0, 1.5, 0.0);
        } else {
            this.hitCount = 0;
            this.isUnderground = false;
        }
        if (!this.field_70170_p.field_72995_K) {
            AMNetHandler.INSTANCE.sendActionUpdateToAllAround(this);
        }
    }

    private void nova() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 36; ++i) {
                AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_70170_p, "explosion_2", this.field_70165_t, this.field_70163_u - 3.0, this.field_70161_v));
                if (particle == null) continue;
                particle.AddParticleController(new ParticleMoveOnHeading(particle, i * 10, this.field_70146_Z.nextInt(20) - 10, 0.2f, 1, false));
                particle.AddParticleController(new ParticleLeaveParticleTrail(particle, "explosion_2", false, 10, 1, false).setTicksBetweenSpawns(1).setParticleRGB_F(1.0f, 1.0f, 1.0f).addControllerToParticleList(new ParticleHoldPosition(particle, 10, 1, false)));
                particle.func_187114_a(20);
                particle.setParticleScale(0.5f);
                particle.setIgnoreMaxAge(false);
            }
        } else {
            List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(2.5, 2.5, 2.5).func_72321_a(0.0, -3.0, 0.0));
            for (EntityLivingBase ent : entities) {
                if (ent == this) continue;
                ent.func_70097_a((DamageSource)DamageSources.causeFireDamage((EntityLivingBase)this), 5.0f);
            }
        }
    }

    private void flamethrower() {
        Vec3d look = this.func_70676_i(1.0f);
        if (this.field_70170_p.field_72995_K) {
            AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_70170_p, "explosion_2", this.field_70165_t + Math.cos(Math.toRadians(this.field_70761_aq + 90.0f)) * 2.0, this.field_70163_u + 3.0, this.field_70161_v + Math.sin(Math.toRadians(this.field_70761_aq + 90.0f)) * 2.0));
            if (particle != null) {
                particle.AddParticleController(new ParticleMoveOnHeading(particle, this.field_70177_z + 90.0f + (float)this.field_70146_Z.nextInt(20) - 10.0f, this.field_70146_Z.nextInt(20) - 10, 0.2f, 1, false));
                particle.func_187114_a(40);
                particle.setParticleScale(0.5f);
                particle.setIgnoreMaxAge(false);
            }
        } else {
            List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(2.5, 2.5, 2.5).func_72321_a(look.field_72450_a * 3.0, 0.0, look.field_72449_c * 3.0));
            for (EntityLivingBase ent : entities) {
                if (ent == this) continue;
                ent.func_70097_a((DamageSource)DamageSources.causeFireDamage((EntityLivingBase)this), 5.0f);
            }
        }
    }

    private void doFlameShield() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        for (Object p : this.field_70170_p.field_73010_i) {
            EntityPlayer player = (EntityPlayer)p;
            if (!(this.func_70068_e((Entity)player) < 9.0)) continue;
            player.func_70097_a((DamageSource)DamageSources.causeFireDamage((EntityLivingBase)this), 2.0f);
        }
    }

    public boolean func_70027_ad() {
        return !this.isUnderground;
    }

    @Override
    public void func_70071_h_() {
        if (this.ticksInCurrentAction == 30 && this.currentAction == BossActions.SPINNING) {
            this.nova();
        }
        if (this.ticksInCurrentAction > 13 && this.currentAction == BossActions.LONG_CASTING) {
            if (this.func_70638_az() != null) {
                this.func_70625_a((Entity)this.func_70638_az(), 10.0f, 10.0f);
            }
            this.flamethrower();
        }
        this.doFlameShield();
        super.func_70071_h_();
    }

    public void func_180430_e(float par1, float par2) {
        if (this.getCurrentAction() == BossActions.SPINNING) {
            this.isUnderground = true;
            return;
        }
        super.func_180430_e(par1, par2);
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource.func_76347_k()) {
            AMParticle particle;
            this.func_70691_i(par2);
            if (this.field_70170_p.field_72995_K && (particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_70170_p, "sparkle", this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v))) != null) {
                particle.addRandomOffset(1.0, 1.0, 1.0);
                particle.AddParticleController(new ParticleFloatUpward(particle, 0.0f, 0.1f, 1, false));
                particle.AddParticleController(new ParticleOrbitEntity(particle, (Entity)this, 0.5, 2, false).setIgnoreYCoordinate(true).SetTargetDistance((double)0.3f + this.field_70146_Z.nextDouble() * 0.3));
                particle.func_187114_a(20);
                particle.setParticleScale(0.2f);
                particle.setRGBColorF(0.1f, 1.0f, 0.1f);
            }
            return false;
        }
        if (this.isUnderground && this.getCurrentAction() != BossActions.SPINNING) {
            return false;
        }
        if (this.getCurrentAction() == BossActions.SPINNING) {
            ++this.hitCount;
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    @Override
    protected float modifyDamageAmount(DamageSource source, float damageAmt) {
        if (source == DamageSource.field_76369_e) {
            damageAmt *= 2.0f;
        } else if (source instanceof DamageSourceFrost) {
            damageAmt /= 3.0f;
        }
        return damageAmt;
    }

    protected SoundEvent func_184601_bQ() {
        return AMSounds.FIRE_GUARDIAN_HIT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSounds.FIRE_GUARDIAN_DEATH;
    }

    protected SoundEvent func_184639_G() {
        return AMSounds.FIRE_GUARDIAN_IDLE;
    }

    @Override
    public SoundEvent getAttackSound() {
        return AMSounds.FIRE_GUARDIAN_ATTACK;
    }

    public int getNumHits() {
        return this.hitCount;
    }

    protected void func_70628_a(boolean par1, int par2) {
        if (par1) {
            this.func_70099_a(new ItemStack((Item)ItemDefs.infinityOrb, 1, 2), 0.0f);
        }
        int i = this.field_70146_Z.nextInt(4);
        for (int j = 0; j < i; ++j) {
            this.func_70099_a(new ItemStack((Item)ItemDefs.essence, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.FIRE)), 0.0f);
        }
        i = this.field_70146_Z.nextInt(10);
        if (i < 3 && par1) {
            this.func_70099_a(ItemDefs.fireEarsEnchanted.func_77946_l(), 0.0f);
        }
    }

    @Override
    protected BossInfo.Color getBarColor() {
        return BossInfo.Color.RED;
    }
}

