/*
 * Decompiled with CFR 0.152.
 */
package am2.bosses;

import am2.ArsMagica2;
import am2.api.ArsMagicaAPI;
import am2.api.DamageSources;
import am2.api.affinity.Affinity;
import am2.api.math.AMVector3;
import am2.bosses.AM2Boss;
import am2.bosses.BossActions;
import am2.bosses.ai.EntityAIEnderRush;
import am2.bosses.ai.EntityAIEnderbolt;
import am2.bosses.ai.EntityAIEndertorrent;
import am2.bosses.ai.EntityAIEnderwave;
import am2.bosses.ai.EntityAIOtherworldlyRoar;
import am2.bosses.ai.EntityAIProtect;
import am2.bosses.ai.EntityAIShadowstep;
import am2.defs.AMSounds;
import am2.defs.ItemDefs;
import am2.defs.PotionEffectsDefs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import thehippomaster.AnimationAPI.IAnimatedEntity;

public class EntityEnderGuardian
extends AM2Boss
implements IAnimatedEntity {
    private int wingFlapTime = 0;
    private int ticksSinceLastAttack = 0;
    private String lastDamageType = "";
    private int hitCount = 0;
    private AMVector3 spawn;
    private static final DataParameter<Integer> ATTACK_TARGET = EntityDataManager.func_187226_a(EntityEnderGuardian.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityEnderGuardian(World par1World) {
        super(par1World);
        this.func_70105_a(1.0f, 3.0f);
    }

    @Override
    protected void initSpecificAI() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIShadowstep(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIEnderwave(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIOtherworldlyRoar(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIProtect(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIEnderRush(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIEndertorrent(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIEnderbolt(this));
    }

    public int func_70658_aO() {
        return 16;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_TARGET, (Object)-1);
    }

    public float func_70047_e() {
        return 2.5f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(490.0);
    }

    @Override
    protected float modifyDamageAmount(DamageSource source, float damageAmt) {
        if (source.func_82725_o()) {
            damageAmt *= 2.0f;
        }
        return damageAmt;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.spawn == null) {
            this.spawn = new AMVector3((Entity)this);
        }
        ++this.wingFlapTime;
        ++this.ticksSinceLastAttack;
        if (this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.7999998927116394;
        }
        switch (this.getCurrentAction()) {
            case LONG_CASTING: {
                if (this.getTicksInCurrentAction() != 32) break;
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, AMSounds.ENDER_GUARDIAN_ROAR, SoundCategory.HOSTILE, 1.0f, 1.0f, false);
                break;
            }
            case CHARGE: {
                if (this.getTicksInCurrentAction() != 0) break;
                this.func_70024_g(0.0, 1.5, 0.0);
                break;
            }
        }
        if (this.shouldFlapWings() && (float)this.wingFlapTime % (50.0f * this.getWingFlapSpeed()) == 0.0f) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, AMSounds.ENDER_GUARDIAN_FLAP, SoundCategory.HOSTILE, 1.0f, 1.0f, false);
        }
    }

    public int getTicksSinceLastAttack() {
        return this.ticksSinceLastAttack;
    }

    public void func_70624_b(EntityLivingBase par1EntityLivingBase) {
        super.func_70624_b(par1EntityLivingBase);
        if (!this.field_70170_p.field_72995_K) {
            if (par1EntityLivingBase != null) {
                this.field_70180_af.func_187227_b(ATTACK_TARGET, (Object)par1EntityLivingBase.func_145782_y());
            } else {
                this.field_70180_af.func_187227_b(ATTACK_TARGET, (Object)-1);
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource.func_76364_f() instanceof EntityEnderman) {
            ((EntityEnderman)par1DamageSource.func_76364_f()).func_70097_a((DamageSource)DamageSources.wtfBoom, 5000.0f);
            this.func_70691_i(10.0f);
            return false;
        }
        if (par1DamageSource.field_76373_n.equals("outOfWorld")) {
            if (this.spawn != null) {
                this.func_70107_b(this.spawn.x, this.spawn.y, this.spawn.z);
                this.setCurrentAction(BossActions.IDLE);
                if (!this.field_70170_p.field_72995_K) {
                    ArsMagica2.proxy.addDeferredTargetSet((EntityLiving)this, null);
                }
            } else {
                this.func_70106_y();
            }
            return false;
        }
        this.ticksSinceLastAttack = 0;
        if (!this.field_70170_p.field_72995_K && par1DamageSource.func_76364_f() != null && par1DamageSource.func_76364_f() instanceof EntityPlayer) {
            if (par1DamageSource.field_76373_n == this.lastDamageType) {
                ++this.hitCount;
                if (this.hitCount > 5) {
                    this.func_70691_i(par2 / 4.0f);
                }
                return false;
            }
            this.lastDamageType = par1DamageSource.field_76373_n;
            this.hitCount = 1;
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    public EntityLivingBase func_70638_az() {
        if (!this.field_70170_p.field_72995_K) {
            return super.func_70638_az();
        }
        return (EntityLivingBase)this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(ATTACK_TARGET)).intValue());
    }

    @Override
    public void setCurrentAction(BossActions action) {
        this.currentAction = action;
        if (action == BossActions.LONG_CASTING) {
            this.wingFlapTime = 0;
        }
    }

    public int getWingFlapTime() {
        return this.wingFlapTime;
    }

    public float getWingFlapSpeed() {
        switch (this.currentAction) {
            case CASTING: {
                return 0.5f;
            }
            case STRIKE: {
                return 0.4f;
            }
            case CHARGE: {
                if (this.ticksInCurrentAction < 15) {
                    return 0.25f;
                }
                return 0.75f;
            }
        }
        return 0.25f;
    }

    public boolean shouldFlapWings() {
        return this.currentAction != BossActions.LONG_CASTING && this.currentAction != BossActions.SHIELD_BASH;
    }

    public boolean func_70644_a(Potion par1Potion) {
        if (par1Potion == PotionEffectsDefs.spellReflect && (this.currentAction == BossActions.SHIELD_BASH || this.currentAction == BossActions.LONG_CASTING)) {
            return true;
        }
        if (par1Potion == PotionEffectsDefs.magicShield && (this.currentAction == BossActions.SHIELD_BASH || this.currentAction == BossActions.LONG_CASTING)) {
            return true;
        }
        return super.func_70644_a(par1Potion);
    }

    protected SoundEvent func_184601_bQ() {
        return AMSounds.ENDER_GUARDIAN_HIT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSounds.ENDER_GUARDIAN_DEATH;
    }

    protected SoundEvent func_184639_G() {
        return AMSounds.ENDER_GUARDIAN_IDLE;
    }

    @Override
    public SoundEvent getAttackSound() {
        return AMSounds.ENDER_GUARDIAN_ATTACK;
    }

    protected void func_70628_a(boolean par1, int par2) {
        if (par1) {
            this.func_70099_a(new ItemStack((Item)ItemDefs.infinityOrb, 1, 2), 0.0f);
        }
        int i = this.field_70146_Z.nextInt(4);
        for (int j = 0; j < i; ++j) {
            this.func_70099_a(new ItemStack((Item)ItemDefs.essence, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.ENDER)), 0.0f);
        }
        i = this.field_70146_Z.nextInt(10);
        if (i < 3 && par1) {
            this.func_70099_a(ItemDefs.enderBootsEnchanted.func_77946_l(), 0.0f);
        }
    }

    @Override
    public void setAnimID(int id) {
        this.setCurrentAction(BossActions.values()[id]);
        this.ticksInCurrentAction = 0;
    }

    @Override
    public void setAnimTick(int tick) {
        this.ticksInCurrentAction = tick;
    }

    @Override
    public int getAnimID() {
        return this.currentAction.ordinal();
    }

    @Override
    public int getAnimTick() {
        return this.ticksInCurrentAction;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @Override
    protected BossInfo.Color getBarColor() {
        return BossInfo.Color.RED;
    }
}

