/*
 * Decompiled with CFR 0.152.
 */
package am2.bosses;

import am2.api.ArsMagicaAPI;
import am2.api.affinity.Affinity;
import am2.blocks.tileentity.TileEntityLectern;
import am2.bosses.EntityAirGuardian;
import am2.bosses.EntityArcaneGuardian;
import am2.bosses.EntityEarthGuardian;
import am2.bosses.EntityEnderGuardian;
import am2.bosses.EntityFireGuardian;
import am2.bosses.EntityLifeGuardian;
import am2.bosses.EntityLightningGuardian;
import am2.bosses.EntityNatureGuardian;
import am2.bosses.EntityWaterGuardian;
import am2.bosses.EntityWinterGuardian;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.entity.EntityDryad;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class BossSpawnHelper {
    public int dryadsKilled;
    public int ticksSinceLastDryadDeath;
    public static final BossSpawnHelper instance = new BossSpawnHelper();
    private final HashMap<EntityLivingBase, World> queuedBosses = new HashMap();

    private BossSpawnHelper() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onDryadKilled(EntityDryad dryad) {
        this.ticksSinceLastDryadDeath = 0;
        ++this.dryadsKilled;
        if (this.dryadsKilled >= 5) {
            this.spawnNatureGuardian(dryad.field_70170_p, dryad.field_70165_t, dryad.field_70163_u, dryad.field_70161_v);
            this.dryadsKilled = 0;
        }
    }

    @SubscribeEvent
    public void onVillagerChildKilled(LivingDeathEvent event) {
        if (event.getEntity().func_130014_f_().field_72995_K || !(event.getEntity() instanceof EntityVillager)) {
            return;
        }
        EntityVillager villager = (EntityVillager)event.getEntity();
        if (!villager.func_70631_g_()) {
            return;
        }
        BlockPos pos = villager.func_180425_c();
        World world = villager.field_70170_p;
        long time = world.func_72820_D() % 24000L;
        if (time < 12500L || time > 23500L) {
            return;
        }
        int phase = this.getMoonPhaseProxiedProperly(world.field_73011_w.getWorldTime());
        if (phase != 0) {
            return;
        }
        if (!world.func_175623_d(pos)) {
            return;
        }
        if (world.func_180495_p(pos.func_177976_e()).func_177230_c() == BlockDefs.wizardChalk) {
            pos = pos.func_177976_e();
        }
        if (world.func_180495_p(pos.func_177974_f()).func_177230_c() == BlockDefs.wizardChalk) {
            pos = pos.func_177974_f();
        }
        if (world.func_180495_p(pos.func_177978_c()).func_177230_c() == BlockDefs.wizardChalk) {
            pos = pos.func_177978_c();
        }
        if (world.func_180495_p(pos.func_177968_d()).func_177230_c() == BlockDefs.wizardChalk) {
            pos = pos.func_177968_d();
        }
        if (!this.chalkCircleIsValid(world, pos)) {
            return;
        }
        if (!world.field_72995_K) {
            EntityLifeGuardian guardian = new EntityLifeGuardian(world);
            guardian.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.queuedBosses.put((EntityLivingBase)guardian, world);
        }
    }

    private int getMoonPhaseProxiedProperly(long worldTime) {
        return (int)(worldTime / 24000L) % 8;
    }

    private boolean chalkCircleIsValid(World world, BlockPos pos) {
        if (world.func_180495_p(pos.func_177965_g(3)).func_177230_c() != BlockDefs.wardingCandle) {
            return false;
        }
        if (world.func_180495_p(pos.func_177985_f(3)).func_177230_c() != BlockDefs.wardingCandle) {
            return false;
        }
        if (world.func_180495_p(pos.func_177964_d(3)).func_177230_c() != BlockDefs.wardingCandle) {
            return false;
        }
        if (world.func_180495_p(pos.func_177970_e(3)).func_177230_c() != BlockDefs.wardingCandle) {
            return false;
        }
        int xOff = -2;
        int zOff = -2;
        while (xOff <= 2) {
            if (world.func_180495_p(pos.func_177982_a(xOff++, 0, zOff)).func_177230_c() == BlockDefs.wizardChalk) continue;
            return false;
        }
        --xOff;
        while (zOff <= 2) {
            if (world.func_180495_p(pos.func_177982_a(xOff, 0, zOff++)).func_177230_c() == BlockDefs.wizardChalk) continue;
            return false;
        }
        --zOff;
        while (xOff >= -2) {
            if (world.func_180495_p(pos.func_177982_a(xOff--, 0, zOff)).func_177230_c() == BlockDefs.wizardChalk) continue;
            return false;
        }
        ++xOff;
        while (zOff >= -2) {
            if (world.func_180495_p(pos.func_177982_a(xOff, 0, zOff--)).func_177230_c() == BlockDefs.wizardChalk) continue;
            return false;
        }
        return true;
    }

    private void spawnNatureGuardian(World world, double x, double y, double z) {
        if (!world.field_72995_K) {
            EntityNatureGuardian eng = new EntityNatureGuardian(world);
            eng.func_70107_b(x, y, z);
            this.queuedBosses.put((EntityLivingBase)eng, world);
        }
    }

    public void tick() {
        ++this.ticksSinceLastDryadDeath;
        if (this.ticksSinceLastDryadDeath >= 400) {
            this.ticksSinceLastDryadDeath = 0;
            this.dryadsKilled = 0;
        }
        for (EntityLivingBase ent : this.queuedBosses.keySet()) {
            World world = this.queuedBosses.get(ent);
            if (world.field_72995_K) continue;
            world.func_72838_d((Entity)ent);
            this.onBossSpawn(ent, world, ent.func_180425_c());
        }
        this.queuedBosses.clear();
    }

    public void onItemInRing(EntityItem item, Block ringID) {
        if (ringID == BlockDefs.redstoneInlay) {
            this.checkForWaterGuardianSpawn(item.field_70170_p, item.func_180425_c());
        } else if (ringID == BlockDefs.ironInlay) {
            this.checkForArcaneGuardianSpawn(item.field_70170_p, item.func_180425_c());
            this.checkForEarthGuardianSpawn(item.field_70170_p, item.func_180425_c());
        } else if (ringID == BlockDefs.goldInlay) {
            this.checkForAirGuardianSpawn(item.field_70170_p, item.func_180425_c());
            this.checkForFireGuardianSpawn(item, item.field_70170_p, item.func_180425_c());
            this.checkForEnderGuardianSpawn(item.field_70170_p, item.func_180425_c());
        }
    }

    private void checkForWaterGuardianSpawn(World world, BlockPos pos) {
        if (!world.func_72896_J()) {
            return;
        }
        Biome biome = world.func_180494_b(pos);
        BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((Biome)biome);
        boolean containsWaterType = false;
        for (BiomeDictionary.Type type : types) {
            if (type != BiomeDictionary.Type.WATER && type != BiomeDictionary.Type.SWAMP && type != BiomeDictionary.Type.BEACH && type != BiomeDictionary.Type.OCEAN && type != BiomeDictionary.Type.RIVER && type != BiomeDictionary.Type.WET) continue;
            containsWaterType = true;
            break;
        }
        if (!containsWaterType) {
            return;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (world.func_175710_j(pos.func_177982_a(i, 1, j))) continue;
                return;
            }
        }
        List itemsInRange = world.func_72872_a(EntityItem.class, new AxisAlignedBB(pos, pos).func_186662_g(1.0));
        if (itemsInRange.size() != 2) {
            return;
        }
        boolean hasBucket = false;
        boolean hasBoat = false;
        for (EntityItem item : itemsInRange) {
            if (item.field_70128_L) continue;
            if (item.func_92059_d().func_77973_b() == Items.field_151124_az) {
                hasBoat = true;
                continue;
            }
            if (item.func_92059_d().func_77973_b() != Items.field_151131_as) continue;
            hasBucket = true;
        }
        if (hasBoat && hasBucket && !world.field_72995_K) {
            for (EntityItem item : itemsInRange) {
                item.func_70106_y();
            }
            EntityWaterGuardian guardian = new EntityWaterGuardian(world);
            guardian.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
            this.queuedBosses.put((EntityLivingBase)guardian, world);
        }
    }

    private void checkForAirGuardianSpawn(World world, BlockPos pos) {
        if (pos.func_177956_o() < 150) {
            return;
        }
        List itemsInRange = world.func_72872_a(EntityItem.class, new AxisAlignedBB(pos, pos).func_186662_g(1.0));
        if (itemsInRange.size() != 1) {
            return;
        }
        if (((EntityItem)itemsInRange.get(0)).func_92059_d().func_77973_b() != ItemDefs.essence || ((EntityItem)itemsInRange.get(0)).func_92059_d().func_77952_i() != ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.AIR)) {
            return;
        }
        ((EntityItem)itemsInRange.get(0)).func_70106_y();
        EntityAirGuardian guardian = new EntityAirGuardian(world);
        guardian.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
        this.queuedBosses.put((EntityLivingBase)guardian, world);
    }

    private void checkForArcaneGuardianSpawn(World world, BlockPos pos) {
        List itemsInRange = world.func_72872_a(EntityItem.class, new AxisAlignedBB(pos, pos).func_186662_g(1.0));
        if (itemsInRange.size() != 1) {
            return;
        }
        if (((EntityItem)itemsInRange.get(0)).func_92059_d().func_77973_b() != ItemDefs.essence || ((EntityItem)itemsInRange.get(0)).func_92059_d().func_77952_i() != ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.ARCANE)) {
            return;
        }
        boolean hasStructure = false;
        TileEntityLectern lectern = null;
        if (world.func_180495_p(pos.func_177982_a(-1, 0, 2)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(-1, 1, 2)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(-1, 2, 2)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(1, 0, 2)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(1, 1, 2)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(1, 2, 2)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(0, 0, 2)).func_177230_c() == BlockDefs.lectern) {
            lectern = (TileEntityLectern)world.func_175625_s(pos.func_177982_a(0, 0, 2));
            hasStructure = true;
        }
        if (world.func_180495_p(pos.func_177982_a(-1, 0, -2)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(-1, 1, -2)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(-1, 2, -2)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(1, 0, -2)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(1, 1, -2)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(1, 2, -2)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(0, 0, -2)).func_177230_c() == BlockDefs.lectern) {
            lectern = (TileEntityLectern)world.func_175625_s(pos.func_177982_a(0, 0, -2));
            hasStructure = true;
        }
        if (world.func_180495_p(pos.func_177982_a(2, 0, -1)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(2, 1, -1)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(2, 2, -1)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(2, 0, 1)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(2, 1, 1)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(2, 2, 1)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(2, 0, 0)).func_177230_c() == BlockDefs.lectern) {
            lectern = (TileEntityLectern)world.func_175625_s(pos.func_177982_a(2, 0, 0));
            hasStructure = true;
        }
        if (world.func_180495_p(pos.func_177982_a(-2, 0, -1)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(-2, 1, -1)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(-2, 2, -1)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(-2, 0, 1)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(-2, 1, 1)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(-2, 2, 1)).func_177230_c() == Blocks.field_150342_X && world.func_180495_p(pos.func_177982_a(-2, 0, 0)).func_177230_c() == BlockDefs.lectern) {
            lectern = (TileEntityLectern)world.func_175625_s(pos.func_177982_a(-2, 0, 0));
            hasStructure = true;
        }
        if (hasStructure && lectern != null && lectern.hasStack() && lectern.getStack().func_77973_b() == ItemDefs.arcaneCompendium) {
            ((EntityItem)itemsInRange.get(0)).func_70106_y();
            EntityArcaneGuardian guardian = new EntityArcaneGuardian(world);
            guardian.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
            this.queuedBosses.put((EntityLivingBase)guardian, world);
        }
    }

    private void checkForEarthGuardianSpawn(World world, BlockPos pos) {
        List itemsInRange = world.func_72872_a(EntityItem.class, new AxisAlignedBB(pos, pos).func_186662_g(1.0));
        if (itemsInRange.size() != 3) {
            return;
        }
        boolean hasEmerald = false;
        boolean hasTopaz = false;
        boolean hasChimerite = false;
        boolean hasStructure = false;
        for (EntityItem item : itemsInRange) {
            if (item.field_70128_L) continue;
            if (item.func_92059_d().func_77973_b() == Items.field_151166_bC) {
                hasEmerald = true;
                continue;
            }
            if (item.func_92059_d().func_77973_b() == ItemDefs.itemOre && item.func_92059_d().func_77952_i() == 5) {
                hasTopaz = true;
                continue;
            }
            if (item.func_92059_d().func_77973_b() != ItemDefs.itemOre || item.func_92059_d().func_77952_i() != 2) continue;
            hasChimerite = true;
        }
        boolean bl = hasStructure = world.func_180495_p(pos.func_177977_b()) == Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED);
        if (!hasStructure) {
            return;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0) continue;
                hasStructure &= world.func_180495_p(pos.func_177982_a(i, -1, j)).func_177230_c() == Blocks.field_150343_Z;
            }
        }
        hasStructure &= world.func_180495_p(pos.func_177982_a(-2, 0, 0)).func_177230_c() == BlockDefs.vinteumTorch;
        hasStructure &= world.func_180495_p(pos.func_177982_a(2, 0, 0)).func_177230_c() == BlockDefs.vinteumTorch;
        hasStructure &= world.func_180495_p(pos.func_177982_a(0, 0, -2)).func_177230_c() == BlockDefs.vinteumTorch;
        if (!world.field_72995_K && hasEmerald && hasTopaz && hasChimerite && (hasStructure &= world.func_180495_p(pos.func_177982_a(0, 0, 2)).func_177230_c() == BlockDefs.vinteumTorch)) {
            for (EntityItem item : itemsInRange) {
                item.func_70106_y();
            }
            EntityEarthGuardian guardian = new EntityEarthGuardian(world);
            guardian.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
            this.queuedBosses.put((EntityLivingBase)guardian, world);
        }
    }

    private void checkForFireGuardianSpawn(EntityItem item, World world, BlockPos pos) {
        if (item.func_92059_d().func_77973_b() != ItemDefs.essence || item.func_92059_d().func_77952_i() != ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.WATER)) {
            return;
        }
        boolean hasStructure = false;
        boolean hasDimension = world.field_73011_w.getDimension() == -1;
        boolean bl = hasStructure = world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150402_ci;
        if (!hasStructure) {
            return;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0) continue;
                hasStructure &= world.func_180495_p(pos.func_177982_a(i, -1, j)).func_177230_c() == Blocks.field_150343_Z;
            }
        }
        if (!world.field_72995_K && hasStructure && hasDimension) {
            item.func_70106_y();
            EntityFireGuardian guardian = new EntityFireGuardian(world);
            guardian.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
            this.queuedBosses.put((EntityLivingBase)guardian, world);
        }
    }

    private void onBossSpawn(EntityLivingBase boss, World world, BlockPos pos) {
        block7: {
            block6: {
                if (!(boss instanceof EntityEarthGuardian)) break block6;
                if (!world.func_82736_K().func_82766_b("mobGriefing")) break block7;
                for (int i = -10; i <= 10; ++i) {
                    for (int j = 0; j <= 4; ++j) {
                        for (int k = -10; k <= 10; ++k) {
                            if (world.func_180495_p(pos.func_177982_a(i, j, k)) == Blocks.field_150357_h) continue;
                            world.func_175655_b(pos, true);
                        }
                    }
                }
                break block7;
            }
            if (boss instanceof EntityFireGuardian) {
                for (int i = -20; i <= 20; ++i) {
                    for (int k = -20; k <= 20; ++k) {
                        Block block = world.func_180495_p(pos.func_177982_a(i, -1, k)).func_177230_c();
                        if (block != Blocks.field_150353_l && block != Blocks.field_150356_k) continue;
                        world.func_180501_a(pos.func_177982_a(i, -1, k), Blocks.field_150424_aL.func_176223_P(), 2);
                    }
                }
            }
        }
    }

    public void onIceEffigyBuilt(World world, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((Biome)biome);
        boolean containsIceType = false;
        for (BiomeDictionary.Type type : types) {
            if (type != BiomeDictionary.Type.COLD) continue;
            containsIceType = true;
            break;
        }
        if (!containsIceType) {
            return;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0 || world.func_175710_j(pos.func_177982_a(i, 1, j))) continue;
                return;
            }
        }
        world.func_175698_g(pos);
        world.func_175698_g(pos.func_177984_a());
        world.func_175698_g(pos.func_177981_b(2));
        EntityWinterGuardian guardian = new EntityWinterGuardian(world);
        guardian.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
        world.func_72838_d((Entity)guardian);
    }

    public void onLightningEffigyBuilt(World world, BlockPos pos) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0 || world.func_175710_j(pos.func_177982_a(i, 1, j))) continue;
                return;
            }
        }
        world.func_175698_g(pos);
        world.func_175698_g(pos.func_177984_a());
        world.func_175698_g(pos.func_177981_b(2));
        EntityLightningGuardian guardian = new EntityLightningGuardian(world);
        guardian.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
        world.func_72838_d((Entity)guardian);
        world.field_73017_q = 1.0f;
    }

    public void checkForEnderGuardianSpawn(World world, BlockPos pos) {
        if (world.field_73011_w.getDimension() != 1) {
            return;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0 || world.func_175710_j(pos.func_177982_a(i, 1, j))) continue;
                return;
            }
        }
        List itemsInRange = world.func_72872_a(EntityItem.class, new AxisAlignedBB(pos, pos).func_186662_g(1.0));
        if (itemsInRange.size() != 2) {
            return;
        }
        boolean hasEnderEssence = false;
        boolean hasEyeofEnder = false;
        boolean hasStructure = false;
        for (EntityItem item : itemsInRange) {
            if (item.field_70128_L) continue;
            if (item.func_92059_d().func_77973_b() == Items.field_151061_bv) {
                hasEyeofEnder = true;
                continue;
            }
            if (item.func_92059_d().func_77973_b() != ItemDefs.essence || item.func_92059_d().func_77952_i() != ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.ENDER)) continue;
            hasEnderEssence = true;
        }
        hasStructure = true;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                hasStructure &= world.func_180495_p(pos.func_177982_a(i, -1, j)).func_177230_c() == Blocks.field_150402_ci;
            }
        }
        hasStructure &= world.func_180495_p(pos.func_177965_g(2)).func_177230_c() == Blocks.field_150480_ab;
        hasStructure &= world.func_180495_p(pos.func_177985_f(2)).func_177230_c() == Blocks.field_150480_ab;
        hasStructure &= world.func_180495_p(pos.func_177970_e(2)).func_177230_c() == Blocks.field_150480_ab;
        hasStructure &= world.func_180495_p(pos.func_177964_d(2)).func_177230_c() == Blocks.field_150480_ab;
        if (!((hasStructure &= world.func_180495_p(pos).func_177230_c() == BlockDefs.blackAurem) && hasEnderEssence && hasEyeofEnder)) {
            return;
        }
        if (!world.field_72995_K) {
            world.func_175698_g(pos.func_177965_g(2));
            world.func_175698_g(pos.func_177985_f(2));
            world.func_175698_g(pos.func_177970_e(2));
            world.func_175698_g(pos.func_177964_d(2));
            world.func_175698_g(pos);
            for (EntityItem item : itemsInRange) {
                item.func_70106_y();
            }
            EntityEnderGuardian guardian = new EntityEnderGuardian(world);
            guardian.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
            world.func_72838_d((Entity)guardian);
        }
    }
}

