/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity.flickers;

import am2.ArsMagica2;
import am2.api.ArsMagicaAPI;
import am2.api.affinity.Affinity;
import am2.api.flickers.AbstractFlickerFunctionality;
import am2.api.flickers.IFlickerController;
import am2.defs.ItemDefs;
import am2.entity.SpawnBlacklists;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import am2.utils.AffinityShiftUtils;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class FlickerOperatorProgeny
extends AbstractFlickerFunctionality {
    private static final int BASE_COOLDOWN = 2000;
    private static final float COOLDOWN_BONUS = 0.75f;
    private static final int COOLDOWN_MINIMUM = 600;
    public static final FlickerOperatorProgeny instance = new FlickerOperatorProgeny();

    @Override
    public boolean RequiresPower() {
        return true;
    }

    @Override
    public int PowerPerOperation() {
        return 500;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController<?> habitat, boolean powered) {
        HashMap entityCount = new HashMap();
        int radius = 8;
        List creatures = worldObj.func_72872_a(EntityAnimal.class, new AxisAlignedBB(((TileEntity)habitat).func_174877_v()).func_186662_g((double)radius));
        for (EntityAnimal creature : creatures) {
            block5: {
                Integer count;
                Class<?> clazz;
                block4: {
                    clazz = creature.getClass();
                    if (!SpawnBlacklists.canProgenyAffect(clazz)) continue;
                    count = (Integer)entityCount.get(clazz);
                    if (count == null) {
                        count = 0;
                    }
                    if (!creature.func_70880_s() && creature.func_70874_b() == 0) {
                        Integer n = count;
                        Integer n2 = count = Integer.valueOf(count + 1);
                    }
                    entityCount.put(clazz, count);
                    if (count != 2) continue;
                    if (!worldObj.field_72995_K) break block4;
                    AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(worldObj, "heart", (double)((TileEntity)habitat).func_174877_v().func_177958_n() + 0.5, (double)((TileEntity)habitat).func_174877_v().func_177958_n() + 0.7, (double)((TileEntity)habitat).func_174877_v().func_177958_n() + 0.5));
                    if (particle == null) break block5;
                    particle.func_187114_a(20);
                    particle.AddParticleController(new ParticleFloatUpward(particle, 0.0f, 0.05f, 1, false));
                    break block5;
                }
                creatures = worldObj.func_72872_a(clazz, new AxisAlignedBB(((TileEntity)habitat).func_174877_v()).func_186662_g((double)radius));
                count = 0;
                for (EntityAnimal animal : creatures) {
                    if (animal.func_70631_g_()) continue;
                    animal.func_146082_f(null);
                    Integer n = count;
                    Integer n3 = count = Integer.valueOf(count + 1);
                    if (count != 2) continue;
                    break;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController<?> controller, boolean powered, Affinity[] flickers) {
        return this.DoOperation(worldObj, controller, powered);
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController<?> controller, boolean powered) {
    }

    @Override
    public int TimeBetweenOperation(boolean powered, Affinity[] flickers) {
        if (powered) {
            float base = 2000.0f;
            for (Affinity aff : flickers) {
                if (aff != Affinity.LIGHTNING) continue;
                base *= 0.75f;
            }
            return (int)Math.max(base, 600.0f);
        }
        return 2000;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController<?> controller, boolean powered, Affinity[] flickers) {
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{"ELE", "EFE", "EWE", Character.valueOf('E'), Items.field_151110_aK, Character.valueOf('L'), AffinityShiftUtils.getEssenceForAffinity(Affinity.LIFE), Character.valueOf('F'), new ItemStack((Item)ItemDefs.flickerJar, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.LIFE)), Character.valueOf('W'), new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.WHITE.func_176767_b())};
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("arsmagica2", "FlickerOperatorProgeny");
    }

    @Override
    public Affinity[] getMask() {
        return new Affinity[]{Affinity.LIFE};
    }
}

