/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity.flickers;

import am2.ArsMagica2;
import am2.api.ArsMagicaAPI;
import am2.api.affinity.Affinity;
import am2.api.flickers.AbstractFlickerFunctionality;
import am2.api.flickers.IFlickerController;
import am2.blocks.tileentity.flickers.FlickerOperatorGentleRains;
import am2.defs.ItemDefs;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import am2.utils.AffinityShiftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class FlickerOperatorNaturesBounty
extends AbstractFlickerFunctionality {
    public static final FlickerOperatorNaturesBounty instance = new FlickerOperatorNaturesBounty();

    @Override
    public boolean RequiresPower() {
        return false;
    }

    @Override
    public int PowerPerOperation() {
        return 5;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController<?> habitat, boolean powered) {
        return this.DoOperation(worldObj, habitat, powered, new Affinity[0]);
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController<?> habitat, boolean powered, Affinity[] flickers) {
        int radius = 6;
        int diameter = radius * 2 + 1;
        boolean updatedOnce = false;
        if (!worldObj.field_72995_K) {
            for (int i = 0; i < (powered ? 5 : 1); ++i) {
                BlockPos effectPos = ((TileEntity)habitat).func_174877_v().func_177982_a(-radius + worldObj.field_73012_v.nextInt(diameter), 0, -radius + worldObj.field_73012_v.nextInt(diameter));
                while (worldObj.func_175623_d(effectPos) && effectPos.func_177956_o() > 0) {
                    effectPos = effectPos.func_177977_b();
                }
                while (!worldObj.func_175623_d(effectPos) && effectPos.func_177956_o() > 0) {
                    effectPos = effectPos.func_177984_a();
                }
                effectPos.func_177977_b();
                Block block = worldObj.func_180495_p(effectPos).func_177230_c();
                if (!(block instanceof IPlantable) && !(block instanceof IGrowable)) continue;
                block.func_180650_b(worldObj, effectPos, worldObj.func_180495_p(effectPos), worldObj.field_73012_v);
                updatedOnce = true;
            }
        } else {
            int posY = ((TileEntity)habitat).func_174877_v().func_177956_o();
            while (!worldObj.func_175623_d(new BlockPos(((TileEntity)habitat).func_174877_v().func_177958_n(), posY, ((TileEntity)habitat).func_174877_v().func_177952_p()))) {
                ++posY;
            }
            --posY;
            for (int i = 0; i < ArsMagica2.config.getGFXLevel() * 2; ++i) {
                AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(worldObj, "plant", (double)((TileEntity)habitat).func_174877_v().func_177958_n() + 0.5, (float)posY + 0.5f, (double)((TileEntity)habitat).func_174877_v().func_177952_p() + 0.5));
                if (particle == null) continue;
                particle.addRandomOffset(diameter, 0.0, diameter);
                particle.AddParticleController(new ParticleFloatUpward(particle, 0.01f, 0.04f, 1, false));
                particle.func_187114_a(16);
                particle.setParticleScale(0.08f);
            }
        }
        if (powered) {
            for (Affinity aff : flickers) {
                if (aff != Affinity.WATER) continue;
                FlickerOperatorGentleRains.instance.DoOperation(worldObj, habitat, powered);
            }
        }
        return updatedOnce;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController<?> controller, boolean powered) {
    }

    @Override
    public int TimeBetweenOperation(boolean powered, Affinity[] flickers) {
        return powered ? 1 : 100;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController<?> controller, boolean powered, Affinity[] flickers) {
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{"BAB", "LNW", "BGB", Character.valueOf('B'), new ItemStack(Items.field_151100_aR, 1, 15), Character.valueOf('G'), new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.GREEN.func_176767_b()), Character.valueOf('N'), AffinityShiftUtils.getEssenceForAffinity(Affinity.NATURE), Character.valueOf('L'), new ItemStack((Item)ItemDefs.flickerJar, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.LIFE)), Character.valueOf('A'), new ItemStack((Item)ItemDefs.flickerJar, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.NATURE)), Character.valueOf('W'), new ItemStack((Item)ItemDefs.flickerJar, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.WATER))};
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("arsmagica2", "FlickerOperatorNaturesBounty");
    }

    @Override
    public Affinity[] getMask() {
        return new Affinity[]{Affinity.NATURE, Affinity.WATER, Affinity.LIFE};
    }
}

