/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity.flickers;

import am2.api.ArsMagicaAPI;
import am2.api.affinity.Affinity;
import am2.api.flickers.AbstractFlickerFunctionality;
import am2.api.flickers.IFlickerController;
import am2.api.math.AMVector3;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.packet.AMDataReader;
import am2.packet.AMDataWriter;
import am2.utils.DummyEntityPlayer;
import am2.utils.InventoryUtilities;
import am2.utils.WorldUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class FlickerOperatorFelledOak
extends AbstractFlickerFunctionality {
    public static final FlickerOperatorFelledOak instance = new FlickerOperatorFelledOak();
    private DummyEntityPlayer dummyPlayer;
    private static final int radius_horiz = 6;
    private static final int radius_vert = 1;
    private int horizRange = 13;
    private int vertRange = 30;
    private Set<BlockPos> tree;
    private static BlockPos origin;
    private IBlockState originalBlockType;

    void destroyTree(World world, BlockPos pos, IBlockState state) {
        for (int xPos = pos.func_177958_n() - 1; xPos <= pos.func_177958_n() + 1; ++xPos) {
            for (int yPos = pos.func_177956_o(); yPos <= pos.func_177956_o() + 1; ++yPos) {
                for (int zPos = pos.func_177952_p() - 1; zPos <= pos.func_177952_p() + 1; ++zPos) {
                    int localblockMeta;
                    int stateMeta;
                    BlockPos newPos = new BlockPos(xPos, yPos, zPos);
                    if (this.tree.contains(newPos) || !this.isWithinBounds(newPos)) continue;
                    IBlockState localblock = world.func_180495_p(newPos);
                    if (state.func_177230_c() != localblock.func_177230_c() || (stateMeta = WorldUtils.getBlockMeta(state) % 4) != (localblockMeta = WorldUtils.getBlockMeta(localblock) % 4)) continue;
                    state.func_177230_c().func_180657_a(world, (EntityPlayer)this.dummyPlayer, newPos, state, null, null);
                    state.func_177230_c().func_176208_a(world, newPos, state, (EntityPlayer)this.dummyPlayer);
                    world.func_175655_b(newPos, false);
                    this.tree.add(newPos);
                    this.destroyTree(world, newPos, state);
                }
            }
        }
    }

    void beginTreeFelling(World world, BlockPos pos) {
        int height = 0;
        IBlockState wood = world.func_180495_p(pos);
        while (wood.func_177230_c().isWood((IBlockAccess)world, pos)) {
            pos = pos.func_177977_b();
            wood = world.func_180495_p(pos);
        }
        this.tree = new HashSet<BlockPos>();
        wood = world.func_180495_p(pos = pos.func_177984_a());
        if (wood.func_177230_c().isWood((IBlockAccess)world, pos)) {
            height = pos.func_177956_o();
            boolean foundTop = false;
            do {
                IBlockState block = world.func_180495_p(new BlockPos(pos.func_177958_n(), ++height, pos.func_177952_p()));
            } while (FlickerOperatorFelledOak.isLog(world, new BlockPos(pos.func_177958_n(), height, pos.func_177952_p())));
            int numLeaves = 0;
            if (--height - pos.func_177956_o() < 50) {
                for (int xPos = pos.func_177958_n() - 1; xPos <= pos.func_177958_n() + 1; ++xPos) {
                    for (int yPos = height - 1; yPos <= height + 1; ++yPos) {
                        for (int zPos = pos.func_177952_p() - 1; zPos <= pos.func_177952_p() + 1; ++zPos) {
                            BlockPos newPos = new BlockPos(xPos, yPos, zPos);
                            IBlockState leaves = world.func_180495_p(newPos);
                            if (leaves == null || !leaves.func_177230_c().isLeaves(leaves, (IBlockAccess)world, newPos)) continue;
                            ++numLeaves;
                        }
                    }
                }
            }
            origin = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            if (numLeaves > 3) {
                this.destroyTree(world, pos, world.func_180495_p(pos));
            }
        }
    }

    private void plantTree(World worldObj, IFlickerController<?> habitat, boolean powered) {
        if (!powered || worldObj.field_72995_K) {
            return;
        }
        ItemStack sapling = this.getSaplingFromNearbyChest(worldObj, habitat);
        if (sapling == null) {
            return;
        }
        AMVector3 plantLoc = this.getPlantLocation(worldObj, habitat, sapling);
        if (plantLoc == null) {
            return;
        }
        this.deductSaplingFromNearbyChest(worldObj, habitat);
        ItemBlock block = (ItemBlock)sapling.func_77973_b();
        worldObj.func_180501_a(plantLoc.toBlockPos(), block.func_179223_d().func_176203_a(sapling.func_77952_i()), 3);
    }

    private AMVector3 getPlantLocation(World worldObj, IFlickerController<?> habitat, ItemStack sapling) {
        if (!(sapling.func_77973_b() instanceof ItemBlock)) {
            return null;
        }
        TileEntity te = (TileEntity)habitat;
        byte[] data = habitat.getMetadata(this);
        AMVector3 offset = null;
        if (data == null || data.length == 0) {
            offset = new AMVector3(te.func_174877_v().func_177958_n() - 6, te.func_174877_v().func_177956_o() - 1, te.func_174877_v().func_177952_p() - 6);
        } else {
            AMDataReader reader = new AMDataReader(data, false);
            offset = new AMVector3(reader.getInt(), te.func_174877_v().func_177956_o() - 1, reader.getInt());
        }
        Block treeBlock = ((ItemBlock)sapling.func_77973_b()).field_150939_a;
        for (int i = (int)offset.x; i <= te.func_174877_v().func_177958_n() + 6; i += 2) {
            for (int k = (int)offset.z; k <= te.func_174877_v().func_177952_p() + 6; k += 2) {
                for (int j = (int)offset.y; j <= te.func_174877_v().func_177956_o() + 1; ++j) {
                    BlockPos newPos = new BlockPos(i, j, k);
                    IBlockState block = worldObj.func_180495_p(newPos);
                    if (!block.func_177230_c().func_176200_f((IBlockAccess)worldObj, newPos) || !treeBlock.func_176196_c(worldObj, newPos)) continue;
                    AMDataWriter writer = new AMDataWriter();
                    writer.add(i).add(k);
                    habitat.setMetadata(this, writer.generate());
                    return new AMVector3(i, j, k);
                }
            }
        }
        AMDataWriter writer = new AMDataWriter();
        writer.add(te.func_174877_v().func_177958_n() - 6).add(te.func_174877_v().func_177958_n() - 6);
        habitat.setMetadata(this, writer.generate());
        return null;
    }

    private ItemStack getSaplingFromNearbyChest(World worldObj, IFlickerController<?> habitat) {
        for (EnumFacing dir : EnumFacing.values()) {
            int index;
            IInventory inv = this.getOffsetInventory(worldObj, habitat, dir);
            if (inv == null || (index = InventoryUtilities.getInventorySlotIndexFor(inv, new ItemStack(Blocks.field_150345_g, 1, Short.MAX_VALUE))) <= -1) continue;
            ItemStack stack = inv.func_70301_a(index).func_77946_l();
            stack.field_77994_a = 1;
            return stack;
        }
        return null;
    }

    private void deductSaplingFromNearbyChest(World worldObj, IFlickerController<?> habitat) {
        for (EnumFacing dir : EnumFacing.values()) {
            int index;
            IInventory inv = this.getOffsetInventory(worldObj, habitat, dir);
            if (inv == null || (index = InventoryUtilities.getInventorySlotIndexFor(inv, new ItemStack(Blocks.field_150345_g, 1, Short.MAX_VALUE))) <= -1) continue;
            InventoryUtilities.decrementStackQuantity(inv, index, 1);
            return;
        }
    }

    private IInventory getOffsetInventory(World worldObj, IFlickerController<?> habitat, EnumFacing direction) {
        TileEntity te = (TileEntity)habitat;
        TileEntity adjacent = worldObj.func_175625_s(te.func_174877_v().func_177972_a(direction));
        if (adjacent != null && adjacent instanceof IInventory) {
            return (IInventory)adjacent;
        }
        return null;
    }

    @Override
    public boolean RequiresPower() {
        return false;
    }

    @Override
    public int PowerPerOperation() {
        return 100;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController<?> habitat, boolean powered) {
        int radius = 6;
        this.dummyPlayer = new DummyEntityPlayer(worldObj);
        for (int i = -6; i <= 6; ++i) {
            for (int j = -6; j <= 6; ++j) {
                BlockPos newPos = ((TileEntity)habitat).func_174877_v().func_177982_a(i, 0, j);
                Block block = worldObj.func_180495_p(newPos).func_177230_c();
                if (block == Blocks.field_150350_a || !block.isWood((IBlockAccess)worldObj, newPos)) continue;
                if (!worldObj.field_72995_K) {
                    this.beginTreeFelling(worldObj, newPos);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController<?> habitat, boolean powered, Affinity[] flickers) {
        boolean hasNatureAugment = Arrays.asList(flickers).contains(Affinity.NATURE);
        if (hasNatureAugment) {
            this.plantTree(worldObj, habitat, powered);
        }
        return this.DoOperation(worldObj, habitat, powered);
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController<?> habitat, boolean powered) {
    }

    @Override
    public int TimeBetweenOperation(boolean powered, Affinity[] flickers) {
        int base = powered ? 300 : 3600;
        float augments = 1.0f;
        for (Affinity aff : flickers) {
            if (aff != Affinity.LIGHTNING) continue;
            base = (int)Math.ceil((float)base * 0.5f);
        }
        return base;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController<?> habitat, boolean powered, Affinity[] flickers) {
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{"WG ", "NCL", " OW", Character.valueOf('W'), BlockDefs.witchwoodLog, Character.valueOf('G'), new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.GREEN.func_176767_b()), Character.valueOf('N'), new ItemStack((Item)ItemDefs.flickerJar, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.NATURE)), Character.valueOf('L'), new ItemStack((Item)ItemDefs.flickerJar, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.LIGHTNING)), Character.valueOf('G'), new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.ORANGE.func_176767_b()), Character.valueOf('G'), new ItemStack((Item)ItemDefs.bindingCatalyst, 1, 1)};
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("arsmagica2", "FlickerOperatorFelledOak");
    }

    @Override
    public Affinity[] getMask() {
        return new Affinity[]{Affinity.NATURE, Affinity.LIGHTNING};
    }

    public static boolean isLog(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().isWood((IBlockAccess)world, pos);
    }

    public boolean isWithinBounds(BlockPos bp) {
        int dist = Math.abs(origin.func_177958_n() - bp.func_177958_n());
        if (dist > this.horizRange / 2) {
            return false;
        }
        dist = Math.abs(origin.func_177952_p() - bp.func_177952_p());
        if (dist > this.horizRange / 2) {
            return false;
        }
        dist = Math.abs(origin.func_177956_o() - bp.func_177956_o());
        return dist <= this.vertRange / 2;
    }
}

