/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity.flickers;

import am2.api.ArsMagicaAPI;
import am2.api.affinity.Affinity;
import am2.api.flickers.AbstractFlickerFunctionality;
import am2.api.flickers.IFlickerController;
import am2.blocks.BlockInvisibleUtility;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.packet.AMDataReader;
import am2.packet.AMDataWriter;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class FlickerOperatorContainment
extends AbstractFlickerFunctionality {
    public static final FlickerOperatorContainment instance = new FlickerOperatorContainment();
    protected static final int BASE_RADIUS = 6;

    protected void setUtilityBlock(World world, BlockPos pos, BlockInvisibleUtility.EnumInvisibleType meta) {
        if (world.func_180495_p(pos).func_177230_c() == BlockDefs.invisibleUtility) {
            BlockInvisibleUtility.EnumInvisibleType exMeta = BlockInvisibleUtility.getType(world.func_180495_p(pos));
            if (meta == exMeta) {
                return;
            }
            if ((meta == BlockInvisibleUtility.EnumInvisibleType.COLLISION_POSITIVE_X || meta == BlockInvisibleUtility.EnumInvisibleType.COLLISION_NEGATIVE_X) && exMeta == BlockInvisibleUtility.EnumInvisibleType.COLLISION_ALL_X) {
                return;
            }
            if ((meta == BlockInvisibleUtility.EnumInvisibleType.COLLISION_NEGATIVE_Z || meta == BlockInvisibleUtility.EnumInvisibleType.COLLISION_POSITIVE_Z) && exMeta == BlockInvisibleUtility.EnumInvisibleType.COLLISION_ALL_Z) {
                return;
            }
            if (meta == BlockInvisibleUtility.EnumInvisibleType.COLLISION_NEGATIVE_X && exMeta == BlockInvisibleUtility.EnumInvisibleType.COLLISION_POSITIVE_X || meta == BlockInvisibleUtility.EnumInvisibleType.COLLISION_POSITIVE_X && exMeta == BlockInvisibleUtility.EnumInvisibleType.COLLISION_NEGATIVE_X) {
                meta = BlockInvisibleUtility.EnumInvisibleType.COLLISION_ALL_X;
            } else if (meta == BlockInvisibleUtility.EnumInvisibleType.COLLISION_NEGATIVE_Z && exMeta == BlockInvisibleUtility.EnumInvisibleType.COLLISION_POSITIVE_Z || meta == BlockInvisibleUtility.EnumInvisibleType.COLLISION_POSITIVE_Z && exMeta == BlockInvisibleUtility.EnumInvisibleType.COLLISION_NEGATIVE_Z) {
                meta = BlockInvisibleUtility.EnumInvisibleType.COLLISION_ALL_Z;
            }
            world.func_175656_a(pos, BlockDefs.invisibleUtility.func_176223_P().func_177226_a(BlockInvisibleUtility.TYPE, (Comparable)((Object)meta)));
        } else if (world.func_175623_d(pos)) {
            world.func_175656_a(pos, BlockDefs.invisibleUtility.func_176223_P().func_177226_a(BlockInvisibleUtility.TYPE, (Comparable)((Object)meta)));
        }
    }

    protected void clearUtilityBlock(World world, BlockPos pos) {
        if (world.func_180495_p(pos) == BlockDefs.invisibleUtility) {
            world.func_175698_g(pos);
        }
    }

    protected void setLastRadius(IFlickerController<?> habitat, int radius) {
        habitat.setMetadata(this, new AMDataWriter().add(radius).generate());
    }

    protected int getLastRadius(IFlickerController<?> habitat) {
        byte[] meta = habitat.getMetadata(this);
        if (meta == null || meta.length == 0) {
            return 6;
        }
        AMDataReader rdr = new AMDataReader(meta, false);
        return rdr.getInt();
    }

    protected int calculateRadius(Affinity[] flickers) {
        int rad = 6;
        for (Affinity aff : flickers) {
            if (aff != Affinity.ICE) continue;
            ++rad;
        }
        return rad;
    }

    @Override
    public boolean RequiresPower() {
        return true;
    }

    @Override
    public int PowerPerOperation() {
        return 5;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController<?> habitat, boolean powered) {
        return false;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController<?> habitat, boolean powered, Affinity[] flickers) {
        int calcRadius;
        if (worldObj.field_72995_K) {
            return true;
        }
        int lastRadius = this.getLastRadius(habitat);
        if (lastRadius != (calcRadius = this.calculateRadius(flickers))) {
            this.RemoveOperator(worldObj, habitat, powered, flickers);
        }
        boolean hasArcaneAugment = false;
        for (Affinity aff : flickers) {
            if (aff != Affinity.ARCANE) continue;
            hasArcaneAugment = true;
            break;
        }
        for (int i = 0; i < calcRadius * 2 + 1; ++i) {
            if (hasArcaneAugment) {
                this.setUtilityBlock(worldObj, new BlockPos(((TileEntity)habitat).func_174877_v().func_177958_n() - calcRadius, ((TileEntity)habitat).func_174877_v().func_177956_o(), ((TileEntity)habitat).func_174877_v().func_177952_p() + calcRadius + 1 - i), BlockInvisibleUtility.EnumInvisibleType.COLLISION_ALL);
                this.setUtilityBlock(worldObj, new BlockPos(((TileEntity)habitat).func_174877_v().func_177958_n() + calcRadius + 1, ((TileEntity)habitat).func_174877_v().func_177956_o(), ((TileEntity)habitat).func_174877_v().func_177952_p() - calcRadius + i), BlockInvisibleUtility.EnumInvisibleType.COLLISION_ALL);
                this.setUtilityBlock(worldObj, new BlockPos(((TileEntity)habitat).func_174877_v().func_177958_n() - calcRadius + i, ((TileEntity)habitat).func_174877_v().func_177956_o(), ((TileEntity)habitat).func_174877_v().func_177952_p() - calcRadius), BlockInvisibleUtility.EnumInvisibleType.COLLISION_ALL);
                this.setUtilityBlock(worldObj, new BlockPos(((TileEntity)habitat).func_174877_v().func_177958_n() + calcRadius + 1 - i, ((TileEntity)habitat).func_174877_v().func_177956_o(), ((TileEntity)habitat).func_174877_v().func_177952_p() + calcRadius + 1), BlockInvisibleUtility.EnumInvisibleType.COLLISION_ALL);
                continue;
            }
            this.setUtilityBlock(worldObj, new BlockPos(((TileEntity)habitat).func_174877_v().func_177958_n() - calcRadius, ((TileEntity)habitat).func_174877_v().func_177956_o(), ((TileEntity)habitat).func_174877_v().func_177952_p() + calcRadius + 1 - i), i == 0 ? BlockInvisibleUtility.EnumInvisibleType.COLLISION_ALL : BlockInvisibleUtility.EnumInvisibleType.COLLISION_POSITIVE_X);
            this.setUtilityBlock(worldObj, new BlockPos(((TileEntity)habitat).func_174877_v().func_177958_n() + calcRadius + 1, ((TileEntity)habitat).func_174877_v().func_177956_o(), ((TileEntity)habitat).func_174877_v().func_177952_p() - calcRadius + i), i == 0 ? BlockInvisibleUtility.EnumInvisibleType.COLLISION_ALL : BlockInvisibleUtility.EnumInvisibleType.COLLISION_NEGATIVE_X);
            this.setUtilityBlock(worldObj, new BlockPos(((TileEntity)habitat).func_174877_v().func_177958_n() - calcRadius + i, ((TileEntity)habitat).func_174877_v().func_177956_o(), ((TileEntity)habitat).func_174877_v().func_177952_p() - calcRadius), i == 0 ? BlockInvisibleUtility.EnumInvisibleType.COLLISION_ALL : BlockInvisibleUtility.EnumInvisibleType.COLLISION_POSITIVE_Z);
            this.setUtilityBlock(worldObj, new BlockPos(((TileEntity)habitat).func_174877_v().func_177958_n() + calcRadius + 1 - i, ((TileEntity)habitat).func_174877_v().func_177956_o(), ((TileEntity)habitat).func_174877_v().func_177952_p() + calcRadius + 1), i == 0 ? BlockInvisibleUtility.EnumInvisibleType.COLLISION_ALL : BlockInvisibleUtility.EnumInvisibleType.COLLISION_NEGATIVE_Z);
        }
        this.setLastRadius(habitat, calcRadius);
        return true;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController<?> habitat, boolean powered) {
        int radius = this.getLastRadius(habitat);
        for (int i = 0; i < radius * 2 + 1; ++i) {
            this.clearUtilityBlock(worldObj, new BlockPos(((TileEntity)habitat).func_174877_v().func_177958_n() - radius, ((TileEntity)habitat).func_174877_v().func_177956_o(), ((TileEntity)habitat).func_174877_v().func_177952_p() + radius + 1 - i));
            this.clearUtilityBlock(worldObj, new BlockPos(((TileEntity)habitat).func_174877_v().func_177958_n() + radius + 1, ((TileEntity)habitat).func_174877_v().func_177956_o(), ((TileEntity)habitat).func_174877_v().func_177952_p() - radius + i));
            this.clearUtilityBlock(worldObj, new BlockPos(((TileEntity)habitat).func_174877_v().func_177958_n() - radius + i, ((TileEntity)habitat).func_174877_v().func_177956_o(), ((TileEntity)habitat).func_174877_v().func_177952_p() - radius));
            this.clearUtilityBlock(worldObj, new BlockPos(((TileEntity)habitat).func_174877_v().func_177958_n() + radius + 1 - i, ((TileEntity)habitat).func_174877_v().func_177956_o(), ((TileEntity)habitat).func_174877_v().func_177952_p() + radius + 1));
        }
    }

    @Override
    public int TimeBetweenOperation(boolean powered, Affinity[] flickers) {
        return 200;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController<?> habitat, boolean powered, Affinity[] flickers) {
        this.RemoveOperator(worldObj, habitat, powered);
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{"FWF", "ARN", "IWI", Character.valueOf('F'), "fenceWood", Character.valueOf('W'), Blocks.field_150463_bK, Character.valueOf('A'), new ItemStack((Item)ItemDefs.flickerJar, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.AIR)), Character.valueOf('R'), new ItemStack((Item)ItemDefs.rune, 1, EnumDyeColor.BLUE.func_176767_b()), Character.valueOf('N'), new ItemStack((Item)ItemDefs.flickerJar, 1, ArsMagicaAPI.getAffinityRegistry().getId((IForgeRegistryEntry)Affinity.ENDER)), Character.valueOf('I'), Blocks.field_150411_aY};
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("arsmagica2", "FlickerOperatorContainment");
    }

    @Override
    public Affinity[] getMask() {
        return new Affinity[]{Affinity.AIR, Affinity.ENDER};
    }
}

