/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity;

import am2.ArsMagica2;
import am2.api.math.AMVector3;
import am2.blocks.BlockParticleEmitter;
import am2.defs.ItemDefs;
import am2.packet.AMDataWriter;
import am2.packet.AMNetHandler;
import am2.particles.AMParticle;
import am2.particles.AMParticleIcons;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityParticleEmitter
extends TileEntity
implements ITickable {
    private int particleType = 0;
    private int particleQuantity = 1;
    private int spawnRate = 5;
    private int particleBehaviour = 0;
    private int particleColor = 0;
    private float particleScale = 0.5f;
    private float particleAlpha = 1.0f;
    private boolean defaultColor = true;
    private boolean randomColor = false;
    private boolean show = true;
    private float speed;
    private int spawnTicks = 0;
    private int showTicks = 0;
    boolean forceShow = false;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K && this.spawnTicks++ >= this.spawnRate) {
            for (int i = 0; i < this.particleQuantity; ++i) {
                this.doSpawn();
            }
            this.spawnTicks = 0;
        }
        if (!this.show && !this.field_145850_b.field_72995_K && (this.forceShow && this.showTicks++ > 100 || !this.forceShow)) {
            this.showTicks = 0;
            this.forceShow = false;
            for (EntityPlayer player : this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(8.0))) {
                AMVector3 playerLoc;
                AMVector3 myLoc;
                if (player == null || player.field_71071_by.func_70448_g() == null || player.field_71071_by.func_70448_g().func_77973_b() != ItemDefs.crystalWrench || !((myLoc = new AMVector3(this.field_174879_c)).distanceSqTo(playerLoc = new AMVector3((Entity)player)) < 64.0)) continue;
                this.forceShow = true;
            }
            this.field_145850_b.func_180501_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockParticleEmitter.HIDDEN, (Comparable)Boolean.valueOf(!this.forceShow)), 3);
        }
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    private void doSpawn() {
        double z;
        double y;
        double x = this.randomizeCoord((double)this.field_174879_c.func_177958_n() + 0.5);
        AMParticle particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_145850_b, AMParticle.particleTypes[this.particleType], x, y = this.randomizeCoord((double)this.field_174879_c.func_177956_o() + 0.5), z = this.randomizeCoord((double)this.field_174879_c.func_177952_p() + 0.5)));
        if (particle != null) {
            particle.AddParticleController(ArsMagica2.proxy.particleManager.createDefaultParticleController(this.particleBehaviour, (Object)particle, new AMVector3(x, y, z).toVec3D(), this.speed, this.func_145832_p()));
            particle.setParticleAge(Math.min(Math.max(this.spawnRate, 10), 40));
            particle.setIgnoreMaxAge(false);
            particle.setParticleScale(this.particleScale);
            particle.SetParticleAlpha(this.particleAlpha);
            if (!this.defaultColor) {
                if (!this.randomColor) {
                    particle.setRGBColorF((float)(this.particleColor >> 16 & 0xFF) / 255.0f, (float)(this.particleColor >> 8 & 0xFF) / 255.0f, (float)(this.particleColor & 0xFF) / 255.0f);
                } else {
                    particle.setRGBColorF(this.field_145850_b.field_73012_v.nextFloat(), this.field_145850_b.field_73012_v.nextFloat(), this.field_145850_b.field_73012_v.nextFloat());
                }
            }
        }
    }

    private double randomizeCoord(double base) {
        return base + this.field_145850_b.field_73012_v.nextDouble() - 0.5;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        SPacketUpdateTileEntity packet = new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), compound);
        return packet;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.applyParamConstraints();
    }

    private void applyParamConstraints() {
        if (this.spawnRate < 1) {
            this.spawnRate = 1;
        }
        if (this.particleQuantity < 1) {
            this.particleQuantity = 1;
        }
        if (this.particleQuantity > 5) {
            this.particleQuantity = 5;
        }
        if (this.particleType < 0) {
            this.particleType = 0;
        }
        if (this.particleType > AMParticleIcons.instance.numParticles()) {
            this.particleType = AMParticleIcons.instance.numParticles() - 1;
        }
        if (this.particleBehaviour < 0) {
            this.particleBehaviour = 0;
        }
        if (this.particleBehaviour > 6) {
            this.particleBehaviour = 6;
        }
        if (this.particleScale < 0.0f) {
            this.particleScale = 0.0f;
        }
        if (this.particleScale > 1.0f) {
            this.particleScale = 1.0f;
        }
        if (this.particleAlpha < 0.0f) {
            this.particleAlpha = 0.0f;
        }
        if (this.particleAlpha > 1.0f) {
            this.particleAlpha = 1.0f;
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readSettingsFromNBT(compound);
    }

    public void readSettingsFromNBT(NBTTagCompound compound) {
        this.particleType = compound.func_74762_e("particleType");
        this.particleQuantity = compound.func_74762_e("particleQuantity");
        this.spawnRate = compound.func_74762_e("spawnRate");
        this.particleBehaviour = compound.func_74762_e("particleBehaviour");
        this.particleColor = compound.func_74762_e("particleColor");
        this.particleScale = compound.func_74760_g("particleScale");
        this.particleAlpha = compound.func_74760_g("particleAlpha");
        this.defaultColor = compound.func_74767_n("defaultColor");
        this.randomColor = compound.func_74767_n("randomColor");
        this.show = compound.func_74767_n("show");
        this.speed = compound.func_74760_g("speed");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.writeSettingsToNBT(compound);
        return compound;
    }

    public void writeSettingsToNBT(NBTTagCompound compound) {
        compound.func_74768_a("particleType", this.particleType);
        compound.func_74768_a("particleQuantity", this.particleQuantity);
        compound.func_74768_a("spawnRate", this.spawnRate);
        compound.func_74768_a("particleBehaviour", this.particleBehaviour);
        compound.func_74768_a("particleColor", this.particleColor);
        compound.func_74776_a("particleScale", this.particleScale);
        compound.func_74776_a("particleAlpha", this.particleAlpha);
        compound.func_74757_a("defaultColor", this.defaultColor);
        compound.func_74757_a("randomColor", this.randomColor);
        compound.func_74757_a("show", this.show);
        compound.func_74776_a("speed", this.speed);
    }

    public void setParticleType(int particleType) {
        this.particleType = particleType;
    }

    public void setParticleBehaviour(int particleBehaviour) {
        this.particleBehaviour = particleBehaviour;
    }

    public void setColorDefault(boolean def) {
        this.defaultColor = def;
    }

    public void setColorRandom(boolean rand) {
        this.randomColor = rand;
    }

    public void setColor(int color) {
        this.particleColor = color;
    }

    public void setScale(float scale) {
        this.particleScale = scale;
    }

    public void setAlpha(float alpha) {
        this.particleAlpha = alpha;
    }

    public void setShow(boolean show) {
        this.show = show;
        if (this.field_145850_b.field_72995_K && show) {
            AMVector3 playerLoc;
            AMVector3 myLoc;
            this.forceShow = false;
            this.showTicks = 0;
            EntityPlayer localPlayer = ArsMagica2.proxy.getLocalPlayer();
            if (localPlayer != null && localPlayer.field_71071_by.func_70448_g() != null && localPlayer.field_71071_by.func_70448_g().func_77973_b() == ItemDefs.crystalWrench && (myLoc = new AMVector3(this.field_174879_c)).distanceSqTo(playerLoc = new AMVector3((Entity)localPlayer)) < 64.0) {
                this.forceShow = true;
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public int getParticleType() {
        return this.particleType;
    }

    public int getParticleBehaviour() {
        return this.particleBehaviour;
    }

    public boolean getColorDefault() {
        return this.defaultColor;
    }

    public boolean getColorRandom() {
        return this.randomColor;
    }

    public int getColor() {
        return this.particleColor;
    }

    public float getScale() {
        return this.particleScale;
    }

    public float getAlpha() {
        return this.particleAlpha;
    }

    public boolean getShow() {
        return this.show;
    }

    public void setQuantity(int quantity) {
        this.particleQuantity = quantity;
    }

    public int getQuantity() {
        return this.particleQuantity;
    }

    public void setDelay(int delay) {
        this.spawnRate = delay;
        this.spawnTicks = 0;
    }

    public int getDelay() {
        return this.spawnRate;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void syncWithServer() {
        if (this.field_145850_b.field_72995_K) {
            AMDataWriter writer = new AMDataWriter();
            writer.add(this.field_174879_c.func_177958_n());
            writer.add(this.field_174879_c.func_177956_o());
            writer.add(this.field_174879_c.func_177952_p());
            NBTTagCompound compound = new NBTTagCompound();
            this.func_189515_b(compound);
            writer.add(compound);
            byte[] data = writer.generate();
            AMNetHandler.INSTANCE.sendPacketToServer((byte)35, data);
        }
    }
}

