/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity;

import am2.api.blocks.IKeystoneLockable;
import am2.blocks.BlockMagiciansWorkbench;
import am2.packet.AMDataWriter;
import am2.packet.AMNetHandler;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;

public class TileEntityMagiciansWorkbench
extends TileEntity
implements ITickable,
IKeystoneLockable<TileEntityMagiciansWorkbench>,
ISidedInventory {
    private ItemStack[] inventory = new ItemStack[this.func_70302_i_()];
    public IInventory firstCraftResult = new InventoryCraftResult();
    public IInventory secondCraftResult = new InventoryCraftResult();
    private final LinkedList<RememberedRecipe> rememberedRecipes = new LinkedList();
    private byte upgradeState = 0;
    public static final byte UPG_CRAFT = 1;
    public static final byte UPG_ADJ_INV = 2;
    private int numPlayersUsing = 0;
    private float drawerOffset = 0.0f;
    private float prevDrawerOffset = 0.0f;
    private static final float drawerIncrement = 0.05f;
    private static final float drawerMax = 0.5f;
    private static final float drawerMin = 0.0f;

    public void func_73660_a() {
        this.setPrevDrawerOffset(this.getDrawerOffset());
        if (this.numPlayersUsing > 0) {
            if (this.getDrawerOffset() == 0.0f) {
                // empty if block
            }
            if (this.getDrawerOffset() < 0.5f) {
                this.setDrawerOffset(this.getDrawerOffset() + 0.05f);
            } else {
                this.setDrawerOffset(0.5f);
            }
        } else {
            if (this.getDrawerOffset() == 0.5f) {
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f, true);
            }
            if (this.getDrawerOffset() - 0.05f > 0.0f) {
                this.setDrawerOffset(this.getDrawerOffset() - 0.05f);
            } else {
                this.setDrawerOffset(0.0f);
            }
        }
    }

    public boolean func_145842_c(int par1, int par2) {
        if (par1 == 1) {
            this.numPlayersUsing = par2;
            return true;
        }
        return super.func_145842_c(par1, par2);
    }

    public float getPrevDrawerOffset() {
        return this.prevDrawerOffset;
    }

    public void setPrevDrawerOffset(float prevDrawerOffset) {
        this.prevDrawerOffset = prevDrawerOffset;
    }

    public float getDrawerOffset() {
        return this.drawerOffset;
    }

    public void setDrawerOffset(float drawerOffset) {
        this.drawerOffset = drawerOffset;
    }

    public void func_174889_b(EntityPlayer player) {
        if (this.numPlayersUsing < 0) {
            this.numPlayersUsing = 0;
        }
        ++this.numPlayersUsing;
        this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
    }

    public void func_174886_c(EntityPlayer player) {
        if (this.func_145838_q() != null && this.func_145838_q() instanceof BlockMagiciansWorkbench) {
            --this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
        }
    }

    public boolean getUpgradeStatus(byte flag) {
        return (this.upgradeState & flag) == flag;
    }

    public void setUpgradeStatus(byte flag, boolean set) {
        this.upgradeState = set ? (byte)(this.upgradeState | flag) : (byte)(this.upgradeState & ~flag);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
        }
    }

    public void rememberRecipe(ItemStack output, ItemStack[] recipeItems, boolean is2x2) {
        for (RememberedRecipe recipe : this.rememberedRecipes) {
            if (!recipe.output.func_77969_a(output)) continue;
            return;
        }
        if (!this.popRecipe()) {
            return;
        }
        for (ItemStack stack : recipeItems) {
            if (stack == null) continue;
            stack.field_77994_a = 1;
        }
        this.rememberedRecipes.add(new RememberedRecipe(output, recipeItems, is2x2));
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
    }

    private boolean popRecipe() {
        if (this.rememberedRecipes.size() < 8) {
            return true;
        }
        for (int index = 0; index < this.rememberedRecipes.size(); ++index) {
            if (this.rememberedRecipes.get(index).isLocked) continue;
            this.rememberedRecipes.remove(index);
            return true;
        }
        return false;
    }

    public LinkedList<RememberedRecipe> getRememberedRecipeItems() {
        return this.rememberedRecipes;
    }

    public int func_70302_i_() {
        return 48;
    }

    public ItemStack func_70301_a(int i) {
        if (i < 0 || i >= this.func_70302_i_()) {
            return null;
        }
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventory[i] != null) {
            if (this.inventory[i].field_77994_a <= j) {
                ItemStack itemstack = this.inventory[i];
                this.inventory[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.inventory[i].func_77979_a(j);
            if (this.inventory[i].field_77994_a == 0) {
                this.inventory[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.inventory[i] != null) {
            ItemStack itemstack = this.inventory[i];
            this.inventory[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70005_c_() {
        return "Magician's Workbench";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return entityplayer.func_174831_c(this.field_174879_c) <= 64.0;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i > this.getStorageStart();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        SPacketUpdateTileEntity packet = new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
        return packet;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void setRecipeLocked(int index, boolean locked) {
        if (index >= 0 && index < this.rememberedRecipes.size()) {
            this.rememberedRecipes.get(index).isLocked = locked;
        }
        if (this.field_145850_b.field_72995_K) {
            AMDataWriter writer = new AMDataWriter();
            writer.add(this.field_174879_c.func_177958_n());
            writer.add(this.field_174879_c.func_177956_o());
            writer.add(this.field_174879_c.func_177952_p());
            writer.add(index);
            writer.add(locked);
            AMNetHandler.INSTANCE.sendPacketToServer((byte)52, writer.generate());
        }
    }

    public void toggleRecipeLocked(int index) {
        if (index >= 0 && index < this.rememberedRecipes.size()) {
            this.setRecipeLocked(index, !this.rememberedRecipes.get(index).isLocked);
        }
    }

    public int getStorageStart() {
        return 18;
    }

    public int getStorageSize() {
        return 27;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("ArcaneReconstructorInventory", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c(tag);
            if (byte0 < 0 || byte0 >= this.inventory.length) continue;
            this.inventory[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        NBTTagList recall = nbttagcompound.func_150295_c("rememberedRecipes", 10);
        this.rememberedRecipes.clear();
        for (int i = 0; i < recall.func_74745_c(); ++i) {
            NBTTagCompound rememberedRecipe = recall.func_150305_b(i);
            ItemStack output = ItemStack.func_77949_a((NBTTagCompound)rememberedRecipe);
            boolean is2x2 = rememberedRecipe.func_74767_n("is2x2");
            NBTTagList componentNBT = rememberedRecipe.func_150295_c("components", 10);
            ItemStack[] components = new ItemStack[componentNBT.func_74745_c()];
            for (int n = 0; n < componentNBT.func_74745_c(); ++n) {
                ItemStack component;
                NBTTagCompound componentTAG = componentNBT.func_150305_b(n);
                components[n] = componentTAG.func_74767_n("componentExisted") ? (component = ItemStack.func_77949_a((NBTTagCompound)componentTAG)) : null;
            }
            RememberedRecipe rec = new RememberedRecipe(output, components, is2x2);
            rec.isLocked = rememberedRecipe.func_74767_n("isLocked");
            this.rememberedRecipes.add(rec);
        }
        this.upgradeState = nbttagcompound.func_74771_c("upgradestate");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a(tag, (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("ArcaneReconstructorInventory", (NBTBase)nbttaglist);
        NBTTagList recall = new NBTTagList();
        for (RememberedRecipe recipe : this.rememberedRecipes) {
            try {
                NBTTagCompound output = new NBTTagCompound();
                recipe.output.func_77955_b(output);
                output.func_74757_a("is2x2", recipe.is2x2);
                NBTTagList components = new NBTTagList();
                for (int i = 0; i < recipe.components.length; ++i) {
                    NBTTagCompound component = new NBTTagCompound();
                    component.func_74757_a("componentExisted", recipe.components[i] != null);
                    if (recipe.components[i] != null) {
                        recipe.components[i].func_77955_b(component);
                    }
                    components.func_74742_a((NBTBase)component);
                }
                output.func_74782_a("components", (NBTBase)components);
                output.func_74757_a("isLocked", recipe.isLocked);
                recall.func_74742_a((NBTBase)output);
            }
            catch (Throwable throwable) {}
        }
        nbttagcompound.func_74782_a("rememberedRecipes", (NBTBase)recall);
        nbttagcompound.func_74774_a("upgradestate", this.upgradeState);
        return nbttagcompound;
    }

    @Override
    public ItemStack[] getRunesInKey() {
        ItemStack[] runes = new ItemStack[]{this.inventory[45], this.inventory[46], this.inventory[47]};
        return runes;
    }

    @Override
    public boolean keystoneMustBeHeld() {
        return false;
    }

    @Override
    public boolean keystoneMustBeInActionBar() {
        return false;
    }

    public int[] func_180463_a(EnumFacing var1) {
        int[] slots = new int[this.getStorageSize()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i + this.getStorageStart();
        }
        return slots;
    }

    public boolean func_180462_a(int i, ItemStack itemstack, EnumFacing j) {
        return i > this.getStorageStart();
    }

    public boolean func_180461_b(int i, ItemStack itemstack, EnumFacing j) {
        return i > this.getStorageStart();
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public class RememberedRecipe {
        public final ItemStack output;
        public final ItemStack[] components;
        private boolean isLocked;
        public final boolean is2x2;

        public RememberedRecipe(ItemStack output, ItemStack[] components, boolean is2x2) {
            this.output = output;
            this.components = components;
            this.isLocked = false;
            this.is2x2 = is2x2;
        }

        public void lock() {
            this.isLocked = true;
        }

        public void unlock() {
            this.isLocked = false;
        }

        public boolean isLocked() {
            return this.isLocked;
        }
    }
}

