/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity;

import am2.ArsMagica2;
import am2.LogHelper;
import am2.api.ArsMagicaAPI;
import am2.api.SpellRegistry;
import am2.api.affinity.Affinity;
import am2.api.event.SpellRecipeItemsEvent;
import am2.api.skill.Skill;
import am2.api.spell.AbstractSpellPart;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifier;
import am2.api.spell.SpellModifiers;
import am2.api.spell.SpellShape;
import am2.blocks.BlockInscriptionTable;
import am2.blocks.tileentity.ITileEntityAMBase;
import am2.container.ContainerInscriptionTable;
import am2.defs.BlockDefs;
import am2.defs.ItemDefs;
import am2.lore.Story;
import am2.packet.AMDataReader;
import am2.packet.AMDataWriter;
import am2.packet.AMNetHandler;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import am2.particles.ParticleHoldPosition;
import am2.power.PowerTypes;
import am2.spell.SpellValidator;
import am2.utils.KeyValuePair;
import am2.utils.NBTUtils;
import am2.utils.RecipeUtils;
import am2.utils.SpellUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityInscriptionTable
extends TileEntity
implements IInventory,
ITickable,
ITileEntityAMBase {
    private ItemStack[] inscriptionTableItemStacks = new ItemStack[this.func_70302_i_()];
    private final ArrayList<AbstractSpellPart> currentRecipe = new ArrayList();
    private final ArrayList<ArrayList<AbstractSpellPart>> shapeGroups = new ArrayList();
    private int numStageGroups = 2;
    private boolean dirty = false;
    public static final int MAX_STAGE_GROUPS = 5;
    public static int bookIndex = 0;
    public static int paperIndex = 1;
    public static int featherIndex = 2;
    public static int inkIndex = 3;
    private EntityPlayer currentPlayerUsing = null;
    private int ticksToNextParticle = 20;
    private final HashMap<SpellModifiers, Integer> modifierCount;
    private String currentSpellName = "";
    private boolean currentSpellIsReadOnly;
    private static final byte FULL_UPDATE = 1;
    private static final byte MAKE_SPELL = 2;
    private static final byte RESET_NAME = 4;

    public TileEntityInscriptionTable() {
        for (int i = 0; i < 5; ++i) {
            this.shapeGroups.add(new ArrayList());
        }
        this.modifierCount = new HashMap();
        this.resetModifierCount();
    }

    public ArrayList<AbstractSpellPart> getCurrentRecipe() {
        return this.currentRecipe;
    }

    public int func_70302_i_() {
        return 4;
    }

    public ItemStack func_70301_a(int i) {
        return this.inscriptionTableItemStacks[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inscriptionTableItemStacks[i] != null) {
            if (this.inscriptionTableItemStacks[i].field_77994_a <= j) {
                ItemStack itemstack = this.inscriptionTableItemStacks[i];
                this.inscriptionTableItemStacks[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.inscriptionTableItemStacks[i].func_77979_a(j);
            if (this.inscriptionTableItemStacks[i].field_77994_a == 0) {
                this.inscriptionTableItemStacks[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inscriptionTableItemStacks[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70005_c_() {
        return "Inscription Table";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return entityplayer.func_174831_c(this.field_174879_c) <= 64.0;
    }

    public boolean isInUse(EntityPlayer player) {
        return this.currentPlayerUsing != null && this.currentPlayerUsing.func_145782_y() != player.func_145782_y();
    }

    public void setInUse(EntityPlayer player) {
        this.currentPlayerUsing = player;
        if (!this.field_145850_b.field_72995_K) {
            this.func_70296_d();
        }
    }

    public EntityPlayer getCurrentPlayerUsing() {
        return this.currentPlayerUsing;
    }

    private boolean isRenderingLeft() {
        return (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockInscriptionTable.LEFT);
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != BlockDefs.inscriptionTable) {
            this.func_145843_s();
            return;
        }
        if (this.field_145850_b.field_72995_K && this.getUpgradeState() >= 3) {
            this.candleUpdate();
        }
        if (this.numStageGroups > 5) {
            this.numStageGroups = 5;
        }
        if (!this.field_145850_b.field_72995_K) {
            boolean shouldSet = false;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (this.getUpgradeState() >= 1 && !((Boolean)state.func_177229_b((IProperty)BlockInscriptionTable.TIER_1)).booleanValue()) {
                shouldSet = true;
            } else if (this.getUpgradeState() >= 2 && !((Boolean)state.func_177229_b((IProperty)BlockInscriptionTable.TIER_2)).booleanValue()) {
                shouldSet = true;
            } else if (this.getUpgradeState() >= 3 && !((Boolean)state.func_177229_b((IProperty)BlockInscriptionTable.TIER_3)).booleanValue()) {
                shouldSet = true;
            }
            if (shouldSet) {
                this.field_145850_b.func_180501_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockInscriptionTable.TIER_1, (Comparable)Boolean.valueOf(this.getUpgradeState() >= 1)).func_177226_a((IProperty)BlockInscriptionTable.TIER_2, (Comparable)Boolean.valueOf(this.getUpgradeState() >= 2)).func_177226_a((IProperty)BlockInscriptionTable.TIER_3, (Comparable)Boolean.valueOf(this.getUpgradeState() >= 3)), 2);
            }
        }
        this.func_70296_d();
    }

    public int getUpgradeState() {
        return this.numStageGroups - 2;
    }

    private void candleUpdate() {
        --this.ticksToNextParticle;
        if (this.isRenderingLeft()) {
            AMParticle smoke;
            AMParticle effect;
            double particleZ;
            double particleX;
            if (this.ticksToNextParticle == 0 || this.ticksToNextParticle == 15) {
                particleX = 0.0;
                particleZ = 0.0;
                switch ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockInscriptionTable.FACING)) {
                    case SOUTH: {
                        particleX = (double)this.field_174879_c.func_177958_n() + 0.15;
                        particleZ = (double)this.func_174877_v().func_177952_p() + 0.22;
                        break;
                    }
                    case NORTH: {
                        particleX = (double)this.func_174877_v().func_177958_n() + 0.22;
                        particleZ = (double)this.func_174877_v().func_177952_p() + 0.85;
                        break;
                    }
                    case WEST: {
                        particleX = (double)this.func_174877_v().func_177958_n() + 0.78;
                        particleZ = (double)this.func_174877_v().func_177952_p() + 0.85;
                        break;
                    }
                    case EAST: {
                        particleX = (double)this.func_174877_v().func_177958_n() + 0.79;
                        particleZ = (double)this.func_174877_v().func_177952_p() + 0.15;
                    }
                }
                this.ticksToNextParticle = 30;
                effect = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_145850_b, "fire", particleX, (double)this.func_174877_v().func_177956_o() + 1.32, particleZ));
                if (effect != null) {
                    effect.setParticleScale(0.025f, 0.1f, 0.025f);
                    effect.AddParticleController(new ParticleHoldPosition(effect, 29, 1, false));
                    effect.setIgnoreMaxAge(false);
                    effect.func_187114_a(400);
                }
                if (this.field_145850_b.field_73012_v.nextInt(100) > 80 && (smoke = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_145850_b, "smoke", particleX, (double)this.func_174877_v().func_177956_o() + 1.4, particleZ))) != null) {
                    smoke.setParticleScale(0.025f);
                    smoke.AddParticleController(new ParticleFloatUpward(smoke, 0.01f, 0.01f, 1, false));
                    smoke.setIgnoreMaxAge(false);
                    smoke.func_187114_a(20 + this.field_145850_b.field_73012_v.nextInt(10));
                }
            }
            if (this.ticksToNextParticle == 10 || this.ticksToNextParticle == 25) {
                particleX = 0.0;
                particleZ = 0.0;
                switch ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockInscriptionTable.FACING)) {
                    case SOUTH: {
                        particleX = (double)this.func_174877_v().func_177958_n() + 0.59;
                        particleZ = (double)this.func_174877_v().func_177952_p() - 0.72;
                        break;
                    }
                    case NORTH: {
                        particleX = (double)this.func_174877_v().func_177958_n() - 0.72;
                        particleZ = (double)this.func_174877_v().func_177952_p() + 0.41;
                        break;
                    }
                    case EAST: {
                        particleX = (double)this.func_174877_v().func_177958_n() + 0.41;
                        particleZ = (double)this.func_174877_v().func_177952_p() + 1.72;
                        break;
                    }
                    case WEST: {
                        particleX = (double)this.func_174877_v().func_177958_n() + 1.72;
                        particleZ = (double)this.func_174877_v().func_177952_p() + 0.41;
                    }
                }
                effect = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_145850_b, "fire", particleX, (double)this.func_174877_v().func_177956_o() + 1.26, particleZ));
                if (effect != null) {
                    effect.setParticleScale(0.025f, 0.1f, 0.025f);
                    effect.AddParticleController(new ParticleHoldPosition(effect, 29, 1, false));
                    effect.setIgnoreMaxAge(false);
                    effect.func_187114_a(400);
                }
                if (this.field_145850_b.field_73012_v.nextInt(100) > 80 && (smoke = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_145850_b, "smoke", particleX, (double)this.func_174877_v().func_177956_o() + 1.4, particleZ))) != null) {
                    smoke.setParticleScale(0.025f);
                    smoke.AddParticleController(new ParticleFloatUpward(smoke, 0.01f, 0.01f, 1, false));
                    smoke.setIgnoreMaxAge(false);
                    smoke.func_187114_a(20 + this.field_145850_b.field_73012_v.nextInt(10));
                }
            }
        }
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public ItemStack func_70304_b(int i) {
        if (this.inscriptionTableItemStacks[i] != null) {
            ItemStack itemstack = this.inscriptionTableItemStacks[i];
            this.inscriptionTableItemStacks[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.clearCurrentRecipe();
        this.parseTagCompound(par1NBTTagCompound);
    }

    private void parseTagCompound(NBTTagCompound par1NBTTagCompound) {
        NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("InscriptionTableInventory", 10);
        this.inscriptionTableItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c(tag);
            if (byte0 < 0 || byte0 >= this.inscriptionTableItemStacks.length) continue;
            this.inscriptionTableItemStacks[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.shapeGroups.clear();
        NBTTagList shapeGroups = par1NBTTagCompound.func_150295_c("ShapeGroups", 9);
        for (int i = 0; i < shapeGroups.func_74745_c(); ++i) {
            NBTTagList tmplist = (NBTTagList)shapeGroups.func_179238_g(i);
            ArrayList<IForgeRegistryEntry> parts = new ArrayList<IForgeRegistryEntry>();
            for (int j = 0; j < tmplist.func_74745_c(); ++j) {
                NBTTagCompound tmp = tmplist.func_150305_b(j);
                parts.add(tmp.func_74762_e("Slot"), ArsMagicaAPI.getSpellRegistry().getObject(new ResourceLocation(tmp.func_74779_i("ID"))));
            }
            this.shapeGroups.add(parts);
        }
        this.currentRecipe.clear();
        NBTTagList recipe = par1NBTTagCompound.func_150295_c("CurrentRecipe", 10);
        for (int i = 0; i < recipe.func_74745_c(); ++i) {
            NBTTagCompound tmp = recipe.func_150305_b(i);
            this.currentRecipe.add(tmp.func_74762_e("Slot"), (AbstractSpellPart)ArsMagicaAPI.getSpellRegistry().getObject(new ResourceLocation(tmp.func_74779_i("ID"))));
        }
        this.numStageGroups = Math.max(par1NBTTagCompound.func_74762_e("numShapeGroupSlots"), 2);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound par1NBTTagCompound) {
        super.func_189515_b(par1NBTTagCompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inscriptionTableItemStacks.length; ++i) {
            if (this.inscriptionTableItemStacks[i] == null) continue;
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a(tag, (byte)i);
            this.inscriptionTableItemStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        NBTTagList recipe = new NBTTagList();
        for (int i = 0; i < this.currentRecipe.size(); ++i) {
            NBTTagCompound tmp = new NBTTagCompound();
            tmp.func_74768_a("Slot", i);
            tmp.func_74778_a("ID", SpellRegistry.getSkillFromPart(this.currentRecipe.get(i)).getID());
            recipe.func_74742_a((NBTBase)tmp);
        }
        NBTTagList shapeGroups = new NBTTagList();
        for (int j = 0; j < this.shapeGroups.size(); ++j) {
            ArrayList<AbstractSpellPart> parts = this.shapeGroups.get(j);
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < parts.size(); ++i) {
                NBTTagCompound tmp = new NBTTagCompound();
                tmp.func_74768_a("Slot", i);
                tmp.func_74778_a("ID", SpellRegistry.getSkillFromPart(parts.get(i)).getID());
                list.func_74742_a((NBTBase)tmp);
            }
            shapeGroups.func_74742_a((NBTBase)list);
        }
        par1NBTTagCompound.func_74782_a("ShapeGroups", (NBTBase)shapeGroups);
        par1NBTTagCompound.func_74782_a("CurrentRecipe", (NBTBase)recipe);
        par1NBTTagCompound.func_74782_a("InscriptionTableInventory", (NBTBase)nbttaglist);
        par1NBTTagCompound.func_74768_a("numShapeGroupSlots", this.numStageGroups);
        return par1NBTTagCompound;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public void HandleUpdatePacket(byte[] data) {
        if (this.field_145850_b == null) {
            return;
        }
        AMDataReader rdr = new AMDataReader(data);
        switch (rdr.ID) {
            case 1: {
                if (!rdr.getBoolean()) {
                    Entity e = this.field_145850_b.func_73045_a(rdr.getInt());
                    if (e instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)e;
                        this.setInUse(player);
                    } else {
                        this.setInUse(null);
                    }
                } else {
                    this.setInUse(null);
                }
                this.currentRecipe.clear();
                int partLength = rdr.getInt();
                for (int i = 0; i < partLength; ++i) {
                    Skill part = (Skill)ArsMagicaAPI.getSkillRegistry().getObjectById(rdr.getInt());
                    AbstractSpellPart spellPart = (AbstractSpellPart)ArsMagicaAPI.getSpellRegistry().getObject(part.getRegistryName());
                    if (spellPart == null) continue;
                    this.currentRecipe.add(spellPart);
                }
                this.shapeGroups.clear();
                int numGroups = rdr.getInt();
                for (int i = 0; i < numGroups; ++i) {
                    int[] partData;
                    ArrayList<AbstractSpellPart> group = new ArrayList<AbstractSpellPart>();
                    for (int n : partData = rdr.getIntArray()) {
                        Skill part = (Skill)ArsMagicaAPI.getSkillRegistry().getObjectById(n);
                        AbstractSpellPart spellPart = (AbstractSpellPart)ArsMagicaAPI.getSpellRegistry().getObject(part.getRegistryName());
                        if (spellPart == null) continue;
                        group.add(spellPart);
                    }
                    this.shapeGroups.add(group);
                }
                this.countModifiers();
                this.currentSpellName = rdr.getString();
                this.currentSpellIsReadOnly = rdr.getBoolean();
                break;
            }
            case 2: {
                int entityID = rdr.getInt();
                EntityPlayer player = (EntityPlayer)this.field_145850_b.func_73045_a(entityID);
                if (player == null) break;
                this.createSpellForPlayer(player);
                break;
            }
            case 4: {
                int entityID = rdr.getInt();
                EntityPlayer player = (EntityPlayer)this.field_145850_b.func_73045_a(entityID);
                if (player == null) break;
                ((ContainerInscriptionTable)player.field_71070_bA).resetSpellNameAndIcon();
            }
        }
    }

    private byte[] GetUpdatePacketForServer() {
        AMDataWriter writer = new AMDataWriter();
        writer.add((byte)1);
        writer.add(this.currentPlayerUsing == null);
        if (this.currentPlayerUsing != null) {
            writer.add(this.currentPlayerUsing.func_145782_y());
        }
        writer.add(this.currentRecipe.size());
        for (int i = 0; i < this.currentRecipe.size(); ++i) {
            writer.add(ArsMagicaAPI.getSkillRegistry().getId(this.currentRecipe.get(i).getRegistryName()));
        }
        writer.add(this.shapeGroups.size());
        for (ArrayList<AbstractSpellPart> shapeGroup : this.shapeGroups) {
            int[] groupData = new int[shapeGroup.size()];
            for (int i = 0; i < shapeGroup.size(); ++i) {
                groupData[i] = ArsMagicaAPI.getSkillRegistry().getId(shapeGroup.get(i).getRegistryName());
            }
            writer.add(groupData);
        }
        writer.add(this.currentSpellName);
        writer.add(this.currentSpellIsReadOnly);
        return writer.generate();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        SPacketUpdateTileEntity packet = new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), compound);
        return packet;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.parseTagCompound(pkt.func_148857_g());
    }

    private void sendDataToServer() {
        AMDataWriter writer = new AMDataWriter();
        writer.add(this.func_174877_v().func_177958_n());
        writer.add(this.func_174877_v().func_177956_o());
        writer.add(this.func_174877_v().func_177952_p());
        writer.add(this.GetUpdatePacketForServer());
        AMNetHandler.INSTANCE.sendPacketToServer((byte)36, writer.generate());
    }

    public void addSpellPartToStageGroup(int groupIndex, AbstractSpellPart part) {
        ArrayList<AbstractSpellPart> group = this.shapeGroups.get(groupIndex);
        if (!this.currentSpellIsReadOnly && group.size() < 4 && !(part instanceof SpellComponent)) {
            group.add(part);
            if (this.field_145850_b.field_72995_K) {
                this.sendDataToServer();
            }
            this.countModifiers();
        }
    }

    public void removeSpellPartFromStageGroup(int index, int groupIndex) {
        ArrayList<AbstractSpellPart> group = this.shapeGroups.get(groupIndex);
        if (!this.currentSpellIsReadOnly) {
            group.remove(index);
            if (this.field_145850_b.field_72995_K) {
                this.sendDataToServer();
            }
            this.countModifiers();
        }
    }

    public void removeMultipleSpellPartsFromStageGroup(int startIndex, int length, int groupIndex) {
        ArrayList<AbstractSpellPart> group = this.shapeGroups.get(groupIndex);
        if (!this.currentSpellIsReadOnly) {
            for (int i = 0; i <= length; ++i) {
                group.remove(startIndex);
            }
            this.countModifiers();
            if (this.field_145850_b.field_72995_K) {
                this.sendDataToServer();
            }
        }
    }

    public void addSpellPart(AbstractSpellPart part) {
        if (!this.currentSpellIsReadOnly && this.currentRecipe.size() < 16) {
            this.currentRecipe.add(part);
            if (this.field_145850_b.field_72995_K) {
                this.sendDataToServer();
            }
            this.countModifiers();
        }
    }

    public void removeSpellPart(int index) {
        if (!this.currentSpellIsReadOnly) {
            this.currentRecipe.remove(index);
            if (this.field_145850_b.field_72995_K) {
                this.sendDataToServer();
            }
            this.countModifiers();
        }
    }

    public void removeMultipleSpellParts(int startIndex, int length) {
        if (!this.currentSpellIsReadOnly) {
            for (int i = 0; i <= length; ++i) {
                this.getCurrentRecipe().remove(startIndex);
            }
            this.countModifiers();
            if (this.field_145850_b.field_72995_K) {
                this.sendDataToServer();
            }
        }
    }

    public int getNumStageGroups() {
        return this.numStageGroups;
    }

    private void countModifiers() {
        this.resetModifierCount();
        for (ArrayList<AbstractSpellPart> shapeGroup : this.shapeGroups) {
            this.countModifiersInList(shapeGroup);
        }
        ArrayList<ArrayList<AbstractSpellPart>> stages = SpellValidator.splitToStages(this.currentRecipe);
        if (stages.size() == 0) {
            return;
        }
        for (ArrayList<AbstractSpellPart> currentStage : stages) {
            this.countModifiersInList(currentStage);
        }
    }

    private void countModifiersInList(ArrayList<AbstractSpellPart> currentStage) {
        for (AbstractSpellPart part : currentStage) {
            if (!(part instanceof SpellModifier)) continue;
            EnumSet<SpellModifiers> modifiers = ((SpellModifier)part).getAspectsModified();
            for (SpellModifiers modifier : modifiers) {
                int count = this.modifierCount.get((Object)modifier) + 1;
                this.modifierCount.put(modifier, count);
            }
        }
    }

    private void resetModifierCount() {
        this.modifierCount.clear();
        for (SpellModifiers modifier : SpellModifiers.values()) {
            this.modifierCount.put(modifier, 0);
        }
    }

    public int getModifierCount(SpellModifiers modifier) {
        return this.modifierCount.get((Object)modifier);
    }

    public void createSpellForPlayer(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            AMDataWriter writer = new AMDataWriter();
            writer.add(this.func_174877_v().func_177958_n());
            writer.add(this.func_174877_v().func_177956_o());
            writer.add(this.func_174877_v().func_177952_p());
            writer.add((byte)2);
            writer.add(player.func_145782_y());
            AMNetHandler.INSTANCE.sendPacketToServer((byte)36, writer.generate());
        } else {
            ArrayList<KeyValuePair<ArrayList<AbstractSpellPart>, NBTTagCompound>> shapeGroupSetup = new ArrayList<KeyValuePair<ArrayList<AbstractSpellPart>, NBTTagCompound>>();
            KeyValuePair<ArrayList<AbstractSpellPart>, NBTTagCompound> curRecipeSetup = new KeyValuePair<ArrayList<AbstractSpellPart>, NBTTagCompound>(this.currentRecipe, new NBTTagCompound());
            for (ArrayList<AbstractSpellPart> arr : this.shapeGroups) {
                shapeGroupSetup.add(new KeyValuePair<ArrayList<AbstractSpellPart>, NBTTagCompound>(arr, new NBTTagCompound()));
            }
            ItemStack stack = SpellUtils.createSpellStack(shapeGroupSetup, curRecipeSetup);
            stack.func_77978_p().func_74778_a("suggestedName", this.currentSpellName);
            player.field_71071_by.func_70441_a(stack);
        }
    }

    public ItemStack writeRecipeAndDataToBook(ItemStack bookstack, EntityPlayer player, String title) {
        if (bookstack.func_77973_b() == Items.field_151164_bB && this.currentRecipe != null) {
            if (!this.currentRecipeIsValid().valid) {
                return bookstack;
            }
            if (!bookstack.func_77942_o()) {
                bookstack.func_77982_d(new NBTTagCompound());
            } else if (bookstack.func_77978_p().func_74767_n("spellFinalized")) {
                return bookstack;
            }
            LinkedHashMap<Object, Integer> materialsList = new LinkedHashMap<Object, Integer>();
            materialsList.put(ItemDefs.blankRune.func_77653_i(new ItemStack((Item)ItemDefs.blankRune)), 1);
            ArrayList<ItemStack> componentRecipeList = new ArrayList<ItemStack>();
            ArrayList<AbstractSpellPart> allRecipeItems = new ArrayList<AbstractSpellPart>();
            for (ArrayList<AbstractSpellPart> shapeGroup : this.shapeGroups) {
                if (shapeGroup == null || shapeGroup.size() == 0) continue;
                allRecipeItems.addAll(shapeGroup);
            }
            allRecipeItems.addAll(this.currentRecipe);
            for (AbstractSpellPart part : allRecipeItems) {
                if (part == null) {
                    LogHelper.error("Unable to write recipe to book.  Recipe part is null!", new Object[0]);
                    return bookstack;
                }
                Object[] recipeItems = part.getRecipe();
                SpellRecipeItemsEvent event = new SpellRecipeItemsEvent(SpellRegistry.getSkillFromPart(part).getID(), recipeItems);
                MinecraftForge.EVENT_BUS.post((Event)event);
                recipeItems = event.recipeItems;
                if (recipeItems == null) {
                    LogHelper.error("Unable to write recipe to book.  Recipe items are null for part %s!", SpellRegistry.getSkillFromPart(part).getName());
                    return bookstack;
                }
                for (int i = 0; i < recipeItems.length; ++i) {
                    Object o = recipeItems[i];
                    Object materialkey = "";
                    int qty = 1;
                    ItemStack recipeStack = null;
                    if (o instanceof ItemStack) {
                        materialkey = ((ItemStack)o).func_82833_r();
                        recipeStack = (ItemStack)o;
                    } else if (o instanceof Item) {
                        recipeStack = new ItemStack((Item)o);
                        materialkey = ((Item)o).func_77653_i(new ItemStack((Item)o));
                    } else if (o instanceof Block) {
                        recipeStack = new ItemStack((Block)o);
                        materialkey = ((Block)o).func_149732_F();
                    } else if (o instanceof String) {
                        if (((String)o).startsWith("E:")) {
                            int[] ids = RecipeUtils.ParseEssenceIDs((String)o);
                            materialkey = "Essence (";
                            for (int powerID : ids) {
                                PowerTypes type = PowerTypes.getByID(powerID);
                                materialkey = (String)materialkey + type.name() + "/";
                            }
                            if (((String)materialkey).equals("Essence (")) {
                                ++i;
                                continue;
                            }
                            o = recipeItems[++i];
                            if (((String)materialkey).startsWith("Essence (")) {
                                materialkey = ((String)materialkey).substring(0, ((String)materialkey).lastIndexOf("/")) + ")";
                                qty = (Integer)o;
                                int flag = 0;
                                int[] nArray = ids;
                                int n = nArray.length;
                                for (int powerID = 0; powerID < n; ++powerID) {
                                    int f = nArray[powerID];
                                    flag |= f;
                                }
                                recipeStack = new ItemStack(ItemDefs.etherium, qty, flag);
                            }
                        } else {
                            List ores = OreDictionary.getOres((String)((String)o));
                            recipeStack = ores.size() > 0 ? (ItemStack)ores.get(1) : null;
                            materialkey = (String)o;
                        }
                    }
                    if (materialsList.containsKey(materialkey)) {
                        int old = (Integer)materialsList.get(materialkey);
                        materialsList.put(materialkey, old += qty);
                    } else {
                        materialsList.put(materialkey, qty);
                    }
                    if (recipeStack == null) continue;
                    componentRecipeList.add(recipeStack);
                }
            }
            materialsList.put(ItemDefs.spellParchment.func_77653_i(new ItemStack((Item)ItemDefs.spellParchment)), 1);
            StringBuilder sb = new StringBuilder();
            int sgCount = 0;
            int[][] shapeGroupCombos = new int[this.shapeGroups.size()][];
            for (ArrayList arrayList : this.shapeGroups) {
                sb.append("Shape Group " + ++sgCount + "\n\n");
                Iterator<AbstractSpellPart> it = arrayList.iterator();
                shapeGroupCombos[sgCount - 1] = this.SpellPartListToStringBuilder(it, sb, " -");
                sb.append("\n");
            }
            sb.append("Combination:\n\n");
            Iterator<AbstractSpellPart> it = this.currentRecipe.iterator();
            int[] nArray = this.SpellPartListToStringBuilder(it, sb, null);
            LogHelper.info(sb.toString(), new Object[0]);
            ArrayList<NBTTagString> pages = Story.splitStoryPartIntoPages(sb.toString());
            sb = new StringBuilder();
            sb.append("\n\nMaterials List:\n\n");
            for (String s : materialsList.keySet()) {
                sb.append(materialsList.get(s) + " x " + s + "\n");
            }
            pages.addAll(Story.splitStoryPartIntoPages(sb.toString()));
            sb = new StringBuilder();
            sb.append("Affinity Breakdown:\n\n");
            it = this.currentRecipe.iterator();
            HashMap<Affinity, Integer> affinityData = new HashMap<Affinity, Integer>();
            int cpCount = 0;
            while (it.hasNext()) {
                AbstractSpellPart part = it.next();
                if (!(part instanceof SpellComponent)) continue;
                Set<Affinity> aff = ((SpellComponent)part).getAffinity();
                for (Affinity affinity : aff) {
                    int qty = 1;
                    if (affinityData.containsKey(affinity)) {
                        qty = 1 + affinityData.get(affinity);
                    }
                    affinityData.put(affinity, qty);
                }
                ++cpCount;
            }
            ValueComparator vc = new ValueComparator(affinityData);
            TreeMap<Affinity, Integer> sorted = new TreeMap<Affinity, Integer>(vc);
            sorted.putAll(affinityData);
            for (Affinity aff : sorted.keySet()) {
                float pct = (float)((Integer)sorted.get(aff)).intValue() / (float)cpCount * 100.0f;
                sb.append(String.format("%s: %.2f%%", aff.getLocalizedName(), Float.valueOf(pct)));
                sb.append("\n");
            }
            pages.addAll(Story.splitStoryPartIntoPages(sb.toString()));
            Story.WritePartToNBT(bookstack.func_77978_p(), pages);
            bookstack = Story.finalizeStory(bookstack, title, player.func_70005_c_());
            ItemStack[] recipeData = new ItemStack[componentRecipeList.size()];
            int idx = 0;
            for (ItemStack stack : componentRecipeList) {
                recipeData[idx++] = stack;
            }
            NBTUtils.setItemStackArray(bookstack.func_77978_p(), "spell_combo", recipeData);
            bookstack.func_77978_p().func_74783_a("output_combo", nArray);
            bookstack.func_77978_p().func_74768_a("numShapeGroups", shapeGroupCombos.length);
            int index = 0;
            for (int[] sgArray : shapeGroupCombos) {
                bookstack.func_77978_p().func_74783_a("shapeGroupCombo_" + index++, sgArray);
            }
            bookstack.func_77978_p().func_74778_a("spell_mod_version", ArsMagica2.instance.getVersion());
            if (this.currentSpellName.equals("")) {
                this.currentSpellName = "Spell Recipe";
            }
            bookstack.func_151001_c(this.currentSpellName);
            this.currentRecipe.clear();
            Object object = this.shapeGroups.iterator();
            while (object.hasNext()) {
                ArrayList list = (ArrayList)object.next();
                list.clear();
            }
            this.currentSpellName = "";
            bookstack.func_77978_p().func_74757_a("spellFinalized", true);
            this.func_70296_d();
        }
        return bookstack;
    }

    private int[] SpellPartListToStringBuilder(Iterator<AbstractSpellPart> it, StringBuilder sb, String prefix) {
        ArrayList<Integer> outputCombo = new ArrayList<Integer>();
        while (it.hasNext()) {
            AbstractSpellPart part = it.next();
            String displayName = SpellRegistry.getSkillFromPart(part).getName();
            if (prefix != null) {
                sb.append(prefix + displayName + "\n");
            } else if (part instanceof SpellShape) {
                sb.append(displayName + "\n");
            } else {
                sb.append("-" + displayName + "\n");
            }
            outputCombo.add(ArsMagicaAPI.getSkillRegistry().getId(part.getRegistryName()));
        }
        int[] outputData = new int[outputCombo.size()];
        int idx = 0;
        for (Integer I : outputCombo) {
            outputData[idx++] = I;
        }
        return outputData;
    }

    public void clearCurrentRecipe() {
        this.currentRecipe.clear();
        for (ArrayList<AbstractSpellPart> group : this.shapeGroups) {
            group.clear();
        }
        this.currentSpellName = "";
        this.currentSpellIsReadOnly = false;
    }

    public SpellValidator.ValidationResult currentRecipeIsValid() {
        ArrayList<ArrayList<AbstractSpellPart>> segmented = SpellValidator.splitToStages(this.currentRecipe);
        return SpellValidator.instance.spellDefIsValid(this.shapeGroups, segmented);
    }

    public boolean modifierCanBeAdded(SpellModifier modifier) {
        return false;
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }

    @Override
    public void markForUpdate() {
        this.dirty = true;
    }

    @Override
    public boolean needsUpdate() {
        return this.dirty;
    }

    @Override
    public void clean() {
        this.dirty = false;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void setSpellName(String name) {
        this.currentSpellName = name;
        this.sendDataToServer();
    }

    public String getSpellName() {
        return this.currentSpellName != null ? this.currentSpellName : "";
    }

    public void reverseEngineerSpell(ItemStack stack) {
        this.currentRecipe.clear();
        for (ArrayList<AbstractSpellPart> group : this.shapeGroups) {
            group.clear();
        }
        this.currentSpellName = "";
        this.currentSpellName = stack.func_82833_r();
        int numStages = SpellUtils.numStages(stack);
        for (int i = 0; i < numStages; ++i) {
            SpellShape shape = SpellUtils.getShapeForStage(stack, i);
            this.currentRecipe.add(shape);
            ArrayList<SpellComponent> components = SpellUtils.getComponentsForStage(stack, i);
            for (SpellComponent spellComponent : components) {
                this.currentRecipe.add(spellComponent);
            }
            ArrayList<SpellModifier> modifiers = SpellUtils.getModifiersForStage(stack, i);
            for (SpellModifier modifier : modifiers) {
                this.currentRecipe.add(modifier);
            }
        }
        int numShapeGroups = SpellUtils.numShapeGroups(stack);
        for (int i = 0; i < numShapeGroups; ++i) {
            ArrayList<AbstractSpellPart> parts = SpellUtils.getShapeGroupParts(stack, i);
            for (AbstractSpellPart abstractSpellPart : parts) {
                if (abstractSpellPart == null || !(abstractSpellPart instanceof AbstractSpellPart)) continue;
                this.shapeGroups.get(i).add(abstractSpellPart);
            }
        }
        this.currentSpellIsReadOnly = true;
    }

    public boolean currentSpellDefIsReadOnly() {
        return this.currentSpellIsReadOnly;
    }

    public void resetSpellNameAndIcon(ItemStack stack, EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            AMDataWriter writer = new AMDataWriter();
            writer.add(this.func_174877_v().func_177958_n());
            writer.add(this.func_174877_v().func_177956_o());
            writer.add(this.func_174877_v().func_177952_p());
            writer.add((byte)4);
            writer.add(player.func_145782_y());
            AMNetHandler.INSTANCE.sendPacketToServer((byte)36, writer.generate());
        }
        stack.func_77964_b(0);
        stack.func_135074_t();
    }

    public int getShapeGroupSize(int groupIndex) {
        if (groupIndex > this.shapeGroups.size() || groupIndex < 0) {
            return 0;
        }
        return this.shapeGroups.get(groupIndex).size();
    }

    public AbstractSpellPart getShapeGroupPartAt(int groupIndex, int index) {
        return this.shapeGroups.get(groupIndex).get(index);
    }

    public void incrementUpgradeState() {
        ++this.numStageGroups;
        if (!this.field_145850_b.field_72995_K) {
            List players = this.field_145850_b.func_72872_a(EntityPlayerMP.class, new AxisAlignedBB(this.field_174879_c).func_72314_b(256.0, 256.0, 256.0));
            for (EntityPlayerMP player : players) {
                player.field_71135_a.func_147359_a((Packet)this.func_189518_D_());
            }
        }
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    static class ValueComparator
    implements Comparator<Affinity> {
        Map<Affinity, Integer> base;

        ValueComparator(Map<Affinity, Integer> base) {
            this.base = base;
        }

        @Override
        public int compare(Affinity a, Affinity b) {
            Integer y;
            Integer x = this.base.get(a);
            if (x.equals(y = this.base.get(b))) {
                return a.compareTo(b);
            }
            return x.compareTo(y);
        }
    }
}

